/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.utils.math;

import io.flutter.utils.math.Vector3;

class Quaternion {
    final double[] _qStorage;

    private Quaternion() {
        this._qStorage = new double[4];
    }

    public Quaternion(Quaternion other) {
        this._qStorage = (double[])other._qStorage.clone();
    }

    public Quaternion(double x, double y, double z, double w) {
        this._qStorage = new double[4];
        this.setValues(x, y, z, w);
    }

    public Quaternion(double[] _qStorage) {
        this._qStorage = _qStorage;
    }

    public static Quaternion axisAngle(Vector3 axis, double angle) {
        Quaternion ret = new Quaternion();
        ret.setAxisAngle(axis, angle);
        return ret;
    }

    public static Quaternion fromTwoVectors(Vector3 a, Vector3 b) {
        Quaternion ret = new Quaternion();
        ret.setFromTwoVectors(a, b);
        return ret;
    }

    public static Quaternion copy(Quaternion original) {
        Quaternion ret = new Quaternion();
        ret.setFrom(original);
        return ret;
    }

    public static Quaternion identity() {
        Quaternion ret = new Quaternion();
        ret._qStorage[3] = 1.0;
        return ret;
    }

    public static Quaternion dq(Quaternion q, Vector3 omega) {
        Quaternion ret = new Quaternion();
        ret.setDQ(q, omega);
        return ret;
    }

    public double[] getStorage() {
        return this._qStorage;
    }

    public double getX() {
        return this._qStorage[0];
    }

    public void setX(double x) {
        this._qStorage[0] = x;
    }

    public double getY() {
        return this._qStorage[1];
    }

    public void setY(double y) {
        this._qStorage[1] = y;
    }

    public double getZ() {
        return this._qStorage[2];
    }

    public void setZ(double z) {
        this._qStorage[2] = z;
    }

    public double getW() {
        return this._qStorage[3];
    }

    public void setW(double w) {
        this._qStorage[3] = w;
    }

    public Quaternion euler(double yaw, double pitch, double roll) {
        Quaternion ret = new Quaternion();
        ret.setEuler(yaw, pitch, roll);
        return ret;
    }

    public Quaternion clone() {
        return new Quaternion(this);
    }

    public void setFrom(Quaternion source) {
        double[] sourceStorage = source._qStorage;
        this._qStorage[0] = sourceStorage[0];
        this._qStorage[1] = sourceStorage[1];
        this._qStorage[2] = sourceStorage[2];
        this._qStorage[3] = sourceStorage[3];
    }

    public void setValues(double x, double y, double z, double w) {
        this._qStorage[0] = x;
        this._qStorage[1] = y;
        this._qStorage[2] = z;
        this._qStorage[3] = w;
    }

    public void setAxisAngle(Vector3 axis, double radians) {
        double len = axis.getLength();
        if (len == 0.0) {
            return;
        }
        double halfSin = Math.sin(radians * 0.5) / len;
        double[] axisStorage = axis.getStorage();
        this._qStorage[0] = axisStorage[0] * halfSin;
        this._qStorage[1] = axisStorage[1] * halfSin;
        this._qStorage[2] = axisStorage[2] * halfSin;
        this._qStorage[3] = Math.cos(radians * 0.5);
    }

    public void setFromTwoVectors(Vector3 a, Vector3 b) {
        Vector3 v1 = a.normalized();
        Vector3 v2 = b.normalized();
        double c = v1.dot(v2);
        double angle = Math.acos(c);
        Vector3 axis = v1.cross(v2);
        if (Math.abs(1.0 + c) < 5.0E-4) {
            angle = Math.PI;
            axis = v1.getX() > v1.getY() && v1.getX() > v1.getZ() ? v1.cross(new Vector3(0.0, 1.0, 0.0)) : v1.cross(new Vector3(1.0, 0.0, 0.0));
        } else if (Math.abs(1.0 - c) < 5.0E-4) {
            angle = 0.0;
            axis = new Vector3(1.0, 0.0, 0.0);
        }
        this.setAxisAngle(axis.normalized(), angle);
    }

    public void setDQ(Quaternion q, Vector3 omega) {
        double[] qStorage = q._qStorage;
        double[] omegaStorage = omega.getStorage();
        double qx = qStorage[0];
        double qy = qStorage[1];
        double qz = qStorage[2];
        double qw = qStorage[3];
        double ox = omegaStorage[0];
        double oy = omegaStorage[1];
        double oz = omegaStorage[2];
        double _x = ox * qw + oy * qz - oz * qy;
        double _y = oy * qw + oz * qx - ox * qz;
        double _z = oz * qw + ox * qy - oy * qx;
        double _w = -ox * qx - oy * qy - oz * qz;
        this._qStorage[0] = _x * 0.5;
        this._qStorage[1] = _y * 0.5;
        this._qStorage[2] = _z * 0.5;
        this._qStorage[3] = _w * 0.5;
    }

    public void setEuler(double yaw, double pitch, double roll) {
        double halfYaw = yaw * 0.5;
        double halfPitch = pitch * 0.5;
        double halfRoll = roll * 0.5;
        double cosYaw = Math.cos(halfYaw);
        double sinYaw = Math.sin(halfYaw);
        double cosPitch = Math.cos(halfPitch);
        double sinPitch = Math.sin(halfPitch);
        double cosRoll = Math.cos(halfRoll);
        double sinRoll = Math.sin(halfRoll);
        this._qStorage[0] = cosRoll * sinPitch * cosYaw + sinRoll * cosPitch * sinYaw;
        this._qStorage[1] = cosRoll * cosPitch * sinYaw - sinRoll * sinPitch * cosYaw;
        this._qStorage[2] = sinRoll * cosPitch * cosYaw - cosRoll * sinPitch * sinYaw;
        this._qStorage[3] = cosRoll * cosPitch * cosYaw + sinRoll * sinPitch * sinYaw;
    }

    public double normalize() {
        double l = this.getLength();
        if (l == 0.0) {
            return 0.0;
        }
        double d = 1.0 / l;
        this._qStorage[0] = this._qStorage[0] * d;
        this._qStorage[1] = this._qStorage[1] * d;
        this._qStorage[2] = this._qStorage[2] * d;
        this._qStorage[3] = this._qStorage[3] * d;
        return l;
    }

    public void conjugate() {
        this._qStorage[2] = -this._qStorage[2];
        this._qStorage[1] = -this._qStorage[1];
        this._qStorage[0] = -this._qStorage[0];
    }

    public void inverse() {
        double l = 1.0 / this.getLength2();
        this._qStorage[3] = this._qStorage[3] * l;
        this._qStorage[2] = -this._qStorage[2] * l;
        this._qStorage[1] = -this._qStorage[1] * l;
        this._qStorage[0] = -this._qStorage[0] * l;
    }

    public Quaternion normalized() {
        Quaternion ret = this.clone();
        ret.normalize();
        return ret;
    }

    public Quaternion conjugated() {
        Quaternion ret = this.clone();
        ret.conjugate();
        return ret;
    }

    public Quaternion inverted() {
        Quaternion ret = this.clone();
        ret.inverse();
        return ret;
    }

    public double getRadians() {
        return 2.0 * Math.acos(this._qStorage[3]);
    }

    public Vector3 getAxis() {
        double den = 1.0 - this._qStorage[3] * this._qStorage[3];
        if (den < 5.0E-4) {
            return new Vector3();
        }
        double scale = 1.0 / Math.sqrt(den);
        return new Vector3(this._qStorage[0] * scale, this._qStorage[1] * scale, this._qStorage[2] * scale);
    }

    public double getLength2() {
        double x = this._qStorage[0];
        double y = this._qStorage[1];
        double z = this._qStorage[2];
        double w = this._qStorage[3];
        return x * x + y * y + z * z + w * w;
    }

    public double getLength() {
        return Math.sqrt(this.getLength2());
    }

    public Vector3 rotated(Vector3 v) {
        Vector3 out = v.clone();
        this.rotate(out);
        return out;
    }

    public Vector3 rotate(Vector3 v) {
        double _w = this._qStorage[3];
        double _z = this._qStorage[2];
        double _y = this._qStorage[1];
        double _x = this._qStorage[0];
        double tiw = _w;
        double tiz = -_z;
        double tiy = -_y;
        double tix = -_x;
        double tx = tiw * v.getX() + tix * 0.0 + tiy * v.getZ() - tiz * v.getY();
        double ty = tiw * v.getY() + tiy * 0.0 + tiz * v.getX() - tix * v.getZ();
        double tz = tiw * v.getZ() + tiz * 0.0 + tix * v.getY() - tiy * v.getX();
        double tw = tiw * 0.0 - tix * v.getX() - tiy * v.getY() - tiz * v.getZ();
        double result_x = tw * _x + tx * _w + ty * _z - tz * _y;
        double result_y = tw * _y + ty * _w + tz * _x - tx * _z;
        double result_z = tw * _z + tz * _w + tx * _y - ty * _x;
        double[] vStorage = v.getStorage();
        vStorage[2] = result_z;
        vStorage[1] = result_y;
        vStorage[0] = result_x;
        return v;
    }

    public void add(Quaternion arg) {
        double[] argStorage = arg._qStorage;
        this._qStorage[0] = this._qStorage[0] + argStorage[0];
        this._qStorage[1] = this._qStorage[1] + argStorage[1];
        this._qStorage[2] = this._qStorage[2] + argStorage[2];
        this._qStorage[3] = this._qStorage[3] + argStorage[3];
    }

    public void sub(Quaternion arg) {
        double[] argStorage = arg._qStorage;
        this._qStorage[0] = this._qStorage[0] - argStorage[0];
        this._qStorage[1] = this._qStorage[1] - argStorage[1];
        this._qStorage[2] = this._qStorage[2] - argStorage[2];
        this._qStorage[3] = this._qStorage[3] - argStorage[3];
    }

    public void scale(double scale) {
        this._qStorage[3] = this._qStorage[3] * scale;
        this._qStorage[2] = this._qStorage[2] * scale;
        this._qStorage[1] = this._qStorage[1] * scale;
        this._qStorage[0] = this._qStorage[0] * scale;
    }

    public Quaternion scaled(double scale) {
        Quaternion ret = this.clone();
        ret.scale(scale);
        return ret;
    }

    public Quaternion operatorMultiply(Quaternion other) {
        double _w = this._qStorage[3];
        double _z = this._qStorage[2];
        double _y = this._qStorage[1];
        double _x = this._qStorage[0];
        double[] otherStorage = other._qStorage;
        double ow = otherStorage[3];
        double oz = otherStorage[2];
        double oy = otherStorage[1];
        double ox = otherStorage[0];
        return new Quaternion(_w * ox + _x * ow + _y * oz - _z * oy, _w * oy + _y * ow + _z * ox - _x * oz, _w * oz + _z * ow + _x * oy - _y * ox, _w * ow - _x * ox - _y * oy - _z * oz);
    }

    public Quaternion operatorAdd(Quaternion other) {
        Quaternion ret = this.clone();
        ret.add(other);
        return ret;
    }

    public Quaternion operatorSub(Quaternion other) {
        Quaternion ret = this.clone();
        ret.sub(other);
        return ret;
    }

    public Quaternion operatorConjugated() {
        Quaternion ret = this.clone();
        ret.conjugated();
        return ret;
    }

    public String toString() {
        return this._qStorage[0] + ", " + this._qStorage[1] + ", " + this._qStorage[2] + " @ " + this._qStorage[3];
    }

    public double relativeError(Quaternion correct) {
        Quaternion diff = correct.operatorSub(this);
        double norm_diff = diff.getLength();
        double correct_norm = correct.getLength();
        return norm_diff / correct_norm;
    }

    public double absoluteError(Quaternion correct) {
        double this_norm = this.getLength();
        double correct_norm = correct.getLength();
        double norm_diff = Math.abs(this_norm - correct_norm);
        return norm_diff;
    }
}

