/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.utils.math;

import io.flutter.utils.math.Vector;
import io.flutter.utils.math.VectorUtil;
import java.util.Arrays;

public class Vector2
implements Vector {
    final double[] _v2storage;

    Vector2(double x, double y) {
        this._v2storage = new double[]{x, y};
    }

    public Vector2() {
        this._v2storage = new double[2];
    }

    static void min(Vector2 a, Vector2 b, Vector2 result) {
        result.setX(Math.min(a.getX(), b.getX()));
        result.setY(Math.min(a.getY(), b.getY()));
    }

    static void max(Vector2 a, Vector2 b, Vector2 result) {
        result.setX(Math.max(a.getX(), b.getX()));
        result.setY(Math.max(a.getY(), b.getY()));
    }

    static void mix(Vector2 min, Vector2 max, double a, Vector2 result) {
        result.setX(min.getX() + a * (max.getX() - min.getX()));
        result.setY(min.getY() + a * max.getY() - min.getY());
    }

    static Vector2 all(double value) {
        Vector2 ret = new Vector2();
        ret.splat(value);
        return ret;
    }

    static Vector2 copy(Vector2 other) {
        Vector2 ret = new Vector2();
        ret.setFrom(other);
        return ret;
    }

    @Override
    public double[] getStorage() {
        return this._v2storage;
    }

    public void setValues(double x_, double y_) {
        this._v2storage[0] = x_;
        this._v2storage[1] = y_;
    }

    public void setZero() {
        this._v2storage[0] = 0.0;
        this._v2storage[1] = 0.0;
    }

    public void setFrom(Vector2 other) {
        double[] otherStorage = other._v2storage;
        this._v2storage[1] = otherStorage[1];
        this._v2storage[0] = otherStorage[0];
    }

    public void splat(double arg) {
        this._v2storage[0] = arg;
        this._v2storage[1] = arg;
    }

    public String toString() {
        return "[" + this._v2storage[0] + "," + this._v2storage[1] + "]";
    }

    public boolean equals(Object other) {
        if (!(other instanceof Vector2)) {
            return false;
        }
        Vector2 otherV = (Vector2)other;
        return this._v2storage[0] == otherV._v2storage[0] && this._v2storage[1] == otherV._v2storage[1];
    }

    public int hashCode() {
        return Arrays.hashCode(this._v2storage);
    }

    Vector2 operatorNegate() {
        Vector2 ret = this.clone();
        ret.negate();
        return ret;
    }

    public Vector2 operatorSub(Vector2 other) {
        Vector2 ret = this.clone();
        ret.sub(other);
        return ret;
    }

    public Vector2 operatorAdd(Vector2 other) {
        Vector2 ret = this.clone();
        ret.add(other);
        return ret;
    }

    public Vector2 operatorDiv(double scale) {
        Vector2 ret = this.clone();
        ret.scale(1.0 / scale);
        return ret;
    }

    public Vector2 operatorScale(double scale) {
        Vector2 ret = this.clone();
        ret.scale(scale);
        return ret;
    }

    public double getLength() {
        return Math.sqrt(this.getLength2());
    }

    public void setLength(double value) {
        if (value == 0.0) {
            this.setZero();
        } else {
            double l = this.getLength();
            if (l == 0.0) {
                return;
            }
            l = value / l;
            this._v2storage[0] = this._v2storage[0] * l;
            this._v2storage[1] = this._v2storage[1] * l;
        }
    }

    public double getLength2() {
        double sum = this._v2storage[0] * this._v2storage[0];
        return sum += this._v2storage[1] * this._v2storage[1];
    }

    public double normalize() {
        double l = this.getLength();
        if (l == 0.0) {
            return 0.0;
        }
        double d = 1.0 / l;
        this._v2storage[0] = this._v2storage[0] * d;
        this._v2storage[1] = this._v2storage[1] * d;
        return l;
    }

    public Vector2 normalized() {
        Vector2 ret = this.clone();
        ret.normalize();
        return ret;
    }

    public Vector2 normalizeInto(Vector2 out) {
        out.setFrom(this);
        out.normalize();
        return out;
    }

    public double distanceTo(Vector2 arg) {
        return Math.sqrt(this.distanceToSquared(arg));
    }

    public double distanceToSquared(Vector2 arg) {
        double dx = this.getX() - arg.getX();
        double dy = this.getY() - arg.getY();
        return dx * dx + dy * dy;
    }

    public double angleTo(Vector2 other) {
        double[] otherStorage = other._v2storage;
        if (this._v2storage[0] == otherStorage[0] && this._v2storage[1] == otherStorage[1]) {
            return 0.0;
        }
        double d = this.dot(other) / (this.getLength() * other.getLength());
        return Math.acos(VectorUtil.clamp(d, -1.0, 1.0));
    }

    public double angleToSigned(Vector2 other) {
        double[] otherStorage = other._v2storage;
        if (this._v2storage[0] == otherStorage[0] && this._v2storage[1] == otherStorage[1]) {
            return 0.0;
        }
        double s = this.cross(other);
        double c = this.dot(other);
        return Math.atan2(s, c);
    }

    public double dot(Vector2 other) {
        double[] otherStorage = other._v2storage;
        double sum = this._v2storage[0] * otherStorage[0];
        return sum += this._v2storage[1] * otherStorage[1];
    }

    public double cross(Vector2 other) {
        double[] otherStorage = other._v2storage;
        return this._v2storage[0] * otherStorage[1] - this._v2storage[1] * otherStorage[0];
    }

    public Vector2 scaleOrthogonalInto(double scale, Vector2 out) {
        out.setValues(-scale * this._v2storage[1], scale * this._v2storage[0]);
        return out;
    }

    public void reflect(Vector2 normal) {
        this.sub(normal.scaled(2.0 * normal.dot(this)));
    }

    public Vector2 reflected(Vector2 normal) {
        Vector2 ret = this.clone();
        ret.reflect(this.normalized());
        return ret;
    }

    public double relativeError(Vector2 correct) {
        double correct_norm = correct.getLength();
        double diff_norm = this.operatorSub(correct).getLength();
        return diff_norm / correct_norm;
    }

    public double absoluteError(Vector2 correct) {
        return this.operatorSub(correct).getLength();
    }

    public boolean isInfinite() {
        boolean is_infinite = Double.isInfinite(this._v2storage[0]);
        is_infinite = is_infinite || Double.isInfinite(this._v2storage[1]);
        return is_infinite;
    }

    public boolean isNaN() {
        boolean is_nan = Double.isNaN(this._v2storage[0]);
        is_nan = is_nan || Double.isNaN(this._v2storage[1]);
        return is_nan;
    }

    public void add(Vector2 arg) {
        double[] argStorage = arg._v2storage;
        this._v2storage[0] = this._v2storage[0] + argStorage[0];
        this._v2storage[1] = this._v2storage[1] + argStorage[1];
    }

    public void addScaled(Vector2 arg, double factor) {
        double[] argStorage = arg._v2storage;
        this._v2storage[0] = this._v2storage[0] + argStorage[0] * factor;
        this._v2storage[1] = this._v2storage[1] + argStorage[1] * factor;
    }

    public void sub(Vector2 arg) {
        double[] argStorage = arg._v2storage;
        this._v2storage[0] = this._v2storage[0] - argStorage[0];
        this._v2storage[1] = this._v2storage[1] - argStorage[1];
    }

    public void multiply(Vector2 arg) {
        double[] argStorage = arg._v2storage;
        this._v2storage[0] = this._v2storage[0] * argStorage[0];
        this._v2storage[1] = this._v2storage[1] * argStorage[1];
    }

    public void divide(Vector2 arg) {
        double[] argStorage = arg._v2storage;
        this._v2storage[0] = this._v2storage[0] / argStorage[0];
        this._v2storage[1] = this._v2storage[1] / argStorage[1];
    }

    public void scale(double arg) {
        this._v2storage[1] = this._v2storage[1] * arg;
        this._v2storage[0] = this._v2storage[0] * arg;
    }

    public Vector2 scaled(double arg) {
        Vector2 ret = this.clone();
        ret.scale(arg);
        return ret;
    }

    public void negate() {
        this._v2storage[1] = -this._v2storage[1];
        this._v2storage[0] = -this._v2storage[0];
    }

    public void absolute() {
        this._v2storage[1] = Math.abs(this._v2storage[1]);
        this._v2storage[0] = Math.abs(this._v2storage[0]);
    }

    public void clamp(Vector2 min, Vector2 max) {
        double[] minStorage = min.getStorage();
        double[] maxStorage = max.getStorage();
        this._v2storage[0] = VectorUtil.clamp(this._v2storage[0], minStorage[0], maxStorage[0]);
        this._v2storage[1] = VectorUtil.clamp(this._v2storage[1], minStorage[1], maxStorage[1]);
    }

    public void clampScalar(double min, double max) {
        this._v2storage[0] = VectorUtil.clamp(this._v2storage[0], min, max);
        this._v2storage[1] = VectorUtil.clamp(this._v2storage[1], min, max);
    }

    public void floor() {
        this._v2storage[0] = Math.floor(this._v2storage[0]);
        this._v2storage[1] = Math.floor(this._v2storage[1]);
    }

    public void ceil() {
        this._v2storage[0] = Math.ceil(this._v2storage[0]);
        this._v2storage[1] = Math.ceil(this._v2storage[1]);
    }

    public void round() {
        this._v2storage[0] = Math.round(this._v2storage[0]);
        this._v2storage[1] = Math.round(this._v2storage[1]);
    }

    public void roundToZero() {
        this._v2storage[0] = this._v2storage[0] < 0.0 ? Math.ceil(this._v2storage[0]) : Math.floor(this._v2storage[0]);
        this._v2storage[1] = this._v2storage[1] < 0.0 ? Math.ceil(this._v2storage[1]) : Math.floor(this._v2storage[1]);
    }

    public Vector2 clone() {
        Vector2 ret = new Vector2();
        ret.setFrom(this);
        return ret;
    }

    public Vector2 copyInto(Vector2 arg) {
        double[] argStorage = arg._v2storage;
        argStorage[1] = this._v2storage[1];
        argStorage[0] = this._v2storage[0];
        return arg;
    }

    public double getX() {
        return this._v2storage[0];
    }

    public void setX(double arg) {
        this._v2storage[0] = arg;
    }

    public double getY() {
        return this._v2storage[1];
    }

    public void setY(double arg) {
        this._v2storage[1] = arg;
    }
}

