/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.utils.math;

import io.flutter.utils.math.Matrix4;
import io.flutter.utils.math.Quaternion;
import io.flutter.utils.math.Vector;
import io.flutter.utils.math.VectorUtil;
import java.util.Arrays;

public class Vector3
implements Vector {
    final double[] _v3storage;

    public Vector3(double x, double y, double z) {
        this._v3storage = new double[]{x, y, z};
    }

    Vector3() {
        this._v3storage = new double[3];
    }

    public Vector3(double[] v3storage) {
        this._v3storage = v3storage;
    }

    public static void min(Vector3 a, Vector3 b, Vector3 result) {
        result.setX(Math.min(a.getX(), b.getX()));
        result.setY(Math.min(a.getY(), b.getY()));
        result.setZ(Math.min(a.getZ(), b.getZ()));
    }

    public static void max(Vector3 a, Vector3 b, Vector3 result) {
        result.setX(Math.max(a.getX(), b.getX()));
        result.setY(Math.max(a.getY(), b.getY()));
        result.setZ(Math.max(a.getZ(), b.getZ()));
    }

    public static void mix(Vector3 min, Vector3 max, double a, Vector3 result) {
        result.setX(min.getX() + a * (max.getX() - min.getX()));
        result.setY(min.getY() + a * (max.getY() - min.getY()));
        result.setZ(min.getZ() + a * (max.getZ() - min.getZ()));
    }

    public static Vector3 array(double[] array) {
        return Vector3.array(array, 0);
    }

    public static Vector3 array(double[] array, int offset) {
        Vector3 ret = new Vector3();
        ret.copyFromArray(array, offset);
        return ret;
    }

    public static Vector3 getZero() {
        return new Vector3();
    }

    static Vector3 all(double value) {
        Vector3 ret = Vector3.getZero();
        ret.splat(value);
        return ret;
    }

    static Vector3 copy(Vector3 other) {
        Vector3 ret = Vector3.getZero();
        ret.setFrom(other);
        return ret;
    }

    public static Vector3 zero() {
        return new Vector3();
    }

    @Override
    public double[] getStorage() {
        return this._v3storage;
    }

    public void setValues(double x_, double y_, double z_) {
        this._v3storage[0] = x_;
        this._v3storage[1] = y_;
        this._v3storage[2] = z_;
    }

    public void setZero() {
        this._v3storage[2] = 0.0;
        this._v3storage[1] = 0.0;
        this._v3storage[0] = 0.0;
    }

    public void setFrom(Vector3 other) {
        double[] otherStorage = other._v3storage;
        this._v3storage[0] = otherStorage[0];
        this._v3storage[1] = otherStorage[1];
        this._v3storage[2] = otherStorage[2];
    }

    public void splat(double arg) {
        this._v3storage[2] = arg;
        this._v3storage[1] = arg;
        this._v3storage[0] = arg;
    }

    public String toString() {
        return "[" + this._v3storage[0] + "," + this._v3storage[1] + "," + this._v3storage[2] + "]";
    }

    public boolean equals(Object o) {
        if (!(o instanceof Vector3)) {
            return false;
        }
        Vector3 other = (Vector3)o;
        return this._v3storage[0] == other._v3storage[0] && this._v3storage[1] == other._v3storage[1] && this._v3storage[2] == other._v3storage[2];
    }

    public int hashCode() {
        return Arrays.hashCode(this._v3storage);
    }

    public Vector3 operatorNegate() {
        Vector3 ret = this.clone();
        ret.negate();
        return ret;
    }

    public Vector3 operatorSub(Vector3 other) {
        Vector3 ret = this.clone();
        ret.sub(other);
        return ret;
    }

    public Vector3 operatorAdd(Vector3 other) {
        Vector3 ret = this.clone();
        ret.add(other);
        return ret;
    }

    public Vector3 operatorDiv(double scale) {
        Vector3 ret = this.clone();
        ret.scaled(1.0 / scale);
        return ret;
    }

    public Vector3 operatorScaled(double scale) {
        Vector3 ret = this.clone();
        ret.scaled(scale);
        return ret;
    }

    public double getLength() {
        return Math.sqrt(this.getLength2());
    }

    public void setLength(double value) {
        if (value == 0.0) {
            this.setZero();
        } else {
            double l = this.getLength();
            if (l == 0.0) {
                return;
            }
            l = value / l;
            this._v3storage[0] = this._v3storage[0] * l;
            this._v3storage[1] = this._v3storage[1] * l;
            this._v3storage[2] = this._v3storage[2] * l;
        }
    }

    public double getLength2() {
        double sum = this._v3storage[0] * this._v3storage[0];
        sum += this._v3storage[1] * this._v3storage[1];
        return sum += this._v3storage[2] * this._v3storage[2];
    }

    public double normalize() {
        double l = this.getLength();
        if (l == 0.0) {
            return 0.0;
        }
        double d = 1.0 / l;
        this._v3storage[0] = this._v3storage[0] * d;
        this._v3storage[1] = this._v3storage[1] * d;
        this._v3storage[2] = this._v3storage[2] * d;
        return l;
    }

    public Vector3 normalized() {
        Vector3 ret = Vector3.copy(this);
        ret.normalize();
        return ret;
    }

    public Vector3 normalizeInto(Vector3 out) {
        out.setFrom(this);
        out.normalize();
        return out;
    }

    public double distanceTo(Vector3 arg) {
        return Math.sqrt(this.distanceToSquared(arg));
    }

    public double distanceToSquared(Vector3 arg) {
        double[] argStorage = arg._v3storage;
        double dx = this._v3storage[0] - argStorage[0];
        double dy = this._v3storage[1] - argStorage[1];
        double dz = this._v3storage[2] - argStorage[2];
        return dx * dx + dy * dy + dz * dz;
    }

    public double angleTo(Vector3 other) {
        double[] otherStorage = other._v3storage;
        if (this._v3storage[0] == otherStorage[0] && this._v3storage[1] == otherStorage[1] && this._v3storage[2] == otherStorage[2]) {
            return 0.0;
        }
        double d = this.dot(other) / (this.getLength() * other.getLength());
        return Math.acos(VectorUtil.clamp(d, -1.0, 1.0));
    }

    public double angleToSigned(Vector3 other, Vector3 normal) {
        double angle = this.angleTo(other);
        Vector3 c = this.cross(other);
        double d = c.dot(normal);
        return d < 0.0 ? -angle : angle;
    }

    public double dot(Vector3 other) {
        double[] otherStorage = other._v3storage;
        double sum = this._v3storage[0] * otherStorage[0];
        sum += this._v3storage[1] * otherStorage[1];
        return sum += this._v3storage[2] * otherStorage[2];
    }

    public Vector3 cross(Vector3 other) {
        double _x = this._v3storage[0];
        double _y = this._v3storage[1];
        double _z = this._v3storage[2];
        double[] otherStorage = other._v3storage;
        double ox = otherStorage[0];
        double oy = otherStorage[1];
        double oz = otherStorage[2];
        return new Vector3(_y * oz - _z * oy, _z * ox - _x * oz, _x * oy - _y * ox);
    }

    public Vector3 crossInto(Vector3 other, Vector3 out) {
        double x = this._v3storage[0];
        double y = this._v3storage[1];
        double z = this._v3storage[2];
        double[] otherStorage = other._v3storage;
        double ox = otherStorage[0];
        double oy = otherStorage[1];
        double oz = otherStorage[2];
        double[] outStorage = out._v3storage;
        outStorage[0] = y * oz - z * oy;
        outStorage[1] = z * ox - x * oz;
        outStorage[2] = x * oy - y * ox;
        return out;
    }

    public Vector3 reflect(Vector3 normal) {
        this.sub(normal.scaled(2.0 * normal.dot(this)));
        return this;
    }

    public Vector3 reflected(Vector3 normal) {
        Vector3 ret = this.clone();
        ret.reflect(normal);
        return ret;
    }

    public void applyProjection(Matrix4 arg) {
        double[] argStorage = arg.getStorage();
        double x = this._v3storage[0];
        double y = this._v3storage[1];
        double z = this._v3storage[2];
        double d = 1.0 / (argStorage[3] * x + argStorage[7] * y + argStorage[11] * z + argStorage[15]);
        this._v3storage[0] = (argStorage[0] * x + argStorage[4] * y + argStorage[8] * z + argStorage[12]) * d;
        this._v3storage[1] = (argStorage[1] * x + argStorage[5] * y + argStorage[9] * z + argStorage[13]) * d;
        this._v3storage[2] = (argStorage[2] * x + argStorage[6] * y + argStorage[10] * z + argStorage[14]) * d;
    }

    public void applyAxisAngle(Vector3 axis, double angle) {
        this.applyQuaternion(Quaternion.axisAngle(axis, angle));
    }

    public void applyQuaternion(Quaternion arg) {
        double[] argStorage = arg._qStorage;
        double v0 = this._v3storage[0];
        double v1 = this._v3storage[1];
        double v2 = this._v3storage[2];
        double qx = argStorage[0];
        double qy = argStorage[1];
        double qz = argStorage[2];
        double qw = argStorage[3];
        double ix = qw * v0 + qy * v2 - qz * v1;
        double iy = qw * v1 + qz * v0 - qx * v2;
        double iz = qw * v2 + qx * v1 - qy * v0;
        double iw = -qx * v0 - qy * v1 - qz * v2;
        this._v3storage[0] = ix * qw + iw * -qx + iy * -qz - iz * -qy;
        this._v3storage[1] = iy * qw + iw * -qy + iz * -qx - ix * -qz;
        this._v3storage[2] = iz * qw + iw * -qz + ix * -qy - iy * -qx;
    }

    public void applyMatrix4(Matrix4 arg) {
        double[] argStorage = arg.getStorage();
        double v0 = this._v3storage[0];
        double v1 = this._v3storage[1];
        double v2 = this._v3storage[2];
        this._v3storage[0] = argStorage[0] * v0 + argStorage[4] * v1 + argStorage[8] * v2 + argStorage[12];
        this._v3storage[1] = argStorage[1] * v0 + argStorage[5] * v1 + argStorage[9] * v2 + argStorage[13];
        this._v3storage[2] = argStorage[2] * v0 + argStorage[6] * v1 + argStorage[10] * v2 + argStorage[14];
    }

    public double relativeError(Vector3 correct) {
        double correct_norm = correct.getLength();
        double diff_norm = this.operatorSub(correct).getLength();
        return diff_norm / correct_norm;
    }

    public double absoluteError(Vector3 correct) {
        return this.operatorSub(correct).getLength();
    }

    public boolean isInfinite() {
        boolean is_infinite = false;
        is_infinite = is_infinite || Double.isInfinite(this._v3storage[0]);
        is_infinite = is_infinite || Double.isInfinite(this._v3storage[1]);
        is_infinite = is_infinite || Double.isInfinite(this._v3storage[2]);
        return is_infinite;
    }

    public boolean isNaN() {
        boolean is_nan = false;
        is_nan = is_nan || Double.isNaN(this._v3storage[0]);
        is_nan = is_nan || Double.isNaN(this._v3storage[1]);
        is_nan = is_nan || Double.isNaN(this._v3storage[2]);
        return is_nan;
    }

    public void add(Vector3 arg) {
        double[] argStorage = arg._v3storage;
        this._v3storage[0] = this._v3storage[0] + argStorage[0];
        this._v3storage[1] = this._v3storage[1] + argStorage[1];
        this._v3storage[2] = this._v3storage[2] + argStorage[2];
    }

    public void addScaled(Vector3 arg, double factor) {
        double[] argStorage = arg._v3storage;
        this._v3storage[0] = this._v3storage[0] + argStorage[0] * factor;
        this._v3storage[1] = this._v3storage[1] + argStorage[1] * factor;
        this._v3storage[2] = this._v3storage[2] + argStorage[2] * factor;
    }

    public Vector3 sub(Vector3 arg) {
        double[] argStorage = arg._v3storage;
        this._v3storage[0] = this._v3storage[0] - argStorage[0];
        this._v3storage[1] = this._v3storage[1] - argStorage[1];
        this._v3storage[2] = this._v3storage[2] - argStorage[2];
        return this;
    }

    public Vector3 multiply(Vector3 arg) {
        double[] argStorage = arg._v3storage;
        this._v3storage[0] = this._v3storage[0] * argStorage[0];
        this._v3storage[1] = this._v3storage[1] * argStorage[1];
        this._v3storage[2] = this._v3storage[2] * argStorage[2];
        return this;
    }

    public Vector3 divide(Vector3 arg) {
        double[] argStorage = arg._v3storage;
        this._v3storage[0] = this._v3storage[0] / argStorage[0];
        this._v3storage[1] = this._v3storage[1] / argStorage[1];
        this._v3storage[2] = this._v3storage[2] / argStorage[2];
        return this;
    }

    public void scale(double arg) {
        this._v3storage[2] = this._v3storage[2] * arg;
        this._v3storage[1] = this._v3storage[1] * arg;
        this._v3storage[0] = this._v3storage[0] * arg;
    }

    public Vector3 scaled(double arg) {
        Vector3 ret = this.clone();
        ret.scale(arg);
        return ret;
    }

    public void negate() {
        this._v3storage[2] = -this._v3storage[2];
        this._v3storage[1] = -this._v3storage[1];
        this._v3storage[0] = -this._v3storage[0];
    }

    public void absolute() {
        this._v3storage[0] = Math.abs(this._v3storage[0]);
        this._v3storage[1] = Math.abs(this._v3storage[1]);
        this._v3storage[2] = Math.abs(this._v3storage[2]);
    }

    public void clamp(Vector3 min, Vector3 max) {
        double[] minStorage = min.getStorage();
        double[] maxStorage = max.getStorage();
        this._v3storage[0] = VectorUtil.clamp(this._v3storage[0], minStorage[0], maxStorage[0]);
        this._v3storage[1] = VectorUtil.clamp(this._v3storage[1], minStorage[1], maxStorage[1]);
        this._v3storage[2] = VectorUtil.clamp(this._v3storage[2], minStorage[2], maxStorage[2]);
    }

    public void clampScalar(double min, double max) {
        this._v3storage[0] = VectorUtil.clamp(this._v3storage[0], min, max);
        this._v3storage[1] = VectorUtil.clamp(this._v3storage[1], min, max);
        this._v3storage[2] = VectorUtil.clamp(this._v3storage[2], min, max);
    }

    public void floor() {
        this._v3storage[0] = Math.floor(this._v3storage[0]);
        this._v3storage[1] = Math.floor(this._v3storage[1]);
        this._v3storage[2] = Math.floor(this._v3storage[2]);
    }

    public void ceil() {
        this._v3storage[0] = Math.ceil(this._v3storage[0]);
        this._v3storage[1] = Math.ceil(this._v3storage[1]);
        this._v3storage[2] = Math.ceil(this._v3storage[2]);
    }

    public void round() {
        this._v3storage[0] = Math.round(this._v3storage[0]);
        this._v3storage[1] = Math.round(this._v3storage[1]);
        this._v3storage[2] = Math.round(this._v3storage[2]);
    }

    public void roundToZero() {
        this._v3storage[0] = this._v3storage[0] < 0.0 ? Math.ceil(this._v3storage[0]) : Math.floor(this._v3storage[0]);
        this._v3storage[1] = this._v3storage[1] < 0.0 ? Math.ceil(this._v3storage[1]) : Math.floor(this._v3storage[1]);
        this._v3storage[2] = this._v3storage[2] < 0.0 ? Math.ceil(this._v3storage[2]) : Math.floor(this._v3storage[2]);
    }

    public Vector3 clone() {
        Vector3 ret = new Vector3();
        this.copyInto(ret);
        return ret;
    }

    public Vector3 copyInto(Vector3 arg) {
        double[] argStorage = arg._v3storage;
        argStorage[0] = this._v3storage[0];
        argStorage[1] = this._v3storage[1];
        argStorage[2] = this._v3storage[2];
        return arg;
    }

    public void copyIntoArray(double[] array) {
        this.copyIntoArray(array, 0);
    }

    public void copyIntoArray(double[] array, int offset) {
        array[offset + 2] = this._v3storage[2];
        array[offset + 1] = this._v3storage[1];
        array[offset + 0] = this._v3storage[0];
    }

    public void copyFromArray(double[] array) {
        this.copyFromArray(array, 0);
    }

    public void copyFromArray(double[] array, int offset) {
        this._v3storage[2] = array[offset + 2];
        this._v3storage[1] = array[offset + 1];
        this._v3storage[0] = array[offset + 0];
    }

    public double getX() {
        return this._v3storage[0];
    }

    public void setX(double arg) {
        this._v3storage[0] = arg;
    }

    public double getY() {
        return this._v3storage[1];
    }

    public void setY(double arg) {
        this._v3storage[1] = arg;
    }

    public double getZ() {
        return this._v3storage[2];
    }

    public void setZ(double arg) {
        this._v3storage[2] = arg;
    }
}

