/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.utils.math;

import io.flutter.utils.math.Matrix4;
import io.flutter.utils.math.Vector;
import io.flutter.utils.math.VectorUtil;
import java.util.Arrays;

class Vector4
implements Vector {
    final double[] _v4storage;

    Vector4(double x, double y, double z, double w) {
        this._v4storage = new double[]{x, y, z, w};
    }

    Vector4() {
        this._v4storage = new double[4];
    }

    Vector4(double[] values) {
        this._v4storage = values;
    }

    public static void min(Vector4 a, Vector4 b, Vector4 result) {
        result.setX(Math.min(a.getX(), b.getX()));
        result.setY(Math.min(a.getY(), b.getY()));
        result.setZ(Math.min(a.getZ(), b.getZ()));
        result.setW(Math.min(a.getW(), b.getW()));
    }

    public static void max(Vector4 a, Vector4 b, Vector4 result) {
        result.setX(Math.max(a.getX(), b.getX()));
        result.setY(Math.max(a.getY(), b.getY()));
        result.setZ(Math.max(a.getZ(), b.getZ()));
        result.setW(Math.max(a.getW(), b.getW()));
    }

    public static void mix(Vector4 min, Vector4 max, double a, Vector4 result) {
        result.setX(min.getX() + a * (max.getX() - min.getX()));
        result.setY(min.getY() + a * (max.getY() - min.getY()));
        result.setZ(min.getZ() + a * (max.getZ() - min.getZ()));
        result.setW(min.getW() + a * (max.getW() - min.getW()));
    }

    public static Vector4 identity() {
        Vector4 ret = new Vector4();
        ret.setIdentity();
        return ret;
    }

    public static Vector4 all(double value) {
        Vector4 ret = new Vector4();
        ret.splat(value);
        return ret;
    }

    public static Vector4 copy(Vector4 other) {
        Vector4 ret = new Vector4();
        ret.setFrom(other);
        return ret;
    }

    @Override
    public double[] getStorage() {
        return this._v4storage;
    }

    public void setValues(double x_, double y_, double z_, double w_) {
        this._v4storage[3] = w_;
        this._v4storage[2] = z_;
        this._v4storage[1] = y_;
        this._v4storage[0] = x_;
    }

    public void setZero() {
        this._v4storage[0] = 0.0;
        this._v4storage[1] = 0.0;
        this._v4storage[2] = 0.0;
        this._v4storage[3] = 0.0;
    }

    public void setIdentity() {
        this._v4storage[0] = 0.0;
        this._v4storage[1] = 0.0;
        this._v4storage[2] = 0.0;
        this._v4storage[3] = 1.0;
    }

    public void setFrom(Vector4 other) {
        double[] otherStorage = other._v4storage;
        this._v4storage[3] = otherStorage[3];
        this._v4storage[2] = otherStorage[2];
        this._v4storage[1] = otherStorage[1];
        this._v4storage[0] = otherStorage[0];
    }

    public void splat(double arg) {
        this._v4storage[3] = arg;
        this._v4storage[2] = arg;
        this._v4storage[1] = arg;
        this._v4storage[0] = arg;
    }

    public String toString() {
        return this._v4storage[0] + "," + this._v4storage[1] + "," + this._v4storage[2] + "," + this._v4storage[3];
    }

    public boolean equals(Object o) {
        if (!(o instanceof Vector4)) {
            return false;
        }
        Vector4 other = (Vector4)o;
        return this._v4storage[0] == other._v4storage[0] && this._v4storage[1] == other._v4storage[1] && this._v4storage[2] == other._v4storage[2] && this._v4storage[3] == other._v4storage[3];
    }

    public int hashCode() {
        return Arrays.hashCode(this._v4storage);
    }

    public Vector4 operatorNegate() {
        Vector4 ret = this.clone();
        ret.negate();
        return ret;
    }

    public Vector4 operatorSub(Vector4 other) {
        Vector4 ret = this.clone();
        ret.sub(other);
        return ret;
    }

    public Vector4 operatorAdd(Vector4 other) {
        Vector4 ret = this.clone();
        ret.add(other);
        return ret;
    }

    public Vector4 operatorDiv(double scale) {
        Vector4 ret = this.clone();
        ret.scale(1.0 / scale);
        return ret;
    }

    public Vector4 operatorScale(double scale) {
        Vector4 ret = this.clone();
        ret.scale(scale);
        return ret;
    }

    public double getLength() {
        return Math.sqrt(this.getLength2());
    }

    public void setLength(double value) {
        if (value == 0.0) {
            this.setZero();
        } else {
            double l = this.getLength();
            if (l == 0.0) {
                return;
            }
            l = value / l;
            this._v4storage[0] = this._v4storage[0] * l;
            this._v4storage[1] = this._v4storage[1] * l;
            this._v4storage[2] = this._v4storage[2] * l;
            this._v4storage[3] = this._v4storage[3] * l;
        }
    }

    public double getLength2() {
        double sum = this._v4storage[0] * this._v4storage[0];
        sum += this._v4storage[1] * this._v4storage[1];
        sum += this._v4storage[2] * this._v4storage[2];
        return sum += this._v4storage[3] * this._v4storage[3];
    }

    public double normalize() {
        double l = this.getLength();
        if (l == 0.0) {
            return 0.0;
        }
        double d = 1.0 / l;
        this._v4storage[0] = this._v4storage[0] * d;
        this._v4storage[1] = this._v4storage[1] * d;
        this._v4storage[2] = this._v4storage[2] * d;
        this._v4storage[3] = this._v4storage[3] * d;
        return l;
    }

    public Vector4 normalized() {
        Vector4 ret = this.clone();
        ret.normalize();
        return ret;
    }

    public Vector4 normalizeInto(Vector4 out) {
        out.setFrom(this);
        out.normalize();
        return out;
    }

    public double distanceTo(Vector4 arg) {
        return Math.sqrt(this.distanceToSquared(arg));
    }

    public double distanceToSquared(Vector4 arg) {
        double[] argStorage = arg._v4storage;
        double dx = this._v4storage[0] - argStorage[0];
        double dy = this._v4storage[1] - argStorage[1];
        double dz = this._v4storage[2] - argStorage[2];
        double dw = this._v4storage[3] - argStorage[3];
        return dx * dx + dy * dy + dz * dz + dw * dw;
    }

    public double dot(Vector4 other) {
        double[] otherStorage = other._v4storage;
        double sum = this._v4storage[0] * otherStorage[0];
        sum += this._v4storage[1] * otherStorage[1];
        sum += this._v4storage[2] * otherStorage[2];
        return sum += this._v4storage[3] * otherStorage[3];
    }

    public void applyMatrix4(Matrix4 arg) {
        double v1 = this._v4storage[0];
        double v2 = this._v4storage[1];
        double v3 = this._v4storage[2];
        double v4 = this._v4storage[3];
        double[] argStorage = arg.getStorage();
        this._v4storage[0] = argStorage[0] * v1 + argStorage[4] * v2 + argStorage[8] * v3 + argStorage[12] * v4;
        this._v4storage[1] = argStorage[1] * v1 + argStorage[5] * v2 + argStorage[9] * v3 + argStorage[13] * v4;
        this._v4storage[2] = argStorage[2] * v1 + argStorage[6] * v2 + argStorage[10] * v3 + argStorage[14] * v4;
        this._v4storage[3] = argStorage[3] * v1 + argStorage[7] * v2 + argStorage[11] * v3 + argStorage[15] * v4;
    }

    double relativeError(Vector4 correct) {
        double correct_norm = correct.getLength();
        double diff_norm = this.operatorSub(correct).getLength();
        return diff_norm / correct_norm;
    }

    double absoluteError(Vector4 correct) {
        return this.operatorSub(correct).getLength();
    }

    public boolean isInfinite() {
        boolean is_infinite = Double.isInfinite(this._v4storage[0]);
        is_infinite = is_infinite || Double.isInfinite(this._v4storage[1]);
        is_infinite = is_infinite || Double.isInfinite(this._v4storage[2]);
        is_infinite = is_infinite || Double.isInfinite(this._v4storage[3]);
        return is_infinite;
    }

    public boolean isNaN() {
        boolean is_nan = Double.isNaN(this._v4storage[0]);
        is_nan = is_nan || Double.isNaN(this._v4storage[1]);
        is_nan = is_nan || Double.isNaN(this._v4storage[2]);
        is_nan = is_nan || Double.isNaN(this._v4storage[3]);
        return is_nan;
    }

    public void add(Vector4 arg) {
        double[] argStorage = arg._v4storage;
        this._v4storage[0] = this._v4storage[0] + argStorage[0];
        this._v4storage[1] = this._v4storage[1] + argStorage[1];
        this._v4storage[2] = this._v4storage[2] + argStorage[2];
        this._v4storage[3] = this._v4storage[3] + argStorage[3];
    }

    public void addScaled(Vector4 arg, double factor) {
        double[] argStorage = arg._v4storage;
        this._v4storage[0] = this._v4storage[0] + argStorage[0] * factor;
        this._v4storage[1] = this._v4storage[1] + argStorage[1] * factor;
        this._v4storage[2] = this._v4storage[2] + argStorage[2] * factor;
        this._v4storage[3] = this._v4storage[3] + argStorage[3] * factor;
    }

    public void sub(Vector4 arg) {
        double[] argStorage = arg._v4storage;
        this._v4storage[0] = this._v4storage[0] - argStorage[0];
        this._v4storage[1] = this._v4storage[1] - argStorage[1];
        this._v4storage[2] = this._v4storage[2] - argStorage[2];
        this._v4storage[3] = this._v4storage[3] - argStorage[3];
    }

    public void multiply(Vector4 arg) {
        double[] argStorage = arg._v4storage;
        this._v4storage[0] = this._v4storage[0] * argStorage[0];
        this._v4storage[1] = this._v4storage[1] * argStorage[1];
        this._v4storage[2] = this._v4storage[2] * argStorage[2];
        this._v4storage[3] = this._v4storage[3] * argStorage[3];
    }

    public void div(Vector4 arg) {
        double[] argStorage = arg._v4storage;
        this._v4storage[0] = this._v4storage[0] / argStorage[0];
        this._v4storage[1] = this._v4storage[1] / argStorage[1];
        this._v4storage[2] = this._v4storage[2] / argStorage[2];
        this._v4storage[3] = this._v4storage[3] / argStorage[3];
    }

    public void scale(double arg) {
        this._v4storage[0] = this._v4storage[0] * arg;
        this._v4storage[1] = this._v4storage[1] * arg;
        this._v4storage[2] = this._v4storage[2] * arg;
        this._v4storage[3] = this._v4storage[3] * arg;
    }

    public Vector4 scaled(double arg) {
        Vector4 ret = this.clone();
        ret.scale(arg);
        return ret;
    }

    public void negate() {
        this._v4storage[0] = -this._v4storage[0];
        this._v4storage[1] = -this._v4storage[1];
        this._v4storage[2] = -this._v4storage[2];
        this._v4storage[3] = -this._v4storage[3];
    }

    public void absolute() {
        this._v4storage[3] = Math.abs(this._v4storage[3]);
        this._v4storage[2] = Math.abs(this._v4storage[2]);
        this._v4storage[1] = Math.abs(this._v4storage[1]);
        this._v4storage[0] = Math.abs(this._v4storage[0]);
    }

    public void clamp(Vector4 min, Vector4 max) {
        double[] minStorage = min.getStorage();
        double[] maxStorage = max.getStorage();
        this._v4storage[0] = VectorUtil.clamp(this._v4storage[0], minStorage[0], maxStorage[0]);
        this._v4storage[1] = VectorUtil.clamp(this._v4storage[1], minStorage[1], maxStorage[1]);
        this._v4storage[2] = VectorUtil.clamp(this._v4storage[2], minStorage[2], maxStorage[2]);
        this._v4storage[3] = VectorUtil.clamp(this._v4storage[3], minStorage[3], maxStorage[3]);
    }

    public void clampScalar(double min, double max) {
        this._v4storage[0] = VectorUtil.clamp(this._v4storage[0], min, max);
        this._v4storage[1] = VectorUtil.clamp(this._v4storage[1], min, max);
        this._v4storage[2] = VectorUtil.clamp(this._v4storage[2], min, max);
        this._v4storage[3] = VectorUtil.clamp(this._v4storage[3], min, max);
    }

    public void floor() {
        this._v4storage[0] = Math.floor(this._v4storage[0]);
        this._v4storage[1] = Math.floor(this._v4storage[1]);
        this._v4storage[2] = Math.floor(this._v4storage[2]);
        this._v4storage[3] = Math.floor(this._v4storage[3]);
    }

    public void ceil() {
        this._v4storage[0] = Math.ceil(this._v4storage[0]);
        this._v4storage[1] = Math.ceil(this._v4storage[1]);
        this._v4storage[2] = Math.ceil(this._v4storage[2]);
        this._v4storage[3] = Math.ceil(this._v4storage[3]);
    }

    public void round() {
        this._v4storage[0] = Math.round(this._v4storage[0]);
        this._v4storage[1] = Math.round(this._v4storage[1]);
        this._v4storage[2] = Math.round(this._v4storage[2]);
        this._v4storage[3] = Math.round(this._v4storage[3]);
    }

    public void roundToZero() {
        this._v4storage[0] = this._v4storage[0] < 0.0 ? Math.ceil(this._v4storage[0]) : Math.floor(this._v4storage[0]);
        this._v4storage[1] = this._v4storage[1] < 0.0 ? Math.ceil(this._v4storage[1]) : Math.floor(this._v4storage[1]);
        this._v4storage[2] = this._v4storage[2] < 0.0 ? Math.ceil(this._v4storage[2]) : Math.floor(this._v4storage[2]);
        this._v4storage[3] = this._v4storage[3] < 0.0 ? Math.ceil(this._v4storage[3]) : Math.floor(this._v4storage[3]);
    }

    public Vector4 clone() {
        return Vector4.copy(this);
    }

    public Vector4 copyInto(Vector4 arg) {
        double[] argStorage = arg._v4storage;
        argStorage[0] = this._v4storage[0];
        argStorage[1] = this._v4storage[1];
        argStorage[2] = this._v4storage[2];
        argStorage[3] = this._v4storage[3];
        return arg;
    }

    public double getX() {
        return this._v4storage[0];
    }

    public void setX(double arg) {
        this._v4storage[0] = arg;
    }

    public double getY() {
        return this._v4storage[1];
    }

    public void setY(double arg) {
        this._v4storage[1] = arg;
    }

    public double getZ() {
        return this._v4storage[2];
    }

    public void setZ(double arg) {
        this._v4storage[2] = arg;
    }

    public double getW() {
        return this._v4storage[3];
    }

    public void setW(double arg) {
        this._v4storage[3] = arg;
    }
}

