/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.view;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.components.JBCheckBox;
import io.flutter.run.daemon.FlutterApp;
import io.flutter.utils.StreamSubscription;
import io.flutter.vmService.ServiceExtensionState;
import io.flutter.vmService.ToggleableServiceExtensionDescription;
import javax.swing.JCheckBox;
import org.jetbrains.annotations.NotNull;

public class BoolServiceExtensionCheckbox
implements Disposable {
    private final JCheckBox checkbox;
    private StreamSubscription<ServiceExtensionState> currentValueSubscription;

    BoolServiceExtensionCheckbox(FlutterApp app, @NotNull ToggleableServiceExtensionDescription<Boolean> extensionDescription, String tooltip) {
        if (extensionDescription == null) {
            BoolServiceExtensionCheckbox.$$$reportNull$$$0(0);
        }
        this.checkbox = new JBCheckBox(extensionDescription.getDisabledText());
        this.checkbox.setHorizontalAlignment(2);
        this.checkbox.setToolTipText(tooltip);
        assert (app.getVMServiceManager() != null);
        app.hasServiceExtension(extensionDescription.getExtension(), this.checkbox::setEnabled, app);
        this.checkbox.addActionListener(l -> {
            boolean newValue = this.checkbox.isSelected();
            app.getVMServiceManager().setServiceExtensionState(extensionDescription.getExtension(), newValue, newValue);
            if (app.isSessionActive()) {
                app.callBooleanExtension(extensionDescription.getExtension(), newValue);
            }
        });
        this.currentValueSubscription = app.getVMServiceManager().getServiceExtensionState(extensionDescription.getExtension()).listen(state -> {
            if (this.checkbox.isSelected() != state.isEnabled()) {
                this.checkbox.setSelected(state.isEnabled());
            }
        }, true);
    }

    JCheckBox getComponent() {
        return this.checkbox;
    }

    public void dispose() {
        if (this.currentValueSubscription != null) {
            Disposer.dispose(this.currentValueSubscription);
            this.currentValueSubscription = null;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extensionDescription", "io/flutter/view/BoolServiceExtensionCheckbox", "<init>"));
    }
}

