/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.view;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.ui.content.ContentManager;
import icons.FlutterIcons;
import io.flutter.FlutterInitializer;
import io.flutter.analytics.Analytics;
import io.flutter.devtools.DevToolsUrl;
import io.flutter.utils.AsyncUtils;
import io.flutter.view.BrowserTab;
import io.flutter.view.EmbeddedTab;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public abstract class EmbeddedBrowser {
    public static final String ANALYTICS_CATEGORY = "embedded-browser";
    protected final Map<@NotNull String, @NotNull BrowserTab> tabs = new HashMap<String, BrowserTab>();
    private final Analytics analytics = FlutterInitializer.getAnalytics();

    public abstract Logger logger();

    public EmbeddedBrowser(Project project) {
        ProjectManager.getInstance().addProjectManagerListener(project, new ProjectManagerListener(){

            public void projectClosing(@NotNull Project project) {
                if (project == null) {
                    1.$$$reportNull$$$0(0);
                }
                for (String tabName : EmbeddedBrowser.this.tabs.keySet()) {
                    BrowserTab tab = EmbeddedBrowser.this.tabs.get(tabName);
                    if (tab.embeddedTab == null) continue;
                    try {
                        tab.embeddedTab.close();
                    }
                    catch (Exception ex) {
                        EmbeddedBrowser.this.logger().info((Throwable)ex);
                    }
                }
                EmbeddedBrowser.this.tabs.clear();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "io/flutter/view/EmbeddedBrowser$1", "projectClosing"));
            }
        });
    }

    public void openPanel(ContentManager contentManager, String tabName, DevToolsUrl devToolsUrl, Consumer<String> onBrowserUnavailable) {
        BrowserTab tab;
        BrowserTab firstTab = this.tabs.get(tabName);
        if (firstTab == null) {
            try {
                this.openBrowserTabFor(tabName);
            }
            catch (Exception ex) {
                this.analytics.sendEvent(ANALYTICS_CATEGORY, "openBrowserTabFailed-" + String.valueOf(this.getClass()));
                onBrowserUnavailable.accept(ex.getMessage());
                return;
            }
        }
        if ((tab = this.tabs.get(tabName)) == null) {
            onBrowserUnavailable.accept("Browser failed to start during setup.");
            return;
        }
        AtomicBoolean contentLoaded = new AtomicBoolean(false);
        try {
            tab.embeddedTab.loadUrl(devToolsUrl.getUrlString());
        }
        catch (Exception ex) {
            tab.devToolsUrlFuture.completeExceptionally(ex);
            onBrowserUnavailable.accept(ex.getMessage());
            this.logger().info((Throwable)ex);
            return;
        }
        tab.devToolsUrlFuture.complete(devToolsUrl);
        JComponent component = tab.embeddedTab.getTabComponent(contentManager);
        ApplicationManager.getApplication().invokeLater(() -> {
            if (contentManager.isDisposed()) {
                return;
            }
            contentManager.removeAllContents(false);
            for (String otherTabName : this.tabs.keySet()) {
                if (otherTabName.equals(tabName)) continue;
                BrowserTab browserTab = this.tabs.get(otherTabName);
                contentManager.addContent(browserTab.content);
            }
            tab.content = contentManager.getFactory().createContent(null, tabName, false);
            tab.content.setComponent(component);
            tab.content.putUserData(ToolWindow.SHOW_CONTENT_ICON, (Object)Boolean.TRUE);
            tab.content.setIcon(FlutterIcons.Phone);
            contentManager.addContent(tab.content);
            contentManager.setSelectedContent(tab.content, true);
        });
    }

    private BrowserTab openBrowserTabFor(String tabName) {
        BrowserTab tab = new BrowserTab();
        tab.devToolsUrlFuture = new CompletableFuture();
        tab.embeddedTab = this.openEmbeddedTab();
        this.tabs.put(tabName, tab);
        return tab;
    }

    public abstract EmbeddedTab openEmbeddedTab();

    public void updatePanelToWidget(String widgetId) {
        this.updateUrlAndReload(devToolsUrl -> {
            devToolsUrl.widgetId = widgetId;
            return devToolsUrl;
        });
    }

    public void updateColor(String newColor) {
        this.updateUrlAndReload(devToolsUrl -> {
            if (devToolsUrl.colorHexCode.equals(newColor)) {
                return null;
            }
            devToolsUrl.colorHexCode = newColor;
            return devToolsUrl;
        });
    }

    public void updateFontSize(float newFontSize) {
        this.updateUrlAndReload(devToolsUrl -> {
            if (devToolsUrl.fontSize.equals(Float.valueOf(newFontSize))) {
                return null;
            }
            devToolsUrl.fontSize = Float.valueOf(newFontSize);
            return devToolsUrl;
        });
    }

    private void updateUrlAndReload(Function<DevToolsUrl, DevToolsUrl> newDevToolsUrlFn) {
        this.tabs.forEach((tabName, tab) -> {
            CompletionStage updatedUrlFuture = tab.devToolsUrlFuture.thenApply(devToolsUrl -> {
                if (devToolsUrl == null) {
                    return null;
                }
                return (DevToolsUrl)newDevToolsUrlFn.apply((DevToolsUrl)devToolsUrl);
            });
            AsyncUtils.whenCompleteUiThread(updatedUrlFuture, (devToolsUrl, ex) -> {
                if (ex != null) {
                    this.logger().info(ex);
                    FlutterInitializer.getAnalytics().sendExpectedException("browser-update", (Throwable)ex);
                    return;
                }
                if (devToolsUrl == null) {
                    return;
                }
                tab.embeddedTab.loadUrl(devToolsUrl.getUrlString());
            });
        });
    }
}

