/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.view;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.execution.runners.ExecutionUtil;
import com.intellij.execution.ui.layout.impl.JBRunnerTabs;
import com.intellij.ide.browsers.BrowserLauncher;
import com.intellij.ide.ui.UISettingsListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.Constraints;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.SimpleToolWindowPanel;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.ActiveRunnable;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ex.ToolWindowManagerEx;
import com.intellij.serviceContainer.NonInjectable;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.labels.LinkLabel;
import com.intellij.ui.components.labels.LinkListener;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentManagerAdapter;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import com.intellij.ui.tabs.TabInfo;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.xdebugger.XSourcePosition;
import icons.FlutterIcons;
import io.flutter.FlutterBundle;
import io.flutter.FlutterInitializer;
import io.flutter.FlutterUtils;
import io.flutter.bazel.WorkspaceCache;
import io.flutter.devtools.DevToolsIdeFeature;
import io.flutter.devtools.DevToolsUrl;
import io.flutter.inspector.DiagnosticsNode;
import io.flutter.inspector.InspectorGroupManagerService;
import io.flutter.inspector.InspectorService;
import io.flutter.inspector.InspectorSourceLocation;
import io.flutter.run.FlutterDevice;
import io.flutter.run.daemon.DevToolsInstance;
import io.flutter.run.daemon.DevToolsService;
import io.flutter.run.daemon.FlutterApp;
import io.flutter.sdk.FlutterSdk;
import io.flutter.sdk.FlutterSdkVersion;
import io.flutter.settings.FlutterSettings;
import io.flutter.toolwindow.FlutterViewToolWindowManagerListener;
import io.flutter.utils.AsyncUtils;
import io.flutter.utils.EventStream;
import io.flutter.view.AppState;
import io.flutter.view.DebugPaintAction;
import io.flutter.view.EmbeddedBrowser;
import io.flutter.view.FlutterViewAction;
import io.flutter.view.FlutterViewMessages;
import io.flutter.view.FlutterViewState;
import io.flutter.view.ForceRefreshAction;
import io.flutter.view.InspectorPanel;
import io.flutter.view.InspectorTabPanel;
import io.flutter.view.LabelInput;
import io.flutter.view.OverflowAction;
import io.flutter.view.PerformanceOverlayAction;
import io.flutter.view.ShowPaintBaselinesAction;
import io.flutter.view.TimeDilationAction;
import io.flutter.view.ToggleOnDeviceWidgetInspector;
import io.flutter.view.TogglePlatformAction;
import io.flutter.view.ToggleSelectWidgetMode;
import io.flutter.vmService.ServiceExtensions;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="FlutterView", storages={@Storage(value="$WORKSPACE_FILE$")})
public class FlutterView
implements PersistentStateComponent<FlutterViewState>,
Disposable {
    private static final Logger LOG = Logger.getInstance(FlutterView.class);
    public static final String TOOL_WINDOW_ID = "Flutter Inspector";
    public static final String WIDGET_TAB_LABEL = "Widgets";
    public static final String RENDER_TAB_LABEL = "Render Tree";
    public static final String PERFORMANCE_TAB_LABEL = "Performance";
    protected static final String DEVTOOLS_FAILED_LABEL = "Setting up DevTools failed.";
    protected static final int INSTALLATION_WAIT_LIMIT_SECONDS = 2000;
    protected final EventStream<Boolean> shouldAutoHorizontalScroll;
    protected final EventStream<Boolean> highlightNodesShownInBothTrees;
    @NotNull
    private final FlutterViewState state;
    @NotNull
    private final Project myProject;
    private final Map<FlutterApp, PerAppState> perAppViewState;
    private final MessageBusConnection busConnection;
    private boolean busSubscribed;
    private Content emptyContent;
    private FlutterViewToolWindowManagerListener toolWindowListener;
    private int devToolsInstallCount;

    public FlutterView(@NotNull Project project) {
        if (project == null) {
            FlutterView.$$$reportNull$$$0(0);
        }
        this(project, InspectorGroupManagerService.getInstance(project), ApplicationManager.getApplication().getMessageBus().connect());
    }

    @NonInjectable
    @VisibleForTesting
    protected FlutterView(final @NotNull Project project, @NotNull InspectorGroupManagerService inspectorGroupManagerService, MessageBusConnection messageBusConnection) {
        if (project == null) {
            FlutterView.$$$reportNull$$$0(1);
        }
        if (inspectorGroupManagerService == null) {
            FlutterView.$$$reportNull$$$0(2);
        }
        this.shouldAutoHorizontalScroll = new EventStream<Boolean>(false);
        this.highlightNodesShownInBothTrees = new EventStream<Boolean>(false);
        this.state = new FlutterViewState();
        this.perAppViewState = new HashMap<FlutterApp, PerAppState>();
        this.busSubscribed = false;
        this.devToolsInstallCount = 0;
        this.myProject = project;
        this.busConnection = messageBusConnection;
        this.shouldAutoHorizontalScroll.listen(this.state::setShouldAutoScroll);
        this.highlightNodesShownInBothTrees.listen(this.state::setHighlightNodesShownInBothTrees);
        inspectorGroupManagerService.addListener(new InspectorGroupManagerService.Listener(){

            @Override
            public void onInspectorAvailable(InspectorService service) {
            }

            @Override
            public void onSelectionChanged(DiagnosticsNode selection) {
                if (selection != null) {
                    XSourcePosition position;
                    XSourcePosition sourcePosition;
                    InspectorSourceLocation location = selection.getCreationLocation();
                    if (location != null && (sourcePosition = location.getXSourcePosition()) != null) {
                        sourcePosition.createNavigatable(project).navigate(true);
                    }
                    if (selection.isCreatedByLocalProject() && (position = selection.getCreationLocation().getXSourcePosition()) != null) {
                        position.createNavigatable(project).navigate(false);
                    }
                }
            }
        }, this);
    }

    public void dispose() {
        this.busConnection.disconnect();
        Disposer.dispose((Disposable)this);
    }

    @NotNull
    public FlutterViewState getState() {
        FlutterViewState flutterViewState = this.state;
        if (flutterViewState == null) {
            FlutterView.$$$reportNull$$$0(3);
        }
        return flutterViewState;
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            FlutterView.$$$reportNull$$$0(4);
        }
        return project;
    }

    public void loadState(@NotNull FlutterViewState state) {
        if (state == null) {
            FlutterView.$$$reportNull$$$0(5);
        }
        this.state.copyFrom(state);
        this.shouldAutoHorizontalScroll.setValue(this.state.getShouldAutoScroll());
        this.highlightNodesShownInBothTrees.setValue(this.state.getHighlightNodesShownInBothTrees());
    }

    void initToolWindow(ToolWindow window) {
        if (window.isDisposed()) {
            return;
        }
        this.updateForEmptyContent(window);
    }

    private DefaultActionGroup createToolbar(@NotNull ToolWindow toolWindow, @NotNull FlutterApp app, InspectorService inspectorService) {
        if (toolWindow == null) {
            FlutterView.$$$reportNull$$$0(6);
        }
        if (app == null) {
            FlutterView.$$$reportNull$$$0(7);
        }
        DefaultActionGroup toolbarGroup = new DefaultActionGroup();
        PerAppState state = this.getOrCreateStateForApp(app);
        if (inspectorService != null) {
            toolbarGroup.addSeparator();
            toolbarGroup.add((AnAction)state.registerAction(new ForceRefreshAction(app, inspectorService)));
        }
        toolbarGroup.addSeparator();
        toolbarGroup.add((AnAction)state.registerAction(new PerformanceOverlayAction(app)));
        toolbarGroup.addSeparator();
        toolbarGroup.add((AnAction)state.registerAction(new DebugPaintAction(app)));
        toolbarGroup.add((AnAction)state.registerAction(new ShowPaintBaselinesAction(app, true)));
        toolbarGroup.addSeparator();
        toolbarGroup.add((AnAction)state.registerAction(new TimeDilationAction(app, true)));
        toolbarGroup.addSeparator();
        toolbarGroup.add((AnAction)new TogglePlatformAction(app, this.getOrCreateStateForApp(app)));
        FlutterViewAction selectModeAction = state.registerAction(new ToggleSelectWidgetMode(app));
        FlutterViewAction legacySelectModeAction = state.registerAction(new ToggleOnDeviceWidgetInspector(app));
        FlutterViewAction[] currentExtension = new FlutterViewAction[]{null};
        assert (app.getVMServiceManager() != null);
        app.getVMServiceManager().hasServiceExtension(ServiceExtensions.enableOnDeviceInspector.getExtension(), hasExtension -> {
            FlutterViewAction nextExtension;
            if (toolWindow.isDisposed() || this.myProject.isDisposed()) {
                return;
            }
            FlutterViewAction flutterViewAction = nextExtension = hasExtension != false ? selectModeAction : legacySelectModeAction;
            if (currentExtension[0] != nextExtension) {
                if (currentExtension[0] != null) {
                    toolbarGroup.remove((AnAction)currentExtension[0]);
                }
                toolbarGroup.add((AnAction)nextExtension, Constraints.FIRST);
                currentExtension[0] = nextExtension;
            }
        });
        return toolbarGroup;
    }

    private PerAppState getStateForApp(FlutterApp app) {
        return this.perAppViewState.get(app);
    }

    private PerAppState getOrCreateStateForApp(FlutterApp app) {
        return this.perAppViewState.computeIfAbsent(app, k -> new PerAppState());
    }

    private void addBrowserInspectorViewContent(FlutterApp app, @Nullable InspectorService inspectorService, ToolWindow toolWindow, boolean isEmbedded, DevToolsIdeFeature ideFeature, DevToolsInstance devToolsInstance) {
        FlutterSdkVersion flutterSdkVersion;
        assert (SwingUtilities.isEventDispatchThread());
        ContentManager contentManager = toolWindow.getContentManager();
        FlutterDevice device = app.device();
        ArrayList<FlutterDevice> existingDevices = new ArrayList<FlutterDevice>();
        for (FlutterApp otherApp : this.perAppViewState.keySet()) {
            existingDevices.add(otherApp.device());
        }
        String tabName = device.getUniqueName(existingDevices);
        if (this.emptyContent != null) {
            contentManager.removeContent(this.emptyContent, true);
            this.emptyContent = null;
        }
        String browserUrl = app.getConnector().getBrowserUrl();
        FlutterSdk flutterSdk = FlutterSdk.getFlutterSdk(app.getProject());
        FlutterSdkVersion flutterSdkVersion2 = flutterSdkVersion = flutterSdk == null ? null : flutterSdk.getVersion();
        if (isEmbedded) {
            String color = ColorUtil.toHex((Color)UIUtil.getEditorPaneBackground());
            DevToolsUrl devToolsUrl = new DevToolsUrl(devToolsInstance.host, devToolsInstance.port, browserUrl, "inspector", true, color, Float.valueOf(UIUtil.getFontSize((UIUtil.FontSize)UIUtil.FontSize.NORMAL)), flutterSdkVersion, WorkspaceCache.getInstance(app.getProject()), ideFeature);
            ApplicationManager.getApplication().invokeLater(() -> this.embeddedBrowserOptional().ifPresent(embeddedBrowser -> embeddedBrowser.openPanel(contentManager, tabName, devToolsUrl, error -> {
                List<LabelInput> inputs = Arrays.asList(new LabelInput("The embedded browser failed to load. Error: " + error), this.openDevToolsLabel(app, inspectorService, toolWindow, ideFeature));
                this.presentClickableLabel(toolWindow, inputs);
            })));
            if (!this.busSubscribed) {
                this.busConnection.subscribe(EditorColorsManager.TOPIC, scheme -> this.embeddedBrowserOptional().ifPresent(embeddedBrowser -> embeddedBrowser.updateColor(ColorUtil.toHex((Color)UIUtil.getEditorPaneBackground()))));
                this.busConnection.subscribe(UISettingsListener.TOPIC, scheme -> this.embeddedBrowserOptional().ifPresent(embeddedBrowser -> embeddedBrowser.updateFontSize(UIUtil.getFontSize((UIUtil.FontSize)UIUtil.FontSize.NORMAL))));
                this.busSubscribed = true;
            }
        } else {
            BrowserLauncher.getInstance().browse(new DevToolsUrl(devToolsInstance.host, devToolsInstance.port, browserUrl, "inspector", false, null, null, flutterSdkVersion, WorkspaceCache.getInstance(app.getProject()), ideFeature).getUrlString(), null);
            this.presentLabel(toolWindow, "DevTools inspector has been opened in the browser.");
        }
    }

    private Optional<EmbeddedBrowser> embeddedBrowserOptional() {
        if (this.myProject.isDisposed()) {
            return Optional.empty();
        }
        return Optional.ofNullable(FlutterUtils.embeddedBrowser(this.myProject));
    }

    private void addInspectorViewContent(FlutterApp app, @Nullable InspectorService inspectorService, ToolWindow toolWindow) {
        boolean hasInspectorService;
        String tabName;
        ContentManager contentManager = toolWindow.getContentManager();
        SimpleToolWindowPanel toolWindowPanel = new SimpleToolWindowPanel(true);
        JBRunnerTabs runnerTabs = new JBRunnerTabs(this.myProject, ActionManager.getInstance(), IdeFocusManager.getInstance((Project)this.myProject), (Disposable)this);
        runnerTabs.setSelectionChangeHandler(this::onTabSelectionChange);
        JPanel tabContainer = new JPanel(new BorderLayout());
        FlutterDevice device = app.device();
        if (device == null) {
            tabName = app.getProject().getName();
        } else {
            ArrayList<FlutterDevice> existingDevices = new ArrayList<FlutterDevice>();
            for (FlutterApp otherApp : this.perAppViewState.keySet()) {
                existingDevices.add(otherApp.device());
            }
            tabName = device.getUniqueName(existingDevices);
        }
        Content content = contentManager.getFactory().createContent(null, tabName, false);
        tabContainer.add((Component)runnerTabs.getComponent(), "Center");
        content.setComponent((JComponent)tabContainer);
        content.putUserData(ToolWindow.SHOW_CONTENT_ICON, (Object)Boolean.TRUE);
        content.setIcon(FlutterIcons.Phone);
        contentManager.addContent(content);
        if (this.emptyContent != null) {
            contentManager.removeContent(this.emptyContent, true);
            this.emptyContent = null;
        }
        contentManager.setSelectedContent(content);
        PerAppState state = this.getOrCreateStateForApp(app);
        assert (state.content == null);
        state.content = content;
        DefaultActionGroup toolbarGroup = this.createToolbar(toolWindow, app, inspectorService);
        toolWindowPanel.setToolbar(ActionManager.getInstance().createActionToolbar("FlutterViewToolbar", (ActionGroup)toolbarGroup, true).getComponent());
        toolbarGroup.add((AnAction)new OverflowAction(this.getOrCreateStateForApp(app), this, app));
        ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("InspectorToolbar", (ActionGroup)toolbarGroup, true);
        JComponent toolbarComponent = toolbar.getComponent();
        toolbarComponent.setBorder(IdeBorderFactory.createBorder((int)8));
        tabContainer.add((Component)toolbarComponent, "North");
        boolean debugConnectionAvailable = app.getLaunchMode().supportsDebugConnection();
        boolean bl = hasInspectorService = inspectorService != null;
        if (debugConnectionAvailable) {
            if (hasInspectorService) {
                boolean detailsSummaryViewSupported = inspectorService.isDetailsSummaryViewSupported();
                this.addInspectorPanel(WIDGET_TAB_LABEL, runnerTabs, state, InspectorService.FlutterTreeType.widget, app, inspectorService, toolWindow, toolbarGroup, true, detailsSummaryViewSupported);
                this.addInspectorPanel(RENDER_TAB_LABEL, runnerTabs, state, InspectorService.FlutterTreeType.renderObject, app, inspectorService, toolWindow, toolbarGroup, false, false);
            } else {
                this.addDisabledTab(WIDGET_TAB_LABEL, runnerTabs, toolbarGroup);
                this.addDisabledTab(RENDER_TAB_LABEL, runnerTabs, toolbarGroup);
            }
        } else {
            JBLabel label = new JBLabel("Inspector not available in release mode", 0);
            label.setForeground(UIUtil.getLabelDisabledForeground());
            tabContainer.add((Component)label, "Center");
        }
    }

    private ActionCallback onTabSelectionChange(TabInfo info, boolean requestFocus, @NotNull ActiveRunnable doChangeSelection) {
        TabInfo previous;
        if (doChangeSelection == null) {
            FlutterView.$$$reportNull$$$0(8);
        }
        if (info.getComponent() instanceof InspectorTabPanel) {
            InspectorTabPanel panel2 = (InspectorTabPanel)((Object)info.getComponent());
            panel2.setVisibleToUser(true);
        }
        if ((previous = info.getPreviousSelection()) != null) {
            FlutterInitializer.getAnalytics().sendScreenView(TOOL_WINDOW_ID.toLowerCase() + "/" + info.getText().toLowerCase());
        }
        if (previous != null && previous.getComponent() instanceof InspectorTabPanel) {
            InspectorTabPanel panel3 = (InspectorTabPanel)((Object)previous.getComponent());
            panel3.setVisibleToUser(false);
        }
        return doChangeSelection.run();
    }

    private void addInspectorPanel(String displayName, JBRunnerTabs tabs, PerAppState state, InspectorService.FlutterTreeType treeType, FlutterApp app, InspectorService inspectorService, @NotNull ToolWindow toolWindow, DefaultActionGroup toolbarGroup, boolean selectedTab, boolean useSummaryTree) {
        if (toolWindow == null) {
            FlutterView.$$$reportNull$$$0(9);
        }
        InspectorPanel inspectorPanel = new InspectorPanel(this, app, inspectorService, (Computable<Boolean>)((Computable)app::isSessionActive), treeType, useSummaryTree, treeType != InspectorService.FlutterTreeType.widget || !inspectorService.isDetailsSummaryViewSupported(), this.shouldAutoHorizontalScroll, this.highlightNodesShownInBothTrees);
        TabInfo tabInfo = new TabInfo((JComponent)inspectorPanel).append(displayName, SimpleTextAttributes.REGULAR_ATTRIBUTES);
        tabs.addTab(tabInfo);
        state.inspectorPanels.add(inspectorPanel);
        if (selectedTab) {
            tabs.select(tabInfo, false);
        }
    }

    private void addDisabledTab(String displayName, JBRunnerTabs runnerTabs, DefaultActionGroup toolbarGroup) {
        JPanel panel2 = new JPanel(new BorderLayout());
        JBLabel label = new JBLabel("Widget info not available in profile mode", 0);
        label.setForeground(UIUtil.getLabelDisabledForeground());
        panel2.add((Component)label, "Center");
        TabInfo tabInfo = new TabInfo((JComponent)panel2).append(displayName, SimpleTextAttributes.GRAYED_ATTRIBUTES);
        runnerTabs.addTab(tabInfo);
    }

    public void debugActive(@NotNull FlutterViewMessages.FlutterDebugEvent event) {
        FlutterApp app;
        if (event == null) {
            FlutterView.$$$reportNull$$$0(10);
        }
        if ((app = event.app).getFlutterDebugProcess() == null || app.getFlutterDebugProcess().getInspectorService() == null) {
            return;
        }
        if (app.getMode().isProfiling() || app.getLaunchMode().isProfiling()) {
            ApplicationManager.getApplication().invokeLater(() -> this.debugActiveHelper(app, null));
        } else {
            AsyncUtils.whenCompleteUiThread(app.getFlutterDebugProcess().getInspectorService(), (inspectorService, throwable) -> {
                if (throwable != null) {
                    FlutterUtils.warn(LOG, throwable);
                    return;
                }
                this.debugActiveHelper(app, (InspectorService)inspectorService);
            });
        }
    }

    private void presentDevTools(FlutterApp app, InspectorService inspectorService, ToolWindow toolWindow, boolean isEmbedded, DevToolsIdeFeature ideFeature) {
        this.verifyEventDispatchThread();
        ++this.devToolsInstallCount;
        this.presentLabel(toolWindow, this.getInstallingDevtoolsLabel());
        this.openInspectorWithDevTools(app, inspectorService, toolWindow, isEmbedded, ideFeature);
        this.setUpToolWindowListener(app, inspectorService, toolWindow, isEmbedded, ideFeature);
    }

    @VisibleForTesting
    protected void verifyEventDispatchThread() {
        assert (SwingUtilities.isEventDispatchThread());
    }

    @VisibleForTesting
    protected void setUpToolWindowListener(FlutterApp app, InspectorService inspectorService, ToolWindow toolWindow, boolean isEmbedded, DevToolsIdeFeature ideFeature) {
        if (this.toolWindowListener == null) {
            this.toolWindowListener = new FlutterViewToolWindowManagerListener(this.myProject, toolWindow);
        }
        this.toolWindowListener.updateOnWindowOpen(() -> {
            ++this.devToolsInstallCount;
            this.presentLabel(toolWindow, this.getInstallingDevtoolsLabel());
            this.openInspectorWithDevTools(app, inspectorService, toolWindow, isEmbedded, ideFeature, true);
        });
    }

    private String getInstallingDevtoolsLabel() {
        return "<html><body style=\"text-align: center;\">" + FlutterBundle.message("flutter.devtools.installing", this.devToolsInstallCount) + "</body></html>";
    }

    @VisibleForTesting
    protected void openInspectorWithDevTools(FlutterApp app, InspectorService inspectorService, ToolWindow toolWindow, boolean isEmbedded, DevToolsIdeFeature ideFeature) {
        this.openInspectorWithDevTools(app, inspectorService, toolWindow, isEmbedded, ideFeature, false);
    }

    private void openInspectorWithDevTools(FlutterApp app, InspectorService inspectorService, ToolWindow toolWindow, boolean isEmbedded, DevToolsIdeFeature ideFeature, boolean forceDevToolsRestart) {
        AsyncUtils.whenCompleteUiThread(forceDevToolsRestart ? DevToolsService.getInstance(this.myProject).getDevToolsInstanceWithForcedRestart() : DevToolsService.getInstance(this.myProject).getDevToolsInstance(), (instance, error) -> {
            if (!this.myProject.isOpen()) {
                return;
            }
            if (error != null) {
                LOG.error(error);
                this.presentLabel(toolWindow, DEVTOOLS_FAILED_LABEL);
                return;
            }
            if (instance == null) {
                this.presentLabel(toolWindow, DEVTOOLS_FAILED_LABEL);
                return;
            }
            this.addBrowserInspectorViewContent(app, inspectorService, toolWindow, isEmbedded, ideFeature, (DevToolsInstance)instance);
        });
    }

    private LabelInput openDevToolsLabel(FlutterApp app, InspectorService inspectorService, ToolWindow toolWindow, DevToolsIdeFeature ideFeature) {
        return new LabelInput("Open DevTools in the browser?", (LinkListener<String>)((LinkListener)(linkLabel, data) -> this.presentDevTools(app, inspectorService, toolWindow, false, ideFeature)));
    }

    protected void presentLabel(ToolWindow toolWindow, String text) {
        JBLabel label = new JBLabel(text, 0);
        label.setForeground(UIUtil.getLabelDisabledForeground());
        this.replacePanelLabel(toolWindow, (JComponent)label);
    }

    protected void presentClickableLabel(ToolWindow toolWindow, List<LabelInput> labels) {
        JPanel panel2 = new JPanel(new GridLayout(0, 1));
        for (LabelInput input : labels) {
            if (input.listener == null) {
                JLabel descriptionLabel = new JLabel("<html>" + input.text + "</html>");
                descriptionLabel.setBorder(JBUI.Borders.empty((int)5));
                descriptionLabel.setHorizontalAlignment(0);
                panel2.add((Component)descriptionLabel, "North");
                continue;
            }
            LinkLabel linkLabel = new LinkLabel("<html>" + input.text + "</html>", null);
            linkLabel.setBorder(JBUI.Borders.empty((int)5));
            linkLabel.setListener(input.listener, null);
            linkLabel.setHorizontalAlignment(0);
            panel2.add((Component)linkLabel, "South");
        }
        JPanel center = new JPanel((LayoutManager)new VerticalFlowLayout(1));
        center.add(panel2);
        this.replacePanelLabel(toolWindow, center);
    }

    private void replacePanelLabel(ToolWindow toolWindow, JComponent label) {
        ApplicationManager.getApplication().invokeLater(() -> {
            ContentManager contentManager = toolWindow.getContentManager();
            if (contentManager.isDisposed()) {
                return;
            }
            JPanel panel2 = new JPanel(new BorderLayout());
            panel2.add((Component)label, "Center");
            Content content = contentManager.getFactory().createContent((JComponent)panel2, null, false);
            contentManager.removeAllContents(true);
            contentManager.addContent(content);
        });
    }

    private void debugActiveHelper(FlutterApp app, @Nullable InspectorService inspectorService) {
        ToolWindowManager toolWindowManager = ToolWindowManager.getInstance((Project)this.myProject);
        if (!(toolWindowManager instanceof ToolWindowManagerEx)) {
            return;
        }
        ToolWindow toolWindow = toolWindowManager.getToolWindow(TOOL_WINDOW_ID);
        if (toolWindow == null) {
            return;
        }
        AtomicReference<Object> ideFeature = new AtomicReference<Object>(null);
        if (toolWindow.isAvailable()) {
            ideFeature.set(this.updateToolWindowVisibility(toolWindow));
        } else {
            toolWindow.setAvailable(true, () -> ideFeature.set(this.updateToolWindowVisibility(toolWindow)));
        }
        if (this.emptyContent != null) {
            ContentManager contentManager = toolWindow.getContentManager();
            contentManager.removeContent(this.emptyContent, true);
            this.emptyContent = null;
        }
        toolWindow.setIcon(ExecutionUtil.getLiveIndicator((Icon)FlutterIcons.Flutter_13));
        if (toolWindow.isVisible()) {
            this.displayEmbeddedBrowser(app, inspectorService, toolWindow, ideFeature.get());
        } else {
            if (this.toolWindowListener == null) {
                this.toolWindowListener = new FlutterViewToolWindowManagerListener(this.myProject, toolWindow);
            }
            this.toolWindowListener.updateOnWindowFirstVisible(() -> this.displayEmbeddedBrowser(app, inspectorService, toolWindow, DevToolsIdeFeature.TOOL_WINDOW));
        }
    }

    private void displayEmbeddedBrowser(FlutterApp app, InspectorService inspectorService, ToolWindow toolWindow, DevToolsIdeFeature ideFeature) {
        this.presentDevTools(app, inspectorService, toolWindow, true, ideFeature);
    }

    private void updateForEmptyContent(ToolWindow toolWindow) {
        if (toolWindow.isDisposed()) {
            return;
        }
        toolWindow.setIcon(FlutterIcons.Flutter_13);
        ContentManager contentManager = toolWindow.getContentManager();
        JPanel panel2 = new JPanel(new BorderLayout());
        JBLabel label = new JBLabel("No running applications", 0);
        label.setForeground(UIUtil.getLabelDisabledForeground());
        panel2.add((Component)label, "Center");
        this.emptyContent = contentManager.getFactory().createContent((JComponent)panel2, null, false);
        contentManager.addContent(this.emptyContent);
    }

    private static void listenForRenderTreeActivations(@NotNull ToolWindow toolWindow) {
        if (toolWindow == null) {
            FlutterView.$$$reportNull$$$0(11);
        }
        ContentManager contentManager = toolWindow.getContentManager();
        contentManager.addContentManagerListener((ContentManagerListener)new ContentManagerAdapter(){

            public void selectionChanged(@NotNull ContentManagerEvent event) {
                ContentManagerEvent.ContentOperation operation;
                if (event == null) {
                    2.$$$reportNull$$$0(0);
                }
                if ((operation = event.getOperation()) == ContentManagerEvent.ContentOperation.add) {
                    String name = event.getContent().getTabName();
                    if (Objects.equals(name, FlutterView.RENDER_TAB_LABEL)) {
                        FlutterInitializer.getAnalytics().sendEvent("inspector", "renderTreeSelected");
                    } else if (Objects.equals(name, FlutterView.WIDGET_TAB_LABEL)) {
                        FlutterInitializer.getAnalytics().sendEvent("inspector", "widgetTreeSelected");
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "io/flutter/view/FlutterView$2", "selectionChanged"));
            }
        });
    }

    private void handleFlutterFrame(FlutterApp app) {
        PerAppState state = this.getStateForApp(app);
        if (state != null && state.sendRestartNotificationOnNextFrame) {
            state.sendRestartNotificationOnNextFrame = false;
            this.notifyActionsOnRestart(app);
        }
    }

    private void notifyActionsAppStarted(FlutterApp app) {
        PerAppState state = this.getStateForApp(app);
        if (state == null) {
            return;
        }
        for (FlutterViewAction action : state.flutterViewActions) {
            action.handleAppStarted();
        }
    }

    private void notifyActionsOnRestart(FlutterApp app) {
        PerAppState state = this.getStateForApp(app);
        if (state == null) {
            return;
        }
        for (FlutterViewAction action : state.flutterViewActions) {
            action.handleAppRestarted();
        }
    }

    private void notifyActionsAppStopped(FlutterApp app) {
        PerAppState state = this.getStateForApp(app);
        if (state == null) {
            return;
        }
        state.sendRestartNotificationOnNextFrame = false;
    }

    private void onAppChanged(FlutterApp app) {
        if (this.myProject.isDisposed()) {
            return;
        }
        ToolWindow toolWindow = ToolWindowManager.getInstance((Project)this.myProject).getToolWindow(TOOL_WINDOW_ID);
        if (toolWindow == null) {
            return;
        }
        if (this.perAppViewState.isEmpty()) {
            this.notifyActionsAppStopped(app);
        } else {
            this.notifyActionsAppStarted(app);
        }
        PerAppState state = this.getStateForApp(app);
        if (state != null) {
            for (InspectorPanel inspectorPanel : state.inspectorPanels) {
                inspectorPanel.onAppChanged();
            }
        }
    }

    private DevToolsIdeFeature updateToolWindowVisibility(ToolWindow flutterToolWindow) {
        if (flutterToolWindow.isVisible()) {
            return DevToolsIdeFeature.TOOL_WINDOW_RELOAD;
        }
        if (FlutterSettings.getInstance().isOpenInspectorOnAppLaunch()) {
            flutterToolWindow.show(null);
            return DevToolsIdeFeature.ON_DEBUG_AUTOMATIC;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inspectorGroupManagerService";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "io/flutter/view/FlutterView";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 6: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWindow";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "app";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "doChangeSelection";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "io/flutter/view/FlutterView";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createToolbar";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "onTabSelectionChange";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addInspectorPanel";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "debugActive";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "listenForRenderTreeActivations";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4 -> new IllegalStateException(string);
        };
    }

    private static class PerAppState
    extends AppState {
        ArrayList<InspectorPanel> inspectorPanels = new ArrayList();
        boolean sendRestartNotificationOnNextFrame = false;

        private PerAppState() {
        }

        public void dispose() {
            for (InspectorPanel panel2 : this.inspectorPanels) {
                Disposer.dispose((Disposable)panel2);
            }
        }
    }
}

