/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.view;

import com.intellij.ide.browsers.BrowserLauncher;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.diagnostic.Logger;
import icons.FlutterIcons;
import io.flutter.bazel.WorkspaceCache;
import io.flutter.devtools.DevToolsUrl;
import io.flutter.run.daemon.DevToolsService;
import io.flutter.run.daemon.FlutterApp;
import io.flutter.sdk.FlutterSdk;
import io.flutter.utils.AsyncUtils;
import io.flutter.view.FlutterViewAction;
import org.jetbrains.annotations.NotNull;

class FlutterViewDevToolsAction
extends FlutterViewAction {
    private static final Logger LOG = Logger.getInstance(FlutterViewDevToolsAction.class);

    FlutterViewDevToolsAction(@NotNull FlutterApp app) {
        if (app == null) {
            FlutterViewDevToolsAction.$$$reportNull$$$0(0);
        }
        super(app, "Open DevTools", "Open Dart DevTools", FlutterIcons.Dart_16);
    }

    @Override
    public void perform(AnActionEvent event) {
        if (this.app.isSessionActive()) {
            String urlString = this.app.getConnector().getBrowserUrl();
            if (urlString == null) {
                return;
            }
            AsyncUtils.whenCompleteUiThread(DevToolsService.getInstance(this.app.getProject()).getDevToolsInstance(), (instance, ex) -> {
                if (this.app.getProject().isDisposed()) {
                    return;
                }
                if (ex != null) {
                    LOG.error(ex);
                    return;
                }
                FlutterSdk flutterSdk = FlutterSdk.getFlutterSdk(this.app.getProject());
                BrowserLauncher.getInstance().browse(new DevToolsUrl(instance.host, instance.port, urlString, null, false, null, null, flutterSdk == null ? null : flutterSdk.getVersion(), WorkspaceCache.getInstance(this.app.getProject()), null).getUrlString(), null);
            });
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "app", "io/flutter/view/FlutterViewDevToolsAction", "<init>"));
    }
}

