/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.view;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowFactory;
import com.intellij.openapi.wm.ToolWindowManager;
import io.flutter.utils.ViewListener;
import io.flutter.view.FlutterView;
import io.flutter.view.FlutterViewMessages;
import org.jetbrains.annotations.NotNull;

public class FlutterViewFactory
implements ToolWindowFactory,
DumbAware {
    private static final String TOOL_WINDOW_VISIBLE_PROPERTY = "flutter.view.tool.window.visible";

    public static void init(@NotNull Project project) {
        if (project == null) {
            FlutterViewFactory.$$$reportNull$$$0(0);
        }
        project.getMessageBus().connect().subscribe(FlutterViewMessages.FLUTTER_DEBUG_TOPIC, event -> FlutterViewFactory.initFlutterView(project, event));
        ToolWindow window = ToolWindowManager.getInstance((Project)project).getToolWindow("Flutter Inspector");
        if (window != null) {
            window.setAvailable(true);
            if (PropertiesComponent.getInstance((Project)project).getBoolean(TOOL_WINDOW_VISIBLE_PROPERTY, false)) {
                window.activate(null, false);
            }
        }
    }

    public boolean shouldBeAvailable(@NotNull Project project) {
        if (project == null) {
            FlutterViewFactory.$$$reportNull$$$0(1);
        }
        return false;
    }

    private static void initFlutterView(@NotNull Project project, FlutterViewMessages.FlutterDebugEvent event) {
        if (project == null) {
            FlutterViewFactory.$$$reportNull$$$0(2);
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            FlutterView flutterView = (FlutterView)project.getService(FlutterView.class);
            flutterView.debugActive(event);
        });
    }

    public void createToolWindowContent(@NotNull Project project, @NotNull ToolWindow toolWindow) {
        if (project == null) {
            FlutterViewFactory.$$$reportNull$$$0(3);
        }
        if (toolWindow == null) {
            FlutterViewFactory.$$$reportNull$$$0(4);
        }
        DumbService.getInstance((Project)project).runWhenSmart(() -> ((FlutterView)project.getService(FlutterView.class)).initToolWindow(toolWindow));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWindow";
                break;
            }
        }
        objectArray2[1] = "io/flutter/view/FlutterViewFactory";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "init";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "shouldBeAvailable";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "initFlutterView";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "createToolWindowContent";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class FlutterViewListener
    extends ViewListener {
        public FlutterViewListener(@NotNull Project project) {
            if (project == null) {
                FlutterViewListener.$$$reportNull$$$0(0);
            }
            super(project, "Flutter Inspector", FlutterViewFactory.TOOL_WINDOW_VISIBLE_PROPERTY);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "io/flutter/view/FlutterViewFactory$FlutterViewListener", "<init>"));
        }
    }
}

