/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.view;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Toggleable;
import com.intellij.openapi.application.ApplicationManager;
import io.flutter.run.daemon.FlutterApp;
import io.flutter.utils.EventStream;
import io.flutter.utils.StreamSubscription;
import io.flutter.view.FlutterViewAction;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class FlutterViewLocalToggleableAction
extends FlutterViewAction
implements Toggleable,
Disposable {
    private boolean selected;
    private StreamSubscription<Boolean> subscription;
    private final EventStream<Boolean> stream;

    FlutterViewLocalToggleableAction(@NotNull FlutterApp app, @Nullable String text, EventStream<Boolean> stream) {
        if (app == null) {
            FlutterViewLocalToggleableAction.$$$reportNull$$$0(0);
        }
        super(app, text);
        this.selected = false;
        this.stream = stream;
    }

    FlutterViewLocalToggleableAction(@NotNull FlutterApp app, @Nullable String text, @Nullable String description, @Nullable Icon icon, EventStream<Boolean> stream) {
        if (app == null) {
            FlutterViewLocalToggleableAction.$$$reportNull$$$0(1);
        }
        super(app, text, description, icon);
        this.selected = false;
        this.stream = stream;
    }

    @Override
    public final void update(@NotNull AnActionEvent e) {
        if (e == null) {
            FlutterViewLocalToggleableAction.$$$reportNull$$$0(2);
        }
        boolean selected = this.isSelected();
        Presentation presentation = e.getPresentation();
        presentation.putClientProperty("selected", (Object)selected);
        if (!this.app.isSessionActive()) {
            if (this.subscription != null) {
                this.subscription.dispose();
                this.subscription = null;
            }
            e.getPresentation().setEnabled(false);
            return;
        }
        if (this.subscription == null) {
            this.subscription = this.stream.listen(value -> this.setSelected(e, (boolean)value), true);
        }
    }

    public void dispose() {
        if (this.subscription != null) {
            this.subscription.dispose();
            this.subscription = null;
        }
    }

    @Override
    public void actionPerformed(@NotNull AnActionEvent event) {
        if (event == null) {
            FlutterViewLocalToggleableAction.$$$reportNull$$$0(3);
        }
        this.setSelected(event, !this.isSelected());
        Presentation presentation = event.getPresentation();
        presentation.putClientProperty("selected", (Object)this.isSelected());
        super.actionPerformed(event);
    }

    @Override
    protected void perform(@Nullable AnActionEvent event) {
        this.stream.setValue(this.selected);
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(@Nullable AnActionEvent event, boolean selected) {
        this.selected = selected;
        if (event != null) {
            ApplicationManager.getApplication().invokeLater(() -> this.update(event));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "app";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
        }
        objectArray2[1] = "io/flutter/view/FlutterViewLocalToggleableAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

