/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.view;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Toggleable;
import com.intellij.openapi.application.ApplicationManager;
import io.flutter.run.daemon.FlutterApp;
import io.flutter.utils.StreamSubscription;
import io.flutter.view.FlutterViewAction;
import io.flutter.vmService.ServiceExtensionState;
import io.flutter.vmService.ToggleableServiceExtensionDescription;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class FlutterViewToggleableAction<T>
extends FlutterViewAction
implements Toggleable,
Disposable {
    private final ToggleableServiceExtensionDescription<T> extensionDescription;
    private StreamSubscription<ServiceExtensionState> currentValueSubscription;
    private StreamSubscription<Boolean> enabledSubscription;

    FlutterViewToggleableAction(@NotNull FlutterApp app, @Nullable Icon icon, ToggleableServiceExtensionDescription<T> extensionDescription) {
        if (app == null) {
            FlutterViewToggleableAction.$$$reportNull$$$0(0);
        }
        super(app, extensionDescription.getDisabledText(), null, icon);
        this.extensionDescription = extensionDescription;
    }

    @Override
    public final void update(@NotNull AnActionEvent e) {
        if (e == null) {
            FlutterViewToggleableAction.$$$reportNull$$$0(1);
        }
        boolean selected = this.isSelected();
        Presentation presentation = e.getPresentation();
        presentation.putClientProperty("selected", (Object)selected);
        if (!this.app.isSessionActive()) {
            this.dispose();
            e.getPresentation().setEnabled(false);
            return;
        }
        if (this.currentValueSubscription == null) {
            this.currentValueSubscription = this.app.getVMServiceManager().getServiceExtensionState(this.extensionDescription.getExtension()).listen(state -> {
                if (presentation.getClientProperty("selected") != Boolean.valueOf(state.isEnabled())) {
                    presentation.putClientProperty("selected", (Object)state.isEnabled());
                }
            }, true);
            this.enabledSubscription = this.app.hasServiceExtension(this.extensionDescription.getExtension(), enabled -> presentation.setEnabled(this.app.isSessionActive() && enabled != false));
        }
        presentation.setText(this.isSelected() ? this.extensionDescription.getEnabledText() : this.extensionDescription.getDisabledText());
    }

    public void dispose() {
        if (this.currentValueSubscription != null) {
            this.currentValueSubscription.dispose();
            this.currentValueSubscription = null;
        }
        if (this.enabledSubscription != null) {
            this.enabledSubscription.dispose();
            this.enabledSubscription = null;
        }
    }

    @Override
    protected void perform(AnActionEvent event) {
        if (this.app.isSessionActive()) {
            this.app.callBooleanExtension(this.extensionDescription.getExtension(), this.isSelected());
        }
    }

    @Override
    public void actionPerformed(@NotNull AnActionEvent event) {
        if (event == null) {
            FlutterViewToggleableAction.$$$reportNull$$$0(2);
        }
        this.setSelected(event, !this.isSelected());
        super.actionPerformed(event);
    }

    public boolean isSelected() {
        return this.app.getVMServiceManager().getServiceExtensionState(this.extensionDescription.getExtension()).getValue().isEnabled();
    }

    public void setSelected(@Nullable AnActionEvent event, boolean selected) {
        this.app.getVMServiceManager().setServiceExtensionState(this.extensionDescription.getExtension(), selected, selected ? this.extensionDescription.getEnabledValue() : this.extensionDescription.getDisabledValue());
        if (event != null) {
            ApplicationManager.getApplication().invokeLater(() -> this.update(event));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "app";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
        }
        objectArray2[1] = "io/flutter/view/FlutterViewToggleableAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

