/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.view;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.ColoredTableCellRenderer;
import com.intellij.ui.JBColor;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.dualView.TreeTableView;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.ui.treeStructure.treetable.ListTreeTableModelOnColumns;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.tree.TreeUtil;
import io.flutter.FlutterBundle;
import io.flutter.FlutterUtils;
import io.flutter.editor.FlutterMaterialIcons;
import io.flutter.inspector.DiagnosticLevel;
import io.flutter.inspector.DiagnosticsNode;
import io.flutter.inspector.DiagnosticsPathNode;
import io.flutter.inspector.InspectorInstanceRef;
import io.flutter.inspector.InspectorObjectGroupManager;
import io.flutter.inspector.InspectorService;
import io.flutter.inspector.InspectorTree;
import io.flutter.inspector.TreeScrollAnimator;
import io.flutter.inspector.TreeUtils;
import io.flutter.run.daemon.FlutterApp;
import io.flutter.utils.AsyncRateLimiter;
import io.flutter.utils.AsyncUtils;
import io.flutter.utils.ColorIconMaker;
import io.flutter.utils.CustomIconMaker;
import io.flutter.utils.EventStream;
import io.flutter.utils.StreamSubscription;
import io.flutter.view.DiagnosticsTreeCellRenderer;
import io.flutter.view.FlutterView;
import io.flutter.view.InspectorTabPanel;
import io.flutter.view.InspectorTreeMouseListener;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.dartlang.vm.service.element.InstanceRef;
import org.dartlang.vm.service.element.IsolateRef;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InspectorPanel
extends JPanel
implements Disposable,
InspectorService.InspectorServiceClient,
InspectorTabPanel {
    public static final double REFRESH_FRAMES_PER_SECOND = 5.0;
    private static final SimpleTextAttributes WARNING_ATTRIBUTES = new SimpleTextAttributes(0, (Color)JBColor.ORANGE);
    private static final Logger LOG = Logger.getInstance(InspectorPanel.class);
    protected final boolean detailsSubtree;
    protected final boolean isSummaryTree;
    @Nullable
    protected final InspectorPanel parentTree;
    protected final InspectorPanel subtreePanel;
    final CustomIconMaker iconMaker;
    final Splitter treeSplitter;
    final Icon defaultIcon;
    final JBScrollPane treeScrollPane;
    private final InspectorTree myRootsTree;
    @Nullable
    private final PropertiesPanel myPropertiesPanel;
    private final Computable<Boolean> isApplicable;
    private final InspectorService.FlutterTreeType treeType;
    @NotNull
    private final FlutterApp flutterApp;
    @NotNull
    private final InspectorService inspectorService;
    private final StreamSubscription<IsolateRef> flutterIsolateSubscription;
    private final TreeScrollAnimator scrollAnimator;
    private final boolean legacyMode;
    @Nullable
    private AsyncRateLimiter refreshRateLimiter;
    private final InspectorObjectGroupManager treeGroups;
    private final InspectorObjectGroupManager selectionGroups;
    protected DefaultMutableTreeNode currentShowNode;
    boolean flutterAppFrameReady;
    private boolean treeLoadStarted;
    private DiagnosticsNode subtreeRoot;
    private boolean programaticSelectionChangeInProgress;
    private boolean programaticExpansionInProgress;
    private DefaultMutableTreeNode selectedNode;
    private DefaultMutableTreeNode lastExpanded;
    private boolean isActive;
    private final Map<InspectorInstanceRef, DefaultMutableTreeNode> valueToTreeNode;
    private boolean visibleToUser;
    private boolean highlightNodesShownInBothTrees;

    public InspectorPanel(FlutterView flutterView, @NotNull FlutterApp flutterApp, @NotNull InspectorService inspectorService, @NotNull Computable<Boolean> isApplicable, @NotNull InspectorService.FlutterTreeType treeType, boolean isSummaryTree, boolean legacyMode, @NotNull EventStream<Boolean> shouldAutoHorizontalScroll, @NotNull EventStream<Boolean> highlightNodesShownInBothTrees) {
        if (flutterApp == null) {
            InspectorPanel.$$$reportNull$$$0(0);
        }
        if (inspectorService == null) {
            InspectorPanel.$$$reportNull$$$0(1);
        }
        if (isApplicable == null) {
            InspectorPanel.$$$reportNull$$$0(2);
        }
        if (treeType == null) {
            InspectorPanel.$$$reportNull$$$0(3);
        }
        if (shouldAutoHorizontalScroll == null) {
            InspectorPanel.$$$reportNull$$$0(4);
        }
        if (highlightNodesShownInBothTrees == null) {
            InspectorPanel.$$$reportNull$$$0(5);
        }
        this(flutterView, flutterApp, inspectorService, isApplicable, treeType, false, null, isSummaryTree, legacyMode, shouldAutoHorizontalScroll, highlightNodesShownInBothTrees);
    }

    private InspectorPanel(final FlutterView flutterView, @NotNull FlutterApp flutterApp, @NotNull InspectorService inspectorService, @NotNull Computable<Boolean> isApplicable, @NotNull InspectorService.FlutterTreeType treeType, boolean detailsSubtree, @Nullable InspectorPanel parentTree, boolean isSummaryTree, boolean legacyMode, @NotNull EventStream<Boolean> shouldAutoHorizontalScroll, @NotNull EventStream<Boolean> highlightNodesShownInBothTrees) {
        if (flutterApp == null) {
            InspectorPanel.$$$reportNull$$$0(6);
        }
        if (inspectorService == null) {
            InspectorPanel.$$$reportNull$$$0(7);
        }
        if (isApplicable == null) {
            InspectorPanel.$$$reportNull$$$0(8);
        }
        if (treeType == null) {
            InspectorPanel.$$$reportNull$$$0(9);
        }
        if (shouldAutoHorizontalScroll == null) {
            InspectorPanel.$$$reportNull$$$0(10);
        }
        if (highlightNodesShownInBothTrees == null) {
            InspectorPanel.$$$reportNull$$$0(11);
        }
        super(new BorderLayout());
        this.iconMaker = new CustomIconMaker();
        this.flutterAppFrameReady = false;
        this.treeLoadStarted = false;
        this.programaticSelectionChangeInProgress = false;
        this.programaticExpansionInProgress = false;
        this.isActive = false;
        this.valueToTreeNode = new HashMap<InspectorInstanceRef, DefaultMutableTreeNode>();
        this.visibleToUser = false;
        this.highlightNodesShownInBothTrees = false;
        this.treeType = treeType;
        this.flutterApp = flutterApp;
        this.inspectorService = inspectorService;
        this.treeGroups = new InspectorObjectGroupManager(inspectorService, "tree");
        this.selectionGroups = new InspectorObjectGroupManager(inspectorService, "selection");
        this.isApplicable = isApplicable;
        this.detailsSubtree = detailsSubtree;
        this.isSummaryTree = isSummaryTree;
        this.parentTree = parentTree;
        this.legacyMode = legacyMode;
        this.defaultIcon = this.iconMaker.fromInfo("Default");
        if (!Disposer.isDisposed((Disposable)flutterApp)) {
            this.refreshRateLimiter = new AsyncRateLimiter(5.0, this::refresh, flutterApp);
        }
        String parentTreeDisplayName = parentTree != null ? parentTree.treeType.displayName : null;
        this.myRootsTree = new InspectorTree(new DefaultMutableTreeNode(null), treeType.displayName, detailsSubtree, parentTreeDisplayName, treeType != InspectorService.FlutterTreeType.widget || !isSummaryTree && !legacyMode, legacyMode, flutterApp);
        this.myRootsTree.setHorizontalAutoScrollingEnabled(false);
        this.myRootsTree.setAutoscrolls(false);
        this.myRootsTree.setToggleClickCount(0);
        this.myRootsTree.addTreeExpansionListener(new MyTreeExpansionListener());
        InspectorTreeMouseListener mouseListener = new InspectorTreeMouseListener(this, (JTree)((Object)this.myRootsTree));
        this.myRootsTree.addMouseListener(mouseListener);
        this.myRootsTree.addMouseMotionListener(mouseListener);
        this.subtreePanel = isSummaryTree && !legacyMode ? new InspectorPanel(flutterView, flutterApp, inspectorService, isApplicable, treeType, true, this, false, legacyMode, shouldAutoHorizontalScroll, highlightNodesShownInBothTrees) : null;
        this.initTree(this.myRootsTree);
        this.myRootsTree.getSelectionModel().addTreeSelectionListener(this::selectionChanged);
        this.treeScrollPane = (JBScrollPane)ScrollPaneFactory.createScrollPane((Component)((Object)this.myRootsTree));
        this.treeScrollPane.setAutoscrolls(false);
        this.scrollAnimator = new TreeScrollAnimator(this.myRootsTree, (JScrollPane)this.treeScrollPane);
        shouldAutoHorizontalScroll.listen(this.scrollAnimator::setAutoHorizontalScroll, true);
        highlightNodesShownInBothTrees.listen(this::setHighlightNodesShownInBothTrees, true);
        this.myRootsTree.setScrollAnimator(this.scrollAnimator);
        if (!detailsSubtree) {
            this.treeSplitter = new Splitter(false);
            this.treeSplitter.setProportion(flutterView.getState().getSplitterProportion());
            flutterView.getState().addListener(e -> {
                float newProportion = flutterView.getState().getSplitterProportion();
                if (this.treeSplitter.getProportion() != newProportion) {
                    this.treeSplitter.setProportion(newProportion);
                }
            });
            this.treeSplitter.addPropertyChangeListener("proportion", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    flutterView.getState().setSplitterProportion(InspectorPanel.this.treeSplitter.getProportion());
                }
            });
            if (this.subtreePanel == null) {
                this.myPropertiesPanel = new PropertiesPanel(flutterApp, inspectorService);
                this.treeSplitter.setSecondComponent((JComponent)ScrollPaneFactory.createScrollPane((Component)((Object)this.myPropertiesPanel)));
            } else {
                this.myPropertiesPanel = null;
                this.treeSplitter.setSecondComponent((JComponent)this.subtreePanel);
            }
            Disposer.register((Disposable)this, () -> ((Splitter)this.treeSplitter).dispose());
            Disposer.register((Disposable)this, this.scrollAnimator::dispose);
            this.treeSplitter.setFirstComponent((JComponent)this.treeScrollPane);
            this.add((Component)this.treeSplitter);
        } else {
            this.treeSplitter = null;
            this.myPropertiesPanel = null;
            this.add((Component)this.treeScrollPane);
        }
        this.addComponentListener(new ComponentListener(){

            @Override
            public void componentResized(ComponentEvent e) {
                InspectorPanel.this.determineSplitterOrientation();
            }

            @Override
            public void componentMoved(ComponentEvent e) {
            }

            @Override
            public void componentShown(ComponentEvent e) {
                InspectorPanel.this.determineSplitterOrientation();
            }

            @Override
            public void componentHidden(ComponentEvent e) {
            }
        });
        this.determineSplitterOrientation();
        if (this.isDetailsSubtree()) {
            this.setBorder(JBUI.Borders.customLine((Color)JBColor.border(), (int)1, (int)0, (int)0, (int)0));
        }
        this.flutterIsolateSubscription = inspectorService.getApp().getVMServiceManager().getCurrentFlutterIsolate(flutterIsolate -> {
            if (flutterIsolate == null) {
                this.onIsolateStopped();
            }
        }, true);
    }

    @VisibleForTesting
    public boolean isDetailsSubtree() {
        return this.detailsSubtree;
    }

    @VisibleForTesting
    public boolean isSummaryTree() {
        return this.isSummaryTree;
    }

    public boolean isHighlightNodesShownInBothTrees() {
        return this.highlightNodesShownInBothTrees;
    }

    private void setHighlightNodesShownInBothTrees(boolean value) {
        if (this.highlightNodesShownInBothTrees != value) {
            this.highlightNodesShownInBothTrees = value;
            this.myRootsTree.repaint();
        }
    }

    static DiagnosticsNode getDiagnosticNode(TreeNode treeNode) {
        if (!(treeNode instanceof DefaultMutableTreeNode)) {
            return null;
        }
        Object userData = ((DefaultMutableTreeNode)treeNode).getUserObject();
        return userData instanceof DiagnosticsNode ? (DiagnosticsNode)userData : null;
    }

    private static void expandAll(JTree tree, TreePath parent, boolean expandProperties) {
        TreeNode node = (TreeNode)parent.getLastPathComponent();
        if (node.getChildCount() >= 0) {
            Enumeration<? extends TreeNode> e = node.children();
            while (e.hasMoreElements()) {
                DiagnosticsNode diagonsticsNode;
                DefaultMutableTreeNode n = (DefaultMutableTreeNode)e.nextElement();
                if (n.getUserObject() instanceof DiagnosticsNode && (!(diagonsticsNode = (DiagnosticsNode)n.getUserObject()).childrenReady() || diagonsticsNode.isProperty() && !expandProperties)) continue;
                InspectorPanel.expandAll(tree, parent.pathByAddingChild(n), expandProperties);
            }
        }
        tree.expandPath(parent);
    }

    protected static SimpleTextAttributes textAttributesForLevel(DiagnosticLevel level) {
        switch (level) {
            case hidden: {
                return SimpleTextAttributes.GRAYED_ATTRIBUTES;
            }
            case fine: {
                return SimpleTextAttributes.REGULAR_ATTRIBUTES;
            }
            case warning: {
                return WARNING_ATTRIBUTES;
            }
            case error: {
                return SimpleTextAttributes.ERROR_ATTRIBUTES;
            }
        }
        return SimpleTextAttributes.REGULAR_ATTRIBUTES;
    }

    @Nullable
    public static Tree getTree(DataContext e) {
        return (Tree)e.getData(InspectorTree.INSPECTOR_KEY);
    }

    @NotNull
    public FlutterApp getFlutterApp() {
        FlutterApp flutterApp = this.flutterApp;
        if (flutterApp == null) {
            InspectorPanel.$$$reportNull$$$0(12);
        }
        return flutterApp;
    }

    public InspectorService.FlutterTreeType getTreeType() {
        return this.treeType;
    }

    @Override
    public void setVisibleToUser(boolean visible) {
        if (this.visibleToUser == visible) {
            return;
        }
        this.visibleToUser = visible;
        if (this.subtreePanel != null) {
            this.subtreePanel.setVisibleToUser(visible);
        }
        if (this.visibleToUser) {
            if (this.parentTree == null) {
                this.maybeLoadUI();
            }
        } else {
            this.shutdownTree(false);
        }
    }

    private void determineSplitterOrientation() {
        boolean vertical;
        if (this.treeSplitter == null) {
            return;
        }
        double aspectRatio = (double)this.getWidth() / (double)this.getHeight();
        boolean bl = vertical = aspectRatio < 1.4;
        if (vertical != this.treeSplitter.getOrientation()) {
            this.treeSplitter.setOrientation(vertical);
        }
    }

    protected boolean hasDiagnosticsValue(InspectorInstanceRef ref) {
        return this.valueToTreeNode.containsKey(ref);
    }

    protected DiagnosticsNode findDiagnosticsValue(InspectorInstanceRef ref) {
        return InspectorPanel.getDiagnosticNode(this.valueToTreeNode.get(ref));
    }

    protected void endShowNode() {
        this.highlightShowNode((DefaultMutableTreeNode)null);
    }

    protected boolean highlightShowNode(InspectorInstanceRef ref) {
        return this.highlightShowNode(this.valueToTreeNode.get(ref));
    }

    protected boolean highlightShowNode(DefaultMutableTreeNode node) {
        if (node == null && this.parentTree != null) {
            node = this.findMatchingTreeNode(this.parentTree.getSelectedDiagnostic());
        }
        this.getTreeModel().nodeChanged(this.currentShowNode);
        this.getTreeModel().nodeChanged(node);
        this.currentShowNode = node;
        return true;
    }

    private DefaultMutableTreeNode findMatchingTreeNode(DiagnosticsNode node) {
        if (node == null) {
            return null;
        }
        return this.valueToTreeNode.get(node.getValueRef());
    }

    private DefaultTreeModel getTreeModel() {
        return (DefaultTreeModel)this.myRootsTree.getModel();
    }

    private CompletableFuture<?> getPendingUpdateDone() {
        CompletableFuture ret = new CompletableFuture();
        AsyncUtils.whenCompleteUiThread(this.selectionGroups.getPendingUpdateDone(), (value, error) -> this.treeGroups.getPendingUpdateDone().whenCompleteAsync((value2, error2) -> ret.complete(null)));
        return ret;
    }

    private CompletableFuture<?> refresh() {
        if (!this.visibleToUser) {
            return CompletableFuture.completedFuture(null);
        }
        if (this.myPropertiesPanel != null) {
            this.myPropertiesPanel.refresh();
        }
        if (this.myPropertiesPanel != null) {
            return CompletableFuture.allOf(this.getPendingUpdateDone(), this.myPropertiesPanel.getPendingUpdateDone());
        }
        if (this.subtreePanel != null) {
            return CompletableFuture.allOf(this.getPendingUpdateDone(), this.subtreePanel.getPendingUpdateDone());
        }
        return this.getPendingUpdateDone();
    }

    public void shutdownTree(boolean isolateStopped) {
        this.programaticSelectionChangeInProgress = true;
        this.treeGroups.clear(isolateStopped);
        this.selectionGroups.clear(isolateStopped);
        this.currentShowNode = null;
        this.selectedNode = null;
        this.lastExpanded = null;
        this.subtreeRoot = null;
        this.getTreeModel().setRoot(new DefaultMutableTreeNode());
        if (this.subtreePanel != null) {
            this.subtreePanel.shutdownTree(isolateStopped);
        }
        if (this.myPropertiesPanel != null) {
            this.myPropertiesPanel.shutdownTree(isolateStopped);
        }
        this.programaticSelectionChangeInProgress = false;
        this.valueToTreeNode.clear();
    }

    public void onIsolateStopped() {
        this.flutterAppFrameReady = false;
        this.treeLoadStarted = false;
        this.shutdownTree(true);
    }

    @Override
    public CompletableFuture<?> onForceRefresh() {
        if (!this.visibleToUser) {
            return CompletableFuture.completedFuture(null);
        }
        if (!this.legacyMode) {
            this.recomputeTreeRoot(null, null, false, true);
        }
        if (this.myPropertiesPanel != null) {
            this.myPropertiesPanel.refresh();
        }
        return this.getPendingUpdateDone();
    }

    public void onAppChanged() {
        this.setActivate((Boolean)this.isApplicable.compute());
    }

    @NotNull
    private InspectorService getInspectorService() {
        InspectorService inspectorService = this.inspectorService;
        if (inspectorService == null) {
            InspectorPanel.$$$reportNull$$$0(13);
        }
        return inspectorService;
    }

    void setActivate(boolean enabled) {
        if (!enabled) {
            this.onIsolateStopped();
            this.isActive = false;
            return;
        }
        if (this.isActive) {
            return;
        }
        this.isActive = true;
        this.getInspectorService().addClient(this);
        this.maybeLoadUI();
    }

    void maybeLoadUI() {
        if (!this.visibleToUser || !this.isActive) {
            return;
        }
        if (this.flutterAppFrameReady) {
            this.updateSelectionFromService(false);
        } else {
            AsyncUtils.whenCompleteUiThread(this.inspectorService.isWidgetTreeReady(), (ready, throwable) -> {
                if (throwable != null) {
                    return;
                }
                this.flutterAppFrameReady = ready;
                if (this.isActive && ready.booleanValue()) {
                    this.maybeLoadUI();
                }
            });
        }
    }

    private DefaultMutableTreeNode getRootNode() {
        return (DefaultMutableTreeNode)this.getTreeModel().getRoot();
    }

    private void recomputeTreeRoot(DiagnosticsNode newSelection, DiagnosticsNode detailsSelection, boolean setSubtreeRoot, boolean textEditorUpdated) {
        this.treeGroups.cancelNext();
        this.treeGroups.getNext().safeWhenComplete(this.detailsSubtree ? this.treeGroups.getNext().getDetailsSubtree(this.subtreeRoot) : this.treeGroups.getNext().getRoot(this.treeType), (n, error) -> {
            if (error != null) {
                FlutterUtils.warn(LOG, error);
                this.treeGroups.cancelNext();
                return;
            }
            this.treeGroups.promoteNext();
            this.clearValueToTreeNodeMapping();
            if (n != null) {
                DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode(n);
                this.getTreeModel().setRoot(rootNode);
                this.setupTreeNode(rootNode, (DiagnosticsNode)n, true);
                if (n.hasChildren() && !n.childrenReady()) {
                    this.maybeLoadChildren(rootNode);
                }
            } else {
                this.getTreeModel().setRoot(null);
            }
            this.refreshSelection(newSelection, detailsSelection, setSubtreeRoot, textEditorUpdated);
        });
    }

    private void clearValueToTreeNodeMapping() {
        if (this.parentTree != null) {
            for (InspectorInstanceRef v : this.valueToTreeNode.keySet()) {
                this.parentTree.maybeUpdateValueUI(v);
            }
        }
        this.valueToTreeNode.clear();
    }

    public void showDetailSubtrees(DiagnosticsNode subtreeRoot, DiagnosticsNode subtreeSelection) {
        assert (!this.legacyMode);
        this.subtreeRoot = subtreeRoot;
        this.myRootsTree.setHighlightedRoot(this.getSubtreeRootNode());
        if (this.subtreePanel != null) {
            this.subtreePanel.setSubtreeRoot(subtreeRoot, subtreeSelection);
        }
    }

    public InspectorInstanceRef getSubtreeRootValue() {
        return this.subtreeRoot != null ? this.subtreeRoot.getValueRef() : null;
    }

    public void setSubtreeRoot(DiagnosticsNode node, DiagnosticsNode selection) {
        assert (this.detailsSubtree);
        if (selection == null) {
            selection = node;
        }
        if (node != null && node.equals(this.subtreeRoot)) {
            this.applyNewSelection(selection, null, false, true);
            return;
        }
        this.subtreeRoot = node;
        if (node == null) {
            this.shutdownTree(false);
            return;
        }
        this.clearValueToTreeNodeMapping();
        this.recomputeTreeRoot(selection, null, false, true);
    }

    DefaultMutableTreeNode getSubtreeRootNode() {
        if (this.subtreeRoot == null) {
            return null;
        }
        return this.valueToTreeNode.get(this.subtreeRoot.getValueRef());
    }

    private void refreshSelection(DiagnosticsNode newSelection, DiagnosticsNode detailsSelection, boolean setSubtreeRoot, boolean textEditorUpdated) {
        if (newSelection == null) {
            newSelection = this.getSelectedDiagnostic();
        }
        this.setSelectedNode(this.findMatchingTreeNode(newSelection));
        this.syncSelectionHelper(setSubtreeRoot, detailsSelection, textEditorUpdated);
        if (this.subtreePanel != null && this.subtreeRoot != null && this.getSubtreeRootNode() == null) {
            this.subtreeRoot = newSelection;
            this.subtreePanel.setSubtreeRoot(newSelection, detailsSelection);
        }
        if (!this.legacyMode) {
            this.myRootsTree.setHighlightedRoot(this.getSubtreeRootNode());
        }
        this.syncTreeSelection();
    }

    private void syncTreeSelection() {
        this.programaticSelectionChangeInProgress = true;
        TreePath path = this.selectedNode != null ? new TreePath(this.selectedNode.getPath()) : null;
        this.myRootsTree.setSelectionPath(path);
        this.programaticSelectionChangeInProgress = false;
        this.myRootsTree.expandPath(path);
        this.animateTo(this.selectedNode);
    }

    private void selectAndShowNode(DiagnosticsNode node) {
        if (node == null) {
            return;
        }
        this.selectAndShowNode(node.getValueRef());
    }

    private void selectAndShowNode(InspectorInstanceRef ref) {
        DefaultMutableTreeNode node = this.valueToTreeNode.get(ref);
        if (node == null) {
            return;
        }
        this.setSelectedNode(node);
        this.syncTreeSelection();
    }

    private TreePath getTreePath(DiagnosticsNode node) {
        if (node == null) {
            return null;
        }
        DefaultMutableTreeNode treeNode = this.valueToTreeNode.get(node.getValueRef());
        if (treeNode == null) {
            return null;
        }
        return new TreePath(treeNode.getPath());
    }

    protected void maybeUpdateValueUI(InspectorInstanceRef valueRef) {
        DefaultMutableTreeNode node = this.valueToTreeNode.get(valueRef);
        if (node == null) {
            return;
        }
        this.getTreeModel().nodeChanged(node);
    }

    void setupTreeNode(DefaultMutableTreeNode node, DiagnosticsNode diagnosticsNode, boolean expandChildren) {
        node.setUserObject(diagnosticsNode);
        node.setAllowsChildren(diagnosticsNode.hasChildren());
        InspectorInstanceRef valueRef = diagnosticsNode.getValueRef();
        if (valueRef.getId() != null && !diagnosticsNode.isProperty()) {
            this.valueToTreeNode.put(valueRef, node);
        }
        if (this.parentTree != null) {
            this.parentTree.maybeUpdateValueUI(valueRef);
        }
        if (diagnosticsNode.hasChildren() || !diagnosticsNode.getInlineProperties().isEmpty()) {
            if (diagnosticsNode.childrenReady() || !diagnosticsNode.hasChildren()) {
                CompletableFuture<ArrayList<DiagnosticsNode>> childrenFuture = diagnosticsNode.getChildren();
                assert (childrenFuture.isDone());
                this.setupChildren(diagnosticsNode, node, childrenFuture.getNow(null), expandChildren);
            } else {
                node.removeAllChildren();
                node.add(new DefaultMutableTreeNode("Loading..."));
            }
        }
    }

    void setupChildren(DiagnosticsNode parent, DefaultMutableTreeNode treeNode, ArrayList<DiagnosticsNode> children, boolean expandChildren) {
        DefaultMutableTreeNode childTreeNode;
        DefaultTreeModel model = this.getTreeModel();
        if (treeNode.getChildCount() > 0) {
            assert (treeNode.getChildCount() == 1);
            model.removeNodeFromParent((DefaultMutableTreeNode)treeNode.getFirstChild());
        }
        ArrayList<DiagnosticsNode> inlineProperties = parent.getInlineProperties();
        treeNode.setAllowsChildren(!children.isEmpty() || !inlineProperties.isEmpty());
        if (inlineProperties != null) {
            for (DiagnosticsNode property : inlineProperties) {
                childTreeNode = new DefaultMutableTreeNode();
                this.setupTreeNode(childTreeNode, property, false);
                childTreeNode.setAllowsChildren(childTreeNode.getChildCount() > 0);
                model.insertNodeInto(childTreeNode, treeNode, treeNode.getChildCount());
            }
        }
        for (DiagnosticsNode child : children) {
            childTreeNode = new DefaultMutableTreeNode();
            this.setupTreeNode(childTreeNode, child, false);
            model.insertNodeInto(childTreeNode, treeNode, treeNode.getChildCount());
        }
        if (expandChildren) {
            this.programaticExpansionInProgress = true;
            InspectorPanel.expandAll((JTree)((Object)this.myRootsTree), new TreePath(treeNode.getPath()), false);
            this.programaticExpansionInProgress = false;
        }
    }

    void maybeLoadChildren(DefaultMutableTreeNode node) {
        if (!(node.getUserObject() instanceof DiagnosticsNode)) {
            return;
        }
        DiagnosticsNode diagnosticsNode = (DiagnosticsNode)node.getUserObject();
        if ((diagnosticsNode.hasChildren() || !diagnosticsNode.getInlineProperties().isEmpty()) && this.hasPlaceholderChildren(node)) {
            diagnosticsNode.safeWhenComplete(diagnosticsNode.getChildren(), (children, throwable) -> {
                if (throwable != null) {
                    return;
                }
                if (node.getUserObject() != diagnosticsNode) {
                    return;
                }
                this.setupChildren(diagnosticsNode, node, (ArrayList<DiagnosticsNode>)children, true);
                if (node == this.selectedNode || node == this.lastExpanded) {
                    this.animateTo(node);
                }
            });
        }
    }

    @Override
    public void onFlutterFrame() {
        this.flutterAppFrameReady = true;
        if (!this.visibleToUser) {
            return;
        }
        if (!this.treeLoadStarted) {
            this.treeLoadStarted = true;
            this.maybeLoadUI();
        }
        if (this.refreshRateLimiter != null) {
            this.refreshRateLimiter.scheduleRequest();
        }
    }

    private boolean identicalDiagnosticsNodes(DiagnosticsNode a, DiagnosticsNode b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        return a.getDartDiagnosticRef().equals(b.getDartDiagnosticRef());
    }

    @Override
    public void onInspectorSelectionChanged(boolean uiAlreadyUpdated, boolean textEditorUpdated) {
        if (uiAlreadyUpdated) {
            return;
        }
        if (!this.visibleToUser) {
            return;
        }
        if (this.detailsSubtree) {
            return;
        }
        this.updateSelectionFromService(textEditorUpdated);
    }

    public void updateSelectionFromService(boolean textEditorUpdated) {
        this.treeLoadStarted = true;
        this.selectionGroups.cancelNext();
        CompletableFuture<DiagnosticsNode> pendingSelectionFuture = this.selectionGroups.getNext().getSelection(this.getSelectedDiagnostic(), this.treeType, this.isSummaryTree);
        CompletableFuture<DiagnosticsNode> pendingDetailsFuture = this.isSummaryTree ? this.selectionGroups.getNext().getSelection(this.getSelectedDiagnostic(), this.treeType, false) : null;
        CompletableFuture<DiagnosticsNode> selectionsReady = this.isSummaryTree ? CompletableFuture.allOf(pendingDetailsFuture, pendingSelectionFuture) : pendingSelectionFuture;
        this.selectionGroups.getNext().safeWhenComplete(selectionsReady, (ignored, error) -> {
            if (error != null) {
                FlutterUtils.warn(LOG, error);
                this.selectionGroups.cancelNext();
                return;
            }
            this.selectionGroups.promoteNext();
            DiagnosticsNode newSelection = pendingSelectionFuture.getNow(null);
            if (!this.legacyMode) {
                DiagnosticsNode detailsSelection = null;
                if (pendingDetailsFuture != null) {
                    detailsSelection = pendingDetailsFuture.getNow(null);
                }
                this.subtreeRoot = newSelection;
                this.applyNewSelection(newSelection, detailsSelection, true, textEditorUpdated);
            } else {
                if (newSelection == null) {
                    this.recomputeTreeRoot(null, null, false, true);
                    return;
                }
                this.treeGroups.getCurrent().safeWhenComplete(this.treeGroups.getCurrent().getParentChain(newSelection), (path, ex) -> {
                    if (ex != null) {
                        FlutterUtils.warn(LOG, ex);
                        return;
                    }
                    DefaultMutableTreeNode treeNode = this.getRootNode();
                    DefaultTreeModel model = this.getTreeModel();
                    Object[] treePath = new DefaultMutableTreeNode[path.size()];
                    for (int i = 0; i < path.size(); ++i) {
                        treePath[i] = treeNode;
                        DiagnosticsPathNode pathNode = (DiagnosticsPathNode)path.get(i);
                        DiagnosticsNode pathDiagnosticNode = pathNode.getNode();
                        ArrayList<DiagnosticsNode> newChildren = pathNode.getChildren();
                        DiagnosticsNode existingNode = InspectorPanel.getDiagnosticNode(treeNode);
                        if (!this.identicalDiagnosticsNodes(pathDiagnosticNode, existingNode)) {
                            treeNode.setUserObject(pathDiagnosticNode);
                        }
                        treeNode.setAllowsChildren(!newChildren.isEmpty());
                        for (int j = 0; j < newChildren.size(); ++j) {
                            DiagnosticsNode newChild = newChildren.get(j);
                            if (j >= treeNode.getChildCount() || !this.identicalDiagnosticsNodes(newChild, InspectorPanel.getDiagnosticNode(treeNode.getChildAt(j)))) {
                                DefaultMutableTreeNode child;
                                if (j >= treeNode.getChildCount()) {
                                    child = new DefaultMutableTreeNode();
                                    treeNode.add(child);
                                } else {
                                    child = (DefaultMutableTreeNode)treeNode.getChildAt(j);
                                }
                                if (j != pathNode.getChildIndex()) {
                                    this.setupTreeNode(child, newChild, false);
                                    model.reload(child);
                                } else {
                                    child.setUserObject(newChild);
                                    child.setAllowsChildren(newChild.hasChildren());
                                    child.removeAllChildren();
                                }
                                model.nodeStructureChanged(child);
                                model.nodeChanged(child);
                            }
                            model.reload(treeNode);
                        }
                        if (i == path.size() - 1) continue;
                        treeNode = (DefaultMutableTreeNode)treeNode.getChildAt(pathNode.getChildIndex());
                    }
                    TreePath selectionPath = new TreePath(treePath);
                    this.myRootsTree.setSelectionPath(selectionPath);
                    this.animateTo((DefaultMutableTreeNode)treePath[treePath.length - 1]);
                });
            }
        });
    }

    protected void applyNewSelection(DiagnosticsNode newSelection, DiagnosticsNode detailsSelection, boolean setSubtreeRoot, boolean textEditorUpdated) {
        DefaultMutableTreeNode nodeInTree = this.findMatchingTreeNode(newSelection);
        if (nodeInTree == null) {
            this.recomputeTreeRoot(newSelection, detailsSelection, setSubtreeRoot, textEditorUpdated);
        }
        this.refreshSelection(newSelection, detailsSelection, setSubtreeRoot, textEditorUpdated);
    }

    private DiagnosticsNode getSelectedDiagnostic() {
        return InspectorPanel.getDiagnosticNode(this.selectedNode);
    }

    private void animateTo(DefaultMutableTreeNode node) {
        Object userObject;
        int i;
        if (node == null) {
            return;
        }
        ArrayList<TreePath> targets = new ArrayList<TreePath>();
        TreePath target = new TreePath(node.getPath());
        targets.add(target);
        for (i = target.getPathCount() - 1; i >= 0 && (!((userObject = (node = (DefaultMutableTreeNode)target.getPathComponent(i)).getUserObject()) instanceof DiagnosticsNode) || ((DiagnosticsNode)userObject).isProperty()); --i) {
        }
        for (i = 0; i < node.getChildCount(); ++i) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)node.getChildAt(i);
            DiagnosticsNode diagnosticsNode = TreeUtils.maybeGetDiagnostic(child);
            TreePath childPath = new TreePath(child.getPath());
            targets.add(childPath);
            if (!child.isLeaf() && this.myRootsTree.isExpanded(childPath) || diagnosticsNode != null && !diagnosticsNode.isProperty()) break;
        }
        this.scrollAnimator.animateTo(targets);
    }

    private void maybePopulateChildren(DefaultMutableTreeNode treeNode) {
        DiagnosticsNode diagnostic;
        Object userObject = treeNode.getUserObject();
        if (userObject instanceof DiagnosticsNode && (diagnostic = (DiagnosticsNode)userObject).hasChildren() && treeNode.getChildCount() == 0) {
            diagnostic.safeWhenComplete(diagnostic.getChildren(), (children, throwable) -> {
                if (throwable != null) {
                    FlutterUtils.warn(LOG, throwable);
                    return;
                }
                if (treeNode.getChildCount() == 0) {
                    this.setupChildren(diagnostic, treeNode, (ArrayList<DiagnosticsNode>)children, true);
                }
                this.getTreeModel().nodeStructureChanged(treeNode);
                if (treeNode == this.selectedNode) {
                    this.myRootsTree.expandPath(new TreePath(treeNode.getPath()));
                }
            });
        }
    }

    private void setSelectedNode(DefaultMutableTreeNode newSelection) {
        if (newSelection == this.selectedNode) {
            return;
        }
        if (this.selectedNode != null && !this.detailsSubtree) {
            this.getTreeModel().nodeChanged(this.selectedNode.getParent());
        }
        this.selectedNode = newSelection;
        this.animateTo(this.selectedNode);
        this.lastExpanded = null;
        this.endShowNode();
        if (this.subtreePanel != null) {
            this.subtreePanel.endShowNode();
        } else if (this.parentTree != null) {
            this.parentTree.endShowNode();
        }
    }

    private void selectionChanged(TreeSelectionEvent event) {
        DefaultMutableTreeNode[] selectedNodes;
        if (!this.visibleToUser) {
            return;
        }
        for (DefaultMutableTreeNode node : selectedNodes = (DefaultMutableTreeNode[])this.myRootsTree.getSelectedNodes(DefaultMutableTreeNode.class, null)) {
            this.maybePopulateChildren(node);
        }
        if (this.programaticSelectionChangeInProgress) {
            return;
        }
        if (selectedNodes.length > 0) {
            assert (selectedNodes.length == 1);
            this.setSelectedNode(selectedNodes[0]);
            DiagnosticsNode selectedDiagnostic = this.getSelectedDiagnostic();
            boolean maybeReroot = this.isSummaryTree && this.subtreePanel != null && selectedDiagnostic != null && !this.subtreePanel.hasDiagnosticsValue(selectedDiagnostic.getValueRef());
            this.syncSelectionHelper(maybeReroot, null, false);
            if (!maybeReroot) {
                if (this.isSummaryTree && this.subtreePanel != null) {
                    this.subtreePanel.selectAndShowNode(selectedDiagnostic);
                } else if (this.parentTree != null) {
                    this.parentTree.selectAndShowNode(this.firstAncestorInParentTree(this.selectedNode));
                }
            }
        }
    }

    DiagnosticsNode firstAncestorInParentTree(DefaultMutableTreeNode node) {
        if (this.parentTree == null) {
            return InspectorPanel.getDiagnosticNode(node);
        }
        while (node != null) {
            DiagnosticsNode diagnostic = InspectorPanel.getDiagnosticNode(node);
            if (diagnostic != null && this.parentTree.hasDiagnosticsValue(diagnostic.getValueRef())) {
                return this.parentTree.findDiagnosticsValue(diagnostic.getValueRef());
            }
            node = (DefaultMutableTreeNode)node.getParent();
        }
        return null;
    }

    private void syncSelectionHelper(boolean maybeRerootSubtree, DiagnosticsNode detailsSelection, boolean textEditorUpdated) {
        if (!this.detailsSubtree && this.selectedNode != null) {
            this.getTreeModel().nodeChanged(this.selectedNode.getParent());
        }
        DiagnosticsNode diagnostic = this.getSelectedDiagnostic();
        if (this.myPropertiesPanel != null) {
            this.myPropertiesPanel.showProperties(diagnostic);
        }
        if ((this.detailsSubtree || this.subtreePanel == null) && diagnostic != null) {
            DiagnosticsNode toSelect = diagnostic;
            if (diagnostic.isProperty()) {
                TreePath path = new TreePath(this.selectedNode.getPath());
                toSelect = InspectorPanel.getDiagnosticNode((DefaultMutableTreeNode)path.getPathComponent(path.getPathCount() - 2));
            }
            toSelect.setSelection(toSelect.getValueRef(), true);
        }
        if (maybeRerootSubtree) {
            this.showDetailSubtrees(diagnostic, detailsSelection);
        } else if (diagnostic != null) {
            DiagnosticsNode selection = detailsSelection != null ? detailsSelection : diagnostic;
            selection.setSelection(selection.getValueRef(), true);
        }
    }

    private void initTree(Tree tree) {
        tree.setCellRenderer((TreeCellRenderer)new DiagnosticsTreeCellRenderer(this));
        tree.setShowsRootHandles(true);
        TreeUtil.installActions((JTree)tree);
        PopupHandler.installUnknownPopupHandler((JComponent)tree, (ActionGroup)this.createTreePopupActions(), (ActionManager)ActionManager.getInstance());
        new TreeSpeedSearch((JTree)tree){

            protected String getElementText(Object element) {
                TreePath path = (TreePath)element;
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
                Object object = node.getUserObject();
                if (object instanceof DiagnosticsNode) {
                    return object.toString();
                }
                return null;
            }
        };
    }

    private ActionGroup createTreePopupActions() {
        DefaultActionGroup group = new DefaultActionGroup();
        ActionManager actionManager = ActionManager.getInstance();
        group.add(actionManager.getAction("Flutter.JumpToSource"));
        group.add(actionManager.getAction("Flutter.JumpToTypeSource"));
        return group;
    }

    public void dispose() {
        this.flutterIsolateSubscription.dispose();
        InspectorService service = this.getInspectorService();
        this.shutdownTree(false);
    }

    boolean isCreatedByLocalProject(DiagnosticsNode node) {
        return node.isCreatedByLocalProject();
    }

    boolean hasPlaceholderChildren(DefaultMutableTreeNode node) {
        return node.getChildCount() == 0 || node.getChildCount() == 1 && ((DefaultMutableTreeNode)node.getFirstChild()).getUserObject() instanceof String;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 12, 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "flutterApp";
                break;
            }
            case 1: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inspectorService";
                break;
            }
            case 2: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "isApplicable";
                break;
            }
            case 3: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "treeType";
                break;
            }
            case 4: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shouldAutoHorizontalScroll";
                break;
            }
            case 5: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlightNodesShownInBothTrees";
                break;
            }
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "io/flutter/view/InspectorPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "io/flutter/view/InspectorPanel";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getFlutterApp";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getInspectorService";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 12: 
            case 13: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 12, 13 -> new IllegalStateException(string);
        };
    }

    private class MyTreeExpansionListener
    implements TreeExpansionListener {
        private MyTreeExpansionListener() {
        }

        @Override
        public void treeExpanded(TreeExpansionEvent event) {
            DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)event.getPath().getLastPathComponent();
            InspectorPanel.this.maybeLoadChildren(treeNode);
            if (!InspectorPanel.this.programaticExpansionInProgress) {
                InspectorPanel.this.lastExpanded = treeNode;
                InspectorPanel.this.animateTo(treeNode);
            }
        }

        @Override
        public void treeCollapsed(TreeExpansionEvent event) {
        }
    }

    private static class PropertiesPanel
    extends TreeTableView
    implements DataProvider {
        private final InspectorObjectGroupManager groups;
        private final FlutterApp flutterApp;
        private DiagnosticsNode diagnostic;
        private ArrayList<DiagnosticsNode> currentProperties;

        PropertiesPanel(FlutterApp flutterApp, InspectorService inspectorService) {
            super(new ListTreeTableModelOnColumns((TreeNode)new DefaultMutableTreeNode(), new ColumnInfo[]{new PropertyNameColumnInfo("Property"), new PropertyValueColumnInfo("Value")}));
            this.flutterApp = flutterApp;
            this.groups = new InspectorObjectGroupManager(inspectorService, "panel");
            this.setRootVisible(false);
            this.setStriped(true);
            this.setRowHeight(this.getRowHeight() + JBUI.scale((int)4));
            JTableHeader tableHeader = this.getTableHeader();
            tableHeader.setPreferredSize(new Dimension(0, this.getRowHeight()));
            this.getColumnModel().getColumn(0).setPreferredWidth(120);
            this.getColumnModel().getColumn(1).setPreferredWidth(200);
        }

        private ActionGroup createTreePopupActions() {
            DefaultActionGroup group = new DefaultActionGroup();
            ActionManager actionManager = ActionManager.getInstance();
            group.add(actionManager.getAction("Flutter.JumpToSource"));
            return group;
        }

        ListTreeTableModelOnColumns getTreeModel() {
            return (ListTreeTableModelOnColumns)this.getTableModel();
        }

        public void showProperties(DiagnosticsNode diagnostic) {
            this.diagnostic = diagnostic;
            if (diagnostic == null || diagnostic.isDisposed()) {
                this.shutdownTree(false);
                return;
            }
            this.getEmptyText().setText(FlutterBundle.message("app.inspector.loading_properties", new Object[0]));
            this.groups.cancelNext();
            this.groups.getNext().safeWhenComplete(diagnostic.getProperties(this.groups.getNext()), (properties, throwable) -> {
                if (throwable != null) {
                    this.getTreeModel().setRoot((TreeNode)new DefaultMutableTreeNode());
                    this.getEmptyText().setText(FlutterBundle.message("app.inspector.error_loading_properties", new Object[0]));
                    FlutterUtils.warn(LOG, throwable);
                    this.groups.cancelNext();
                    return;
                }
                this.showPropertiesHelper((ArrayList<DiagnosticsNode>)properties);
                PopupHandler.installUnknownPopupHandler((JComponent)((Object)this), (ActionGroup)this.createTreePopupActions(), (ActionManager)ActionManager.getInstance());
            });
        }

        private void showPropertiesHelper(ArrayList<DiagnosticsNode> properties) {
            this.currentProperties = properties;
            if (properties.isEmpty()) {
                this.getTreeModel().setRoot((TreeNode)new DefaultMutableTreeNode());
                this.getEmptyText().setText(FlutterBundle.message("app.inspector.no_properties", new Object[0]));
                this.groups.promoteNext();
                return;
            }
            this.groups.getNext().safeWhenComplete(this.loadPropertyMetadata(properties), (ignored, errorGettingInstances) -> {
                if (errorGettingInstances != null) {
                    this.getTreeModel().setRoot((TreeNode)new DefaultMutableTreeNode());
                    FlutterUtils.warn(LOG, errorGettingInstances);
                    this.getEmptyText().setText(FlutterBundle.message("app.inspector.error_loading_property_details", new Object[0]));
                    this.groups.cancelNext();
                    return;
                }
                this.groups.promoteNext();
                this.setModelFromProperties(properties);
            });
        }

        private void setModelFromProperties(ArrayList<DiagnosticsNode> properties) {
            ListTreeTableModelOnColumns model = this.getTreeModel();
            DefaultMutableTreeNode root = new DefaultMutableTreeNode();
            for (DiagnosticsNode property : properties) {
                if (property.getLevel() == DiagnosticLevel.hidden) continue;
                root.add(new DefaultMutableTreeNode(property));
            }
            this.getEmptyText().setText(FlutterBundle.message("app.inspector.all_properties_hidden", new Object[0]));
            model.setRoot((TreeNode)root);
        }

        private CompletableFuture<Void> loadPropertyMetadata(ArrayList<DiagnosticsNode> properties) {
            CompletableFuture[] futures = new CompletableFuture[properties.size()];
            int i = 0;
            for (DiagnosticsNode property : properties) {
                futures[i] = property.getValueProperties();
                ++i;
            }
            return CompletableFuture.allOf(futures);
        }

        private void refresh() {
            if (this.diagnostic == null) {
                return;
            }
            this.groups.cancelNext();
            if (this.diagnostic.isDisposed()) {
                return;
            }
            this.groups.getNext().safeWhenComplete(this.diagnostic.getProperties(this.groups.getNext()), (properties, throwable) -> {
                if (throwable != null || this.propertiesIdentical((ArrayList<DiagnosticsNode>)properties, this.currentProperties)) {
                    this.groups.cancelNext();
                    return;
                }
                this.showPropertiesHelper((ArrayList<DiagnosticsNode>)properties);
            });
        }

        private boolean propertiesIdentical(ArrayList<DiagnosticsNode> a, ArrayList<DiagnosticsNode> b) {
            if (a == b) {
                return true;
            }
            if (a == null || b == null) {
                return false;
            }
            if (a.size() != b.size()) {
                return false;
            }
            for (int i = 0; i < a.size(); ++i) {
                if (a.get(i).identicalDisplay(b.get(i))) continue;
                return false;
            }
            return true;
        }

        @Nullable
        public Object getData(@NotNull String dataId) {
            if (dataId == null) {
                PropertiesPanel.$$$reportNull$$$0(0);
            }
            return InspectorTree.INSPECTOR_KEY.is(dataId) ? this.getTree() : null;
        }

        public void shutdownTree(boolean isolateStopped) {
            this.diagnostic = null;
            this.getEmptyText().setText(FlutterBundle.message("app.inspector.nothing_to_show", new Object[0]));
            this.getTreeModel().setRoot((TreeNode)new DefaultMutableTreeNode());
            this.groups.clear(isolateStopped);
        }

        public CompletableFuture<?> getPendingUpdateDone() {
            return this.groups.getPendingUpdateDone();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataId", "io/flutter/view/InspectorPanel$PropertiesPanel", "getData"));
        }
    }

    private static class SimplePropertyValueRenderer
    extends ColoredTableCellRenderer {
        final ColorIconMaker colorIconMaker = new ColorIconMaker();

        private SimplePropertyValueRenderer() {
        }

        private static int getIntProperty(Map<String, InstanceRef> properties, String propertyName) {
            if (properties == null || !properties.containsKey(propertyName)) {
                return 0;
            }
            return Integer.parseInt(properties.get(propertyName).getValueAsString());
        }

        protected void customizeCellRenderer(JTable table, @Nullable Object value, boolean selected, boolean hasFocus, int row, int column) {
            CompletableFuture<Map<String, InstanceRef>> propertiesFuture;
            this.setToolTipText(null);
            if (value == null) {
                return;
            }
            DiagnosticsNode node = (DiagnosticsNode)value;
            SimpleTextAttributes textAttributes = InspectorPanel.textAttributesForLevel(node.getLevel());
            boolean appendDescription = true;
            if (node.getTooltip() != null) {
                this.setToolTipText(node.getTooltip());
            }
            if ((propertiesFuture = node.getValueProperties()) != null && propertiesFuture.isDone() && !propertiesFuture.isCompletedExceptionally()) {
                String propertyType;
                Map properties = propertiesFuture.getNow(null);
                if (node.isEnumProperty() && properties != null) {
                    this.setToolTipText("Allowed values:\n" + Joiner.on((char)'\n').join(properties.keySet()));
                }
                if ((propertyType = node.getPropertyType()) != null) {
                    switch (propertyType) {
                        case "Color": {
                            int alpha = SimplePropertyValueRenderer.getIntProperty(properties, "alpha");
                            int red = SimplePropertyValueRenderer.getIntProperty(properties, "red");
                            int green = SimplePropertyValueRenderer.getIntProperty(properties, "green");
                            int blue = SimplePropertyValueRenderer.getIntProperty(properties, "blue");
                            Color color = new Color(red, green, blue, alpha);
                            this.setIcon(this.colorIconMaker.getCustomIcon(color));
                            if (alpha == 255) {
                                this.append(String.format("#%02x%02x%02x", red, green, blue), textAttributes);
                            } else {
                                this.append(String.format("#%02x%02x%02x%02x", alpha, red, green, blue), textAttributes);
                            }
                            appendDescription = false;
                            break;
                        }
                        case "IconData": {
                            Icon icon;
                            int codePoint = SimplePropertyValueRenderer.getIntProperty(properties, "codePoint");
                            if (codePoint <= 0 || (icon = FlutterMaterialIcons.getIconForHex(String.format("%1$04x", codePoint))) == null) break;
                            this.setIcon(icon);
                            this.setIconOpaque(false);
                            this.setTransparentIconBackground(true);
                            break;
                        }
                    }
                }
            }
            if (appendDescription) {
                this.append(node.getDescription(), textAttributes);
            }
        }
    }

    private static class PropertyNameRenderer
    extends ColoredTableCellRenderer {
        private PropertyNameRenderer() {
        }

        protected void customizeCellRenderer(JTable table, @Nullable Object value, boolean selected, boolean hasFocus, int row, int column) {
            if (value == null) {
                return;
            }
            DiagnosticsNode node = (DiagnosticsNode)value;
            if (!node.getShowSeparator() || !node.getShowName()) {
                return;
            }
            SimpleTextAttributes attributes = node.hasCreationLocation() ? SimpleTextAttributes.REGULAR_ITALIC_ATTRIBUTES : SimpleTextAttributes.REGULAR_ATTRIBUTES;
            this.append(node.getName(), attributes);
            CompletableFuture<String> propertyDoc = node.getPropertyDoc();
            String doc = propertyDoc.getNow(null);
            if (doc != null) {
                this.setToolTipText(doc);
            } else {
                this.setToolTipText(null);
                node.safeWhenComplete(propertyDoc, (tooltip, th) -> {
                    if (th != null) {
                        FlutterUtils.warn(LOG, th);
                    }
                    this.setToolTipText((String)tooltip);
                });
            }
        }
    }

    static class PropertyValueColumnInfo
    extends ColumnInfo<DefaultMutableTreeNode, DiagnosticsNode> {
        private final TableCellRenderer defaultRenderer = new SimplePropertyValueRenderer();

        public PropertyValueColumnInfo(String name) {
            super(name);
        }

        @Nullable
        public DiagnosticsNode valueOf(DefaultMutableTreeNode node) {
            return (DiagnosticsNode)node.getUserObject();
        }

        public TableCellRenderer getRenderer(DefaultMutableTreeNode item) {
            return this.defaultRenderer;
        }
    }

    static class PropertyNameColumnInfo
    extends ColumnInfo<DefaultMutableTreeNode, DiagnosticsNode> {
        private final TableCellRenderer renderer = new PropertyNameRenderer();

        public PropertyNameColumnInfo(String name) {
            super(name);
        }

        @Nullable
        public DiagnosticsNode valueOf(DefaultMutableTreeNode node) {
            return (DiagnosticsNode)node.getUserObject();
        }

        public TableCellRenderer getRenderer(DefaultMutableTreeNode item) {
            return this.renderer;
        }
    }
}

