/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.view;

import com.intellij.ide.BrowserUtil;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.paint.EffectPainter;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import gnu.trove.TIntIntHashMap;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.font.FontRenderContext;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.tree.TreeCellRenderer;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MultiIconSimpleColoredComponent
extends JComponent
implements Accessible,
ColoredTextContainer {
    private static final Logger LOG = Logger.getInstance(MultiIconSimpleColoredComponent.class);
    public static final Color SHADOW_COLOR;
    public static final Color STYLE_SEARCH_MATCH_BACKGROUND;
    public static final int FRAGMENT_ICON = -100;
    private final List<String> myFragments;
    private final List<TextLayout> myLayouts;
    private final List<PositionedIcon> myIcons;
    private Font myLayoutFont;
    private final List<SimpleTextAttributes> myAttributes;
    private List<Object> myFragmentTags = null;
    private TIntIntHashMap myFragmentAlignment;
    private Insets myIpad;
    protected int myIconTextGap;
    private boolean myPaintFocusBorder;
    private boolean myFocusBorderAroundIcon;
    private Border myBorder;
    private int myMainTextLastIndex = -1;
    private final TIntIntHashMap myFragmentPadding;
    @JdkConstants.HorizontalAlignment
    private int myTextAlign = 2;
    private boolean myIconOpaque = false;
    private boolean myAutoInvalidate = !(this instanceof TreeCellRenderer);
    private boolean myTransparentIconBackground;

    public MultiIconSimpleColoredComponent() {
        this.myFragments = new ArrayList<String>(3);
        this.myLayouts = new ArrayList<TextLayout>(3);
        this.myAttributes = new ArrayList<SimpleTextAttributes>(3);
        this.myIcons = new ArrayList<PositionedIcon>(3);
        this.myIpad = new JBInsets(1, 2, 1, 2);
        this.myIconTextGap = JBUI.scale((int)2);
        this.myBorder = new MyBorder();
        this.myFragmentPadding = new TIntIntHashMap(10);
        this.myFragmentAlignment = new TIntIntHashMap(10);
        this.setOpaque(true);
        this.updateUI();
    }

    @Override
    public void updateUI() {
        UISettings.setupComponentAntialiasing((JComponent)this);
    }

    @NotNull
    public ColoredIterator iterator() {
        return new MyIterator();
    }

    @NotNull
    public final MultiIconSimpleColoredComponent append(@NotNull String fragment) {
        if (fragment == null) {
            MultiIconSimpleColoredComponent.$$$reportNull$$$0(0);
        }
        this.append(fragment, SimpleTextAttributes.REGULAR_ATTRIBUTES);
        MultiIconSimpleColoredComponent multiIconSimpleColoredComponent = this;
        if (multiIconSimpleColoredComponent == null) {
            MultiIconSimpleColoredComponent.$$$reportNull$$$0(1);
        }
        return multiIconSimpleColoredComponent;
    }

    public final void append(@NotNull String fragment, @NotNull SimpleTextAttributes attributes) {
        if (fragment == null) {
            MultiIconSimpleColoredComponent.$$$reportNull$$$0(2);
        }
        if (attributes == null) {
            MultiIconSimpleColoredComponent.$$$reportNull$$$0(3);
        }
        this.append(fragment, attributes, this.myMainTextLastIndex < 0);
    }

    public final void append(@NotNull String fragment, @NotNull SimpleTextAttributes attributes, int padding, @JdkConstants.HorizontalAlignment int align) {
        if (fragment == null) {
            MultiIconSimpleColoredComponent.$$$reportNull$$$0(4);
        }
        if (attributes == null) {
            MultiIconSimpleColoredComponent.$$$reportNull$$$0(5);
        }
        this.append(fragment, attributes, this.myMainTextLastIndex < 0);
        this.appendTextPadding(padding, align);
    }

    public void append(@NotNull String fragment, @NotNull SimpleTextAttributes attributes, boolean isMainText) {
        if (fragment == null) {
            MultiIconSimpleColoredComponent.$$$reportNull$$$0(6);
        }
        if (attributes == null) {
            MultiIconSimpleColoredComponent.$$$reportNull$$$0(7);
        }
        this._append(fragment, attributes, isMainText);
        this.revalidateAndRepaint();
    }

    private synchronized void _append(@NotNull String fragment, @NotNull SimpleTextAttributes attributes, boolean isMainText) {
        if (fragment == null) {
            MultiIconSimpleColoredComponent.$$$reportNull$$$0(8);
        }
        if (attributes == null) {
            MultiIconSimpleColoredComponent.$$$reportNull$$$0(9);
        }
        this.myFragments.add(fragment);
        this.myAttributes.add(attributes);
        if (isMainText) {
            this.myMainTextLastIndex = this.myFragments.size() - 1;
        }
    }

    void revalidateAndRepaint() {
        if (this.myAutoInvalidate) {
            this.revalidate();
        }
        this.repaint();
    }

    public void append(@NotNull String fragment, @NotNull SimpleTextAttributes attributes, Object tag) {
        if (fragment == null) {
            MultiIconSimpleColoredComponent.$$$reportNull$$$0(10);
        }
        if (attributes == null) {
            MultiIconSimpleColoredComponent.$$$reportNull$$$0(11);
        }
        this._append(fragment, attributes, tag);
        this.revalidateAndRepaint();
    }

    public void setIcon(@Nullable Icon icon) {
        assert (this.myIcons.isEmpty());
        if (icon == null) {
            return;
        }
        this.myIcons.add(new PositionedIcon(icon, 0));
    }

    private synchronized void _append(String fragment, SimpleTextAttributes attributes, Object tag) {
        this.append(fragment, attributes);
        if (this.myFragmentTags == null) {
            this.myFragmentTags = new ArrayList<Object>();
        }
        while (this.myFragmentTags.size() < this.myFragments.size() - 1) {
            this.myFragmentTags.add(null);
        }
        this.myFragmentTags.add(tag);
    }

    @Deprecated
    public synchronized void appendFixedTextFragmentWidth(int width) {
        this.appendTextPadding(width);
    }

    public synchronized void appendTextPadding(int padding) {
        this.appendTextPadding(padding, 2);
    }

    public synchronized void appendTextPadding(int padding, @JdkConstants.HorizontalAlignment int align) {
        int alignIndex = this.myFragments.size() - 1;
        this.myFragmentPadding.put(alignIndex, padding);
        this.myFragmentAlignment.put(alignIndex, align);
    }

    public void setTextAlign(@JdkConstants.HorizontalAlignment int align) {
        this.myTextAlign = align;
    }

    public void clear() {
        this._clear();
        this.revalidateAndRepaint();
    }

    private synchronized void _clear() {
        this.myPaintFocusBorder = false;
        this.myIcons.clear();
        this.myFragments.clear();
        this.myLayouts.clear();
        this.myAttributes.clear();
        this.myFragmentTags = null;
        this.myMainTextLastIndex = -1;
        this.myFragmentPadding.clear();
    }

    public final void addIcon(@NotNull Icon icon) {
        if (icon == null) {
            MultiIconSimpleColoredComponent.$$$reportNull$$$0(12);
        }
        assert (icon != null);
        assert (this.myFragments.size() == this.myAttributes.size());
        this.myIcons.add(new PositionedIcon(icon, this.myFragments.size()));
        this.revalidateAndRepaint();
    }

    @NotNull
    public Insets getIpad() {
        Insets insets = this.myIpad;
        if (insets == null) {
            MultiIconSimpleColoredComponent.$$$reportNull$$$0(13);
        }
        return insets;
    }

    public void setIpad(@NotNull Insets ipad) {
        if (ipad == null) {
            MultiIconSimpleColoredComponent.$$$reportNull$$$0(14);
        }
        this.myIpad = ipad;
        this.revalidateAndRepaint();
    }

    public int getIconTextGap() {
        return this.myIconTextGap;
    }

    public void setIconTextGap(int iconTextGap) {
        if (iconTextGap < 0) {
            throw new IllegalArgumentException("wrong iconTextGap: " + iconTextGap);
        }
        this.myIconTextGap = iconTextGap;
        this.revalidateAndRepaint();
    }

    public Border getMyBorder() {
        return this.myBorder;
    }

    public void setMyBorder(@Nullable Border border) {
        this.myBorder = border;
    }

    protected final void setPaintFocusBorder(boolean paintFocusBorder) {
        this.myPaintFocusBorder = paintFocusBorder;
        this.repaint();
    }

    protected final void setFocusBorderAroundIcon(boolean focusBorderAroundIcon) {
        this.myFocusBorderAroundIcon = focusBorderAroundIcon;
        this.repaint();
    }

    public boolean isIconOpaque() {
        return this.myIconOpaque;
    }

    public void setIconOpaque(boolean iconOpaque) {
        this.myIconOpaque = iconOpaque;
        this.repaint();
    }

    @Override
    @NotNull
    public Dimension getPreferredSize() {
        return this.computePreferredSize(false);
    }

    @Override
    @NotNull
    public Dimension getMinimumSize() {
        return this.computePreferredSize(false);
    }

    @Nullable
    public synchronized Object getFragmentTag(int index) {
        if (this.myFragmentTags != null && index < this.myFragmentTags.size()) {
            return this.myFragmentTags.get(index);
        }
        return null;
    }

    @NotNull
    public final synchronized Dimension computePreferredSize(boolean mainTextOnly) {
        int width = this.myIpad.left;
        for (PositionedIcon icon : this.myIcons) {
            width += icon.icon.getIconWidth() + this.myIconTextGap;
        }
        JBInsets borderInsets = this.myBorder != null ? this.myBorder.getBorderInsets(this) : JBUI.emptyInsets();
        width += borderInsets.left;
        Font font = this.getBaseFont();
        width = (int)((float)width + this.computeTextWidth(font, mainTextOnly));
        width += this.myIpad.right + borderInsets.right;
        Insets insets = this.getInsets();
        if (insets != null) {
            width += insets.left + insets.right;
        }
        int height = this.computePreferredHeight();
        return new Dimension(width, height);
    }

    public final synchronized int computePreferredHeight() {
        Insets insets;
        int height = this.myIpad.top + this.myIpad.bottom;
        Font font = this.getBaseFont();
        FontMetrics metrics = this.getFontMetrics(font);
        int textHeight = Math.max(JBUI.scale((int)16), metrics.getHeight());
        JBInsets borderInsets = this.myBorder != null ? this.myBorder.getBorderInsets(this) : JBUI.emptyInsets();
        textHeight += borderInsets.top + borderInsets.bottom;
        if (!this.myIcons.isEmpty()) {
            for (PositionedIcon icon : this.myIcons) {
                height += Math.max(icon.icon.getIconHeight(), textHeight);
            }
        } else {
            height += textHeight;
        }
        if ((insets = this.getInsets()) != null) {
            height += insets.top + insets.bottom;
        }
        return height;
    }

    private Rectangle computePaintArea() {
        Rectangle area = new Rectangle(this.getWidth(), this.getHeight());
        JBInsets.removeFrom((Rectangle)area, (Insets)this.getInsets());
        JBInsets.removeFrom((Rectangle)area, (Insets)this.myIpad);
        return area;
    }

    private float computeTextWidth(@NotNull Font font, boolean mainTextOnly) {
        if (font == null) {
            MultiIconSimpleColoredComponent.$$$reportNull$$$0(15);
        }
        float result = 0.0f;
        int baseSize = font.getSize();
        boolean wasSmaller = false;
        for (int i = 0; i < this.myAttributes.size(); ++i) {
            SimpleTextAttributes attributes = this.myAttributes.get(i);
            boolean isSmaller = attributes.isSmaller();
            if (font.getStyle() != attributes.getFontStyle() || isSmaller != wasSmaller) {
                font = font.deriveFont(attributes.getFontStyle(), isSmaller ? UIUtil.getFontSize((UIUtil.FontSize)UIUtil.FontSize.SMALL) : (float)baseSize);
            }
            wasSmaller = isSmaller;
            result += this.computeStringWidth(i, font);
            int fixedWidth = this.myFragmentPadding.get(i);
            if (fixedWidth > 0 && result < (float)fixedWidth) {
                result = fixedWidth;
            }
            if (mainTextOnly && this.myMainTextLastIndex >= 0 && i == this.myMainTextLastIndex) break;
        }
        return result;
    }

    @NotNull
    private Font getBaseFont() {
        Font font = this.getFont();
        if (font == null) {
            font = UIUtil.getLabelFont();
        }
        Font font2 = font;
        if (font2 == null) {
            MultiIconSimpleColoredComponent.$$$reportNull$$$0(16);
        }
        return font2;
    }

    private TextLayout getTextLayout(int fragmentIndex, Font font, FontRenderContext frc) {
        TextLayout layout;
        if (this.getBaseFont() != this.myLayoutFont) {
            this.myLayouts.clear();
        }
        TextLayout textLayout = layout = fragmentIndex < this.myLayouts.size() ? this.myLayouts.get(fragmentIndex) : null;
        if (layout == null && MultiIconSimpleColoredComponent.needFontFallback(font, this.myFragments.get(fragmentIndex))) {
            layout = this.createAndCacheTextLayout(fragmentIndex, font, frc);
        }
        return layout;
    }

    private void doDrawString(Graphics2D g, int fragmentIndex, float x, float y) {
        String text = this.myFragments.get(fragmentIndex);
        if (StringUtil.isEmpty((String)text)) {
            return;
        }
        TextLayout layout = this.getTextLayout(fragmentIndex, g.getFont(), g.getFontRenderContext());
        if (layout != null) {
            layout.draw(g, x, y);
        } else {
            g.drawString(text, x, y);
        }
    }

    private float computeStringWidth(int fragmentIndex, Font font) {
        String text = this.myFragments.get(fragmentIndex);
        if (StringUtil.isEmpty((String)text)) {
            return 0.0f;
        }
        FontRenderContext fontRenderContext = this.getFontMetrics(font).getFontRenderContext();
        TextLayout layout = this.getTextLayout(fragmentIndex, font, fontRenderContext);
        if (layout != null) {
            return layout.getAdvance();
        }
        return (float)font.getStringBounds(text, fontRenderContext).getWidth();
    }

    private TextLayout createAndCacheTextLayout(int fragmentIndex, Font basefont, FontRenderContext fontRenderContext) {
        String text = this.myFragments.get(fragmentIndex);
        AttributedString string = new AttributedString(text);
        boolean start = false;
        int end = text.length();
        AttributedCharacterIterator it = string.getIterator(new AttributedCharacterIterator.Attribute[0], 0, end);
        Font currentFont = basefont;
        int currentIndex = 0;
        char c = it.first();
        while (c != '\uffff') {
            Font font = basefont;
            int i = it.getIndex();
            if (!Comparing.equal((Object)currentFont, (Object)font)) {
                if (i > currentIndex) {
                    string.addAttribute(TextAttribute.FONT, currentFont, currentIndex, i);
                }
                currentFont = font;
                currentIndex = i;
            }
            c = it.next();
        }
        if (currentIndex < end) {
            string.addAttribute(TextAttribute.FONT, currentFont, currentIndex, end);
        }
        TextLayout layout = new TextLayout(string.getIterator(), fontRenderContext);
        if (fragmentIndex >= this.myLayouts.size()) {
            this.myLayouts.addAll(Collections.nCopies(fragmentIndex - this.myLayouts.size() + 1, null));
        }
        this.myLayouts.set(fragmentIndex, layout);
        this.myLayoutFont = this.getBaseFont();
        return layout;
    }

    private static boolean needFontFallback(Font font, String text) {
        return font.canDisplayUpTo(text) != -1 && text.indexOf(65535) == -1;
    }

    public int findFragmentAt(int x) {
        float curX = this.myIpad.left;
        if (this.myBorder != null) {
            curX += (float)this.myBorder.getBorderInsets((Component)this).left;
        }
        curX += (float)this.computeTextAlignShift();
        Font font = this.getBaseFont();
        int baseSize = font.getSize();
        boolean wasSmaller = false;
        int i = 0;
        int iconIndex = 0;
        while (true) {
            if (iconIndex < this.myIcons.size() && this.myIcons.get((int)iconIndex).index <= i) {
                int iconWidth = this.myIcons.get((int)iconIndex).icon.getIconWidth() + this.myIconTextGap * 2;
                if ((float)x >= curX && (float)x < curX + (float)iconWidth) {
                    return -100 - iconIndex;
                }
                curX += (float)iconWidth;
                ++iconIndex;
                continue;
            }
            if (i >= this.myAttributes.size()) break;
            SimpleTextAttributes attributes = this.myAttributes.get(i);
            boolean isSmaller = attributes.isSmaller();
            if (font.getStyle() != attributes.getFontStyle() || isSmaller != wasSmaller) {
                font = font.deriveFont(attributes.getFontStyle(), isSmaller ? UIUtil.getFontSize((UIUtil.FontSize)UIUtil.FontSize.SMALL) : (float)baseSize);
            }
            wasSmaller = isSmaller;
            float curWidth = this.computeStringWidth(i, font);
            if ((float)x >= curX && (float)x < curX + curWidth) {
                return i;
            }
            curX += curWidth;
            int fragmentPadding = this.myFragmentPadding.get(i);
            if (fragmentPadding > 0 && curX < (float)fragmentPadding) {
                curX = fragmentPadding;
            }
            ++i;
        }
        return -1;
    }

    @Nullable
    public Object getFragmentTagAt(int x) {
        int index = this.findFragmentAt(x);
        return index < 0 ? null : this.getFragmentTag(index);
    }

    @Nullable
    public Icon getIconAt(int x) {
        int index = this.findFragmentAt(x);
        return index <= -100 ? this.myIcons.get((int)(-100 - index)).icon : null;
    }

    @NotNull
    protected JLabel formatToLabel(@NotNull JLabel label) {
        if (label == null) {
            MultiIconSimpleColoredComponent.$$$reportNull$$$0(17);
        }
        label.setIcon(!this.myIcons.isEmpty() ? this.myIcons.get((int)0).icon : null);
        if (!this.myFragments.isEmpty()) {
            StringBuilder text = new StringBuilder();
            text.append("<html><body style=\"white-space:nowrap\">");
            for (int i = 0; i < this.myFragments.size(); ++i) {
                String fragment = this.myFragments.get(i);
                SimpleTextAttributes attributes = this.myAttributes.get(i);
                Object tag = this.getFragmentTag(i);
                if (tag instanceof BrowserLauncherTag) {
                    MultiIconSimpleColoredComponent.formatLink(text, fragment, attributes, ((BrowserLauncherTag)tag).myUrl);
                    continue;
                }
                MultiIconSimpleColoredComponent.formatText(text, fragment, attributes);
            }
            text.append("</body></html>");
            label.setText(text.toString());
        }
        JLabel jLabel = label;
        if (jLabel == null) {
            MultiIconSimpleColoredComponent.$$$reportNull$$$0(18);
        }
        return jLabel;
    }

    static void formatText(@NotNull StringBuilder builder, @NotNull String fragment, @NotNull SimpleTextAttributes attributes) {
        if (builder == null) {
            MultiIconSimpleColoredComponent.$$$reportNull$$$0(19);
        }
        if (fragment == null) {
            MultiIconSimpleColoredComponent.$$$reportNull$$$0(20);
        }
        if (attributes == null) {
            MultiIconSimpleColoredComponent.$$$reportNull$$$0(21);
        }
        if (!fragment.isEmpty()) {
            builder.append("<span");
            MultiIconSimpleColoredComponent.formatStyle(builder, attributes);
            builder.append('>').append(MultiIconSimpleColoredComponent.convertFragment(fragment)).append("</span>");
        }
    }

    static void formatLink(@NotNull StringBuilder builder, @NotNull String fragment, @NotNull SimpleTextAttributes attributes, @NotNull String url) {
        if (builder == null) {
            MultiIconSimpleColoredComponent.$$$reportNull$$$0(22);
        }
        if (fragment == null) {
            MultiIconSimpleColoredComponent.$$$reportNull$$$0(23);
        }
        if (attributes == null) {
            MultiIconSimpleColoredComponent.$$$reportNull$$$0(24);
        }
        if (url == null) {
            MultiIconSimpleColoredComponent.$$$reportNull$$$0(25);
        }
        if (!fragment.isEmpty()) {
            builder.append("<a href=\"").append(StringUtil.replace((String)url, (String)"\"", (String)"%22")).append("\"");
            MultiIconSimpleColoredComponent.formatStyle(builder, attributes);
            builder.append('>').append(MultiIconSimpleColoredComponent.convertFragment(fragment)).append("</a>");
        }
    }

    private static String convertFragment(@NotNull String fragment) {
        if (fragment == null) {
            MultiIconSimpleColoredComponent.$$$reportNull$$$0(26);
        }
        return StringUtil.escapeXmlEntities((String)fragment).replaceAll("\\\\n", "<br>");
    }

    private static void formatStyle(StringBuilder builder, SimpleTextAttributes attributes) {
        Color fgColor = attributes.getFgColor();
        Color bgColor = attributes.getBgColor();
        int style = attributes.getStyle();
        int pos = builder.length();
        if (fgColor != null) {
            builder.append("color:#").append(Integer.toString(fgColor.getRGB() & 0xFFFFFF, 16)).append(';');
        }
        if (bgColor != null) {
            builder.append("background-color:#").append(Integer.toString(bgColor.getRGB() & 0xFFFFFF, 16)).append(';');
        }
        if ((style & 1) != 0) {
            builder.append("font-weight:bold;");
        }
        if ((style & 2) != 0) {
            builder.append("font-style:italic;");
        }
        if ((style & 0x10) != 0) {
            builder.append("text-decoration:underline;");
        } else if ((style & 4) != 0) {
            builder.append("text-decoration:line-through;");
        }
        if (builder.length() > pos) {
            builder.insert(pos, " style=\"");
            builder.append('\"');
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        try {
            this._doPaint(g);
        }
        catch (RuntimeException e) {
            LOG.warn(this.logSwingPath(), (Throwable)e);
            throw e;
        }
    }

    private synchronized void _doPaint(Graphics g) {
        MultiIconSimpleColoredComponent.checkCanPaint(g);
        this.doPaint((Graphics2D)g);
    }

    protected void doPaint(Graphics2D g) {
        this.doPaintTextBackground(g, 0);
        this.doPaintTextAndIcons(g, this.myFocusBorderAroundIcon || this.myIcons.isEmpty());
    }

    private void doPaintTextBackground(Graphics2D g, int offset) {
        if (this.isOpaque() || this.shouldDrawBackground()) {
            this.paintBackground(g, offset, this.getWidth() - offset, this.getHeight());
        }
    }

    protected void paintBackground(Graphics2D g, int x, int width, int height) {
        g.setColor(this.getBackground());
        g.fillRect(x, 0, width, height);
    }

    protected void doPaintIcon(@NotNull Graphics2D g, @NotNull Icon icon, int offset) {
        if (g == null) {
            MultiIconSimpleColoredComponent.$$$reportNull$$$0(27);
        }
        if (icon == null) {
            MultiIconSimpleColoredComponent.$$$reportNull$$$0(28);
        }
        Container parent = this.getParent();
        Color iconBackgroundColor = null;
        if ((this.isOpaque() || this.isIconOpaque()) && !this.isTransparentIconBackground()) {
            iconBackgroundColor = parent != null && !this.myFocusBorderAroundIcon && !UIUtil.isFullRowSelectionLAF() ? parent.getBackground() : this.getBackground();
        }
        if (iconBackgroundColor != null) {
            g.setColor(iconBackgroundColor);
            g.fillRect(offset, 0, icon.getIconWidth() + this.myIpad.left + this.myIconTextGap, this.getHeight());
        }
        this.paintIcon(g, icon, offset + this.myIpad.left);
    }

    protected int doPaintTextAndIcons(Graphics2D g, boolean focusAroundIcon) {
        float offset = this.myIpad.left;
        if (this.myBorder != null) {
            offset += (float)this.myBorder.getBorderInsets((Component)this).left;
        }
        ArrayList<Object[]> searchMatches = new ArrayList<Object[]>();
        this.applyAdditionalHints(g);
        Font baseFont = this.getBaseFont();
        g.setFont(baseFont);
        offset += (float)this.computeTextAlignShift();
        int baseSize = baseFont.getSize();
        FontMetrics baseMetrics = g.getFontMetrics();
        Rectangle area = this.computePaintArea();
        int textBaseline = area.y + MultiIconSimpleColoredComponent.getTextBaseLine(baseMetrics, area.height);
        boolean wasSmaller = false;
        assert (this.myFragments.size() == this.myAttributes.size());
        int i = 0;
        int iconIndex = 0;
        while (true) {
            float endOffset;
            Color color;
            Color bgColor;
            if (iconIndex < this.myIcons.size() && this.myIcons.get((int)iconIndex).index <= i) {
                Icon icon = this.myIcons.get((int)iconIndex).icon;
                int iconWidth = icon.getIconWidth() + this.myIconTextGap;
                this.doPaintIcon(g, icon, (int)offset);
                offset += (float)(iconWidth + this.myIconTextGap);
                ++iconIndex;
                continue;
            }
            if (i >= this.myFragments.size()) break;
            SimpleTextAttributes attributes = this.myAttributes.get(i);
            Font font = g.getFont();
            boolean isSmaller = attributes.isSmaller();
            if (font.getStyle() != attributes.getFontStyle() || isSmaller != wasSmaller) {
                font = font.deriveFont(attributes.getFontStyle(), isSmaller ? UIUtil.getFontSize((UIUtil.FontSize)UIUtil.FontSize.SMALL) : (float)baseSize);
            }
            wasSmaller = isSmaller;
            g.setFont(font);
            FontMetrics metrics = g.getFontMetrics(font);
            float fragmentWidth = this.computeStringWidth(i, font);
            int fragmentPadding = this.myFragmentPadding.get(i);
            Color color2 = bgColor = attributes.isSearchMatch() ? null : attributes.getBgColor();
            if ((attributes.isOpaque() || this.isOpaque()) && bgColor != null) {
                g.setColor(bgColor);
                g.fillRect((int)offset, 0, (int)fragmentWidth, this.getHeight());
            }
            if ((color = attributes.getFgColor()) == null) {
                color = this.getForeground();
            }
            if (!this.isEnabled()) {
                color = UIUtil.getInactiveTextColor();
            }
            g.setColor(color);
            int fragmentAlignment = this.myFragmentAlignment.get(i);
            if (fragmentPadding > 0 && (float)fragmentPadding > fragmentWidth) {
                endOffset = fragmentPadding;
                if (fragmentAlignment == 4 || fragmentAlignment == 11) {
                    offset = (float)fragmentPadding - fragmentWidth;
                }
            } else {
                endOffset = offset + fragmentWidth;
            }
            if (!attributes.isSearchMatch()) {
                if (this.shouldDrawMacShadow()) {
                    g.setColor(SHADOW_COLOR);
                    this.doDrawString(g, i, offset, textBaseline + 1);
                }
                if (this.shouldDrawDimmed()) {
                    color = ColorUtil.dimmer((Color)color);
                }
                g.setColor(color);
                this.doDrawString(g, i, offset, textBaseline);
            }
            g.setStroke(g.getStroke());
            if (attributes.isStrikeout() && !attributes.isSearchMatch()) {
                EffectPainter.STRIKE_THROUGH.paint(g, (int)offset, textBaseline, (int)fragmentWidth, MultiIconSimpleColoredComponent.getCharHeight(g), (Object)font);
            }
            if (attributes.isWaved()) {
                if (attributes.getWaveColor() != null) {
                    g.setColor(attributes.getWaveColor());
                }
                EffectPainter.WAVE_UNDERSCORE.paint(g, (int)offset, textBaseline + 1, (int)fragmentWidth, Math.max(2, metrics.getDescent()), (Object)font);
            }
            if (attributes.isUnderline()) {
                EffectPainter.LINE_UNDERSCORE.paint(g, (int)offset, textBaseline, (int)fragmentWidth, metrics.getDescent(), (Object)font);
            }
            if (attributes.isBoldDottedLine()) {
                int dottedAt = SystemInfo.isMac ? textBaseline : textBaseline + 1;
                Color lineColor = attributes.getWaveColor();
                UIUtil.drawBoldDottedLine((Graphics2D)g, (int)((int)offset), (int)((int)(offset + fragmentWidth)), (int)dottedAt, (Color)bgColor, (Color)lineColor, (boolean)this.isOpaque());
            }
            if (attributes.isSearchMatch()) {
                searchMatches.add(new Object[]{Float.valueOf(offset), Float.valueOf(offset + fragmentWidth), Float.valueOf(textBaseline), this.myFragments.get(i), g.getFont(), attributes});
            }
            offset = endOffset;
            ++i;
        }
        if (this.myPaintFocusBorder && this.myBorder != null) {
            if (focusAroundIcon) {
                this.myBorder.paintBorder(this, g, 0, 0, this.getWidth(), this.getHeight());
            } else {
                int textStart = 0;
                for (PositionedIcon positionedIcon : this.myIcons) {
                    if (positionedIcon.index != 0) break;
                    textStart += positionedIcon.icon.getIconWidth() + this.myIconTextGap;
                }
                this.myBorder.paintBorder(this, g, textStart, 0, this.getWidth() - textStart, this.getHeight());
            }
        }
        for (Object[] info : searchMatches) {
            float x1 = ((Float)info[0]).floatValue();
            float x2 = ((Float)info[1]).floatValue();
            UIUtil.drawSearchMatch((Graphics2D)g, (float)x1, (float)x2, (int)this.getHeight());
            g.setFont((Font)info[4]);
            float baseline = ((Float)info[2]).floatValue();
            String text = (String)info[3];
            if (this.shouldDrawMacShadow()) {
                g.setColor(SHADOW_COLOR);
                g.drawString(text, x1, baseline + 1.0f);
            }
            g.setColor((Color)new JBColor((Color)Gray._50, (Color)Gray._0));
            g.drawString(text, x1, baseline);
            if (!((SimpleTextAttributes)info[5]).isStrikeout()) continue;
            EffectPainter.STRIKE_THROUGH.paint(g, (int)x1, (int)baseline, (int)(x2 - x1), MultiIconSimpleColoredComponent.getCharHeight(g), (Object)g.getFont());
        }
        return (int)offset;
    }

    private static int getCharHeight(Graphics g) {
        return g.getFontMetrics().charWidth('a');
    }

    private int computeTextAlignShift() {
        if (this.myTextAlign == 2 || this.myTextAlign == 10) {
            return 0;
        }
        int componentWidth = this.getSize().width;
        int excessiveWidth = componentWidth - this.computePreferredSize((boolean)false).width;
        if (excessiveWidth <= 0) {
            return 0;
        }
        if (this.myTextAlign == 0) {
            return excessiveWidth / 2;
        }
        if (this.myTextAlign == 4 || this.myTextAlign == 11) {
            return excessiveWidth;
        }
        return 0;
    }

    protected boolean shouldDrawMacShadow() {
        return false;
    }

    protected boolean shouldDrawDimmed() {
        return false;
    }

    protected boolean shouldDrawBackground() {
        return false;
    }

    protected void paintIcon(@NotNull Graphics g, @NotNull Icon icon, int offset) {
        if (g == null) {
            MultiIconSimpleColoredComponent.$$$reportNull$$$0(29);
        }
        if (icon == null) {
            MultiIconSimpleColoredComponent.$$$reportNull$$$0(30);
        }
        Rectangle area = this.computePaintArea();
        icon.paintIcon(this, g, offset, area.y + (area.height - icon.getIconHeight() + 1) / 2);
    }

    protected void applyAdditionalHints(@NotNull Graphics2D g) {
        if (g == null) {
            MultiIconSimpleColoredComponent.$$$reportNull$$$0(31);
        }
        UISettings.setupAntialiasing((Graphics)g);
    }

    @Override
    public int getBaseline(int width, int height) {
        super.getBaseline(width, height);
        return MultiIconSimpleColoredComponent.getTextBaseLine(this.getFontMetrics(this.getFont()), height);
    }

    public boolean isTransparentIconBackground() {
        return this.myTransparentIconBackground;
    }

    public void setTransparentIconBackground(boolean transparentIconBackground) {
        this.myTransparentIconBackground = transparentIconBackground;
    }

    public static int getTextBaseLine(@NotNull FontMetrics metrics, int height) {
        if (metrics == null) {
            MultiIconSimpleColoredComponent.$$$reportNull$$$0(32);
        }
        return (height - metrics.getHeight()) / 2 + metrics.getAscent() + (SystemInfo.isJetBrainsJvm ? metrics.getLeading() : 0);
    }

    private static void checkCanPaint(Graphics g) {
        if (UIUtil.isPrinting((Graphics)g)) {
            return;
        }
        Application application = ApplicationManager.getApplication();
        if (application != null) {
            application.assertIsDispatchThread();
        } else if (!SwingUtilities.isEventDispatchThread()) {
            throw new RuntimeException(Thread.currentThread().toString());
        }
    }

    @NotNull
    private String logSwingPath() {
        StringBuilder buffer = new StringBuilder("Components hierarchy:\n");
        for (Container c = this; c != null; c = c.getParent()) {
            buffer.append('\n');
            buffer.append(c);
        }
        String string = buffer.toString();
        if (string == null) {
            MultiIconSimpleColoredComponent.$$$reportNull$$$0(33);
        }
        return string;
    }

    protected void setBorderInsets(Insets insets) {
        if (this.myBorder instanceof MyBorder) {
            ((MyBorder)this.myBorder).setInsets(insets);
        }
        this.revalidateAndRepaint();
    }

    @NotNull
    public CharSequence getCharSequence(boolean mainOnly) {
        List<String> fragments = mainOnly && this.myMainTextLastIndex > -1 && this.myMainTextLastIndex + 1 < this.myFragments.size() ? this.myFragments.subList(0, this.myMainTextLastIndex + 1) : this.myFragments;
        String string = StringUtil.join(fragments, (String)"");
        if (string == null) {
            MultiIconSimpleColoredComponent.$$$reportNull$$$0(34);
        }
        return string;
    }

    @Override
    public String toString() {
        return this.getCharSequence(false).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void change(@NotNull Runnable runnable, boolean autoInvalidate) {
        if (runnable == null) {
            MultiIconSimpleColoredComponent.$$$reportNull$$$0(35);
        }
        boolean old = this.myAutoInvalidate;
        this.myAutoInvalidate = autoInvalidate;
        try {
            runnable.run();
        }
        finally {
            this.myAutoInvalidate = old;
        }
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleSimpleColoredComponent();
        }
        return this.accessibleContext;
    }

    static {
        STYLE_SEARCH_MATCH_BACKGROUND = SHADOW_COLOR = new JBColor(new Color(250, 250, 250, 140), Gray._0.withAlpha(50));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 13, 16, 18, 33, 34 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fragment";
                break;
            }
            case 1: 
            case 13: 
            case 16: 
            case 18: 
            case 33: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "io/flutter/view/MultiIconSimpleColoredComponent";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 21: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributes";
                break;
            }
            case 12: 
            case 28: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "icon";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ipad";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "font";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "label";
                break;
            }
            case 19: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 27: 
            case 29: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "g";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "metrics";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "io/flutter/view/MultiIconSimpleColoredComponent";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "append";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getIpad";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getBaseFont";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "formatToLabel";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "logSwingPath";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getCharSequence";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "append";
                break;
            }
            case 1: 
            case 13: 
            case 16: 
            case 18: 
            case 33: 
            case 34: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "_append";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "addIcon";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "setIpad";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "computeTextWidth";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "formatToLabel";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "formatText";
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "formatLink";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "convertFragment";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "doPaintIcon";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "paintIcon";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "applyAdditionalHints";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getTextBaseLine";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "change";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 13, 16, 18, 33, 34 -> new IllegalStateException(string);
        };
    }

    private static final class MyBorder
    implements Border {
        private Insets myInsets = JBUI.insets((int)1);

        public void setInsets(Insets insets) {
            this.myInsets = insets;
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return (Insets)this.myInsets.clone();
        }

        @Override
        public boolean isBorderOpaque() {
            return false;
        }
    }

    private class MyIterator
    implements ColoredIterator {
        int myIndex = -1;
        int myOffset;
        int myEndOffset;

        private MyIterator() {
        }

        @Override
        public int getOffset() {
            return this.myOffset;
        }

        @Override
        public int getEndOffset() {
            return this.myEndOffset;
        }

        @Override
        @NotNull
        public String getFragment() {
            String string = MultiIconSimpleColoredComponent.this.myFragments.get(this.myIndex);
            if (string == null) {
                MyIterator.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        @NotNull
        public SimpleTextAttributes getTextAttributes() {
            SimpleTextAttributes simpleTextAttributes = MultiIconSimpleColoredComponent.this.myAttributes.get(this.myIndex);
            if (simpleTextAttributes == null) {
                MyIterator.$$$reportNull$$$0(1);
            }
            return simpleTextAttributes;
        }

        @Override
        public int split(int offset, @NotNull SimpleTextAttributes attributes) {
            if (attributes == null) {
                MyIterator.$$$reportNull$$$0(2);
            }
            if (offset < 0 || offset > this.myEndOffset - this.myOffset) {
                throw new IllegalArgumentException(offset + " is not within [0, " + (this.myEndOffset - this.myOffset) + "]");
            }
            if (offset == this.myEndOffset - this.myOffset) {
                MultiIconSimpleColoredComponent.this.myAttributes.set(this.myIndex, attributes);
            } else if (offset > 0) {
                String text = this.getFragment();
                MultiIconSimpleColoredComponent.this.myFragments.set(this.myIndex, text.substring(0, offset));
                MultiIconSimpleColoredComponent.this.myAttributes.add(this.myIndex, attributes);
                MultiIconSimpleColoredComponent.this.myFragments.add(this.myIndex + 1, text.substring(offset));
                if (MultiIconSimpleColoredComponent.this.myFragmentTags != null && MultiIconSimpleColoredComponent.this.myFragmentTags.size() > this.myIndex) {
                    MultiIconSimpleColoredComponent.this.myFragmentTags.add(this.myIndex, MultiIconSimpleColoredComponent.this.myFragments.get(this.myIndex));
                }
                if (this.myIndex < MultiIconSimpleColoredComponent.this.myLayouts.size()) {
                    MultiIconSimpleColoredComponent.this.myLayouts.set(this.myIndex, null);
                }
                if (this.myIndex + 1 < MultiIconSimpleColoredComponent.this.myLayouts.size()) {
                    MultiIconSimpleColoredComponent.this.myLayouts.add(this.myIndex + 1, null);
                }
                ++this.myIndex;
            }
            this.myOffset += offset;
            return this.myOffset;
        }

        @Override
        public boolean hasNext() {
            return this.myIndex + 1 < MultiIconSimpleColoredComponent.this.myFragments.size();
        }

        @Override
        public String next() {
            ++this.myIndex;
            this.myOffset = this.myEndOffset;
            String text = this.getFragment();
            this.myEndOffset += text.length();
            return text;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 2 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "io/flutter/view/MultiIconSimpleColoredComponent$MyIterator";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "attributes";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFragment";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTextAttributes";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "io/flutter/view/MultiIconSimpleColoredComponent$MyIterator";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "split";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 2 -> new IllegalArgumentException(string);
            };
        }
    }

    static class PositionedIcon {
        final Icon icon;
        final int index;

        public PositionedIcon(Icon icon, int index) {
            this.icon = icon;
            this.index = index;
        }
    }

    public static class BrowserLauncherTag
    implements Runnable {
        private final String myUrl;

        public BrowserLauncherTag(@NotNull String url) {
            if (url == null) {
                BrowserLauncherTag.$$$reportNull$$$0(0);
            }
            this.myUrl = url;
        }

        @Override
        public void run() {
            BrowserUtil.browse((String)this.myUrl);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "io/flutter/view/MultiIconSimpleColoredComponent$BrowserLauncherTag", "<init>"));
        }
    }

    protected class AccessibleSimpleColoredComponent
    extends JComponent.AccessibleJComponent {
        protected AccessibleSimpleColoredComponent() {
            super(MultiIconSimpleColoredComponent.this);
        }

        @Override
        public String getAccessibleName() {
            return MultiIconSimpleColoredComponent.this.getCharSequence(false).toString();
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.LABEL;
        }
    }

    public static interface ColoredIterator
    extends Iterator<String> {
        public int getOffset();

        public int getEndOffset();

        @NotNull
        public String getFragment();

        @NotNull
        public SimpleTextAttributes getTextAttributes();

        public int split(int var1, @NotNull SimpleTextAttributes var2);
    }
}

