/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.view;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Toggleable;
import io.flutter.run.daemon.FlutterApp;
import io.flutter.utils.StreamSubscription;
import io.flutter.view.FlutterViewAction;
import io.flutter.view.PlatformTarget;
import io.flutter.vmService.ServiceExtensionDescription;
import io.flutter.vmService.ServiceExtensionState;
import io.flutter.vmService.ServiceExtensions;
import org.jetbrains.annotations.NotNull;

class PlatformTargetAction
extends FlutterViewAction
implements Toggleable,
Disposable {
    private static final ServiceExtensionDescription<String> extensionDescription = ServiceExtensions.togglePlatformMode;
    private final PlatformTarget platformTarget;
    private StreamSubscription<ServiceExtensionState> currentValueSubscription;
    private boolean selected;

    PlatformTargetAction(@NotNull FlutterApp app, PlatformTarget platformTarget) {
        if (app == null) {
            PlatformTargetAction.$$$reportNull$$$0(0);
        }
        super(app, platformTarget.toString(), extensionDescription.getDescription(), null);
        this.selected = false;
        this.platformTarget = platformTarget;
    }

    @Override
    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            PlatformTargetAction.$$$reportNull$$$0(1);
        }
        if (!this.app.isSessionActive()) {
            e.getPresentation().setEnabled(false);
            return;
        }
        this.app.hasServiceExtension(extensionDescription.getExtension(), enabled -> e.getPresentation().setEnabled(this.app.isSessionActive() && enabled != false));
        e.getPresentation().putClientProperty("selected", (Object)this.selected);
        if (this.currentValueSubscription == null) {
            this.currentValueSubscription = this.app.getVMServiceManager().getServiceExtensionState(extensionDescription.getExtension()).listen(state -> this.setSelected(e, (ServiceExtensionState)state), true);
        }
    }

    public void dispose() {
        if (this.currentValueSubscription != null) {
            this.currentValueSubscription.dispose();
            this.currentValueSubscription = null;
        }
    }

    @Override
    public void perform(AnActionEvent event) {
        if (this.app.isSessionActive()) {
            this.app.togglePlatform(this.platformTarget.name());
            if (this.app.getVMServiceManager() != null) {
                this.app.getVMServiceManager().setServiceExtensionState(extensionDescription.getExtension(), true, this.platformTarget.name());
            }
        }
    }

    public void setSelected(@NotNull AnActionEvent event, ServiceExtensionState state) {
        Object value;
        boolean selected;
        if (event == null) {
            PlatformTargetAction.$$$reportNull$$$0(2);
        }
        this.selected = selected = (value = state.getValue()) != null && value.equals(this.platformTarget.name());
        event.getPresentation().putClientProperty("selected", (Object)selected);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "app";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
        }
        objectArray2[1] = "io/flutter/view/PlatformTargetAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "setSelected";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

