/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.view;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.diagnostic.Logger;
import io.flutter.run.daemon.FlutterApp;
import io.flutter.view.AppState;
import io.flutter.view.FlutterViewAction;
import io.flutter.view.PlatformTarget;
import io.flutter.view.PlatformTargetAction;
import io.flutter.view.ToolbarComboBoxAction;
import io.flutter.vmService.ServiceExtensionDescription;
import io.flutter.vmService.ServiceExtensions;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

class TogglePlatformAction
extends ToolbarComboBoxAction {
    private static final Logger LOG = Logger.getInstance(TogglePlatformAction.class);
    private static final ServiceExtensionDescription<String> extensionDescription = ServiceExtensions.togglePlatformMode;
    @NotNull
    private final FlutterApp app;
    @NotNull
    private final AppState appState;
    private final DefaultActionGroup myActionGroup;
    private final FlutterViewAction fuchsiaAction;
    private PlatformTarget selectedPlatform;

    public TogglePlatformAction(@NotNull FlutterApp app, @NotNull AppState appState) {
        if (app == null) {
            TogglePlatformAction.$$$reportNull$$$0(0);
        }
        if (appState == null) {
            TogglePlatformAction.$$$reportNull$$$0(1);
        }
        this.app = app;
        this.appState = appState;
        this.setSmallVariant(false);
        this.myActionGroup = TogglePlatformAction.createPopupActionGroup(app, appState);
        this.fuchsiaAction = new PlatformTargetAction(app, PlatformTarget.fuchsia);
    }

    @Override
    @NotNull
    protected DefaultActionGroup createPopupActionGroup(JComponent button) {
        DefaultActionGroup defaultActionGroup = this.myActionGroup;
        if (defaultActionGroup == null) {
            TogglePlatformAction.$$$reportNull$$$0(2);
        }
        return defaultActionGroup;
    }

    public final void update(@NotNull AnActionEvent e) {
        if (e == null) {
            TogglePlatformAction.$$$reportNull$$$0(3);
        }
        if (this.app.getVMServiceManager() != null) {
            this.app.getVMServiceManager().getServiceExtensionState(extensionDescription.getExtension()).listen(state -> {
                this.selectedPlatform = PlatformTarget.parseValue((String)state.getValue());
            }, true);
        }
        String selectorText = "Platform:";
        if (this.selectedPlatform != null && this.selectedPlatform != PlatformTarget.unknown) {
            int platformIndex;
            if (this.selectedPlatform == PlatformTarget.fuchsia && !this.appState.flutterViewActions.contains((Object)this.fuchsiaAction)) {
                this.myActionGroup.add((AnAction)this.appState.registerAction(this.fuchsiaAction));
            }
            if ((platformIndex = extensionDescription.getValues().indexOf(this.selectedPlatform.name())) == -1) {
                selectorText = "Platform: Unknown";
                LOG.info("Unknown platform: " + this.selectedPlatform.name());
            } else {
                selectorText = extensionDescription.getTooltips().get(platformIndex);
            }
        }
        e.getPresentation().setText(selectorText);
        e.getPresentation().setDescription(extensionDescription.getDescription());
        e.getPresentation().setEnabled(this.app.isSessionActive());
    }

    private static DefaultActionGroup createPopupActionGroup(FlutterApp app, AppState appState) {
        DefaultActionGroup group = new DefaultActionGroup();
        group.add((AnAction)appState.registerAction(new PlatformTargetAction(app, PlatformTarget.android)));
        group.add((AnAction)appState.registerAction(new PlatformTargetAction(app, PlatformTarget.iOS)));
        return group;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "app";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "appState";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "io/flutter/view/TogglePlatformAction";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "io/flutter/view/TogglePlatformAction";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createPopupActionGroup";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

