/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.view;

import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.ide.HelpTooltip;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ex.ComboBoxAction;
import com.intellij.openapi.actionSystem.ex.CustomComponentAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.ui.UserActivityProviderComponent;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBSwingUtilities;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.MouseEventAdapter;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.accessibility.ScreenReader;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.DefaultButtonModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.plaf.ButtonUI;
import javax.swing.plaf.basic.BasicButtonUI;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ToolbarComboBoxAction
extends AnAction
implements CustomComponentAction {
    private static Icon myIcon = null;
    private static Icon myDisabledIcon = null;
    private static Icon myWin10ComboDropTriangleIcon = null;
    private boolean mySmallVariant = true;
    private String myPopupTitle;

    public static Icon getArrowIcon(boolean enabled) {
        return enabled ? AllIcons.General.ArrowDown : ComboBoxAction.getArrowIcon((boolean)enabled);
    }

    protected ToolbarComboBoxAction() {
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            ToolbarComboBoxAction.$$$reportNull$$$0(0);
        }
        if ((project = e.getProject()) == null) {
            return;
        }
        JFrame frame = WindowManager.getInstance().getFrame(project);
        if (!(frame instanceof IdeFrame)) {
            return;
        }
        ListPopup popup = this.createActionPopup(e.getDataContext(), ((IdeFrame)frame).getComponent(), null);
        popup.showCenteredInCurrentWindow(project);
    }

    @NotNull
    private ListPopup createActionPopup(@NotNull DataContext context, @NotNull JComponent component, @Nullable Runnable disposeCallback) {
        if (context == null) {
            ToolbarComboBoxAction.$$$reportNull$$$0(1);
        }
        if (component == null) {
            ToolbarComboBoxAction.$$$reportNull$$$0(2);
        }
        DefaultActionGroup group = this.createPopupActionGroup(component, context);
        ListPopup popup = JBPopupFactory.getInstance().createActionGroupPopup(this.myPopupTitle, (ActionGroup)group, context, false, this.shouldShowDisabledActions(), false, disposeCallback, this.getMaxRows(), this.getPreselectCondition());
        popup.setMinimumSize(new Dimension(this.getMinWidth(), this.getMinHeight()));
        ListPopup listPopup = popup;
        if (listPopup == null) {
            ToolbarComboBoxAction.$$$reportNull$$$0(3);
        }
        return listPopup;
    }

    @NotNull
    public JComponent createCustomComponent(@NotNull Presentation presentation) {
        if (presentation == null) {
            ToolbarComboBoxAction.$$$reportNull$$$0(4);
        }
        JPanel panel2 = new JPanel(new GridBagLayout());
        ToolbarComboBoxButton button = this.createComboBoxButton(presentation);
        panel2.add((Component)button, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, (Insets)JBUI.insets((int)0, (int)3), 0, 0));
        JPanel jPanel = panel2;
        if (jPanel == null) {
            ToolbarComboBoxAction.$$$reportNull$$$0(5);
        }
        return jPanel;
    }

    protected ToolbarComboBoxButton createComboBoxButton(Presentation presentation) {
        return new ToolbarComboBoxButton(presentation);
    }

    public boolean isSmallVariant() {
        return this.mySmallVariant;
    }

    public void setSmallVariant(boolean smallVariant) {
        this.mySmallVariant = smallVariant;
    }

    public void setPopupTitle(String popupTitle) {
        this.myPopupTitle = popupTitle;
    }

    protected boolean shouldShowDisabledActions() {
        return false;
    }

    @NotNull
    protected abstract DefaultActionGroup createPopupActionGroup(JComponent var1);

    @NotNull
    protected DefaultActionGroup createPopupActionGroup(JComponent button, @NotNull DataContext dataContext) {
        if (dataContext == null) {
            ToolbarComboBoxAction.$$$reportNull$$$0(6);
        }
        DefaultActionGroup defaultActionGroup = this.createPopupActionGroup(button);
        if (defaultActionGroup == null) {
            ToolbarComboBoxAction.$$$reportNull$$$0(7);
        }
        return defaultActionGroup;
    }

    protected int getMaxRows() {
        return 30;
    }

    protected int getMinHeight() {
        return 1;
    }

    protected int getMinWidth() {
        return 1;
    }

    protected Condition<AnAction> getPreselectCondition() {
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 5, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 3: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "io/flutter/view/ToolbarComboBoxAction";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "io/flutter/view/ToolbarComboBoxAction";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createActionPopup";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createCustomComponent";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createPopupActionGroup";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createActionPopup";
                break;
            }
            case 3: 
            case 5: 
            case 7: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createCustomComponent";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createPopupActionGroup";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 5, 7 -> new IllegalStateException(string);
        };
    }

    protected class ToolbarComboBoxButton
    extends JButton
    implements UserActivityProviderComponent {
        private final Presentation myPresentation;
        private boolean myForcePressed = false;
        private PropertyChangeListener myButtonSynchronizer;

        @Override
        public void setUI(ButtonUI ui) {
            super.setUI(new BasicButtonUI());
        }

        public ToolbarComboBoxButton(Presentation presentation) {
            this.myPresentation = presentation;
            this.setModel(new MyButtonModel());
            this.getModel().setEnabled(this.myPresentation.isEnabled());
            this.setVisible(presentation.isVisible());
            this.setHorizontalAlignment(2);
            this.setFocusable(ScreenReader.isActive());
            this.setBorder((Border)JBUI.Borders.empty());
            this.putClientProperty("styleCombo", (Object)ToolbarComboBoxAction.this);
            this.setMargin((Insets)JBUI.insets((int)0, (int)0, (int)0, (int)2));
            if (ToolbarComboBoxAction.this.isSmallVariant()) {
                this.setFont((Font)JBUI.Fonts.miniFont());
            }
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    if (SwingUtilities.isLeftMouseButton(e)) {
                        e.consume();
                        ToolbarComboBoxButton.this.doClick();
                    }
                }
            });
            this.addMouseMotionListener(new MouseMotionAdapter(){

                @Override
                public void mouseDragged(MouseEvent e) {
                    this.mouseMoved(MouseEventAdapter.convert((MouseEvent)e, (Component)e.getComponent(), (int)503, (long)e.getWhen(), (int)(e.getModifiers() | e.getModifiersEx()), (int)e.getX(), (int)e.getY()));
                }
            });
        }

        @Override
        protected void fireActionPerformed(ActionEvent event) {
            if (!this.myForcePressed) {
                IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(this::showPopup);
            }
        }

        @NotNull
        private Runnable setForcePressed() {
            this.myForcePressed = true;
            this.repaint();
            Runnable runnable = () -> {
                ApplicationManager.getApplication().invokeLater(() -> {
                    this.myForcePressed = false;
                    this.repaint();
                }, ModalityState.any());
                this.repaint();
                this.fireStateChanged();
            };
            if (runnable == null) {
                ToolbarComboBoxButton.$$$reportNull$$$0(0);
            }
            return runnable;
        }

        @Override
        @Nullable
        public String getToolTipText() {
            return this.myForcePressed || Registry.is((String)"ide.helptooltip.enabled") ? null : super.getToolTipText();
        }

        public void showPopup() {
            JBPopup popup = this.createPopup(this.setForcePressed());
            if (Registry.is((String)"ide.helptooltip.enabled")) {
                HelpTooltip.setMasterPopup((Component)this, (JBPopup)popup);
            }
            popup.showUnderneathOf((Component)this);
        }

        protected JBPopup createPopup(Runnable onDispose) {
            return ToolbarComboBoxAction.this.createActionPopup(this.getDataContext(), this, onDispose);
        }

        protected DataContext getDataContext() {
            return DataManager.getInstance().getDataContext((Component)this);
        }

        @Override
        public void removeNotify() {
            if (this.myButtonSynchronizer != null) {
                this.myPresentation.removePropertyChangeListener(this.myButtonSynchronizer);
                this.myButtonSynchronizer = null;
            }
            super.removeNotify();
        }

        @Override
        public void addNotify() {
            super.addNotify();
            if (this.myButtonSynchronizer == null) {
                this.myButtonSynchronizer = new MyButtonSynchronizer();
                this.myPresentation.addPropertyChangeListener(this.myButtonSynchronizer);
            }
            this.initButton();
        }

        private void initButton() {
            this.setIcon(this.myPresentation.getIcon());
            this.setText(this.myPresentation.getText());
            this.updateTooltipText(this.myPresentation.getDescription());
            this.updateButtonSize();
        }

        private void updateTooltipText(String description) {
            String tooltip = KeymapUtil.createTooltipText((String)description, (AnAction)ToolbarComboBoxAction.this);
            if (Registry.is((String)"ide.helptooltip.enabled") && StringUtil.isNotEmpty((String)tooltip)) {
                HelpTooltip.dispose((Component)this);
                new HelpTooltip().setDescription(tooltip).setLocation(HelpTooltip.Alignment.BOTTOM).installOn((JComponent)this);
            } else {
                this.setToolTipText(!tooltip.isEmpty() ? tooltip : null);
            }
        }

        @Override
        public boolean isOpaque() {
            return !ToolbarComboBoxAction.this.isSmallVariant();
        }

        @Override
        public int getIconTextGap() {
            return 0;
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension prefSize = super.getPreferredSize();
            int width = prefSize.width + (this.myPresentation != null && this.isArrowVisible(this.myPresentation) ? ToolbarComboBoxAction.getArrowIcon(this.isEnabled()).getIconWidth() : 0) + (StringUtil.isNotEmpty((String)this.getText()) ? this.getIconTextGap() : 0) + (UIUtil.isUnderWin10LookAndFeel() ? JBUI.scale((int)6) : 0);
            Dimension size = new Dimension(width, ToolbarComboBoxAction.this.isSmallVariant() ? JBUI.scale((int)24) : Math.max(JBUI.scale((int)24), prefSize.height));
            JBInsets.addTo((Dimension)size, (Insets)this.getMargin());
            return size;
        }

        @Override
        public Dimension getMinimumSize() {
            return new Dimension(super.getMinimumSize().width, this.getPreferredSize().height);
        }

        @Override
        public Font getFont() {
            return ToolbarComboBoxAction.this.isSmallVariant() ? JBUI.Fonts.miniFont() : UIUtil.getLabelFont();
        }

        @Override
        protected Graphics getComponentGraphics(Graphics graphics) {
            return JBSwingUtilities.runGlobalCGTransform((JComponent)this, (Graphics)super.getComponentGraphics(graphics));
        }

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            if (!this.isArrowVisible(this.myPresentation)) {
                return;
            }
            Icon icon = ToolbarComboBoxAction.getArrowIcon(this.isEnabled());
            int x = this.getWidth() - icon.getIconWidth() - this.getInsets().right - this.getMargin().right;
            icon.paintIcon(null, g, x, (this.getHeight() - icon.getIconHeight()) / 2);
        }

        protected boolean isArrowVisible(@NotNull Presentation presentation) {
            if (presentation == null) {
                ToolbarComboBoxButton.$$$reportNull$$$0(1);
            }
            return true;
        }

        @Override
        public void updateUI() {
            super.updateUI();
            this.setMargin((Insets)JBUI.insets((int)0, (int)0, (int)0, (int)2));
            this.updateButtonSize();
        }

        protected void updateButtonSize() {
            this.invalidate();
            this.repaint();
            this.setSize(this.getPreferredSize());
            this.repaint();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "io/flutter/view/ToolbarComboBoxAction$ToolbarComboBoxButton";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "presentation";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setForcePressed";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "io/flutter/view/ToolbarComboBoxAction$ToolbarComboBoxButton";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "isArrowVisible";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1 -> new IllegalArgumentException(string);
            };
        }

        protected class MyButtonModel
        extends DefaultButtonModel {
            protected MyButtonModel() {
            }

            @Override
            public boolean isPressed() {
                return ToolbarComboBoxButton.this.myForcePressed || super.isPressed();
            }

            @Override
            public boolean isArmed() {
                return ToolbarComboBoxButton.this.myForcePressed || super.isArmed();
            }
        }

        private class MyButtonSynchronizer
        implements PropertyChangeListener {
            private MyButtonSynchronizer() {
            }

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                String propertyName = evt.getPropertyName();
                if ("text".equals(propertyName)) {
                    ToolbarComboBoxButton.this.setText((String)evt.getNewValue());
                    ToolbarComboBoxButton.this.updateButtonSize();
                } else if ("description".equals(propertyName)) {
                    ToolbarComboBoxButton.this.updateTooltipText((String)evt.getNewValue());
                } else if ("icon".equals(propertyName)) {
                    ToolbarComboBoxButton.this.setIcon((Icon)evt.getNewValue());
                    ToolbarComboBoxButton.this.updateButtonSize();
                } else if ("enabled".equals(propertyName)) {
                    ToolbarComboBoxButton.this.setEnabled((Boolean)evt.getNewValue());
                }
            }
        }
    }
}

