/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.vmService;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointProperties;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.intellij.xdebugger.evaluation.XDebuggerEvaluator;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.frame.XSuspendContext;
import com.intellij.xdebugger.frame.XValue;
import com.jetbrains.lang.dart.ide.runner.DartExceptionBreakpointProperties;
import io.flutter.vmService.DartExceptionBreakpointHandler;
import io.flutter.vmService.DartVmServiceBreakpointHandler;
import io.flutter.vmService.DartVmServiceDebugProcess;
import io.flutter.vmService.frame.DartVmServiceSuspendContext;
import io.flutter.vmService.frame.DartVmServiceValue;
import org.dartlang.vm.service.VmServiceListener;
import org.dartlang.vm.service.element.Breakpoint;
import org.dartlang.vm.service.element.ElementList;
import org.dartlang.vm.service.element.Event;
import org.dartlang.vm.service.element.EventKind;
import org.dartlang.vm.service.element.Frame;
import org.dartlang.vm.service.element.InstanceRef;
import org.dartlang.vm.service.element.IsolateRef;
import org.dartlang.vm.service.element.StepOption;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DartVmServiceListener
implements VmServiceListener {
    private static final Logger LOG = Logger.getInstance((String)DartVmServiceListener.class.getName());
    @NotNull
    private final DartVmServiceDebugProcess myDebugProcess;
    @NotNull
    private final DartVmServiceBreakpointHandler myBreakpointHandler;
    @Nullable
    private XSourcePosition myLatestSourcePosition;

    public DartVmServiceListener(@NotNull DartVmServiceDebugProcess debugProcess, @NotNull DartVmServiceBreakpointHandler breakpointHandler) {
        if (debugProcess == null) {
            DartVmServiceListener.$$$reportNull$$$0(0);
        }
        if (breakpointHandler == null) {
            DartVmServiceListener.$$$reportNull$$$0(1);
        }
        this.myDebugProcess = debugProcess;
        this.myBreakpointHandler = breakpointHandler;
    }

    @Override
    public void connectionOpened() {
    }

    @Override
    public void received(@NotNull String streamId, @NotNull Event event) {
        if (streamId == null) {
            DartVmServiceListener.$$$reportNull$$$0(2);
        }
        if (event == null) {
            DartVmServiceListener.$$$reportNull$$$0(3);
        }
        switch (event.getKind()) {
            case BreakpointAdded: {
                break;
            }
            case BreakpointRemoved: {
                break;
            }
            case BreakpointResolved: {
                this.myBreakpointHandler.breakpointResolved(event.getBreakpoint());
                break;
            }
            case Extension: {
                break;
            }
            case GC: {
                break;
            }
            case Inspect: {
                break;
            }
            case IsolateStart: {
                break;
            }
            case IsolateRunnable: {
                this.myDebugProcess.getVmServiceWrapper().handleIsolate(event.getIsolate(), false);
                break;
            }
            case IsolateReload: {
                break;
            }
            case IsolateUpdate: {
                break;
            }
            case IsolateExit: {
                this.myDebugProcess.isolateExit(event.getIsolate());
                break;
            }
            case PauseBreakpoint: 
            case PauseException: 
            case PauseInterrupted: {
                this.myDebugProcess.isolateSuspended(event.getIsolate());
                ApplicationManager.getApplication().executeOnPooledThread(() -> {
                    ElementList<Breakpoint> breakpoints = event.getKind() == EventKind.PauseBreakpoint ? event.getPauseBreakpoints() : null;
                    InstanceRef exception = event.getKind() == EventKind.PauseException ? event.getException() : null;
                    this.onIsolatePaused(event.getIsolate(), breakpoints, exception, event.getTopFrame(), event.getAtAsyncSuspension());
                });
                break;
            }
            case PausePostRequest: {
                this.myDebugProcess.getVmServiceWrapper().restoreBreakpointsForIsolate(event.getIsolate().getId(), () -> this.myDebugProcess.getVmServiceWrapper().resumeIsolate(event.getIsolate().getId(), null));
                break;
            }
            case PauseExit: {
                break;
            }
            case PauseStart: {
                this.myDebugProcess.getVmServiceWrapper().handleIsolate(event.getIsolate(), true);
                break;
            }
            case Resume: {
                this.myDebugProcess.isolateResumed(event.getIsolate());
                break;
            }
            case ServiceExtensionAdded: {
                break;
            }
            case ServiceRegistered: {
                break;
            }
            case ServiceUnregistered: {
                break;
            }
            case VMUpdate: {
                break;
            }
            case WriteEvent: {
                this.myDebugProcess.handleWriteEvent(event.getBytes());
                break;
            }
            case None: {
                break;
            }
        }
    }

    @Override
    public void connectionClosed() {
        this.myDebugProcess.getSession().stop();
    }

    void onIsolatePaused(@NotNull IsolateRef isolateRef, @Nullable ElementList<Breakpoint> vmBreakpoints, @Nullable InstanceRef exception, @Nullable Frame vmTopFrame, boolean atAsyncSuspension) {
        XSourcePosition sourcePosition;
        if (isolateRef == null) {
            DartVmServiceListener.$$$reportNull$$$0(4);
        }
        if (vmTopFrame == null) {
            this.myDebugProcess.getSession().positionReached(new XSuspendContext(){});
            return;
        }
        DartVmServiceSuspendContext suspendContext = new DartVmServiceSuspendContext(this.myDebugProcess, isolateRef, vmTopFrame, exception, atAsyncSuspension);
        XStackFrame xTopFrame = suspendContext.getActiveExecutionStack().getTopFrame();
        XSourcePosition xSourcePosition = sourcePosition = xTopFrame == null ? null : xTopFrame.getSourcePosition();
        if (vmBreakpoints == null || vmBreakpoints.isEmpty()) {
            StepOption latestStep = this.myDebugProcess.getVmServiceWrapper().getLatestStep();
            if (latestStep == StepOption.Over && DartVmServiceListener.equalSourcePositions(this.myLatestSourcePosition, sourcePosition)) {
                StepOption nextStep = atAsyncSuspension ? StepOption.OverAsyncSuspension : latestStep;
                this.myDebugProcess.getVmServiceWrapper().resumeIsolate(isolateRef.getId(), nextStep);
            } else if (exception != null) {
                XBreakpoint<DartExceptionBreakpointProperties> breakpoint = DartExceptionBreakpointHandler.getDefaultExceptionBreakpoint(this.myDebugProcess.getSession().getProject());
                boolean suspend = this.myDebugProcess.getSession().breakpointReached(breakpoint, null, (XSuspendContext)suspendContext);
                if (!suspend) {
                    this.myDebugProcess.getVmServiceWrapper().resumeIsolate(isolateRef.getId(), null);
                }
            } else {
                this.myLatestSourcePosition = sourcePosition;
                this.myDebugProcess.getSession().positionReached((XSuspendContext)suspendContext);
            }
        } else {
            if (vmBreakpoints.size() > 1) {
                LOG.warn(vmBreakpoints.size() + " breakpoints hit in one shot.");
            }
            this.myBreakpointHandler.removeTemporaryBreakpoints(isolateRef.getId());
            XLineBreakpoint<XBreakpointProperties> xBreakpoint = this.myBreakpointHandler.getXBreakpoint(vmBreakpoints.get(0));
            if (xBreakpoint == null) {
                this.myLatestSourcePosition = sourcePosition;
                this.myDebugProcess.getSession().positionReached((XSuspendContext)suspendContext);
                return;
            }
            if ("false".equals(this.evaluateExpression(isolateRef.getId(), vmTopFrame, xBreakpoint.getConditionExpression()))) {
                this.myDebugProcess.getVmServiceWrapper().resumeIsolate(isolateRef.getId(), null);
                return;
            }
            this.myLatestSourcePosition = sourcePosition;
            String logExpression = this.evaluateExpression(isolateRef.getId(), vmTopFrame, xBreakpoint.getLogExpressionObject());
            boolean suspend = this.myDebugProcess.getSession().breakpointReached(xBreakpoint, logExpression, (XSuspendContext)suspendContext);
            if (!suspend) {
                this.myDebugProcess.getVmServiceWrapper().resumeIsolate(isolateRef.getId(), null);
            }
        }
    }

    private static boolean equalSourcePositions(@Nullable XSourcePosition position1, @Nullable XSourcePosition position2) {
        return position1 != null && position2 != null && position1.getFile().equals(position2.getFile()) && position1.getLine() == position2.getLine();
    }

    @Nullable
    private String evaluateExpression(@NotNull String isolateId, @Nullable Frame vmTopFrame, @Nullable XExpression xExpression) {
        String evalText;
        if (isolateId == null) {
            DartVmServiceListener.$$$reportNull$$$0(5);
        }
        String string = evalText = xExpression == null ? null : xExpression.getExpression();
        if (vmTopFrame == null || StringUtil.isEmptyOrSpaces((String)evalText)) {
            return null;
        }
        final Ref evalResult = new Ref();
        final Semaphore semaphore = new Semaphore();
        semaphore.down();
        this.myDebugProcess.getVmServiceWrapper().evaluateInFrame(isolateId, vmTopFrame, evalText, new XDebuggerEvaluator.XEvaluationCallback(){

            public void evaluated(@NotNull XValue result) {
                if (result == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (result instanceof DartVmServiceValue) {
                    evalResult.set((Object)DartVmServiceListener.getSimpleStringPresentation(((DartVmServiceValue)result).getInstanceRef()));
                }
                semaphore.up();
            }

            public void errorOccurred(@NotNull String errorMessage) {
                if (errorMessage == null) {
                    2.$$$reportNull$$$0(1);
                }
                evalResult.set((Object)("Failed to evaluate log expression [" + evalText + "]: " + errorMessage));
                semaphore.up();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "result";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "errorMessage";
                        break;
                    }
                }
                objectArray2[1] = "io/flutter/vmService/DartVmServiceListener$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "evaluated";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "errorOccurred";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        semaphore.waitFor(1000L);
        return (String)evalResult.get();
    }

    @NotNull
    private static String getSimpleStringPresentation(@NotNull InstanceRef instanceRef) {
        if (instanceRef == null) {
            DartVmServiceListener.$$$reportNull$$$0(6);
        }
        switch (instanceRef.getKind()) {
            case Null: 
            case Bool: 
            case Double: 
            case Int: 
            case String: 
            case Float32x4: 
            case Float64x2: 
            case Int32x4: 
            case StackTrace: {
                String string = instanceRef.getValueAsString();
                if (string == null) {
                    DartVmServiceListener.$$$reportNull$$$0(7);
                }
                return string;
            }
        }
        String string = "Instance of " + instanceRef.getClassRef().getName();
        if (string == null) {
            DartVmServiceListener.$$$reportNull$$$0(8);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugProcess";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "breakpointHandler";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "streamId";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "isolateRef";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "isolateId";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instanceRef";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "io/flutter/vmService/DartVmServiceListener";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "io/flutter/vmService/DartVmServiceListener";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getSimpleStringPresentation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "received";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "onIsolatePaused";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "evaluateExpression";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getSimpleStringPresentation";
                break;
            }
            case 7: 
            case 8: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7, 8 -> new IllegalStateException(string);
        };
    }
}

