/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.vmService;

import com.google.gson.JsonObject;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import io.flutter.NotificationManager;
import io.flutter.utils.EventStream;
import io.flutter.utils.StreamSubscription;
import io.flutter.vmService.VMServiceManager;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.dartlang.vm.service.VmService;
import org.dartlang.vm.service.consumer.ServiceExtensionConsumer;
import org.dartlang.vm.service.element.RPCError;

public class DisplayRefreshRateManager {
    private static final Logger LOG = Logger.getInstance(DisplayRefreshRateManager.class);
    private static final String INVALID_DISPLAY_REFRESH_RATE = "INVALID_DISPLAY_REFRESH_RATE";
    public static final double defaultRefreshRate = 60.0;
    private final VMServiceManager vmServiceManager;
    private final VmService vmService;
    private final EventStream<Double> displayRefreshRateStream;

    DisplayRefreshRateManager(VMServiceManager vmServiceManager, VmService vmService) {
        this.vmServiceManager = vmServiceManager;
        this.vmService = vmService;
        this.displayRefreshRateStream = new EventStream();
    }

    public void queryRefreshRate() {
        ApplicationManager.getApplication().invokeLater(() -> this.getDisplayRefreshRate().thenAcceptAsync(this.displayRefreshRateStream::setValue));
    }

    public int getTargetMicrosPerFrame() {
        Double fps = this.getCurrentDisplayRefreshRateRaw();
        if (fps == null) {
            fps = 60.0;
        }
        return (int)Math.round(Math.floor(1000000.0 / fps));
    }

    public StreamSubscription<Double> getCurrentDisplayRefreshRate(Consumer<Double> onValue, boolean onUIThread) {
        return this.displayRefreshRateStream.listen(onValue, onUIThread);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Double getCurrentDisplayRefreshRateRaw() {
        EventStream<Double> eventStream = this.displayRefreshRateStream;
        synchronized (eventStream) {
            Double fps = this.displayRefreshRateStream.getValue();
            if (fps == null) {
                fps = 60.0;
            }
            return fps;
        }
    }

    private CompletableFuture<Double> getDisplayRefreshRate() {
        CompletableFuture<Double> displayRefreshRate = new CompletableFuture<Double>();
        this.vmServiceManager.getFlutterViewId().whenComplete((id, throwable) -> {
            if (throwable != null) {
                LOG.warn(throwable.getMessage());
                displayRefreshRate.complete(60.0);
            } else {
                this.invokeGetDisplayRefreshRate((String)id).whenComplete((refreshRate, t) -> {
                    if (t != null) {
                        LOG.warn(t.getMessage());
                        displayRefreshRate.complete(60.0);
                    } else {
                        displayRefreshRate.complete((Double)refreshRate);
                    }
                });
            }
        });
        return displayRefreshRate;
    }

    private CompletableFuture<Double> invokeGetDisplayRefreshRate(String flutterViewId) {
        final CompletableFuture<Double> ret = new CompletableFuture<Double>();
        JsonObject params = new JsonObject();
        params.addProperty("viewId", flutterViewId);
        this.vmService.callServiceExtension(this.vmServiceManager.getCurrentFlutterIsolateRaw().getId(), "_flutter.getDisplayRefreshRate", params, new ServiceExtensionConsumer(){

            @Override
            public void onError(RPCError error) {
                ret.completeExceptionally(new RuntimeException(error.getMessage()));
            }

            @Override
            public void received(JsonObject object) {
                String fpsField = "fps";
                if (object == null || !object.has("fps")) {
                    ret.complete(null);
                } else {
                    double fps = object.get("fps").getAsDouble();
                    if (DisplayRefreshRateManager.this.invalidFps(fps)) {
                        NotificationManager.showWarning("Flutter device frame rate invalid", "Device returned a target frame rate of " + fps + " FPS. Using 60 FPS instead.", DisplayRefreshRateManager.INVALID_DISPLAY_REFRESH_RATE, true);
                        ret.complete(60.0);
                    } else {
                        ret.complete(fps);
                    }
                }
            }
        });
        return ret;
    }

    private boolean invalidFps(double fps) {
        return fps < 24.0;
    }
}

