/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.vmService;

import com.google.gson.JsonObject;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.EventDispatcher;
import io.flutter.utils.VmServiceListenerAdapter;
import io.flutter.vmService.DisplayRefreshRateManager;
import java.util.EventListener;
import java.util.LinkedList;
import java.util.List;
import org.dartlang.vm.service.VmService;
import org.dartlang.vm.service.element.Event;
import org.dartlang.vm.service.element.ExtensionData;
import org.jetbrains.annotations.NotNull;

public class FlutterFramesMonitor {
    static final int maxFrames = 200;
    private final DisplayRefreshRateManager displayRefreshRateManager;
    private final EventDispatcher<Listener> eventDispatcher;
    private long lastEventFinished;
    public List<FlutterFrameEvent> frames;

    public FlutterFramesMonitor(@NotNull DisplayRefreshRateManager displayRefreshRateManager, @NotNull VmService vmService) {
        if (displayRefreshRateManager == null) {
            FlutterFramesMonitor.$$$reportNull$$$0(0);
        }
        if (vmService == null) {
            FlutterFramesMonitor.$$$reportNull$$$0(1);
        }
        this.eventDispatcher = EventDispatcher.create(Listener.class);
        this.lastEventFinished = 0L;
        this.frames = new LinkedList<FlutterFrameEvent>();
        this.displayRefreshRateManager = displayRefreshRateManager;
        vmService.addVmServiceListener(new VmServiceListenerAdapter(){

            @Override
            public void received(String streamId, Event event) {
                FlutterFramesMonitor.this.onVmServiceReceived(streamId, event);
            }

            @Override
            public void connectionClosed() {
            }
        });
    }

    private void onVmServiceReceived(String streamId, Event event) {
        if (StringUtil.equals((CharSequence)streamId, (CharSequence)"Extension") && StringUtil.equals((CharSequence)"Flutter.Frame", (CharSequence)event.getExtensionKind())) {
            this.handleFlutterFrame(event);
        }
    }

    public boolean hasFps() {
        return !this.frames.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getFPS() {
        int frameCount = 0;
        long costCount = 0L;
        FlutterFramesMonitor flutterFramesMonitor = this;
        synchronized (flutterFramesMonitor) {
            for (FlutterFrameEvent frame : this.frames) {
                ++frameCount;
                int targetMicrosPerFrame = this.displayRefreshRateManager.getTargetMicrosPerFrame();
                long thisCost = frame.elapsedMicros / (long)targetMicrosPerFrame;
                if (frame.elapsedMicros > thisCost * (long)targetMicrosPerFrame) {
                    ++thisCost;
                }
                costCount += thisCost;
                if (!frame.frameSetStart) continue;
                break;
            }
        }
        if (costCount == 0L) {
            return 0.0;
        }
        double targetDisplayRefreshRate = this.displayRefreshRateManager.getCurrentDisplayRefreshRateRaw();
        return (double)frameCount * targetDisplayRefreshRate / (double)costCount;
    }

    public void addListener(Listener listener) {
        this.eventDispatcher.addListener((EventListener)listener);
    }

    public void removeListener(Listener listener) {
        this.eventDispatcher.removeListener((EventListener)listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleFlutterFrame(Event event) {
        FlutterFrameEvent frameEvent = new FlutterFrameEvent(event.getExtensionData(), this.lastEventFinished);
        this.lastEventFinished = frameEvent.getFrameFinishedMicros();
        FlutterFramesMonitor flutterFramesMonitor = this;
        synchronized (flutterFramesMonitor) {
            this.frames.add(0, frameEvent);
            if (this.frames.size() > 200) {
                this.frames.remove(this.frames.size() - 1);
            }
        }
        ((Listener)this.eventDispatcher.getMulticaster()).handleFrameEvent(frameEvent);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "displayRefreshRateManager";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "vmService";
                break;
            }
        }
        objectArray[1] = "io/flutter/vmService/FlutterFramesMonitor";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static interface Listener
    extends EventListener {
        public void handleFrameEvent(FlutterFrameEvent var1);
    }

    public class FlutterFrameEvent {
        public final int frameId;
        public final long startTimeMicros;
        public final long elapsedMicros;
        public final boolean frameSetStart;

        FlutterFrameEvent(ExtensionData data, long lastEventFinished) {
            JsonObject json = data.getJson();
            this.frameId = json.get("number").getAsInt();
            this.startTimeMicros = json.get("startTime").getAsLong();
            this.elapsedMicros = json.get("elapsed").getAsLong();
            this.frameSetStart = this.startTimeMicros - lastEventFinished > (long)(FlutterFramesMonitor.this.displayRefreshRateManager.getTargetMicrosPerFrame() * 2);
        }

        public long getFrameFinishedMicros() {
            return this.startTimeMicros + this.elapsedMicros;
        }

        public boolean isSlowFrame() {
            return this.elapsedMicros > (long)FlutterFramesMonitor.this.displayRefreshRateManager.getTargetMicrosPerFrame();
        }

        public int hashCode() {
            return this.frameId;
        }

        public boolean equals(Object other) {
            return other instanceof FlutterFrameEvent && ((FlutterFrameEvent)other).frameId == this.frameId;
        }

        public String toString() {
            return "#" + this.frameId + " " + this.elapsedMicros + "\u00b5s";
        }
    }
}

