/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.vmService;

import com.intellij.openapi.diagnostic.Logger;
import io.flutter.vmService.VmServiceWrapper;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.dartlang.vm.service.consumer.GetMemoryUsageConsumer;
import org.dartlang.vm.service.element.IsolateRef;
import org.dartlang.vm.service.element.MemoryUsage;
import org.dartlang.vm.service.element.RPCError;
import org.dartlang.vm.service.element.Sentinel;
import org.jetbrains.annotations.NotNull;

public class HeapMonitor {
    private static final Logger LOG = Logger.getInstance(HeapMonitor.class);
    private static final ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();
    private static final int POLL_PERIOD_IN_MS = 1000;
    private final List<HeapListener> heapListeners;
    private ScheduledFuture<?> pollingScheduler;
    @NotNull
    private final VmServiceWrapper vmServiceWrapper;
    private int pollingClients;

    public HeapMonitor(@NotNull VmServiceWrapper vmServiceWrapper) {
        if (vmServiceWrapper == null) {
            HeapMonitor.$$$reportNull$$$0(0);
        }
        this.heapListeners = new ArrayList<HeapListener>();
        this.pollingClients = 0;
        this.vmServiceWrapper = vmServiceWrapper;
    }

    public void addListener(@NotNull HeapListener listener) {
        if (listener == null) {
            HeapMonitor.$$$reportNull$$$0(1);
        }
        this.heapListeners.add(listener);
    }

    public void removeListener(@NotNull HeapListener listener) {
        if (listener == null) {
            HeapMonitor.$$$reportNull$$$0(2);
        }
        this.heapListeners.add(listener);
    }

    public boolean hasListeners() {
        return !this.heapListeners.isEmpty();
    }

    public void start() {
        this.pollingScheduler = executor.scheduleWithFixedDelay(this::poll, 100L, 1000L, TimeUnit.MILLISECONDS);
    }

    public void addPollingClient() {
        ++this.pollingClients;
    }

    public void removePollingClient() {
        --this.pollingClients;
    }

    private void poll() {
        if (this.pollingClients > 0) {
            this.collectMemoryUsage();
        }
    }

    private void collectMemoryUsage() {
        List<IsolateRef> isolateRefs = this.vmServiceWrapper.getExistingIsolates();
        if (isolateRefs.isEmpty()) {
            return;
        }
        final ArrayList memoryUsage = new ArrayList();
        final CountDownLatch latch = new CountDownLatch(isolateRefs.size());
        for (IsolateRef isolateRef : isolateRefs) {
            this.vmServiceWrapper.getVmService().getMemoryUsage(isolateRef.getId(), new GetMemoryUsageConsumer(){

                @Override
                public void received(MemoryUsage usage) {
                    memoryUsage.add(usage);
                    latch.countDown();
                }

                @Override
                public void received(Sentinel sentinel) {
                    latch.countDown();
                }

                @Override
                public void onError(RPCError error) {
                    int rpcInternalError = -32603;
                    int rpcMethodNotFound = -32601;
                    if (error.getCode() == -32603 || error.getCode() == -32601) {
                        HeapMonitor.this.handleMemoryApiNotSupported();
                    }
                    latch.countDown();
                }
            });
        }
        try {
            latch.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (this.pollingScheduler != null) {
            this.heapListeners.forEach(listener -> listener.handleMemoryUsage(memoryUsage));
        }
    }

    private void handleMemoryApiNotSupported() {
        this.stop();
    }

    public void stop() {
        if (this.pollingScheduler != null) {
            this.pollingScheduler.cancel(false);
            this.pollingScheduler = null;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vmServiceWrapper";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
        }
        objectArray2[1] = "io/flutter/vmService/HeapMonitor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "addListener";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "removeListener";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static interface HeapListener {
        public void handleMemoryUsage(List<MemoryUsage> var1);
    }

    public static class HeapSample {
        final int bytes;
        final int external;
        public final long sampleTime;

        public long getSampleTime() {
            return this.sampleTime;
        }

        public HeapSample(int bytes, int external) {
            this.bytes = bytes;
            this.external = external;
            this.sampleTime = System.currentTimeMillis();
        }

        public int getBytes() {
            return this.bytes;
        }

        public int getExternal() {
            return this.external;
        }

        public String toString() {
            return "bytes: " + this.bytes;
        }
    }
}

