/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.vmService;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import gnu.trove.THashMap;
import io.flutter.inspector.EvalOnDartLibrary;
import io.flutter.run.daemon.FlutterApp;
import io.flutter.utils.EventStream;
import io.flutter.utils.StreamSubscription;
import io.flutter.utils.VmServiceListenerAdapter;
import io.flutter.vmService.DisplayRefreshRateManager;
import io.flutter.vmService.FlutterFramesMonitor;
import io.flutter.vmService.HeapMonitor;
import io.flutter.vmService.ServiceExtensionDescription;
import io.flutter.vmService.ServiceExtensionState;
import io.flutter.vmService.ServiceExtensions;
import io.flutter.vmService.ToggleableServiceExtensionDescription;
import io.flutter.vmService.VmServiceConsumers;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.dartlang.vm.service.VmService;
import org.dartlang.vm.service.consumer.GetIsolateConsumer;
import org.dartlang.vm.service.consumer.ServiceExtensionConsumer;
import org.dartlang.vm.service.consumer.VMConsumer;
import org.dartlang.vm.service.element.Event;
import org.dartlang.vm.service.element.EventKind;
import org.dartlang.vm.service.element.Isolate;
import org.dartlang.vm.service.element.IsolateRef;
import org.dartlang.vm.service.element.RPCError;
import org.dartlang.vm.service.element.Sentinel;
import org.dartlang.vm.service.element.VM;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VMServiceManager
implements FlutterApp.FlutterAppListener,
Disposable {
    private static final Logger LOG = Logger.getInstance(VMServiceManager.class);
    @NotNull
    private final FlutterApp app;
    @NotNull
    private final HeapMonitor heapMonitor;
    @NotNull
    private final FlutterFramesMonitor flutterFramesMonitor;
    @NotNull
    private final Map<String, EventStream<Boolean>> serviceExtensions;
    @NotNull
    private final Map<String, EventStream<ServiceExtensionState>> serviceExtensionState;
    private final EventStream<IsolateRef> flutterIsolateRefStream;
    private volatile boolean firstFrameEventReceived;
    private final VmService vmService;
    private final List<String> pendingServiceExtensions;
    private final Set<String> registeredServices;
    @NotNull
    public final DisplayRefreshRateManager displayRefreshRateManager;

    public VMServiceManager(@NotNull FlutterApp app, final @NotNull VmService vmService) {
        if (app == null) {
            VMServiceManager.$$$reportNull$$$0(0);
        }
        if (vmService == null) {
            VMServiceManager.$$$reportNull$$$0(1);
        }
        this.serviceExtensions = new THashMap();
        this.serviceExtensionState = new THashMap();
        this.firstFrameEventReceived = false;
        this.pendingServiceExtensions = new ArrayList<String>();
        this.registeredServices = new HashSet<String>();
        this.app = app;
        this.vmService = vmService;
        app.addStateListener(this);
        assert (app.getFlutterDebugProcess() != null);
        this.heapMonitor = new HeapMonitor(app.getFlutterDebugProcess().getVmServiceWrapper());
        this.displayRefreshRateManager = new DisplayRefreshRateManager(this, vmService);
        this.flutterFramesMonitor = new FlutterFramesMonitor(this.displayRefreshRateManager, vmService);
        this.flutterIsolateRefStream = new EventStream();
        vmService.streamListen("Extension", VmServiceConsumers.EMPTY_SUCCESS_CONSUMER);
        vmService.streamListen("Logging", VmServiceConsumers.EMPTY_SUCCESS_CONSUMER);
        vmService.streamListen("Service", VmServiceConsumers.EMPTY_SUCCESS_CONSUMER);
        VmServiceListenerAdapter myVmServiceListener = new VmServiceListenerAdapter(){

            @Override
            public void received(String streamId, Event event) {
                VMServiceManager.this.onVmServiceReceived(streamId, event);
            }

            @Override
            public void connectionClosed() {
                VMServiceManager.this.onVmConnectionClosed();
            }
        };
        vmService.addVmServiceListener(myVmServiceListener);
        vmService.getVM(new VMConsumer(){

            @Override
            public void received(VM vm) {
                for (final IsolateRef isolateRef : vm.getIsolates()) {
                    vmService.getIsolate(isolateRef.getId(), new GetIsolateConsumer(){

                        @Override
                        public void onError(RPCError error) {
                        }

                        @Override
                        public void received(Isolate isolate) {
                            if (VMServiceManager.this.flutterIsolateRefStream.getValue() == null && isolate.getExtensionRPCs() != null) {
                                for (String extensionName : isolate.getExtensionRPCs()) {
                                    if (!extensionName.startsWith("ext.flutter.")) continue;
                                    VMServiceManager.this.setFlutterIsolate(isolateRef);
                                    break;
                                }
                            }
                            VMServiceManager.this.addRegisteredExtensionRPCs(isolate, false);
                        }

                        @Override
                        public void received(Sentinel sentinel) {
                        }
                    });
                }
            }

            @Override
            public void onError(RPCError error) {
            }
        });
        this.setServiceExtensionState(ServiceExtensions.enableOnDeviceInspector.getExtension(), true, true);
    }

    @NotNull
    public HeapMonitor getHeapMonitor() {
        HeapMonitor heapMonitor = this.heapMonitor;
        if (heapMonitor == null) {
            VMServiceManager.$$$reportNull$$$0(2);
        }
        return heapMonitor;
    }

    public void addRegisteredExtensionRPCs(Isolate isolate, boolean attach) {
        if (attach && isolate.getExtensionRPCs() != null && !this.firstFrameEventReceived) {
            HashSet<String> bindingLibraryNames = new HashSet<String>();
            bindingLibraryNames.add("package:flutter/src/widgets/binding.dart");
            EvalOnDartLibrary flutterLibrary = new EvalOnDartLibrary(bindingLibraryNames, this.vmService, this);
            flutterLibrary.eval("WidgetsBinding.instance.debugDidSendFirstFrameEvent", null, null).whenCompleteAsync((v, e) -> {
                boolean didSendFirstFrameEvent;
                boolean bl = didSendFirstFrameEvent = e == null || v == null || Objects.equals(v.getValueAsString(), "true");
                if (didSendFirstFrameEvent) {
                    this.onFrameEventReceived();
                }
                Disposer.dispose((Disposable)flutterLibrary);
            });
        }
        if (isolate.getExtensionRPCs() != null) {
            for (String extension : isolate.getExtensionRPCs()) {
                this.addServiceExtension(extension);
            }
        }
    }

    private void startHeapMonitor() {
        this.heapMonitor.start();
    }

    public StreamSubscription<IsolateRef> getCurrentFlutterIsolate(Consumer<IsolateRef> onValue, boolean onUIThread) {
        return this.flutterIsolateRefStream.listen(onValue, onUIThread);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IsolateRef getCurrentFlutterIsolateRaw() {
        EventStream<IsolateRef> eventStream = this.flutterIsolateRefStream;
        synchronized (eventStream) {
            return this.flutterIsolateRefStream.getValue();
        }
    }

    private void stopHeapMonitor() {
        this.heapMonitor.stop();
    }

    public void dispose() {
        this.onVmConnectionClosed();
    }

    private void onVmConnectionClosed() {
        this.heapMonitor.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setFlutterIsolate(IsolateRef ref) {
        EventStream<IsolateRef> eventStream = this.flutterIsolateRefStream;
        synchronized (eventStream) {
            IsolateRef existing = this.flutterIsolateRefStream.getValue();
            if (existing == ref || existing != null && ref != null && StringUtil.equals((CharSequence)existing.getId(), (CharSequence)ref.getId())) {
                return;
            }
            this.flutterIsolateRefStream.setValue(ref);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onFlutterIsolateStopped() {
        ArrayList<EventStream<Boolean>> existingExtensions;
        Map<String, EventStream<Boolean>> map = this.serviceExtensions;
        synchronized (map) {
            this.firstFrameEventReceived = false;
            existingExtensions = new ArrayList<EventStream<Boolean>>(this.serviceExtensions.values());
        }
        for (EventStream eventStream : existingExtensions) {
            eventStream.setValue(false);
        }
    }

    private void onVmServiceReceived(String streamId, Event event) {
        String extensionName;
        IsolateRef flutterIsolateRef = this.flutterIsolateRefStream.getValue();
        if (flutterIsolateRef != null && event.getKind() == EventKind.IsolateExit && StringUtil.equals((CharSequence)event.getIsolate().getId(), (CharSequence)flutterIsolateRef.getId())) {
            this.setFlutterIsolate(null);
            this.onFlutterIsolateStopped();
        }
        String kind = event.getExtensionKind();
        if (event.getKind() == EventKind.Extension) {
            switch (kind) {
                case "Flutter.FirstFrame": 
                case "Flutter.Frame": {
                    this.onFrameEventReceived();
                    break;
                }
                case "Flutter.ServiceExtensionStateChanged": {
                    JsonObject extensionData = event.getExtensionData().getJson();
                    String name = extensionData.get("extension").getAsString();
                    String valueFromJson = extensionData.get("value").getAsString();
                    ServiceExtensionDescription<?> extension = ServiceExtensions.toggleableExtensionsAllowList.get(name);
                    if (extension == null) break;
                    Object value = this.getExtensionValueFromEventJson(name, valueFromJson);
                    if (extension instanceof ToggleableServiceExtensionDescription) {
                        ToggleableServiceExtensionDescription toggleableExtension = (ToggleableServiceExtensionDescription)extension;
                        this.setServiceExtensionState(name, value.equals(toggleableExtension.getEnabledValue()), value);
                        break;
                    }
                    this.setServiceExtensionState(name, true, value);
                    break;
                }
                case "Flutter.Error": {
                    this.app.getFlutterConsoleLogManager().handleFlutterErrorEvent(event);
                }
            }
        } else if (event.getKind() == EventKind.ServiceExtensionAdded) {
            this.maybeAddServiceExtension(event.getExtensionRPC());
        } else if (StringUtil.equals((CharSequence)streamId, (CharSequence)"Logging")) {
            this.app.getFlutterConsoleLogManager().handleLoggingEvent(event);
        } else if (event.getKind() == EventKind.ServiceRegistered) {
            this.registerService(event.getService());
        } else if (event.getKind() == EventKind.ServiceUnregistered) {
            this.unregisterService(event.getService());
        }
        if (this.flutterIsolateRefStream.getValue() == null && event.getKind() == EventKind.ServiceExtensionAdded && (extensionName = event.getExtensionRPC()).startsWith("ext.flutter.")) {
            this.setFlutterIsolate(event.getIsolate());
        }
    }

    private Object getExtensionValueFromEventJson(String name, String valueFromJson) {
        Class<?> valueClass = ServiceExtensions.toggleableExtensionsAllowList.get(name).getValueClass();
        if (valueClass == Boolean.class) {
            return valueFromJson.equals("true");
        }
        if (valueClass == Double.class) {
            return Double.valueOf(valueFromJson);
        }
        return valueFromJson;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void maybeAddServiceExtension(String name) {
        Map<String, EventStream<Boolean>> map = this.serviceExtensions;
        synchronized (map) {
            if (this.firstFrameEventReceived) {
                this.addServiceExtension(name);
                assert (this.pendingServiceExtensions.isEmpty());
            } else {
                this.pendingServiceExtensions.add(name);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onFrameEventReceived() {
        Map<String, EventStream<Boolean>> map = this.serviceExtensions;
        synchronized (map) {
            if (this.firstFrameEventReceived) {
                return;
            }
            this.firstFrameEventReceived = true;
            for (String extensionName : this.pendingServiceExtensions) {
                this.addServiceExtension(extensionName);
            }
            this.pendingServiceExtensions.clear();
            this.displayRefreshRateManager.queryRefreshRate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addServiceExtension(String name) {
        Map<String, EventStream<Boolean>> map = this.serviceExtensions;
        synchronized (map) {
            EventStream<Boolean> stream = this.serviceExtensions.get(name);
            if (stream == null) {
                this.serviceExtensions.put(name, new EventStream<Boolean>(true));
            } else if (!stream.getValue().booleanValue()) {
                stream.setValue(true);
            }
            this.restoreExtensionFromDevice(name);
            if (this.getServiceExtensionState(name).getValue().isEnabled()) {
                this.restoreServiceExtensionState(name);
            }
        }
    }

    private void restoreExtensionFromDevice(String name) {
        if (!ServiceExtensions.toggleableExtensionsAllowList.containsKey(name)) {
            return;
        }
        Class<?> valueClass = ServiceExtensions.toggleableExtensionsAllowList.get(name).getValueClass();
        CompletableFuture<JsonObject> response = this.app.callServiceExtension(name);
        response.thenApply(obj -> {
            Object value = null;
            if (obj != null) {
                if (valueClass == Boolean.class) {
                    value = obj.get("enabled").getAsString().equals("true");
                    this.maybeRestoreExtension(name, value);
                } else if (valueClass == String.class) {
                    value = obj.get("value").getAsString();
                    this.maybeRestoreExtension(name, value);
                } else if (valueClass == Double.class) {
                    value = Double.parseDouble(obj.get("value").getAsString());
                    this.maybeRestoreExtension(name, value);
                }
            }
            return value;
        });
    }

    private void maybeRestoreExtension(String name, Object value) {
        if (ServiceExtensions.toggleableExtensionsAllowList.get(name) instanceof ToggleableServiceExtensionDescription) {
            ToggleableServiceExtensionDescription extensionDescription = (ToggleableServiceExtensionDescription)ServiceExtensions.toggleableExtensionsAllowList.get(name);
            if (value.equals(extensionDescription.getEnabledValue())) {
                this.setServiceExtensionState(name, true, value);
            }
        } else {
            this.setServiceExtensionState(name, true, value);
        }
    }

    private void restoreServiceExtensionState(String name) {
        if (this.app.isSessionActive()) {
            if (StringUtil.equals((CharSequence)name, (CharSequence)ServiceExtensions.toggleOnDeviceWidgetInspector.getExtension())) {
                return;
            }
            @Nullable Object value = this.getServiceExtensionState(name).getValue().getValue();
            if (value instanceof Boolean) {
                this.app.callBooleanExtension(name, (Boolean)value);
            } else if (value instanceof String) {
                HashMap<String, Object> params = new HashMap<String, Object>();
                params.put("value", value);
                this.app.callServiceExtension(name, params);
            } else if (value instanceof Double) {
                HashMap<String, Object> params = new HashMap<String, Object>();
                params.put(name.substring(name.lastIndexOf(".") + 1), value);
                this.app.callServiceExtension(name, params);
            }
        }
    }

    @NotNull
    public FlutterFramesMonitor getFlutterFramesMonitor() {
        FlutterFramesMonitor flutterFramesMonitor = this.flutterFramesMonitor;
        if (flutterFramesMonitor == null) {
            VMServiceManager.$$$reportNull$$$0(3);
        }
        return flutterFramesMonitor;
    }

    public void addHeapListener(@NotNull HeapMonitor.HeapListener listener) {
        if (listener == null) {
            VMServiceManager.$$$reportNull$$$0(4);
        }
        boolean hadListeners = this.heapMonitor.hasListeners();
        this.heapMonitor.addListener(listener);
        if (!hadListeners) {
            this.startHeapMonitor();
        }
    }

    public void removeHeapListener(@NotNull HeapMonitor.HeapListener listener) {
        if (listener == null) {
            VMServiceManager.$$$reportNull$$$0(5);
        }
        this.heapMonitor.removeListener(listener);
        if (!this.heapMonitor.hasListeners()) {
            this.stopHeapMonitor();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public StreamSubscription<Boolean> hasServiceExtension(String name, Consumer<Boolean> onData) {
        EventStream<Boolean> stream;
        Map<String, EventStream<Boolean>> map = this.serviceExtensions;
        synchronized (map) {
            stream = this.serviceExtensions.get(name);
            if (stream == null) {
                stream = new EventStream<Boolean>(false);
                this.serviceExtensions.put(name, stream);
            }
        }
        StreamSubscription<Boolean> streamSubscription = stream.listen(onData, true);
        if (streamSubscription == null) {
            VMServiceManager.$$$reportNull$$$0(6);
        }
        return streamSubscription;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public EventStream<ServiceExtensionState> getServiceExtensionState(String name) {
        EventStream<ServiceExtensionState> stream;
        Map<String, EventStream<ServiceExtensionState>> map = this.serviceExtensionState;
        synchronized (map) {
            stream = this.serviceExtensionState.get(name);
            if (stream == null) {
                stream = new EventStream<ServiceExtensionState>(new ServiceExtensionState(false, null));
                this.serviceExtensionState.put(name, stream);
            }
        }
        EventStream<ServiceExtensionState> eventStream = stream;
        if (eventStream == null) {
            VMServiceManager.$$$reportNull$$$0(7);
        }
        return eventStream;
    }

    public void setServiceExtensionState(String name, boolean enabled, Object value) {
        EventStream<ServiceExtensionState> stream = this.getServiceExtensionState(name);
        stream.setValue(new ServiceExtensionState(enabled, value));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasServiceExtensionNow(String name) {
        Map<String, EventStream<Boolean>> map = this.serviceExtensions;
        synchronized (map) {
            EventStream<Boolean> stream = this.serviceExtensions.get(name);
            return stream != null && stream.getValue() == Boolean.TRUE;
        }
    }

    public void hasServiceExtension(String name, Consumer<Boolean> onData, Disposable parentDisposable) {
        if (!Disposer.isDisposed((Disposable)parentDisposable)) {
            Disposer.register((Disposable)parentDisposable, this.hasServiceExtension(name, onData));
        }
    }

    public boolean hasRegisteredService(String name) {
        return this.registeredServices.contains(name);
    }

    public boolean hasAnyRegisteredServices() {
        return !this.registeredServices.isEmpty();
    }

    private void registerService(String serviceName) {
        if (serviceName != null) {
            this.registeredServices.add(serviceName);
        }
    }

    private void unregisterService(String serviceName) {
        if (serviceName != null) {
            this.registeredServices.remove(serviceName);
        }
    }

    public CompletableFuture<String> getFlutterViewId() {
        return ((CompletableFuture)this.getFlutterViewsList().exceptionally(exception -> {
            throw new RuntimeException(exception.getMessage());
        })).thenApplyAsync(element -> {
            JsonArray viewsList = element.getAsJsonObject().get("views").getAsJsonArray();
            for (JsonElement jsonElement : viewsList) {
                JsonObject view = jsonElement.getAsJsonObject();
                if (!view.get("type").getAsString().equals("FlutterView")) continue;
                return view.get("id").getAsString();
            }
            throw new RuntimeException("No Flutter views to query: " + String.valueOf(viewsList));
        });
    }

    private CompletableFuture<JsonElement> getFlutterViewsList() {
        final CompletableFuture<JsonElement> ret = new CompletableFuture<JsonElement>();
        IsolateRef currentFlutterIsolate = this.getCurrentFlutterIsolateRaw();
        if (currentFlutterIsolate == null) {
            ret.completeExceptionally(new RuntimeException("No isolate to query for Flutter views."));
            return ret;
        }
        final String isolateId = this.getCurrentFlutterIsolateRaw().getId();
        this.vmService.callServiceExtension(isolateId, "_flutter.listViews", new ServiceExtensionConsumer(){

            @Override
            public void onError(RPCError error) {
                Object message = isolateId;
                message = (String)message + ":_flutter.listViews";
                message = (String)message + ":" + error.getCode();
                message = (String)message + ":" + error.getMessage();
                if (error.getDetails() != null) {
                    message = (String)message + ":" + error.getDetails();
                }
                ret.completeExceptionally(new RuntimeException((String)message));
            }

            @Override
            public void received(JsonObject object) {
                if (object == null) {
                    ret.complete(null);
                } else {
                    ret.complete(object);
                }
            }
        });
        return ret;
    }

    @Override
    public void stateChanged(FlutterApp.State newState) {
        if (newState == FlutterApp.State.RESTARTING) {
            this.onFlutterIsolateStopped();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 6, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "app";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vmService";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "io/flutter/vmService/VMServiceManager";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "io/flutter/vmService/VMServiceManager";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getHeapMonitor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFlutterFramesMonitor";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "hasServiceExtension";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getServiceExtensionState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addHeapListener";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "removeHeapListener";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 6, 7 -> new IllegalStateException(string);
        };
    }
}

