/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.vmService;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.net.PercentEscaper;
import com.google.gson.JsonObject;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Alarm;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.breakpoints.XBreakpointProperties;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.intellij.xdebugger.evaluation.XDebuggerEvaluator;
import com.intellij.xdebugger.frame.XExecutionStack;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import com.jetbrains.lang.dart.DartFileType;
import io.flutter.FlutterInitializer;
import io.flutter.analytics.Analytics;
import io.flutter.bazel.WorkspaceCache;
import io.flutter.run.daemon.FlutterApp;
import io.flutter.sdk.FlutterSdk;
import io.flutter.vmService.CanonicalBreakpoint;
import io.flutter.vmService.DartVmServiceBreakpointHandler;
import io.flutter.vmService.DartVmServiceDebugProcess;
import io.flutter.vmService.DartVmServiceListener;
import io.flutter.vmService.IsolatesInfo;
import io.flutter.vmService.VMServiceManager;
import io.flutter.vmService.VmServiceConsumers;
import io.flutter.vmService.VmServiceVersion;
import io.flutter.vmService.frame.DartAsyncMarkerFrame;
import io.flutter.vmService.frame.DartVmServiceEvaluator;
import io.flutter.vmService.frame.DartVmServiceStackFrame;
import io.flutter.vmService.frame.DartVmServiceValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dartlang.vm.service.VmService;
import org.dartlang.vm.service.consumer.AddBreakpointWithScriptUriConsumer;
import org.dartlang.vm.service.consumer.EvaluateConsumer;
import org.dartlang.vm.service.consumer.EvaluateInFrameConsumer;
import org.dartlang.vm.service.consumer.GetIsolateConsumer;
import org.dartlang.vm.service.consumer.GetObjectConsumer;
import org.dartlang.vm.service.consumer.GetStackConsumer;
import org.dartlang.vm.service.consumer.InvokeConsumer;
import org.dartlang.vm.service.consumer.PauseConsumer;
import org.dartlang.vm.service.consumer.RemoveBreakpointConsumer;
import org.dartlang.vm.service.consumer.SetExceptionPauseModeConsumer;
import org.dartlang.vm.service.consumer.SetIsolatePauseModeConsumer;
import org.dartlang.vm.service.consumer.SuccessConsumer;
import org.dartlang.vm.service.consumer.UriListConsumer;
import org.dartlang.vm.service.consumer.VMConsumer;
import org.dartlang.vm.service.consumer.VersionConsumer;
import org.dartlang.vm.service.element.Breakpoint;
import org.dartlang.vm.service.element.ElementList;
import org.dartlang.vm.service.element.ErrorRef;
import org.dartlang.vm.service.element.Event;
import org.dartlang.vm.service.element.EventKind;
import org.dartlang.vm.service.element.ExceptionPauseMode;
import org.dartlang.vm.service.element.Frame;
import org.dartlang.vm.service.element.FrameKind;
import org.dartlang.vm.service.element.InstanceRef;
import org.dartlang.vm.service.element.Isolate;
import org.dartlang.vm.service.element.IsolateRef;
import org.dartlang.vm.service.element.LibraryRef;
import org.dartlang.vm.service.element.Obj;
import org.dartlang.vm.service.element.RPCError;
import org.dartlang.vm.service.element.Script;
import org.dartlang.vm.service.element.ScriptRef;
import org.dartlang.vm.service.element.Sentinel;
import org.dartlang.vm.service.element.Stack;
import org.dartlang.vm.service.element.StepOption;
import org.dartlang.vm.service.element.Success;
import org.dartlang.vm.service.element.UnresolvedSourceLocation;
import org.dartlang.vm.service.element.UriList;
import org.dartlang.vm.service.element.VM;
import org.dartlang.vm.service.element.Version;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VmServiceWrapper
implements Disposable {
    @NotNull
    private static final Logger LOG = Logger.getInstance((String)VmServiceWrapper.class.getName());
    private static final long RESPONSE_WAIT_TIMEOUT = 3000L;
    @NotNull
    private final DartVmServiceDebugProcess myDebugProcess;
    @NotNull
    private final VmService myVmService;
    @NotNull
    private final DartVmServiceListener myVmServiceListener;
    @NotNull
    private final IsolatesInfo myIsolatesInfo;
    @NotNull
    private final DartVmServiceBreakpointHandler myBreakpointHandler;
    @NotNull
    private final Alarm myRequestsScheduler;
    @NotNull
    private final Map<Integer, CanonicalBreakpoint> breakpointNumbersToCanonicalMap;
    @NotNull
    private final Set<CanonicalBreakpoint> canonicalBreakpoints;
    private long myVmServiceReceiverThreadId;
    @Nullable
    private StepOption myLatestStep;

    public VmServiceWrapper(@NotNull DartVmServiceDebugProcess debugProcess, @NotNull VmService vmService, @NotNull DartVmServiceListener vmServiceListener, @NotNull IsolatesInfo isolatesInfo, @NotNull DartVmServiceBreakpointHandler breakpointHandler) {
        if (debugProcess == null) {
            VmServiceWrapper.$$$reportNull$$$0(0);
        }
        if (vmService == null) {
            VmServiceWrapper.$$$reportNull$$$0(1);
        }
        if (vmServiceListener == null) {
            VmServiceWrapper.$$$reportNull$$$0(2);
        }
        if (isolatesInfo == null) {
            VmServiceWrapper.$$$reportNull$$$0(3);
        }
        if (breakpointHandler == null) {
            VmServiceWrapper.$$$reportNull$$$0(4);
        }
        this.myDebugProcess = debugProcess;
        this.myVmService = vmService;
        this.myVmServiceListener = vmServiceListener;
        this.myIsolatesInfo = isolatesInfo;
        this.myBreakpointHandler = breakpointHandler;
        this.myRequestsScheduler = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, (Disposable)this);
        this.breakpointNumbersToCanonicalMap = new HashMap<Integer, CanonicalBreakpoint>();
        this.canonicalBreakpoints = new HashSet<CanonicalBreakpoint>();
    }

    @NotNull
    public VmService getVmService() {
        VmService vmService = this.myVmService;
        if (vmService == null) {
            VmServiceWrapper.$$$reportNull$$$0(5);
        }
        return vmService;
    }

    public void dispose() {
    }

    private void addRequest(@NotNull Runnable runnable) {
        if (runnable == null) {
            VmServiceWrapper.$$$reportNull$$$0(6);
        }
        if (!this.myRequestsScheduler.isDisposed()) {
            this.myRequestsScheduler.addRequest(runnable, 0);
        }
    }

    @NotNull
    public List<IsolateRef> getExistingIsolates() {
        ArrayList<IsolateRef> isolateRefs = new ArrayList<IsolateRef>();
        for (IsolatesInfo.IsolateInfo isolateInfo : this.myIsolatesInfo.getIsolateInfos()) {
            isolateRefs.add(isolateInfo.getIsolateRef());
        }
        ArrayList<IsolateRef> arrayList = isolateRefs;
        if (arrayList == null) {
            VmServiceWrapper.$$$reportNull$$$0(7);
        }
        return arrayList;
    }

    @Nullable
    public StepOption getLatestStep() {
        return this.myLatestStep;
    }

    private void assertSyncRequestAllowed() {
        if (ApplicationManager.getApplication().isDispatchThread()) {
            LOG.error("EDT should not be blocked by waiting for for the answer from the Dart debugger");
        }
        if (ApplicationManager.getApplication().isReadAccessAllowed()) {
            LOG.error("Waiting for the answer from the Dart debugger under read action may lead to EDT freeze");
        }
        if (this.myVmServiceReceiverThreadId == Thread.currentThread().getId()) {
            LOG.error("Synchronous requests must not be made in Web Socket listening thread: answer will never be received");
        }
    }

    public void handleDebuggerConnected() {
        this.streamListen("Debug", new VmServiceConsumers.SuccessConsumerWrapper(){

            @Override
            public void received(Success success) {
                VmServiceWrapper.this.myVmServiceReceiverThreadId = Thread.currentThread().getId();
                VmServiceWrapper.this.streamListen("Isolate", new VmServiceConsumers.SuccessConsumerWrapper(){

                    @Override
                    public void received(Success success) {
                        VmServiceWrapper.this.getVm(new VmServiceConsumers.VmConsumerWrapper(){

                            @Override
                            public void received(VM vm) {
                                for (final IsolateRef isolateRef : vm.getIsolates()) {
                                    VmServiceWrapper.this.getIsolate(isolateRef.getId(), new VmServiceConsumers.GetIsolateConsumerWrapper(){

                                        @Override
                                        public void received(Isolate isolate) {
                                            Event event = isolate.getPauseEvent();
                                            EventKind eventKind = event.getKind();
                                            if (eventKind == EventKind.None) {
                                                return;
                                            }
                                            if (eventKind == EventKind.Resume) {
                                                VmServiceWrapper.this.attachIsolate(isolateRef, isolate);
                                                return;
                                            }
                                            VmServiceWrapper.this.handleIsolate(isolateRef, eventKind == EventKind.PauseStart);
                                            if (eventKind == EventKind.PauseBreakpoint || eventKind == EventKind.PauseException || eventKind == EventKind.PauseInterrupted) {
                                                VmServiceWrapper.this.myDebugProcess.isolateSuspended(isolateRef);
                                                ApplicationManager.getApplication().executeOnPooledThread(() -> {
                                                    ElementList<Breakpoint> breakpoints = eventKind == EventKind.PauseBreakpoint ? event.getPauseBreakpoints() : null;
                                                    InstanceRef exception = eventKind == EventKind.PauseException ? event.getException() : null;
                                                    VmServiceWrapper.this.myVmServiceListener.onIsolatePaused(isolateRef, breakpoints, exception, event.getTopFrame(), event.getAtAsyncSuspension());
                                                });
                                            }
                                        }
                                    });
                                }
                            }
                        });
                    }
                });
            }
        });
        this.streamListen("ToolEvent", new SuccessConsumer(){

            @Override
            public void received(Success response) {
            }

            @Override
            public void onError(RPCError error) {
                LOG.error("Error listening to ToolEvent stream: " + String.valueOf(error));
            }
        });
    }

    private void streamListen(@NotNull String streamId, @NotNull SuccessConsumer consumer) {
        if (streamId == null) {
            VmServiceWrapper.$$$reportNull$$$0(8);
        }
        if (consumer == null) {
            VmServiceWrapper.$$$reportNull$$$0(9);
        }
        this.addRequest(() -> this.myVmService.streamListen(streamId, consumer));
    }

    private void getVm(@NotNull VMConsumer consumer) {
        if (consumer == null) {
            VmServiceWrapper.$$$reportNull$$$0(10);
        }
        this.addRequest(() -> this.myVmService.getVM(consumer));
    }

    @NotNull
    public CompletableFuture<Isolate> getCachedIsolate(@NotNull String isolateId) {
        if (isolateId == null) {
            VmServiceWrapper.$$$reportNull$$$0(11);
        }
        CompletableFuture<Isolate> completableFuture = Objects.requireNonNull(this.myIsolatesInfo.getCachedIsolate(isolateId, () -> {
            final CompletableFuture isolateFuture = new CompletableFuture();
            this.getIsolate(isolateId, new GetIsolateConsumer(){

                @Override
                public void onError(RPCError error) {
                    isolateFuture.completeExceptionally(new RuntimeException(error.getMessage()));
                }

                @Override
                public void received(Isolate response) {
                    isolateFuture.complete(response);
                }

                @Override
                public void received(Sentinel response) {
                    isolateFuture.complete(null);
                }
            });
            return isolateFuture;
        }));
        if (completableFuture == null) {
            VmServiceWrapper.$$$reportNull$$$0(12);
        }
        return completableFuture;
    }

    private void getIsolate(@NotNull String isolateId, @NotNull GetIsolateConsumer consumer) {
        if (isolateId == null) {
            VmServiceWrapper.$$$reportNull$$$0(13);
        }
        if (consumer == null) {
            VmServiceWrapper.$$$reportNull$$$0(14);
        }
        this.addRequest(() -> this.myVmService.getIsolate(isolateId, consumer));
    }

    public void handleIsolate(@NotNull IsolateRef isolateRef, boolean isolatePausedStart) {
        if (isolateRef == null) {
            VmServiceWrapper.$$$reportNull$$$0(15);
        }
        boolean newIsolate = this.myIsolatesInfo.addIsolate(isolateRef);
        if (isolatePausedStart) {
            this.myIsolatesInfo.setShouldInitialResume(isolateRef);
        }
        if (newIsolate) {
            this.setIsolatePauseMode(isolateRef.getId(), this.myDebugProcess.getBreakOnExceptionMode(), isolateRef);
        } else {
            this.checkInitialResume(isolateRef);
        }
    }

    private void setIsolatePauseMode(@NotNull String isolateId, @NotNull ExceptionPauseMode mode, final @NotNull IsolateRef isolateRef) {
        if (isolateId == null) {
            VmServiceWrapper.$$$reportNull$$$0(16);
        }
        if (mode == null) {
            VmServiceWrapper.$$$reportNull$$$0(17);
        }
        if (isolateRef == null) {
            VmServiceWrapper.$$$reportNull$$$0(18);
        }
        if (this.supportsSetIsolatePauseMode()) {
            SetIsolatePauseModeConsumer sipmc = new SetIsolatePauseModeConsumer(){

                @Override
                public void onError(RPCError error) {
                }

                @Override
                public void received(Sentinel response) {
                }

                @Override
                public void received(Success response) {
                    VmServiceWrapper.this.setInitialBreakpointsAndResume(isolateRef);
                }
            };
            this.addRequest(() -> this.myVmService.setIsolatePauseMode(isolateId, mode, false, sipmc));
        } else {
            SetExceptionPauseModeConsumer wrapper = new SetExceptionPauseModeConsumer(){

                @Override
                public void onError(RPCError error) {
                }

                @Override
                public void received(Sentinel response) {
                }

                @Override
                public void received(Success response) {
                    VmServiceWrapper.this.setInitialBreakpointsAndResume(isolateRef);
                }
            };
            this.addRequest(() -> this.myVmService.setExceptionPauseMode(isolateId, mode, wrapper));
        }
    }

    public void attachIsolate(@NotNull IsolateRef isolateRef, @NotNull Isolate isolate) {
        boolean newIsolate;
        if (isolateRef == null) {
            VmServiceWrapper.$$$reportNull$$$0(19);
        }
        if (isolate == null) {
            VmServiceWrapper.$$$reportNull$$$0(20);
        }
        if (newIsolate = this.myIsolatesInfo.addIsolate(isolateRef)) {
            XDebugSessionImpl session = (XDebugSessionImpl)this.myDebugProcess.getSession();
            ApplicationManager.getApplication().runReadAction(() -> {
                session.reset();
                session.initBreakpoints();
            });
            this.setIsolatePauseMode(isolateRef.getId(), this.myDebugProcess.getBreakOnExceptionMode(), isolateRef);
        } else {
            this.checkInitialResume(isolateRef);
        }
    }

    private void checkInitialResume(IsolateRef isolateRef) {
        if (this.myIsolatesInfo.getShouldInitialResume(isolateRef)) {
            this.resumeIsolate(isolateRef.getId(), null);
        }
    }

    private void setInitialBreakpointsAndResume(final @NotNull IsolateRef isolateRef) {
        if (isolateRef == null) {
            VmServiceWrapper.$$$reportNull$$$0(21);
        }
        if (this.myDebugProcess.myRemoteProjectRootUri == null) {
            this.getIsolate(isolateRef.getId(), new VmServiceConsumers.GetIsolateConsumerWrapper(){

                @Override
                public void received(Isolate isolate) {
                    VmServiceWrapper.this.myDebugProcess.guessRemoteProjectRoot(isolate.getLibraries());
                    VmServiceWrapper.this.doSetInitialBreakpointsAndResume(isolateRef);
                }
            });
        } else {
            this.doSetInitialBreakpointsAndResume(isolateRef);
        }
    }

    private void setInitialBreakpointsAndCheckExtensions(@NotNull IsolateRef isolateRef, @NotNull Isolate isolate) {
        VMServiceManager service;
        if (isolateRef == null) {
            VmServiceWrapper.$$$reportNull$$$0(22);
        }
        if (isolate == null) {
            VmServiceWrapper.$$$reportNull$$$0(23);
        }
        this.doSetBreakpointsForIsolate(this.myBreakpointHandler.getXBreakpoints(), isolateRef.getId(), () -> this.myIsolatesInfo.setBreakpointsSet(isolateRef));
        FlutterApp app = FlutterApp.fromEnv(this.myDebugProcess.getExecutionEnvironment());
        if (app != null && (service = app.getVMServiceManager()) != null) {
            service.addRegisteredExtensionRPCs(isolate, true);
        }
    }

    private void doSetInitialBreakpointsAndResume(@NotNull IsolateRef isolateRef) {
        if (isolateRef == null) {
            VmServiceWrapper.$$$reportNull$$$0(24);
        }
        this.doSetBreakpointsForIsolate(this.myBreakpointHandler.getXBreakpoints(), isolateRef.getId(), () -> {
            this.myIsolatesInfo.setBreakpointsSet(isolateRef);
            this.checkInitialResume(isolateRef);
        });
    }

    private void doSetBreakpointsForIsolate(@NotNull Set<XLineBreakpoint<XBreakpointProperties>> xBreakpoints, final @NotNull String isolateId, final @Nullable Runnable onFinished) {
        if (xBreakpoints == null) {
            VmServiceWrapper.$$$reportNull$$$0(25);
        }
        if (isolateId == null) {
            VmServiceWrapper.$$$reportNull$$$0(26);
        }
        if (xBreakpoints.isEmpty()) {
            if (onFinished != null) {
                onFinished.run();
            }
            return;
        }
        final AtomicInteger counter = new AtomicInteger(xBreakpoints.size());
        for (final XLineBreakpoint<XBreakpointProperties> xBreakpoint : xBreakpoints) {
            this.addBreakpoint(isolateId, xBreakpoint.getSourcePosition(), new VmServiceConsumers.BreakpointsConsumer(){

                @Override
                void sourcePositionNotApplicable() {
                    VmServiceWrapper.this.myBreakpointHandler.breakpointFailed((XLineBreakpoint<XBreakpointProperties>)xBreakpoint);
                    this.checkDone();
                }

                @Override
                void received(List<Breakpoint> breakpointResponses, List<RPCError> errorResponses) {
                    if (!breakpointResponses.isEmpty()) {
                        for (Breakpoint breakpoint : breakpointResponses) {
                            VmServiceWrapper.this.myBreakpointHandler.vmBreakpointAdded((XLineBreakpoint<XBreakpointProperties>)xBreakpoint, isolateId, breakpoint);
                        }
                    } else if (!errorResponses.isEmpty()) {
                        VmServiceWrapper.this.myBreakpointHandler.breakpointFailed((XLineBreakpoint<XBreakpointProperties>)xBreakpoint);
                    }
                    this.checkDone();
                }

                private void checkDone() {
                    if (counter.decrementAndGet() == 0 && onFinished != null) {
                        onFinished.run();
                        VmServiceWrapper.this.myVmService.getIsolate(isolateId, new GetIsolateConsumer(){

                            @Override
                            public void received(Isolate response) {
                                HashSet<String> libraryUris = new HashSet<String>();
                                HashSet<String> fileNames = new HashSet<String>();
                                for (LibraryRef library : response.getLibraries()) {
                                    String uri = library.getUri();
                                    libraryUris.add(uri);
                                    String[] split = uri.split("/");
                                    fileNames.add(split[split.length - 1]);
                                }
                                ElementList<Breakpoint> breakpoints = response.getBreakpoints();
                                if (breakpoints.isEmpty() && VmServiceWrapper.this.canonicalBreakpoints.isEmpty()) {
                                    return;
                                }
                                HashSet<CanonicalBreakpoint> mappedCanonicalBreakpoints = new HashSet<CanonicalBreakpoint>();
                                assert (breakpoints != null);
                                for (Breakpoint breakpoint : breakpoints) {
                                    ScriptRef script;
                                    Object location = breakpoint.getLocation();
                                    if (!(location instanceof UnresolvedSourceLocation) || (script = ((UnresolvedSourceLocation)location).getScript()) == null || !libraryUris.contains(script.getUri())) continue;
                                    mappedCanonicalBreakpoints.add(VmServiceWrapper.this.breakpointNumbersToCanonicalMap.get(breakpoint.getBreakpointNumber()));
                                }
                                Analytics analytics = FlutterInitializer.getAnalytics();
                                String category = "breakpoint";
                                Sets.SetView initialDifference = Sets.difference(VmServiceWrapper.this.canonicalBreakpoints, mappedCanonicalBreakpoints);
                                HashSet<CanonicalBreakpoint> finalDifference = new HashSet<CanonicalBreakpoint>();
                                for (CanonicalBreakpoint missingBreakpoint : initialDifference) {
                                    if (!fileNames.contains(missingBreakpoint.fileName)) continue;
                                    finalDifference.add(missingBreakpoint);
                                }
                                analytics.sendEventMetric(category, "unmapped-count", finalDifference.size());
                                if (WorkspaceCache.getInstance(VmServiceWrapper.this.myDebugProcess.getSession().getProject()).isBazel()) {
                                    for (CanonicalBreakpoint canonicalBreakpoint : finalDifference) {
                                        if (!canonicalBreakpoint.path.contains("google3")) continue;
                                        analytics.sendEvent(category, String.format("unmapped-file|%s|%s", response.getRootLib().getUri(), canonicalBreakpoint.path));
                                    }
                                }
                            }

                            @Override
                            public void received(Sentinel response) {
                            }

                            @Override
                            public void onError(RPCError error) {
                            }
                        });
                    }
                }
            });
        }
    }

    public void addBreakpoint(final @NotNull String isolateId, final @Nullable XSourcePosition position, final @NotNull VmServiceConsumers.BreakpointsConsumer consumer) {
        if (isolateId == null) {
            VmServiceWrapper.$$$reportNull$$$0(27);
        }
        if (consumer == null) {
            VmServiceWrapper.$$$reportNull$$$0(28);
        }
        this.myVmService.getVersion(new VersionConsumer(){

            @Override
            public void received(Version response) {
                if (VmServiceWrapper.this.isVmServiceMappingSupported(response)) {
                    VmServiceWrapper.this.addBreakpointWithVmService(isolateId, position, consumer);
                } else {
                    VmServiceWrapper.this.addBreakpointWithMapper(isolateId, position, consumer);
                }
            }

            @Override
            public void onError(RPCError error) {
                VmServiceWrapper.this.addBreakpointWithMapper(isolateId, position, consumer);
            }
        });
    }

    private boolean isVmServiceMappingSupported(Version version) {
        assert (version != null);
        if (WorkspaceCache.getInstance(this.myDebugProcess.getSession().getProject()).isBazel()) {
            return true;
        }
        FlutterSdk sdk = FlutterSdk.getFlutterSdk(this.myDebugProcess.getSession().getProject());
        return VmServiceVersion.hasMapping(version) && sdk.getVersion().isUriMappingSupportedForWeb();
    }

    public void addBreakpointWithMapper(@NotNull String isolateId, @Nullable XSourcePosition position, final @NotNull VmServiceConsumers.BreakpointsConsumer consumer) {
        if (isolateId == null) {
            VmServiceWrapper.$$$reportNull$$$0(29);
        }
        if (consumer == null) {
            VmServiceWrapper.$$$reportNull$$$0(30);
        }
        if (position == null || position.getFile().getFileType() != DartFileType.INSTANCE) {
            consumer.sourcePositionNotApplicable();
            return;
        }
        this.addRequest(() -> {
            int line = position.getLine() + 1;
            final Collection<String> scriptUris = this.myDebugProcess.getUrisForFile(position.getFile());
            final CanonicalBreakpoint canonicalBreakpoint = new CanonicalBreakpoint(position.getFile().getName(), position.getFile().getCanonicalPath(), line);
            this.canonicalBreakpoints.add(canonicalBreakpoint);
            final ArrayList breakpointResponses = new ArrayList();
            final ArrayList errorResponses = new ArrayList();
            for (String uri : scriptUris) {
                this.myVmService.addBreakpointWithScriptUri(isolateId, uri, line, new AddBreakpointWithScriptUriConsumer(){

                    @Override
                    public void received(Breakpoint response) {
                        breakpointResponses.add(response);
                        VmServiceWrapper.this.breakpointNumbersToCanonicalMap.put(response.getBreakpointNumber(), canonicalBreakpoint);
                        this.checkDone();
                    }

                    @Override
                    public void received(Sentinel response) {
                        this.checkDone();
                    }

                    @Override
                    public void onError(RPCError error) {
                        errorResponses.add(error);
                        this.checkDone();
                    }

                    private void checkDone() {
                        if (scriptUris.size() == breakpointResponses.size() + errorResponses.size()) {
                            consumer.received(breakpointResponses, errorResponses);
                        }
                    }
                });
            }
        });
    }

    public void addBreakpointWithVmService(final @NotNull String isolateId, @Nullable XSourcePosition position, final @NotNull VmServiceConsumers.BreakpointsConsumer consumer) {
        if (isolateId == null) {
            VmServiceWrapper.$$$reportNull$$$0(31);
        }
        if (consumer == null) {
            VmServiceWrapper.$$$reportNull$$$0(32);
        }
        if (position == null || position.getFile().getFileType() != DartFileType.INSTANCE) {
            consumer.sourcePositionNotApplicable();
            return;
        }
        this.addRequest(() -> {
            final int line = position.getLine() + 1;
            final String resolvedUri = this.getResolvedUri(position);
            LOG.info("Computed resolvedUri: " + resolvedUri);
            List<String> resolvedUriList = List.of(this.percentEscapeUri(resolvedUri));
            final CanonicalBreakpoint canonicalBreakpoint = new CanonicalBreakpoint(position.getFile().getName(), position.getFile().getCanonicalPath(), line);
            this.canonicalBreakpoints.add(canonicalBreakpoint);
            final ArrayList breakpointResponses = new ArrayList();
            final ArrayList errorResponses = new ArrayList();
            this.myVmService.lookupPackageUris(isolateId, resolvedUriList, new UriListConsumer(){

                @Override
                public void received(UriList response) {
                    LOG.info("in received of lookupPackageUris");
                    if (VmServiceWrapper.this.myDebugProcess.getSession().getProject().isDisposed()) {
                        return;
                    }
                    List<String> uris = response.getUris();
                    if (uris == null || uris.get(0) == null) {
                        LOG.info("Uri was not found");
                        JsonObject error = new JsonObject();
                        error.addProperty("error", "Breakpoint could not be mapped to package URI");
                        errorResponses.add(new RPCError(error));
                        Analytics analytics = FlutterInitializer.getAnalytics();
                        String category = "breakpoint";
                        if (WorkspaceCache.getInstance(VmServiceWrapper.this.myDebugProcess.getSession().getProject()).isBazel() && resolvedUri.contains("google3")) {
                            analytics.sendEvent(category, String.format("no-package-uri|%s", resolvedUri));
                        }
                        consumer.received(breakpointResponses, errorResponses);
                        return;
                    }
                    String scriptUri = uris.get(0);
                    LOG.info("in received of lookupPackageUris. scriptUri: " + scriptUri);
                    VmServiceWrapper.this.myVmService.addBreakpointWithScriptUri(isolateId, scriptUri, line, new AddBreakpointWithScriptUriConsumer(){

                        @Override
                        public void received(Breakpoint response) {
                            breakpointResponses.add(response);
                            VmServiceWrapper.this.breakpointNumbersToCanonicalMap.put(response.getBreakpointNumber(), canonicalBreakpoint);
                            this.checkDone();
                        }

                        @Override
                        public void received(Sentinel response) {
                            this.checkDone();
                        }

                        @Override
                        public void onError(RPCError error) {
                            errorResponses.add(error);
                            this.checkDone();
                        }

                        private void checkDone() {
                            consumer.received(breakpointResponses, errorResponses);
                        }
                    });
                }

                @Override
                public void onError(RPCError error) {
                    LOG.error((Object)error);
                    LOG.error(error.getMessage());
                    LOG.error((Object)error.getRequest());
                    LOG.error(error.getDetails());
                    errorResponses.add(error);
                    consumer.received(breakpointResponses, errorResponses);
                }
            });
        });
    }

    private String getResolvedUri(@NotNull XSourcePosition position) {
        VirtualFile file;
        if (position == null) {
            VmServiceWrapper.$$$reportNull$$$0(33);
        }
        XDebugSession session = this.myDebugProcess.getSession();
        assert (session != null);
        VirtualFile virtualFile = file = WorkspaceCache.getInstance(session.getProject()).isBazel() ? position.getFile() : position.getFile().getCanonicalFile();
        assert (file != null);
        String url = file.getUrl();
        LOG.info("in getResolvedUri. url: " + url);
        if (WorkspaceCache.getInstance(this.myDebugProcess.getSession().getProject()).isBazel()) {
            String root = WorkspaceCache.getInstance(this.myDebugProcess.getSession().getProject()).get().getRoot().getPath();
            String resolvedUriRoot = "google3:///";
            String genFilePattern = root + "/blaze-.*?/(.*)";
            Pattern pattern = Pattern.compile(genFilePattern);
            Matcher matcher = pattern.matcher(url);
            if (matcher.find()) {
                String path = matcher.group(1);
                return resolvedUriRoot + path;
            }
            int rootIdx = url.indexOf(root);
            if (rootIdx >= 0) {
                return resolvedUriRoot + url.substring(rootIdx + root.length() + 1);
            }
        }
        if (SystemInfo.isWindows) {
            return url.replace("file://", "file:///");
        }
        return url;
    }

    private String percentEscapeUri(String uri) {
        PercentEscaper escaper = new PercentEscaper("!#$&'()*+,-./:;=?@_~", false);
        return escaper.escape(uri);
    }

    public void addBreakpointForIsolates(final @NotNull XLineBreakpoint<XBreakpointProperties> xBreakpoint, @NotNull Collection<IsolatesInfo.IsolateInfo> isolateInfos) {
        if (xBreakpoint == null) {
            VmServiceWrapper.$$$reportNull$$$0(34);
        }
        if (isolateInfos == null) {
            VmServiceWrapper.$$$reportNull$$$0(35);
        }
        for (final IsolatesInfo.IsolateInfo isolateInfo : isolateInfos) {
            this.addBreakpoint(isolateInfo.getIsolateId(), xBreakpoint.getSourcePosition(), new VmServiceConsumers.BreakpointsConsumer(){

                @Override
                void sourcePositionNotApplicable() {
                    VmServiceWrapper.this.myBreakpointHandler.breakpointFailed((XLineBreakpoint<XBreakpointProperties>)xBreakpoint);
                }

                @Override
                void received(List<Breakpoint> breakpointResponses, List<RPCError> errorResponses) {
                    for (Breakpoint breakpoint : breakpointResponses) {
                        VmServiceWrapper.this.myBreakpointHandler.vmBreakpointAdded((XLineBreakpoint<XBreakpointProperties>)xBreakpoint, isolateInfo.getIsolateId(), breakpoint);
                    }
                }
            });
        }
    }

    public void restoreBreakpointsForIsolate(@NotNull String isolateId, @Nullable Runnable onFinished) {
        if (isolateId == null) {
            VmServiceWrapper.$$$reportNull$$$0(36);
        }
        this.myIsolatesInfo.invalidateCache(isolateId);
        this.myBreakpointHandler.removeAllVmBreakpoints(isolateId);
        this.doSetBreakpointsForIsolate(this.myBreakpointHandler.getXBreakpoints(), isolateId, onFinished);
    }

    public void addTemporaryBreakpoint(@NotNull XSourcePosition position, final @NotNull String isolateId) {
        if (position == null) {
            VmServiceWrapper.$$$reportNull$$$0(37);
        }
        if (isolateId == null) {
            VmServiceWrapper.$$$reportNull$$$0(38);
        }
        this.addBreakpoint(isolateId, position, new VmServiceConsumers.BreakpointsConsumer(){

            @Override
            void sourcePositionNotApplicable() {
            }

            @Override
            void received(List<Breakpoint> breakpointResponses, List<RPCError> errorResponses) {
                for (Breakpoint breakpoint : breakpointResponses) {
                    VmServiceWrapper.this.myBreakpointHandler.temporaryBreakpointAdded(isolateId, breakpoint);
                }
            }
        });
    }

    public void removeBreakpoint(@NotNull String isolateId, @NotNull String vmBreakpointId) {
        if (isolateId == null) {
            VmServiceWrapper.$$$reportNull$$$0(39);
        }
        if (vmBreakpointId == null) {
            VmServiceWrapper.$$$reportNull$$$0(40);
        }
        this.addRequest(() -> this.myVmService.removeBreakpoint(isolateId, vmBreakpointId, new RemoveBreakpointConsumer(){

            @Override
            public void onError(RPCError error) {
            }

            @Override
            public void received(Sentinel response) {
            }

            @Override
            public void received(Success response) {
            }
        }));
    }

    public void resumeIsolate(@NotNull String isolateId, @Nullable StepOption stepOption) {
        if (isolateId == null) {
            VmServiceWrapper.$$$reportNull$$$0(41);
        }
        this.addRequest(() -> {
            this.myLatestStep = stepOption;
            this.myVmService.resume(isolateId, stepOption, null, new VmServiceConsumers.EmptyResumeConsumer(){});
        });
    }

    public void setExceptionPauseMode(@NotNull ExceptionPauseMode mode) {
        if (mode == null) {
            VmServiceWrapper.$$$reportNull$$$0(42);
        }
        for (IsolatesInfo.IsolateInfo isolateInfo : this.myIsolatesInfo.getIsolateInfos()) {
            if (this.supportsSetIsolatePauseMode()) {
                this.addRequest(() -> this.myVmService.setIsolatePauseMode(isolateInfo.getIsolateId(), mode, false, new SetIsolatePauseModeConsumer(){

                    @Override
                    public void onError(RPCError error) {
                    }

                    @Override
                    public void received(Sentinel response) {
                    }

                    @Override
                    public void received(Success response) {
                    }
                }));
                continue;
            }
            this.addRequest(() -> this.myVmService.setExceptionPauseMode(isolateInfo.getIsolateId(), mode, new SetExceptionPauseModeConsumer(){

                @Override
                public void onError(RPCError error) {
                }

                @Override
                public void received(Sentinel response) {
                }

                @Override
                public void received(Success response) {
                }
            }));
        }
    }

    public void dropFrame(@NotNull String isolateId, int frameIndex) {
        if (isolateId == null) {
            VmServiceWrapper.$$$reportNull$$$0(43);
        }
        this.addRequest(() -> {
            this.myLatestStep = StepOption.Rewind;
            this.myVmService.resume(isolateId, StepOption.Rewind, frameIndex, new VmServiceConsumers.EmptyResumeConsumer(){

                @Override
                public void onError(RPCError error) {
                    VmServiceWrapper.this.myDebugProcess.getSession().getConsoleView().print("Error from drop frame: " + error.getMessage() + "\n", ConsoleViewContentType.ERROR_OUTPUT);
                }
            });
        });
    }

    public void pauseIsolate(@NotNull String isolateId) {
        if (isolateId == null) {
            VmServiceWrapper.$$$reportNull$$$0(44);
        }
        this.addRequest(() -> this.myVmService.pause(isolateId, new PauseConsumer(){

            @Override
            public void onError(RPCError error) {
            }

            @Override
            public void received(Sentinel response) {
            }

            @Override
            public void received(Success response) {
            }
        }));
    }

    public void computeStackFrames(final @NotNull String isolateId, final int firstFrameIndex, final @NotNull XExecutionStack.XStackFrameContainer container, final @Nullable InstanceRef exception) {
        if (isolateId == null) {
            VmServiceWrapper.$$$reportNull$$$0(45);
        }
        if (container == null) {
            VmServiceWrapper.$$$reportNull$$$0(46);
        }
        this.addRequest(() -> this.myVmService.getStack(isolateId, new GetStackConsumer(){

            @Override
            public void received(Stack vmStack) {
                ApplicationManager.getApplication().executeOnPooledThread(() -> {
                    InstanceRef exceptionToAddToFrame = exception;
                    ElementList<Frame> elementList = vmStack.getAsyncCausalFrames();
                    if (elementList == null) {
                        elementList = vmStack.getFrames();
                    }
                    ArrayList vmFrames = Lists.newArrayList(elementList);
                    ArrayList<XStackFrame> xStackFrames = new ArrayList<XStackFrame>(vmFrames.size());
                    for (Frame vmFrame : vmFrames) {
                        if (vmFrame.getKind() == FrameKind.AsyncSuspensionMarker) {
                            DartAsyncMarkerFrame markerFrame = new DartAsyncMarkerFrame();
                            xStackFrames.add(markerFrame);
                            continue;
                        }
                        DartVmServiceStackFrame stackFrame = new DartVmServiceStackFrame(VmServiceWrapper.this.myDebugProcess, isolateId, vmFrame, vmFrames, exceptionToAddToFrame);
                        stackFrame.setIsDroppableFrame(vmFrame.getKind() == FrameKind.Regular);
                        xStackFrames.add(stackFrame);
                        if (stackFrame.isInDartSdkPatchFile()) continue;
                        exceptionToAddToFrame = null;
                    }
                    container.addStackFrames(firstFrameIndex == 0 ? xStackFrames : xStackFrames.subList(firstFrameIndex, xStackFrames.size()), true);
                });
            }

            @Override
            public void onError(RPCError error) {
                container.errorOccurred(error.getMessage());
            }

            @Override
            public void received(Sentinel response) {
                container.errorOccurred(response.getValueAsString());
            }
        }));
    }

    @Nullable
    public Script getScriptSync(@NotNull String isolateId, @NotNull String scriptId) {
        if (isolateId == null) {
            VmServiceWrapper.$$$reportNull$$$0(47);
        }
        if (scriptId == null) {
            VmServiceWrapper.$$$reportNull$$$0(48);
        }
        this.assertSyncRequestAllowed();
        final Semaphore semaphore = new Semaphore();
        semaphore.down();
        final Ref resultRef = Ref.create();
        this.addRequest(() -> this.myVmService.getObject(isolateId, scriptId, new GetObjectConsumer(){

            @Override
            public void received(Obj script) {
                resultRef.set((Object)((Script)script));
                semaphore.up();
            }

            @Override
            public void received(Sentinel response) {
                semaphore.up();
            }

            @Override
            public void onError(RPCError error) {
                semaphore.up();
            }
        }));
        semaphore.waitFor(3000L);
        return (Script)resultRef.get();
    }

    public void getObject(@NotNull String isolateId, @NotNull String objectId, @NotNull GetObjectConsumer consumer) {
        if (isolateId == null) {
            VmServiceWrapper.$$$reportNull$$$0(49);
        }
        if (objectId == null) {
            VmServiceWrapper.$$$reportNull$$$0(50);
        }
        if (consumer == null) {
            VmServiceWrapper.$$$reportNull$$$0(51);
        }
        this.addRequest(() -> this.myVmService.getObject(isolateId, objectId, consumer));
    }

    public void getCollectionObject(@NotNull String isolateId, @NotNull String objectId, int offset, int count, @NotNull GetObjectConsumer consumer) {
        if (isolateId == null) {
            VmServiceWrapper.$$$reportNull$$$0(52);
        }
        if (objectId == null) {
            VmServiceWrapper.$$$reportNull$$$0(53);
        }
        if (consumer == null) {
            VmServiceWrapper.$$$reportNull$$$0(54);
        }
        this.addRequest(() -> this.myVmService.getObject(isolateId, objectId, offset, count, consumer));
    }

    public void evaluateInFrame(final @NotNull String isolateId, @NotNull Frame vmFrame, @NotNull String expression, final @NotNull XDebuggerEvaluator.XEvaluationCallback callback) {
        if (isolateId == null) {
            VmServiceWrapper.$$$reportNull$$$0(55);
        }
        if (vmFrame == null) {
            VmServiceWrapper.$$$reportNull$$$0(56);
        }
        if (expression == null) {
            VmServiceWrapper.$$$reportNull$$$0(57);
        }
        if (callback == null) {
            VmServiceWrapper.$$$reportNull$$$0(58);
        }
        this.addRequest(() -> this.myVmService.evaluateInFrame(isolateId, vmFrame.getIndex(), expression, new EvaluateInFrameConsumer(){

            @Override
            public void received(InstanceRef instanceRef) {
                callback.evaluated((XValue)new DartVmServiceValue(VmServiceWrapper.this.myDebugProcess, isolateId, "result", instanceRef, null, null, false));
            }

            @Override
            public void received(Sentinel sentinel) {
                callback.errorOccurred(sentinel.getValueAsString());
            }

            @Override
            public void received(ErrorRef errorRef) {
                callback.errorOccurred(DartVmServiceEvaluator.getPresentableError(errorRef.getMessage()));
            }

            @Override
            public void onError(RPCError error) {
                callback.errorOccurred(error.getMessage());
            }
        }));
    }

    public void evaluateInTargetContext(@NotNull String isolateId, @NotNull String targetId, @NotNull String expression, @NotNull EvaluateConsumer consumer) {
        if (isolateId == null) {
            VmServiceWrapper.$$$reportNull$$$0(59);
        }
        if (targetId == null) {
            VmServiceWrapper.$$$reportNull$$$0(60);
        }
        if (expression == null) {
            VmServiceWrapper.$$$reportNull$$$0(61);
        }
        if (consumer == null) {
            VmServiceWrapper.$$$reportNull$$$0(62);
        }
        this.addRequest(() -> this.myVmService.evaluate(isolateId, targetId, expression, consumer));
    }

    public void evaluateInTargetContext(final @NotNull String isolateId, @NotNull String targetId, @NotNull String expression, final @NotNull XDebuggerEvaluator.XEvaluationCallback callback) {
        if (isolateId == null) {
            VmServiceWrapper.$$$reportNull$$$0(63);
        }
        if (targetId == null) {
            VmServiceWrapper.$$$reportNull$$$0(64);
        }
        if (expression == null) {
            VmServiceWrapper.$$$reportNull$$$0(65);
        }
        if (callback == null) {
            VmServiceWrapper.$$$reportNull$$$0(66);
        }
        this.evaluateInTargetContext(isolateId, targetId, expression, new EvaluateConsumer(){

            @Override
            public void received(InstanceRef instanceRef) {
                callback.evaluated((XValue)new DartVmServiceValue(VmServiceWrapper.this.myDebugProcess, isolateId, "result", instanceRef, null, null, false));
            }

            @Override
            public void received(Sentinel sentinel) {
                callback.errorOccurred(sentinel.getValueAsString());
            }

            @Override
            public void received(ErrorRef errorRef) {
                callback.errorOccurred(DartVmServiceEvaluator.getPresentableError(errorRef.getMessage()));
            }

            @Override
            public void onError(RPCError error) {
                callback.errorOccurred(error.getMessage());
            }
        });
    }

    public void callToString(@NotNull String isolateId, @NotNull String targetId, @NotNull InvokeConsumer callback) {
        if (isolateId == null) {
            VmServiceWrapper.$$$reportNull$$$0(67);
        }
        if (targetId == null) {
            VmServiceWrapper.$$$reportNull$$$0(68);
        }
        if (callback == null) {
            VmServiceWrapper.$$$reportNull$$$0(69);
        }
        this.callMethodOnTarget(isolateId, targetId, "toString", callback);
    }

    public void callToList(@NotNull String isolateId, @NotNull String targetId, @NotNull InvokeConsumer callback) {
        if (isolateId == null) {
            VmServiceWrapper.$$$reportNull$$$0(70);
        }
        if (targetId == null) {
            VmServiceWrapper.$$$reportNull$$$0(71);
        }
        if (callback == null) {
            VmServiceWrapper.$$$reportNull$$$0(72);
        }
        this.callMethodOnTarget(isolateId, targetId, "toList", callback);
    }

    public void callMethodOnTarget(@NotNull String isolateId, @NotNull String targetId, @NotNull String methodName, @NotNull InvokeConsumer callback) {
        if (isolateId == null) {
            VmServiceWrapper.$$$reportNull$$$0(73);
        }
        if (targetId == null) {
            VmServiceWrapper.$$$reportNull$$$0(74);
        }
        if (methodName == null) {
            VmServiceWrapper.$$$reportNull$$$0(75);
        }
        if (callback == null) {
            VmServiceWrapper.$$$reportNull$$$0(76);
        }
        this.addRequest(() -> this.myVmService.invoke(isolateId, targetId, methodName, Collections.emptyList(), true, callback));
    }

    public CompletableFuture<String> findResolvedFile(@NotNull String isolateId, @NotNull String scriptUri) {
        if (isolateId == null) {
            VmServiceWrapper.$$$reportNull$$$0(77);
        }
        if (scriptUri == null) {
            VmServiceWrapper.$$$reportNull$$$0(78);
        }
        final CompletableFuture<String> uriFuture = new CompletableFuture<String>();
        this.myVmService.lookupResolvedPackageUris(isolateId, List.of(scriptUri), true, new UriListConsumer(){

            @Override
            public void received(UriList response) {
                if (response == null) {
                    LOG.info("lookupResolvedPackageUris returned null response");
                    uriFuture.complete(null);
                    return;
                }
                List<String> uris = response.getUris();
                if (uris == null) {
                    LOG.info("lookupResolvedPackageUris returned null uris");
                    uriFuture.complete(null);
                    return;
                }
                uriFuture.complete(uris.get(0));
            }

            @Override
            public void onError(RPCError error) {
                assert (error != null);
                LOG.info("lookupResolvedPackageUris error: " + error.getMessage());
                uriFuture.complete(null);
            }
        });
        return uriFuture;
    }

    private boolean supportsSetIsolatePauseMode() {
        Version version = this.myVmService.getRuntimeVersion();
        return version.getMajor() > 3 || version.getMajor() == 3 && version.getMinor() >= 53;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 7, 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugProcess";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vmService";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vmServiceListener";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "isolatesInfo";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "breakpointHandler";
                break;
            }
            case 5: 
            case 7: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "io/flutter/vmService/VmServiceWrapper";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "streamId";
                break;
            }
            case 9: 
            case 10: 
            case 14: 
            case 28: 
            case 30: 
            case 32: 
            case 51: 
            case 54: 
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 11: 
            case 13: 
            case 16: 
            case 26: 
            case 27: 
            case 29: 
            case 31: 
            case 36: 
            case 38: 
            case 39: 
            case 41: 
            case 43: 
            case 44: 
            case 45: 
            case 47: 
            case 49: 
            case 52: 
            case 55: 
            case 59: 
            case 63: 
            case 67: 
            case 70: 
            case 73: 
            case 77: {
                objectArray2 = objectArray3;
                objectArray3[0] = "isolateId";
                break;
            }
            case 15: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "isolateRef";
                break;
            }
            case 17: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mode";
                break;
            }
            case 20: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "isolate";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "xBreakpoints";
                break;
            }
            case 33: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "xBreakpoint";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "isolateInfos";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vmBreakpointId";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "container";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scriptId";
                break;
            }
            case 50: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "objectId";
                break;
            }
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vmFrame";
                break;
            }
            case 57: 
            case 61: 
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 58: 
            case 66: 
            case 69: 
            case 72: 
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 60: 
            case 64: 
            case 68: 
            case 71: 
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetId";
                break;
            }
            case 75: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodName";
                break;
            }
            case 78: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scriptUri";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "io/flutter/vmService/VmServiceWrapper";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getVmService";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getExistingIsolates";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getCachedIsolate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 7: 
            case 12: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addRequest";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "streamListen";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getVm";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getCachedIsolate";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getIsolate";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "handleIsolate";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "setIsolatePauseMode";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "attachIsolate";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "setInitialBreakpointsAndResume";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "setInitialBreakpointsAndCheckExtensions";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "doSetInitialBreakpointsAndResume";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "doSetBreakpointsForIsolate";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "addBreakpoint";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "addBreakpointWithMapper";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "addBreakpointWithVmService";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getResolvedUri";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "addBreakpointForIsolates";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "restoreBreakpointsForIsolate";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "addTemporaryBreakpoint";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "removeBreakpoint";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "resumeIsolate";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "setExceptionPauseMode";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "dropFrame";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "pauseIsolate";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "computeStackFrames";
                break;
            }
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "getScriptSync";
                break;
            }
            case 49: 
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "getObject";
                break;
            }
            case 52: 
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "getCollectionObject";
                break;
            }
            case 55: 
            case 56: 
            case 57: 
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "evaluateInFrame";
                break;
            }
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "evaluateInTargetContext";
                break;
            }
            case 67: 
            case 68: 
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "callToString";
                break;
            }
            case 70: 
            case 71: 
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "callToList";
                break;
            }
            case 73: 
            case 74: 
            case 75: 
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "callMethodOnTarget";
                break;
            }
            case 77: 
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "findResolvedFile";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 7, 12 -> new IllegalStateException(string);
        };
    }
}

