/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.vmService.frame;

import com.google.gson.JsonElement;
import com.intellij.icons.AllIcons;
import com.intellij.util.SmartList;
import com.intellij.xdebugger.frame.XCompositeNode;
import com.intellij.xdebugger.frame.XNamedValue;
import com.intellij.xdebugger.frame.XNavigatable;
import com.intellij.xdebugger.frame.XValueChildrenList;
import com.intellij.xdebugger.frame.XValueGroup;
import com.intellij.xdebugger.frame.XValueNode;
import com.intellij.xdebugger.frame.XValuePlace;
import io.flutter.vmService.DartVmServiceDebugProcess;
import io.flutter.vmService.frame.DartVmServiceValue;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.Icon;
import org.dartlang.vm.service.consumer.GetObjectConsumer;
import org.dartlang.vm.service.element.Field;
import org.dartlang.vm.service.element.FieldRef;
import org.dartlang.vm.service.element.InstanceRef;
import org.dartlang.vm.service.element.Obj;
import org.dartlang.vm.service.element.RPCError;
import org.dartlang.vm.service.element.Sentinel;
import org.jetbrains.annotations.NotNull;

class DartStaticFieldsGroup
extends XValueGroup {
    @NotNull
    private final DartVmServiceDebugProcess myDebugProcess;
    @NotNull
    private final String myIsolateId;
    @NotNull
    private final String myClassName;
    @NotNull
    private final SmartList<FieldRef> myFieldRefs;

    public DartStaticFieldsGroup(@NotNull DartVmServiceDebugProcess debugProcess, @NotNull String isolateId, @NotNull String className, @NotNull SmartList<FieldRef> fieldsRefs) {
        if (debugProcess == null) {
            DartStaticFieldsGroup.$$$reportNull$$$0(0);
        }
        if (isolateId == null) {
            DartStaticFieldsGroup.$$$reportNull$$$0(1);
        }
        if (className == null) {
            DartStaticFieldsGroup.$$$reportNull$$$0(2);
        }
        if (fieldsRefs == null) {
            DartStaticFieldsGroup.$$$reportNull$$$0(3);
        }
        super("static");
        this.myDebugProcess = debugProcess;
        this.myIsolateId = isolateId;
        this.myClassName = className;
        this.myFieldRefs = fieldsRefs;
    }

    @NotNull
    public String getSeparator() {
        return "";
    }

    public String getComment() {
        return " members of " + this.myClassName;
    }

    public Icon getIcon() {
        return AllIcons.Nodes.Static;
    }

    public void computeChildren(final @NotNull XCompositeNode node) {
        if (node == null) {
            DartStaticFieldsGroup.$$$reportNull$$$0(4);
        }
        final AtomicInteger counter = new AtomicInteger(this.myFieldRefs.size());
        final XValueChildrenList list = new XValueChildrenList(this.myFieldRefs.size());
        for (final FieldRef fieldRef : this.myFieldRefs) {
            this.myDebugProcess.getVmServiceWrapper().getObject(this.myIsolateId, fieldRef.getId(), new GetObjectConsumer(){

                @Override
                public void received(Obj field) {
                    final InstanceRef instanceRef = ((Field)field).getStaticValue();
                    if ("@Instance".equals(instanceRef.getType())) {
                        list.add((XNamedValue)new DartVmServiceValue(DartStaticFieldsGroup.this.myDebugProcess, DartStaticFieldsGroup.this.myIsolateId, ((Field)field).getName(), instanceRef, null, fieldRef, false));
                    } else if ("Sentinel".equals(instanceRef.getType())) {
                        list.add(new XNamedValue(((Field)field).getName()){

                            public void computeSourcePosition(@NotNull XNavigatable navigatable) {
                                if (navigatable == null) {
                                    1.$$$reportNull$$$0(0);
                                }
                                DartVmServiceValue.doComputeSourcePosition(DartStaticFieldsGroup.this.myDebugProcess, navigatable, DartStaticFieldsGroup.this.myIsolateId, fieldRef);
                            }

                            public void computePresentation(@NotNull XValueNode node, @NotNull XValuePlace place) {
                                JsonElement valueAsString;
                                if (node == null) {
                                    1.$$$reportNull$$$0(1);
                                }
                                if (place == null) {
                                    1.$$$reportNull$$$0(2);
                                }
                                String value = (valueAsString = instanceRef.getJson().get("valueAsString")) == null ? "not initialized" : valueAsString.getAsString();
                                node.setPresentation(AllIcons.Nodes.Field, null, value, false);
                            }

                            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                                Object[] objectArray;
                                Object[] objectArray2;
                                Object[] objectArray3 = new Object[3];
                                switch (n) {
                                    default: {
                                        objectArray2 = objectArray3;
                                        objectArray3[0] = "navigatable";
                                        break;
                                    }
                                    case 1: {
                                        objectArray2 = objectArray3;
                                        objectArray3[0] = "node";
                                        break;
                                    }
                                    case 2: {
                                        objectArray2 = objectArray3;
                                        objectArray3[0] = "place";
                                        break;
                                    }
                                }
                                objectArray2[1] = "io/flutter/vmService/frame/DartStaticFieldsGroup$1$1";
                                switch (n) {
                                    default: {
                                        objectArray = objectArray2;
                                        objectArray2[2] = "computeSourcePosition";
                                        break;
                                    }
                                    case 1: 
                                    case 2: {
                                        objectArray = objectArray2;
                                        objectArray2[2] = "computePresentation";
                                        break;
                                    }
                                }
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                            }
                        });
                    }
                    if (counter.decrementAndGet() == 0) {
                        if (list.size() == 0) {
                            node.setErrorMessage("Static fields not initialized yet");
                        } else {
                            node.addChildren(list, true);
                        }
                    }
                }

                @Override
                public void received(Sentinel sentinel) {
                    node.setErrorMessage(sentinel.getValueAsString());
                }

                @Override
                public void onError(RPCError error) {
                    node.setErrorMessage(error.getMessage());
                }
            });
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugProcess";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "isolateId";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "className";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldsRefs";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        objectArray2[1] = "io/flutter/vmService/frame/DartStaticFieldsGroup";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "computeChildren";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

