/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.vmService.frame;

import com.intellij.icons.AllIcons;
import com.intellij.xdebugger.frame.XExecutionStack;
import com.intellij.xdebugger.frame.XStackFrame;
import io.flutter.vmService.DartVmServiceDebugProcess;
import io.flutter.vmService.frame.DartVmServiceStackFrame;
import java.util.Collections;
import org.dartlang.vm.service.element.Frame;
import org.dartlang.vm.service.element.InstanceRef;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DartVmServiceExecutionStack
extends XExecutionStack {
    private final DartVmServiceDebugProcess myDebugProcess;
    private final String myIsolateId;
    @Nullable
    private final XStackFrame myTopFrame;
    @Nullable
    private final InstanceRef myException;

    public DartVmServiceExecutionStack(@NotNull DartVmServiceDebugProcess debugProcess, @NotNull String isolateId, @NotNull String isolateName, @Nullable Frame topFrame, @Nullable InstanceRef exception) {
        if (debugProcess == null) {
            DartVmServiceExecutionStack.$$$reportNull$$$0(0);
        }
        if (isolateId == null) {
            DartVmServiceExecutionStack.$$$reportNull$$$0(1);
        }
        if (isolateName == null) {
            DartVmServiceExecutionStack.$$$reportNull$$$0(2);
        }
        super((String)(debugProcess.isIsolateSuspended(isolateId) ? DartVmServiceExecutionStack.beautify(isolateName) : DartVmServiceExecutionStack.beautify(isolateName) + " (running)"), topFrame != null ? AllIcons.Debugger.ThreadCurrent : (debugProcess.isIsolateSuspended(isolateId) ? AllIcons.Debugger.ThreadAtBreakpoint : AllIcons.Debugger.ThreadRunning));
        this.myDebugProcess = debugProcess;
        this.myIsolateId = isolateId;
        this.myException = exception;
        this.myTopFrame = topFrame == null ? null : new DartVmServiceStackFrame(debugProcess, isolateId, topFrame, null, exception);
    }

    @NotNull
    private static String beautify(@NotNull String isolateName) {
        int index;
        if (isolateName == null) {
            DartVmServiceExecutionStack.$$$reportNull$$$0(3);
        }
        String string = (index = isolateName.indexOf(".dart%22%20as%20test;")) > 0 ? isolateName.substring(0, index + ".dart".length()) : isolateName;
        if (string == null) {
            DartVmServiceExecutionStack.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Nullable
    public XStackFrame getTopFrame() {
        return this.myTopFrame;
    }

    public void computeStackFrames(int firstFrameIndex, @NotNull XExecutionStack.XStackFrameContainer container) {
        if (container == null) {
            DartVmServiceExecutionStack.$$$reportNull$$$0(5);
        }
        if (this.myDebugProcess.isIsolateSuspended(this.myIsolateId)) {
            this.myDebugProcess.getVmServiceWrapper().computeStackFrames(this.myIsolateId, firstFrameIndex, container, this.myException);
        } else {
            container.addStackFrames(Collections.emptyList(), true);
        }
    }

    public String getIsolateId() {
        return this.myIsolateId;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugProcess";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "isolateId";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "isolateName";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "io/flutter/vmService/frame/DartVmServiceExecutionStack";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "container";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "io/flutter/vmService/frame/DartVmServiceExecutionStack";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "beautify";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "beautify";
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "computeStackFrames";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4 -> new IllegalStateException(string);
        };
    }
}

