/*
 * Decompiled with CFR 0.152.
 */
package org.dartlang.analysis.server.protocol;

import com.google.common.collect.Lists;
import com.google.dart.server.utilities.general.ObjectUtilities;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.dartlang.analysis.server.protocol.Element;
import org.dartlang.analysis.server.protocol.FlutterOutlineAttribute;

public class FlutterOutline {
    public static final FlutterOutline[] EMPTY_ARRAY = new FlutterOutline[0];
    public static final List<FlutterOutline> EMPTY_LIST = Lists.newArrayList();
    private final String kind;
    private final int offset;
    private final int length;
    private final int codeOffset;
    private final int codeLength;
    private final String label;
    private final Element dartElement;
    private final List<FlutterOutlineAttribute> attributes;
    private final String className;
    private final String parentAssociationLabel;
    private final String variableName;
    private final List<FlutterOutline> children;

    public FlutterOutline(String kind, int offset, int length, int codeOffset, int codeLength, String label, Element dartElement, List<FlutterOutlineAttribute> attributes, String className, String parentAssociationLabel, String variableName, List<FlutterOutline> children) {
        this.kind = kind;
        this.offset = offset;
        this.length = length;
        this.codeOffset = codeOffset;
        this.codeLength = codeLength;
        this.label = label;
        this.dartElement = dartElement;
        this.attributes = attributes;
        this.className = className;
        this.parentAssociationLabel = parentAssociationLabel;
        this.variableName = variableName;
        this.children = children;
    }

    public boolean equals(Object obj) {
        if (obj instanceof FlutterOutline) {
            FlutterOutline other = (FlutterOutline)obj;
            return ObjectUtilities.equals((Object)other.kind, (Object)this.kind) && other.offset == this.offset && other.length == this.length && other.codeOffset == this.codeOffset && other.codeLength == this.codeLength && ObjectUtilities.equals((Object)other.label, (Object)this.label) && ObjectUtilities.equals((Object)other.dartElement, (Object)this.dartElement) && ObjectUtilities.equals(other.attributes, this.attributes) && ObjectUtilities.equals((Object)other.className, (Object)this.className) && ObjectUtilities.equals((Object)other.parentAssociationLabel, (Object)this.parentAssociationLabel) && ObjectUtilities.equals((Object)other.variableName, (Object)this.variableName) && ObjectUtilities.equals(other.children, this.children);
        }
        return false;
    }

    public static FlutterOutline fromJson(JsonObject jsonObject) {
        String kind = jsonObject.get("kind").getAsString();
        int offset = jsonObject.get("offset").getAsInt();
        int length = jsonObject.get("length").getAsInt();
        int codeOffset = jsonObject.get("codeOffset").getAsInt();
        int codeLength = jsonObject.get("codeLength").getAsInt();
        String label = jsonObject.get("label") == null ? null : jsonObject.get("label").getAsString();
        Element dartElement = jsonObject.get("dartElement") == null ? null : Element.fromJson((JsonObject)jsonObject.get("dartElement").getAsJsonObject());
        List<FlutterOutlineAttribute> attributes = jsonObject.get("attributes") == null ? null : FlutterOutlineAttribute.fromJsonArray(jsonObject.get("attributes").getAsJsonArray());
        String className = jsonObject.get("className") == null ? null : jsonObject.get("className").getAsString();
        String parentAssociationLabel = jsonObject.get("parentAssociationLabel") == null ? null : jsonObject.get("parentAssociationLabel").getAsString();
        String variableName = jsonObject.get("variableName") == null ? null : jsonObject.get("variableName").getAsString();
        List<FlutterOutline> children = jsonObject.get("children") == null ? null : FlutterOutline.fromJsonArray(jsonObject.get("children").getAsJsonArray());
        return new FlutterOutline(kind, offset, length, codeOffset, codeLength, label, dartElement, attributes, className, parentAssociationLabel, variableName, children);
    }

    public static List<FlutterOutline> fromJsonArray(JsonArray jsonArray) {
        if (jsonArray == null) {
            return EMPTY_LIST;
        }
        ArrayList<FlutterOutline> list = new ArrayList<FlutterOutline>(jsonArray.size());
        Iterator iterator = jsonArray.iterator();
        while (iterator.hasNext()) {
            list.add(FlutterOutline.fromJson(((JsonElement)iterator.next()).getAsJsonObject()));
        }
        return list;
    }

    public List<FlutterOutlineAttribute> getAttributes() {
        return this.attributes;
    }

    public List<FlutterOutline> getChildren() {
        return this.children;
    }

    public String getClassName() {
        return this.className;
    }

    public int getCodeLength() {
        return this.codeLength;
    }

    public int getCodeOffset() {
        return this.codeOffset;
    }

    public Element getDartElement() {
        return this.dartElement;
    }

    public String getKind() {
        return this.kind;
    }

    public String getLabel() {
        return this.label;
    }

    public int getLength() {
        return this.length;
    }

    public int getOffset() {
        return this.offset;
    }

    public String getParentAssociationLabel() {
        return this.parentAssociationLabel;
    }

    public String getVariableName() {
        return this.variableName;
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        builder.append((Object)this.kind);
        builder.append(this.offset);
        builder.append(this.length);
        builder.append(this.codeOffset);
        builder.append(this.codeLength);
        builder.append((Object)this.label);
        builder.append((Object)this.dartElement);
        builder.append(this.attributes);
        builder.append((Object)this.className);
        builder.append((Object)this.parentAssociationLabel);
        builder.append((Object)this.variableName);
        builder.append(this.children);
        return builder.toHashCode();
    }

    public JsonObject toJson() {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("kind", this.kind);
        jsonObject.addProperty("offset", (Number)this.offset);
        jsonObject.addProperty("length", (Number)this.length);
        jsonObject.addProperty("codeOffset", (Number)this.codeOffset);
        jsonObject.addProperty("codeLength", (Number)this.codeLength);
        if (this.label != null) {
            jsonObject.addProperty("label", this.label);
        }
        if (this.dartElement != null) {
            jsonObject.add("dartElement", (JsonElement)this.dartElement.toJson());
        }
        if (this.attributes != null) {
            JsonArray jsonArrayAttributes = new JsonArray();
            for (FlutterOutlineAttribute flutterOutlineAttribute : this.attributes) {
                jsonArrayAttributes.add((JsonElement)flutterOutlineAttribute.toJson());
            }
            jsonObject.add("attributes", (JsonElement)jsonArrayAttributes);
        }
        if (this.className != null) {
            jsonObject.addProperty("className", this.className);
        }
        if (this.parentAssociationLabel != null) {
            jsonObject.addProperty("parentAssociationLabel", this.parentAssociationLabel);
        }
        if (this.variableName != null) {
            jsonObject.addProperty("variableName", this.variableName);
        }
        if (this.children != null) {
            JsonArray jsonArrayChildren = new JsonArray();
            for (FlutterOutline flutterOutline : this.children) {
                jsonArrayChildren.add((JsonElement)flutterOutline.toJson());
            }
            jsonObject.add("children", (JsonElement)jsonArrayChildren);
        }
        return jsonObject;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        builder.append("kind=");
        builder.append(this.kind).append(", ");
        builder.append("offset=");
        builder.append(this.offset).append(", ");
        builder.append("length=");
        builder.append(this.length).append(", ");
        builder.append("codeOffset=");
        builder.append(this.codeOffset).append(", ");
        builder.append("codeLength=");
        builder.append(this.codeLength).append(", ");
        builder.append("label=");
        builder.append(this.label).append(", ");
        builder.append("dartElement=");
        builder.append(this.dartElement).append(", ");
        if (this.attributes != null) {
            builder.append("attributes=");
            builder.append(StringUtils.join(this.attributes, (String)", ")).append(", ");
        }
        builder.append("className=");
        builder.append(this.className).append(", ");
        builder.append("parentAssociationLabel=");
        builder.append(this.parentAssociationLabel).append(", ");
        builder.append("variableName=");
        builder.append(this.variableName).append(", ");
        if (this.children != null) {
            builder.append("children=");
            builder.append(StringUtils.join(this.children, (String)", "));
        }
        builder.append("]");
        return builder.toString();
    }
}

