/*
 * Decompiled with CFR 0.152.
 */
package org.dartlang.analysis.server.protocol;

import com.google.common.collect.Lists;
import com.google.dart.server.utilities.general.ObjectUtilities;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.dartlang.analysis.server.protocol.Location;

public class FlutterOutlineAttribute {
    public static final FlutterOutlineAttribute[] EMPTY_ARRAY = new FlutterOutlineAttribute[0];
    public static final List<FlutterOutlineAttribute> EMPTY_LIST = Lists.newArrayList();
    private final String name;
    private final String label;
    private final Boolean literalValueBoolean;
    private final Integer literalValueInteger;
    private final String literalValueString;
    private final Location nameLocation;
    private final Location valueLocation;

    public FlutterOutlineAttribute(String name, String label, Boolean literalValueBoolean, Integer literalValueInteger, String literalValueString, Location nameLocation, Location valueLocation) {
        this.name = name;
        this.label = label;
        this.literalValueBoolean = literalValueBoolean;
        this.literalValueInteger = literalValueInteger;
        this.literalValueString = literalValueString;
        this.nameLocation = nameLocation;
        this.valueLocation = valueLocation;
    }

    public boolean equals(Object obj) {
        if (obj instanceof FlutterOutlineAttribute) {
            FlutterOutlineAttribute other = (FlutterOutlineAttribute)obj;
            return ObjectUtilities.equals((Object)other.name, (Object)this.name) && ObjectUtilities.equals((Object)other.label, (Object)this.label) && ObjectUtilities.equals((Object)other.literalValueBoolean, (Object)this.literalValueBoolean) && ObjectUtilities.equals((Object)other.literalValueInteger, (Object)this.literalValueInteger) && ObjectUtilities.equals((Object)other.literalValueString, (Object)this.literalValueString) && ObjectUtilities.equals((Object)other.nameLocation, (Object)this.nameLocation) && ObjectUtilities.equals((Object)other.valueLocation, (Object)this.valueLocation);
        }
        return false;
    }

    public static FlutterOutlineAttribute fromJson(JsonObject jsonObject) {
        String name = jsonObject.get("name").getAsString();
        String label = jsonObject.get("label").getAsString();
        Boolean literalValueBoolean = jsonObject.get("literalValueBoolean") == null ? null : Boolean.valueOf(jsonObject.get("literalValueBoolean").getAsBoolean());
        Integer literalValueInteger = jsonObject.get("literalValueInteger") == null ? null : Integer.valueOf(jsonObject.get("literalValueInteger").getAsInt());
        String literalValueString = jsonObject.get("literalValueString") == null ? null : jsonObject.get("literalValueString").getAsString();
        Location nameLocation = jsonObject.get("nameLocation") == null ? null : Location.fromJson((JsonObject)jsonObject.get("nameLocation").getAsJsonObject());
        Location valueLocation = jsonObject.get("valueLocation") == null ? null : Location.fromJson((JsonObject)jsonObject.get("valueLocation").getAsJsonObject());
        return new FlutterOutlineAttribute(name, label, literalValueBoolean, literalValueInteger, literalValueString, nameLocation, valueLocation);
    }

    public static List<FlutterOutlineAttribute> fromJsonArray(JsonArray jsonArray) {
        if (jsonArray == null) {
            return EMPTY_LIST;
        }
        ArrayList<FlutterOutlineAttribute> list = new ArrayList<FlutterOutlineAttribute>(jsonArray.size());
        Iterator iterator = jsonArray.iterator();
        while (iterator.hasNext()) {
            list.add(FlutterOutlineAttribute.fromJson(((JsonElement)iterator.next()).getAsJsonObject()));
        }
        return list;
    }

    public String getLabel() {
        return this.label;
    }

    public Boolean getLiteralValueBoolean() {
        return this.literalValueBoolean;
    }

    public Integer getLiteralValueInteger() {
        return this.literalValueInteger;
    }

    public String getLiteralValueString() {
        return this.literalValueString;
    }

    public String getName() {
        return this.name;
    }

    public Location getNameLocation() {
        return this.nameLocation;
    }

    public Location getValueLocation() {
        return this.valueLocation;
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        builder.append((Object)this.name);
        builder.append((Object)this.label);
        builder.append((Object)this.literalValueBoolean);
        builder.append((Object)this.literalValueInteger);
        builder.append((Object)this.literalValueString);
        builder.append((Object)this.nameLocation);
        builder.append((Object)this.valueLocation);
        return builder.toHashCode();
    }

    public JsonObject toJson() {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("name", this.name);
        jsonObject.addProperty("label", this.label);
        if (this.literalValueBoolean != null) {
            jsonObject.addProperty("literalValueBoolean", this.literalValueBoolean);
        }
        if (this.literalValueInteger != null) {
            jsonObject.addProperty("literalValueInteger", (Number)this.literalValueInteger);
        }
        if (this.literalValueString != null) {
            jsonObject.addProperty("literalValueString", this.literalValueString);
        }
        if (this.nameLocation != null) {
            jsonObject.add("nameLocation", (JsonElement)this.nameLocation.toJson());
        }
        if (this.valueLocation != null) {
            jsonObject.add("valueLocation", (JsonElement)this.valueLocation.toJson());
        }
        return jsonObject;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        builder.append("name=");
        builder.append(this.name).append(", ");
        builder.append("label=");
        builder.append(this.label).append(", ");
        builder.append("literalValueBoolean=");
        builder.append(this.literalValueBoolean).append(", ");
        builder.append("literalValueInteger=");
        builder.append(this.literalValueInteger).append(", ");
        builder.append("literalValueString=");
        builder.append(this.literalValueString).append(", ");
        builder.append("nameLocation=");
        builder.append(this.nameLocation).append(", ");
        builder.append("valueLocation=");
        builder.append(this.valueLocation);
        builder.append("]");
        return builder.toString();
    }
}

