/*
 * Decompiled with CFR 0.152.
 */
package org.dartlang.analysis.server.protocol;

import com.google.common.collect.Lists;
import com.google.dart.server.utilities.general.ObjectUtilities;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.dartlang.analysis.server.protocol.FlutterWidgetPropertyEditor;
import org.dartlang.analysis.server.protocol.FlutterWidgetPropertyValue;

public class FlutterWidgetProperty {
    public static final FlutterWidgetProperty[] EMPTY_ARRAY = new FlutterWidgetProperty[0];
    public static final List<FlutterWidgetProperty> EMPTY_LIST = Lists.newArrayList();
    private final String documentation;
    private final String expression;
    private final int id;
    private final boolean isRequired;
    private final boolean isSafeToUpdate;
    private final String name;
    private final List<FlutterWidgetProperty> children;
    private final FlutterWidgetPropertyEditor editor;
    private final FlutterWidgetPropertyValue value;

    public FlutterWidgetProperty(String documentation, String expression, int id, boolean isRequired, boolean isSafeToUpdate, String name, List<FlutterWidgetProperty> children, FlutterWidgetPropertyEditor editor, FlutterWidgetPropertyValue value) {
        this.documentation = documentation;
        this.expression = expression;
        this.id = id;
        this.isRequired = isRequired;
        this.isSafeToUpdate = isSafeToUpdate;
        this.name = name;
        this.children = children;
        this.editor = editor;
        this.value = value;
    }

    public boolean equals(Object obj) {
        if (obj instanceof FlutterWidgetProperty) {
            FlutterWidgetProperty other = (FlutterWidgetProperty)obj;
            return ObjectUtilities.equals((Object)other.documentation, (Object)this.documentation) && ObjectUtilities.equals((Object)other.expression, (Object)this.expression) && other.id == this.id && other.isRequired == this.isRequired && other.isSafeToUpdate == this.isSafeToUpdate && ObjectUtilities.equals((Object)other.name, (Object)this.name) && ObjectUtilities.equals(other.children, this.children) && ObjectUtilities.equals((Object)other.editor, (Object)this.editor) && ObjectUtilities.equals((Object)other.value, (Object)this.value);
        }
        return false;
    }

    public static FlutterWidgetProperty fromJson(JsonObject jsonObject) {
        String documentation = jsonObject.get("documentation") == null ? null : jsonObject.get("documentation").getAsString();
        String expression = jsonObject.get("expression") == null ? null : jsonObject.get("expression").getAsString();
        int id = jsonObject.get("id").getAsInt();
        boolean isRequired = jsonObject.get("isRequired").getAsBoolean();
        boolean isSafeToUpdate = jsonObject.get("isSafeToUpdate").getAsBoolean();
        String name = jsonObject.get("name").getAsString();
        List<FlutterWidgetProperty> children = jsonObject.get("children") == null ? null : FlutterWidgetProperty.fromJsonArray(jsonObject.get("children").getAsJsonArray());
        FlutterWidgetPropertyEditor editor = jsonObject.get("editor") == null ? null : FlutterWidgetPropertyEditor.fromJson(jsonObject.get("editor").getAsJsonObject());
        FlutterWidgetPropertyValue value = jsonObject.get("value") == null ? null : FlutterWidgetPropertyValue.fromJson(jsonObject.get("value").getAsJsonObject());
        return new FlutterWidgetProperty(documentation, expression, id, isRequired, isSafeToUpdate, name, children, editor, value);
    }

    public static List<FlutterWidgetProperty> fromJsonArray(JsonArray jsonArray) {
        if (jsonArray == null) {
            return EMPTY_LIST;
        }
        ArrayList<FlutterWidgetProperty> list = new ArrayList<FlutterWidgetProperty>(jsonArray.size());
        Iterator iterator = jsonArray.iterator();
        while (iterator.hasNext()) {
            list.add(FlutterWidgetProperty.fromJson(((JsonElement)iterator.next()).getAsJsonObject()));
        }
        return list;
    }

    public List<FlutterWidgetProperty> getChildren() {
        return this.children;
    }

    public String getDocumentation() {
        return this.documentation;
    }

    public FlutterWidgetPropertyEditor getEditor() {
        return this.editor;
    }

    public String getExpression() {
        return this.expression;
    }

    public int getId() {
        return this.id;
    }

    public boolean isRequired() {
        return this.isRequired;
    }

    public boolean isSafeToUpdate() {
        return this.isSafeToUpdate;
    }

    public String getName() {
        return this.name;
    }

    public FlutterWidgetPropertyValue getValue() {
        return this.value;
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        builder.append((Object)this.documentation);
        builder.append((Object)this.expression);
        builder.append(this.id);
        builder.append(this.isRequired);
        builder.append(this.isSafeToUpdate);
        builder.append((Object)this.name);
        builder.append(this.children);
        builder.append((Object)this.editor);
        builder.append((Object)this.value);
        return builder.toHashCode();
    }

    public JsonObject toJson() {
        JsonObject jsonObject = new JsonObject();
        if (this.documentation != null) {
            jsonObject.addProperty("documentation", this.documentation);
        }
        if (this.expression != null) {
            jsonObject.addProperty("expression", this.expression);
        }
        jsonObject.addProperty("id", (Number)this.id);
        jsonObject.addProperty("isRequired", Boolean.valueOf(this.isRequired));
        jsonObject.addProperty("isSafeToUpdate", Boolean.valueOf(this.isSafeToUpdate));
        jsonObject.addProperty("name", this.name);
        if (this.children != null) {
            JsonArray jsonArrayChildren = new JsonArray();
            for (FlutterWidgetProperty elt : this.children) {
                jsonArrayChildren.add((JsonElement)elt.toJson());
            }
            jsonObject.add("children", (JsonElement)jsonArrayChildren);
        }
        if (this.editor != null) {
            jsonObject.add("editor", (JsonElement)this.editor.toJson());
        }
        if (this.value != null) {
            jsonObject.add("value", (JsonElement)this.value.toJson());
        }
        return jsonObject;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        builder.append("documentation=");
        builder.append(this.documentation).append(", ");
        builder.append("expression=");
        builder.append(this.expression).append(", ");
        builder.append("id=");
        builder.append(this.id).append(", ");
        builder.append("isRequired=");
        builder.append(this.isRequired).append(", ");
        builder.append("isSafeToUpdate=");
        builder.append(this.isSafeToUpdate).append(", ");
        builder.append("name=");
        builder.append(this.name).append(", ");
        builder.append("children=");
        builder.append(StringUtils.join(this.children, (String)", ")).append(", ");
        builder.append("editor=");
        builder.append(this.editor).append(", ");
        builder.append("value=");
        builder.append(this.value);
        builder.append("]");
        return builder.toString();
    }
}

