/*
 * Decompiled with CFR 0.152.
 */
package org.dartlang.analysis.server.protocol;

import com.google.common.collect.Lists;
import com.google.dart.server.utilities.general.ObjectUtilities;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.dartlang.analysis.server.protocol.FlutterWidgetPropertyValueEnumItem;

public class FlutterWidgetPropertyEditor {
    public static final FlutterWidgetPropertyEditor[] EMPTY_ARRAY = new FlutterWidgetPropertyEditor[0];
    public static final List<FlutterWidgetPropertyEditor> EMPTY_LIST = Lists.newArrayList();
    private final String kind;
    private final List<FlutterWidgetPropertyValueEnumItem> enumItems;

    public FlutterWidgetPropertyEditor(String kind, List<FlutterWidgetPropertyValueEnumItem> enumItems) {
        this.kind = kind;
        this.enumItems = enumItems;
    }

    public boolean equals(Object obj) {
        if (obj instanceof FlutterWidgetPropertyEditor) {
            FlutterWidgetPropertyEditor other = (FlutterWidgetPropertyEditor)obj;
            return ObjectUtilities.equals((Object)other.kind, (Object)this.kind) && ObjectUtilities.equals(other.enumItems, this.enumItems);
        }
        return false;
    }

    public static FlutterWidgetPropertyEditor fromJson(JsonObject jsonObject) {
        String kind = jsonObject.get("kind").getAsString();
        List<FlutterWidgetPropertyValueEnumItem> enumItems = jsonObject.get("enumItems") == null ? null : FlutterWidgetPropertyValueEnumItem.fromJsonArray(jsonObject.get("enumItems").getAsJsonArray());
        return new FlutterWidgetPropertyEditor(kind, enumItems);
    }

    public static List<FlutterWidgetPropertyEditor> fromJsonArray(JsonArray jsonArray) {
        if (jsonArray == null) {
            return EMPTY_LIST;
        }
        ArrayList<FlutterWidgetPropertyEditor> list = new ArrayList<FlutterWidgetPropertyEditor>(jsonArray.size());
        Iterator iterator = jsonArray.iterator();
        while (iterator.hasNext()) {
            list.add(FlutterWidgetPropertyEditor.fromJson(((JsonElement)iterator.next()).getAsJsonObject()));
        }
        return list;
    }

    public List<FlutterWidgetPropertyValueEnumItem> getEnumItems() {
        return this.enumItems;
    }

    public String getKind() {
        return this.kind;
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        builder.append((Object)this.kind);
        builder.append(this.enumItems);
        return builder.toHashCode();
    }

    public JsonObject toJson() {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("kind", this.kind);
        if (this.enumItems != null) {
            JsonArray jsonArrayEnumItems = new JsonArray();
            for (FlutterWidgetPropertyValueEnumItem elt : this.enumItems) {
                jsonArrayEnumItems.add((JsonElement)elt.toJson());
            }
            jsonObject.add("enumItems", (JsonElement)jsonArrayEnumItems);
        }
        return jsonObject;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        builder.append("kind=");
        builder.append(this.kind).append(", ");
        builder.append("enumItems=");
        builder.append(StringUtils.join(this.enumItems, (String)", "));
        builder.append("]");
        return builder.toString();
    }
}

