/*
 * Decompiled with CFR 0.152.
 */
package org.dartlang.analysis.server.protocol;

import com.google.common.collect.Lists;
import com.google.dart.server.utilities.general.ObjectUtilities;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.dartlang.analysis.server.protocol.FlutterWidgetPropertyValueEnumItem;

public class FlutterWidgetPropertyValue {
    public static final FlutterWidgetPropertyValue[] EMPTY_ARRAY = new FlutterWidgetPropertyValue[0];
    public static final List<FlutterWidgetPropertyValue> EMPTY_LIST = Lists.newArrayList();
    private final Boolean boolValue;
    private final Double doubleValue;
    private final Integer intValue;
    private final String stringValue;
    private final FlutterWidgetPropertyValueEnumItem enumValue;
    private final String expression;

    public FlutterWidgetPropertyValue(Boolean boolValue, Double doubleValue, Integer intValue, String stringValue, FlutterWidgetPropertyValueEnumItem enumValue, String expression) {
        this.boolValue = boolValue;
        this.doubleValue = doubleValue;
        this.intValue = intValue;
        this.stringValue = stringValue;
        this.enumValue = enumValue;
        this.expression = expression;
    }

    public boolean equals(Object obj) {
        if (obj instanceof FlutterWidgetPropertyValue) {
            FlutterWidgetPropertyValue other = (FlutterWidgetPropertyValue)obj;
            return ObjectUtilities.equals((Object)other.boolValue, (Object)this.boolValue) && ObjectUtilities.equals((Object)other.doubleValue, (Object)this.doubleValue) && ObjectUtilities.equals((Object)other.intValue, (Object)this.intValue) && ObjectUtilities.equals((Object)other.stringValue, (Object)this.stringValue) && ObjectUtilities.equals((Object)other.enumValue, (Object)this.enumValue) && ObjectUtilities.equals((Object)other.expression, (Object)this.expression);
        }
        return false;
    }

    public static FlutterWidgetPropertyValue fromJson(JsonObject jsonObject) {
        Boolean boolValue = jsonObject.get("boolValue") == null ? null : Boolean.valueOf(jsonObject.get("boolValue").getAsBoolean());
        Double doubleValue = jsonObject.get("doubleValue") == null ? null : Double.valueOf(jsonObject.get("doubleValue").getAsDouble());
        Integer intValue = jsonObject.get("intValue") == null ? null : Integer.valueOf(jsonObject.get("intValue").getAsInt());
        String stringValue = jsonObject.get("stringValue") == null ? null : jsonObject.get("stringValue").getAsString();
        FlutterWidgetPropertyValueEnumItem enumValue = jsonObject.get("enumValue") == null ? null : FlutterWidgetPropertyValueEnumItem.fromJson(jsonObject.get("enumValue").getAsJsonObject());
        String expression = jsonObject.get("expression") == null ? null : jsonObject.get("expression").getAsString();
        return new FlutterWidgetPropertyValue(boolValue, doubleValue, intValue, stringValue, enumValue, expression);
    }

    public static List<FlutterWidgetPropertyValue> fromJsonArray(JsonArray jsonArray) {
        if (jsonArray == null) {
            return EMPTY_LIST;
        }
        ArrayList<FlutterWidgetPropertyValue> list = new ArrayList<FlutterWidgetPropertyValue>(jsonArray.size());
        Iterator iterator = jsonArray.iterator();
        while (iterator.hasNext()) {
            list.add(FlutterWidgetPropertyValue.fromJson(((JsonElement)iterator.next()).getAsJsonObject()));
        }
        return list;
    }

    public Boolean getBoolValue() {
        return this.boolValue;
    }

    public Double getDoubleValue() {
        return this.doubleValue;
    }

    public FlutterWidgetPropertyValueEnumItem getEnumValue() {
        return this.enumValue;
    }

    public String getExpression() {
        return this.expression;
    }

    public Integer getIntValue() {
        return this.intValue;
    }

    public String getStringValue() {
        return this.stringValue;
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        builder.append((Object)this.boolValue);
        builder.append((Object)this.doubleValue);
        builder.append((Object)this.intValue);
        builder.append((Object)this.stringValue);
        builder.append((Object)this.enumValue);
        builder.append((Object)this.expression);
        return builder.toHashCode();
    }

    public JsonObject toJson() {
        JsonObject jsonObject = new JsonObject();
        if (this.boolValue != null) {
            jsonObject.addProperty("boolValue", this.boolValue);
        }
        if (this.doubleValue != null) {
            jsonObject.addProperty("doubleValue", (Number)this.doubleValue);
        }
        if (this.intValue != null) {
            jsonObject.addProperty("intValue", (Number)this.intValue);
        }
        if (this.stringValue != null) {
            jsonObject.addProperty("stringValue", this.stringValue);
        }
        if (this.enumValue != null) {
            jsonObject.add("enumValue", (JsonElement)this.enumValue.toJson());
        }
        if (this.expression != null) {
            jsonObject.addProperty("expression", this.expression);
        }
        return jsonObject;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        builder.append("boolValue=");
        builder.append(this.boolValue).append(", ");
        builder.append("doubleValue=");
        builder.append(this.doubleValue).append(", ");
        builder.append("intValue=");
        builder.append(this.intValue).append(", ");
        builder.append("stringValue=");
        builder.append(this.stringValue).append(", ");
        builder.append("enumValue=");
        builder.append(this.enumValue).append(", ");
        builder.append("expression=");
        builder.append(this.expression);
        builder.append("]");
        return builder.toString();
    }
}

