/*
 * Decompiled with CFR 0.152.
 */
package org.dartlang.analysis.server.protocol;

import com.google.common.collect.Lists;
import com.google.dart.server.utilities.general.ObjectUtilities;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class FlutterWidgetPropertyValueEnumItem {
    public static final FlutterWidgetPropertyValueEnumItem[] EMPTY_ARRAY = new FlutterWidgetPropertyValueEnumItem[0];
    public static final List<FlutterWidgetPropertyValueEnumItem> EMPTY_LIST = Lists.newArrayList();
    private final String libraryUri;
    private final String className;
    private final String name;
    private final String documentation;

    public FlutterWidgetPropertyValueEnumItem(String libraryUri, String className, String name, String documentation) {
        this.libraryUri = libraryUri;
        this.className = className;
        this.name = name;
        this.documentation = documentation;
    }

    public boolean equals(Object obj) {
        if (obj instanceof FlutterWidgetPropertyValueEnumItem) {
            FlutterWidgetPropertyValueEnumItem other = (FlutterWidgetPropertyValueEnumItem)obj;
            return ObjectUtilities.equals((Object)other.libraryUri, (Object)this.libraryUri) && ObjectUtilities.equals((Object)other.className, (Object)this.className) && ObjectUtilities.equals((Object)other.name, (Object)this.name) && ObjectUtilities.equals((Object)other.documentation, (Object)this.documentation);
        }
        return false;
    }

    public static FlutterWidgetPropertyValueEnumItem fromJson(JsonObject jsonObject) {
        String libraryUri = jsonObject.get("libraryUri").getAsString();
        String className = jsonObject.get("className").getAsString();
        String name = jsonObject.get("name").getAsString();
        String documentation = jsonObject.get("documentation") == null ? null : jsonObject.get("documentation").getAsString();
        return new FlutterWidgetPropertyValueEnumItem(libraryUri, className, name, documentation);
    }

    public static List<FlutterWidgetPropertyValueEnumItem> fromJsonArray(JsonArray jsonArray) {
        if (jsonArray == null) {
            return EMPTY_LIST;
        }
        ArrayList<FlutterWidgetPropertyValueEnumItem> list = new ArrayList<FlutterWidgetPropertyValueEnumItem>(jsonArray.size());
        Iterator iterator = jsonArray.iterator();
        while (iterator.hasNext()) {
            list.add(FlutterWidgetPropertyValueEnumItem.fromJson(((JsonElement)iterator.next()).getAsJsonObject()));
        }
        return list;
    }

    public String getClassName() {
        return this.className;
    }

    public String getDocumentation() {
        return this.documentation;
    }

    public String getLibraryUri() {
        return this.libraryUri;
    }

    public String getName() {
        return this.name;
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        builder.append((Object)this.libraryUri);
        builder.append((Object)this.className);
        builder.append((Object)this.name);
        builder.append((Object)this.documentation);
        return builder.toHashCode();
    }

    public JsonObject toJson() {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("libraryUri", this.libraryUri);
        jsonObject.addProperty("className", this.className);
        jsonObject.addProperty("name", this.name);
        if (this.documentation != null) {
            jsonObject.addProperty("documentation", this.documentation);
        }
        return jsonObject;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        builder.append("libraryUri=");
        builder.append(this.libraryUri).append(", ");
        builder.append("className=");
        builder.append(this.className).append(", ");
        builder.append("name=");
        builder.append(this.name).append(", ");
        builder.append("documentation=");
        builder.append(this.documentation);
        builder.append("]");
        return builder.toString();
    }
}

