/*
 * Decompiled with CFR 0.152.
 */
package org.dartlang.vm.service;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.List;
import java.util.Map;
import org.dartlang.vm.service.VmServiceBase;
import org.dartlang.vm.service.consumer.AddBreakpointAtEntryConsumer;
import org.dartlang.vm.service.consumer.AddBreakpointConsumer;
import org.dartlang.vm.service.consumer.AddBreakpointWithScriptUriConsumer;
import org.dartlang.vm.service.consumer.BreakpointConsumer;
import org.dartlang.vm.service.consumer.ClearCpuSamplesConsumer;
import org.dartlang.vm.service.consumer.Consumer;
import org.dartlang.vm.service.consumer.CpuSamplesConsumer;
import org.dartlang.vm.service.consumer.EvaluateConsumer;
import org.dartlang.vm.service.consumer.EvaluateInFrameConsumer;
import org.dartlang.vm.service.consumer.FlagListConsumer;
import org.dartlang.vm.service.consumer.GetAllocationProfileConsumer;
import org.dartlang.vm.service.consumer.GetClassListConsumer;
import org.dartlang.vm.service.consumer.GetCpuSamplesConsumer;
import org.dartlang.vm.service.consumer.GetInboundReferencesConsumer;
import org.dartlang.vm.service.consumer.GetInstancesAsListConsumer;
import org.dartlang.vm.service.consumer.GetInstancesConsumer;
import org.dartlang.vm.service.consumer.GetIsolateConsumer;
import org.dartlang.vm.service.consumer.GetIsolateGroupConsumer;
import org.dartlang.vm.service.consumer.GetIsolateGroupMemoryUsageConsumer;
import org.dartlang.vm.service.consumer.GetMemoryUsageConsumer;
import org.dartlang.vm.service.consumer.GetObjectConsumer;
import org.dartlang.vm.service.consumer.GetRetainingPathConsumer;
import org.dartlang.vm.service.consumer.GetScriptsConsumer;
import org.dartlang.vm.service.consumer.GetSourceReportConsumer;
import org.dartlang.vm.service.consumer.GetStackConsumer;
import org.dartlang.vm.service.consumer.InvokeConsumer;
import org.dartlang.vm.service.consumer.KillConsumer;
import org.dartlang.vm.service.consumer.PauseConsumer;
import org.dartlang.vm.service.consumer.PortListConsumer;
import org.dartlang.vm.service.consumer.ProcessMemoryUsageConsumer;
import org.dartlang.vm.service.consumer.ProtocolListConsumer;
import org.dartlang.vm.service.consumer.ReloadSourcesConsumer;
import org.dartlang.vm.service.consumer.RemoveBreakpointConsumer;
import org.dartlang.vm.service.consumer.RequestHeapSnapshotConsumer;
import org.dartlang.vm.service.consumer.ResumeConsumer;
import org.dartlang.vm.service.consumer.ServiceExtensionConsumer;
import org.dartlang.vm.service.consumer.SetExceptionPauseModeConsumer;
import org.dartlang.vm.service.consumer.SetFlagConsumer;
import org.dartlang.vm.service.consumer.SetIsolatePauseModeConsumer;
import org.dartlang.vm.service.consumer.SetLibraryDebuggableConsumer;
import org.dartlang.vm.service.consumer.SetNameConsumer;
import org.dartlang.vm.service.consumer.SetTraceClassAllocationConsumer;
import org.dartlang.vm.service.consumer.SuccessConsumer;
import org.dartlang.vm.service.consumer.TimelineConsumer;
import org.dartlang.vm.service.consumer.TimelineFlagsConsumer;
import org.dartlang.vm.service.consumer.TimestampConsumer;
import org.dartlang.vm.service.consumer.UriListConsumer;
import org.dartlang.vm.service.consumer.VMConsumer;
import org.dartlang.vm.service.consumer.VersionConsumer;
import org.dartlang.vm.service.element.AllocationProfile;
import org.dartlang.vm.service.element.Breakpoint;
import org.dartlang.vm.service.element.ClassList;
import org.dartlang.vm.service.element.ClassObj;
import org.dartlang.vm.service.element.Code;
import org.dartlang.vm.service.element.Context;
import org.dartlang.vm.service.element.CpuSamples;
import org.dartlang.vm.service.element.ErrorObj;
import org.dartlang.vm.service.element.ErrorRef;
import org.dartlang.vm.service.element.ExceptionPauseMode;
import org.dartlang.vm.service.element.Field;
import org.dartlang.vm.service.element.FlagList;
import org.dartlang.vm.service.element.Func;
import org.dartlang.vm.service.element.InboundReferences;
import org.dartlang.vm.service.element.Instance;
import org.dartlang.vm.service.element.InstanceRef;
import org.dartlang.vm.service.element.InstanceSet;
import org.dartlang.vm.service.element.Isolate;
import org.dartlang.vm.service.element.IsolateGroup;
import org.dartlang.vm.service.element.Library;
import org.dartlang.vm.service.element.MemoryUsage;
import org.dartlang.vm.service.element.Null;
import org.dartlang.vm.service.element.NullRef;
import org.dartlang.vm.service.element.Obj;
import org.dartlang.vm.service.element.PortList;
import org.dartlang.vm.service.element.ProcessMemoryUsage;
import org.dartlang.vm.service.element.ProtocolList;
import org.dartlang.vm.service.element.ReloadReport;
import org.dartlang.vm.service.element.RetainingPath;
import org.dartlang.vm.service.element.Script;
import org.dartlang.vm.service.element.ScriptList;
import org.dartlang.vm.service.element.Sentinel;
import org.dartlang.vm.service.element.SourceReport;
import org.dartlang.vm.service.element.SourceReportKind;
import org.dartlang.vm.service.element.Stack;
import org.dartlang.vm.service.element.StepOption;
import org.dartlang.vm.service.element.Success;
import org.dartlang.vm.service.element.Timeline;
import org.dartlang.vm.service.element.TimelineFlags;
import org.dartlang.vm.service.element.Timestamp;
import org.dartlang.vm.service.element.TypeArguments;
import org.dartlang.vm.service.element.UriList;
import org.dartlang.vm.service.element.VM;
import org.dartlang.vm.service.element.Version;

public class VmService
extends VmServiceBase {
    public static final String DEBUG_STREAM_ID = "Debug";
    public static final String EXTENSION_STREAM_ID = "Extension";
    public static final String GC_STREAM_ID = "GC";
    public static final String HEAPSNAPSHOT_STREAM_ID = "HeapSnapshot";
    public static final String ISOLATE_STREAM_ID = "Isolate";
    public static final String LOGGING_STREAM_ID = "Logging";
    public static final String PROFILER_STREAM_ID = "Profiler";
    public static final String SERVICE_STREAM_ID = "Service";
    public static final String STDERR_STREAM_ID = "Stderr";
    public static final String STDOUT_STREAM_ID = "Stdout";
    public static final String TIMELINE_STREAM_ID = "Timeline";
    public static final String VM_STREAM_ID = "VM";
    public static final int versionMajor = 4;
    public static final int versionMinor = 3;

    public void addBreakpoint(String isolateId, String scriptId, int line, AddBreakpointConsumer consumer) {
        JsonObject params = new JsonObject();
        params.addProperty("isolateId", isolateId);
        params.addProperty("scriptId", scriptId);
        params.addProperty("line", (Number)line);
        this.request("addBreakpoint", params, consumer);
    }

    public void addBreakpoint(String isolateId, String scriptId, int line, Integer column, AddBreakpointConsumer consumer) {
        JsonObject params = new JsonObject();
        params.addProperty("isolateId", isolateId);
        params.addProperty("scriptId", scriptId);
        params.addProperty("line", (Number)line);
        if (column != null) {
            params.addProperty("column", (Number)column);
        }
        this.request("addBreakpoint", params, consumer);
    }

    public void addBreakpointAtEntry(String isolateId, String functionId, AddBreakpointAtEntryConsumer consumer) {
        JsonObject params = new JsonObject();
        params.addProperty("isolateId", isolateId);
        params.addProperty("functionId", functionId);
        this.request("addBreakpointAtEntry", params, consumer);
    }

    public void addBreakpointWithScriptUri(String isolateId, String scriptUri, int line, AddBreakpointWithScriptUriConsumer consumer) {
        JsonObject params = new JsonObject();
        params.addProperty("isolateId", isolateId);
        params.addProperty("scriptUri", scriptUri);
        params.addProperty("line", (Number)line);
        this.request("addBreakpointWithScriptUri", params, consumer);
    }

    public void addBreakpointWithScriptUri(String isolateId, String scriptUri, int line, Integer column, AddBreakpointWithScriptUriConsumer consumer) {
        JsonObject params = new JsonObject();
        params.addProperty("isolateId", isolateId);
        params.addProperty("scriptUri", scriptUri);
        params.addProperty("line", (Number)line);
        if (column != null) {
            params.addProperty("column", (Number)column);
        }
        this.request("addBreakpointWithScriptUri", params, consumer);
    }

    public void clearCpuSamples(String isolateId, ClearCpuSamplesConsumer consumer) {
        JsonObject params = new JsonObject();
        params.addProperty("isolateId", isolateId);
        this.request("clearCpuSamples", params, consumer);
    }

    public void clearVMTimeline(SuccessConsumer consumer) {
        JsonObject params = new JsonObject();
        this.request("clearVMTimeline", params, consumer);
    }

    public void evaluate(String isolateId, String targetId, String expression, EvaluateConsumer consumer) {
        JsonObject params = new JsonObject();
        params.addProperty("isolateId", isolateId);
        params.addProperty("targetId", targetId);
        params.addProperty("expression", this.removeNewLines(expression));
        this.request("evaluate", params, consumer);
    }

    public void evaluate(String isolateId, String targetId, String expression, Map<String, String> scope, Boolean disableBreakpoints, EvaluateConsumer consumer) {
        JsonObject params = new JsonObject();
        params.addProperty("isolateId", isolateId);
        params.addProperty("targetId", targetId);
        params.addProperty("expression", this.removeNewLines(expression));
        if (scope != null) {
            params.add("scope", (JsonElement)this.convertMapToJsonObject(scope));
        }
        if (disableBreakpoints != null) {
            params.addProperty("disableBreakpoints", disableBreakpoints);
        }
        this.request("evaluate", params, consumer);
    }

    public void evaluateInFrame(String isolateId, int frameIndex, String expression, EvaluateInFrameConsumer consumer) {
        JsonObject params = new JsonObject();
        params.addProperty("isolateId", isolateId);
        params.addProperty("frameIndex", (Number)frameIndex);
        params.addProperty("expression", this.removeNewLines(expression));
        this.request("evaluateInFrame", params, consumer);
    }

    public void evaluateInFrame(String isolateId, int frameIndex, String expression, Map<String, String> scope, Boolean disableBreakpoints, EvaluateInFrameConsumer consumer) {
        JsonObject params = new JsonObject();
        params.addProperty("isolateId", isolateId);
        params.addProperty("frameIndex", (Number)frameIndex);
        params.addProperty("expression", this.removeNewLines(expression));
        if (scope != null) {
            params.add("scope", (JsonElement)this.convertMapToJsonObject(scope));
        }
        if (disableBreakpoints != null) {
            params.addProperty("disableBreakpoints", disableBreakpoints);
        }
        this.request("evaluateInFrame", params, consumer);
    }

    public void getAllocationProfile(String isolateId, Boolean reset, Boolean gc, GetAllocationProfileConsumer consumer) {
        JsonObject params = new JsonObject();
        params.addProperty("isolateId", isolateId);
        if (reset != null) {
            params.addProperty("reset", reset);
        }
        if (gc != null) {
            params.addProperty("gc", gc);
        }
        this.request("getAllocationProfile", params, consumer);
    }

    public void getAllocationProfile(String isolateId, GetAllocationProfileConsumer consumer) {
        JsonObject params = new JsonObject();
        params.addProperty("isolateId", isolateId);
        this.request("getAllocationProfile", params, consumer);
    }

    public void getAllocationTraces(String isolateId, CpuSamplesConsumer consumer) {
        JsonObject params = new JsonObject();
        params.addProperty("isolateId", isolateId);
        this.request("getAllocationTraces", params, consumer);
    }

    public void getAllocationTraces(String isolateId, Integer timeOriginMicros, Integer timeExtentMicros, String classId, CpuSamplesConsumer consumer) {
        JsonObject params = new JsonObject();
        params.addProperty("isolateId", isolateId);
        if (timeOriginMicros != null) {
            params.addProperty("timeOriginMicros", (Number)timeOriginMicros);
        }
        if (timeExtentMicros != null) {
            params.addProperty("timeExtentMicros", (Number)timeExtentMicros);
        }
        if (classId != null) {
            params.addProperty("classId", classId);
        }
        this.request("getAllocationTraces", params, consumer);
    }

    public void getClassList(String isolateId, GetClassListConsumer consumer) {
        JsonObject params = new JsonObject();
        params.addProperty("isolateId", isolateId);
        this.request("getClassList", params, consumer);
    }

    public void getCpuSamples(String isolateId, int timeOriginMicros, int timeExtentMicros, GetCpuSamplesConsumer consumer) {
        JsonObject params = new JsonObject();
        params.addProperty("isolateId", isolateId);
        params.addProperty("timeOriginMicros", (Number)timeOriginMicros);
        params.addProperty("timeExtentMicros", (Number)timeExtentMicros);
        this.request("getCpuSamples", params, consumer);
    }

    public void getFlagList(FlagListConsumer consumer) {
        JsonObject params = new JsonObject();
        this.request("getFlagList", params, consumer);
    }

    public void getInboundReferences(String isolateId, String targetId, int limit, GetInboundReferencesConsumer consumer) {
        JsonObject params = new JsonObject();
        params.addProperty("isolateId", isolateId);
        params.addProperty("targetId", targetId);
        params.addProperty("limit", (Number)limit);
        this.request("getInboundReferences", params, consumer);
    }

    public void getInstances(String isolateId, String objectId, int limit, Boolean includeSubclasses, Boolean includeImplementers, GetInstancesConsumer consumer) {
        JsonObject params = new JsonObject();
        params.addProperty("isolateId", isolateId);
        params.addProperty("objectId", objectId);
        params.addProperty("limit", (Number)limit);
        if (includeSubclasses != null) {
            params.addProperty("includeSubclasses", includeSubclasses);
        }
        if (includeImplementers != null) {
            params.addProperty("includeImplementers", includeImplementers);
        }
        this.request("getInstances", params, consumer);
    }

    public void getInstances(String isolateId, String objectId, int limit, GetInstancesConsumer consumer) {
        JsonObject params = new JsonObject();
        params.addProperty("isolateId", isolateId);
        params.addProperty("objectId", objectId);
        params.addProperty("limit", (Number)limit);
        this.request("getInstances", params, consumer);
    }

    public void getInstancesAsList(String isolateId, String objectId, Boolean includeSubclasses, Boolean includeImplementers, GetInstancesAsListConsumer consumer) {
        JsonObject params = new JsonObject();
        params.addProperty("isolateId", isolateId);
        params.addProperty("objectId", objectId);
        if (includeSubclasses != null) {
            params.addProperty("includeSubclasses", includeSubclasses);
        }
        if (includeImplementers != null) {
            params.addProperty("includeImplementers", includeImplementers);
        }
        this.request("getInstancesAsList", params, consumer);
    }

    public void getInstancesAsList(String isolateId, String objectId, GetInstancesAsListConsumer consumer) {
        JsonObject params = new JsonObject();
        params.addProperty("isolateId", isolateId);
        params.addProperty("objectId", objectId);
        this.request("getInstancesAsList", params, consumer);
    }

    public void getIsolate(String isolateId, GetIsolateConsumer consumer) {
        JsonObject params = new JsonObject();
        params.addProperty("isolateId", isolateId);
        this.request("getIsolate", params, consumer);
    }

    public void getIsolateGroup(String isolateGroupId, GetIsolateGroupConsumer consumer) {
        JsonObject params = new JsonObject();
        params.addProperty("isolateGroupId", isolateGroupId);
        this.request("getIsolateGroup", params, consumer);
    }

    public void getIsolateGroupMemoryUsage(String isolateGroupId, GetIsolateGroupMemoryUsageConsumer consumer) {
        JsonObject params = new JsonObject();
        params.addProperty("isolateGroupId", isolateGroupId);
        this.request("getIsolateGroupMemoryUsage", params, consumer);
    }

    public void getMemoryUsage(String isolateId, GetMemoryUsageConsumer consumer) {
        JsonObject params = new JsonObject();
        params.addProperty("isolateId", isolateId);
        this.request("getMemoryUsage", params, consumer);
    }

    @Override
    public void getObject(String isolateId, String objectId, GetObjectConsumer consumer) {
        JsonObject params = new JsonObject();
        params.addProperty("isolateId", isolateId);
        params.addProperty("objectId", objectId);
        this.request("getObject", params, consumer);
    }

    public void getObject(String isolateId, String objectId, Integer offset, Integer count, GetObjectConsumer consumer) {
        JsonObject params = new JsonObject();
        params.addProperty("isolateId", isolateId);
        params.addProperty("objectId", objectId);
        if (offset != null) {
            params.addProperty("offset", (Number)offset);
        }
        if (count != null) {
            params.addProperty("count", (Number)count);
        }
        this.request("getObject", params, consumer);
    }

    public void getPorts(String isolateId, PortListConsumer consumer) {
        JsonObject params = new JsonObject();
        params.addProperty("isolateId", isolateId);
        this.request("getPorts", params, consumer);
    }

    public void getProcessMemoryUsage(ProcessMemoryUsageConsumer consumer) {
        JsonObject params = new JsonObject();
        this.request("getProcessMemoryUsage", params, consumer);
    }

    public void getRetainingPath(String isolateId, String targetId, int limit, GetRetainingPathConsumer consumer) {
        JsonObject params = new JsonObject();
        params.addProperty("isolateId", isolateId);
        params.addProperty("targetId", targetId);
        params.addProperty("limit", (Number)limit);
        this.request("getRetainingPath", params, consumer);
    }

    public void getScripts(String isolateId, GetScriptsConsumer consumer) {
        JsonObject params = new JsonObject();
        params.addProperty("isolateId", isolateId);
        this.request("getScripts", params, consumer);
    }

    public void getSourceReport(String isolateId, List<SourceReportKind> reports, GetSourceReportConsumer consumer) {
        JsonObject params = new JsonObject();
        params.addProperty("isolateId", isolateId);
        params.add("reports", (JsonElement)this.convertIterableToJsonArray(reports));
        this.request("getSourceReport", params, consumer);
    }

    public void getSourceReport(String isolateId, List<SourceReportKind> reports, String scriptId, Integer tokenPos, Integer endTokenPos, Boolean forceCompile, Boolean reportLines, List<String> libraryFilters, GetSourceReportConsumer consumer) {
        JsonObject params = new JsonObject();
        params.addProperty("isolateId", isolateId);
        params.add("reports", (JsonElement)this.convertIterableToJsonArray(reports));
        if (scriptId != null) {
            params.addProperty("scriptId", scriptId);
        }
        if (tokenPos != null) {
            params.addProperty("tokenPos", (Number)tokenPos);
        }
        if (endTokenPos != null) {
            params.addProperty("endTokenPos", (Number)endTokenPos);
        }
        if (forceCompile != null) {
            params.addProperty("forceCompile", forceCompile);
        }
        if (reportLines != null) {
            params.addProperty("reportLines", reportLines);
        }
        if (libraryFilters != null) {
            params.add("libraryFilters", (JsonElement)this.convertIterableToJsonArray(libraryFilters));
        }
        this.request("getSourceReport", params, consumer);
    }

    public void getStack(String isolateId, GetStackConsumer consumer) {
        JsonObject params = new JsonObject();
        params.addProperty("isolateId", isolateId);
        this.request("getStack", params, consumer);
    }

    public void getStack(String isolateId, Integer limit, GetStackConsumer consumer) {
        JsonObject params = new JsonObject();
        params.addProperty("isolateId", isolateId);
        if (limit != null) {
            params.addProperty("limit", (Number)limit);
        }
        this.request("getStack", params, consumer);
    }

    public void getSupportedProtocols(ProtocolListConsumer consumer) {
        JsonObject params = new JsonObject();
        this.request("getSupportedProtocols", params, consumer);
    }

    public void getVM(VMConsumer consumer) {
        JsonObject params = new JsonObject();
        this.request("getVM", params, consumer);
    }

    public void getVMTimeline(Integer timeOriginMicros, Integer timeExtentMicros, TimelineConsumer consumer) {
        JsonObject params = new JsonObject();
        if (timeOriginMicros != null) {
            params.addProperty("timeOriginMicros", (Number)timeOriginMicros);
        }
        if (timeExtentMicros != null) {
            params.addProperty("timeExtentMicros", (Number)timeExtentMicros);
        }
        this.request("getVMTimeline", params, consumer);
    }

    public void getVMTimeline(TimelineConsumer consumer) {
        JsonObject params = new JsonObject();
        this.request("getVMTimeline", params, consumer);
    }

    public void getVMTimelineFlags(TimelineFlagsConsumer consumer) {
        JsonObject params = new JsonObject();
        this.request("getVMTimelineFlags", params, consumer);
    }

    public void getVMTimelineMicros(TimestampConsumer consumer) {
        JsonObject params = new JsonObject();
        this.request("getVMTimelineMicros", params, consumer);
    }

    public void getVersion(VersionConsumer consumer) {
        JsonObject params = new JsonObject();
        this.request("getVersion", params, consumer);
    }

    public void invoke(String isolateId, String targetId, String selector, List<String> argumentIds, Boolean disableBreakpoints, InvokeConsumer consumer) {
        JsonObject params = new JsonObject();
        params.addProperty("isolateId", isolateId);
        params.addProperty("targetId", targetId);
        params.addProperty("selector", selector);
        params.add("argumentIds", (JsonElement)this.convertIterableToJsonArray(argumentIds));
        if (disableBreakpoints != null) {
            params.addProperty("disableBreakpoints", disableBreakpoints);
        }
        this.request("invoke", params, consumer);
    }

    public void invoke(String isolateId, String targetId, String selector, List<String> argumentIds, InvokeConsumer consumer) {
        JsonObject params = new JsonObject();
        params.addProperty("isolateId", isolateId);
        params.addProperty("targetId", targetId);
        params.addProperty("selector", selector);
        params.add("argumentIds", (JsonElement)this.convertIterableToJsonArray(argumentIds));
        this.request("invoke", params, consumer);
    }

    public void kill(String isolateId, KillConsumer consumer) {
        JsonObject params = new JsonObject();
        params.addProperty("isolateId", isolateId);
        this.request("kill", params, consumer);
    }

    public void lookupPackageUris(String isolateId, List<String> uris, UriListConsumer consumer) {
        JsonObject params = new JsonObject();
        params.addProperty("isolateId", isolateId);
        params.add("uris", (JsonElement)this.convertIterableToJsonArray(uris));
        this.request("lookupPackageUris", params, consumer);
    }

    public void lookupResolvedPackageUris(String isolateId, List<String> uris, Boolean local, UriListConsumer consumer) {
        JsonObject params = new JsonObject();
        params.addProperty("isolateId", isolateId);
        params.add("uris", (JsonElement)this.convertIterableToJsonArray(uris));
        if (local != null) {
            params.addProperty("local", local);
        }
        this.request("lookupResolvedPackageUris", params, consumer);
    }

    public void lookupResolvedPackageUris(String isolateId, List<String> uris, UriListConsumer consumer) {
        JsonObject params = new JsonObject();
        params.addProperty("isolateId", isolateId);
        params.add("uris", (JsonElement)this.convertIterableToJsonArray(uris));
        this.request("lookupResolvedPackageUris", params, consumer);
    }

    public void pause(String isolateId, PauseConsumer consumer) {
        JsonObject params = new JsonObject();
        params.addProperty("isolateId", isolateId);
        this.request("pause", params, consumer);
    }

    public void registerService(String service, String alias, SuccessConsumer consumer) {
        JsonObject params = new JsonObject();
        params.addProperty("service", service);
        params.addProperty("alias", alias);
        this.request("registerService", params, consumer);
    }

    public void reloadSources(String isolateId, Boolean force, Boolean pause, String rootLibUri, String packagesUri, ReloadSourcesConsumer consumer) {
        JsonObject params = new JsonObject();
        params.addProperty("isolateId", isolateId);
        if (force != null) {
            params.addProperty("force", force);
        }
        if (pause != null) {
            params.addProperty("pause", pause);
        }
        if (rootLibUri != null) {
            params.addProperty("rootLibUri", rootLibUri);
        }
        if (packagesUri != null) {
            params.addProperty("packagesUri", packagesUri);
        }
        this.request("reloadSources", params, consumer);
    }

    public void reloadSources(String isolateId, ReloadSourcesConsumer consumer) {
        JsonObject params = new JsonObject();
        params.addProperty("isolateId", isolateId);
        this.request("reloadSources", params, consumer);
    }

    public void removeBreakpoint(String isolateId, String breakpointId, RemoveBreakpointConsumer consumer) {
        JsonObject params = new JsonObject();
        params.addProperty("isolateId", isolateId);
        params.addProperty("breakpointId", breakpointId);
        this.request("removeBreakpoint", params, consumer);
    }

    public void requestHeapSnapshot(String isolateId, RequestHeapSnapshotConsumer consumer) {
        JsonObject params = new JsonObject();
        params.addProperty("isolateId", isolateId);
        this.request("requestHeapSnapshot", params, consumer);
    }

    public void resume(String isolateId, ResumeConsumer consumer) {
        JsonObject params = new JsonObject();
        params.addProperty("isolateId", isolateId);
        this.request("resume", params, consumer);
    }

    public void resume(String isolateId, StepOption step, Integer frameIndex, ResumeConsumer consumer) {
        JsonObject params = new JsonObject();
        params.addProperty("isolateId", isolateId);
        if (step != null) {
            params.addProperty("step", step.name());
        }
        if (frameIndex != null) {
            params.addProperty("frameIndex", (Number)frameIndex);
        }
        this.request("resume", params, consumer);
    }

    public void setBreakpointState(String isolateId, String breakpointId, boolean enable, BreakpointConsumer consumer) {
        JsonObject params = new JsonObject();
        params.addProperty("isolateId", isolateId);
        params.addProperty("breakpointId", breakpointId);
        params.addProperty("enable", Boolean.valueOf(enable));
        this.request("setBreakpointState", params, consumer);
    }

    @Deprecated
    public void setExceptionPauseMode(String isolateId, ExceptionPauseMode mode, SetExceptionPauseModeConsumer consumer) {
        JsonObject params = new JsonObject();
        params.addProperty("isolateId", isolateId);
        params.addProperty("mode", mode.name());
        this.request("setExceptionPauseMode", params, consumer);
    }

    public void setFlag(String name, String value, SetFlagConsumer consumer) {
        JsonObject params = new JsonObject();
        params.addProperty("name", name);
        params.addProperty("value", value);
        this.request("setFlag", params, consumer);
    }

    public void setIsolatePauseMode(String isolateId, ExceptionPauseMode exceptionPauseMode, Boolean shouldPauseOnExit, SetIsolatePauseModeConsumer consumer) {
        JsonObject params = new JsonObject();
        params.addProperty("isolateId", isolateId);
        if (exceptionPauseMode != null) {
            params.addProperty("exceptionPauseMode", exceptionPauseMode.name());
        }
        if (shouldPauseOnExit != null) {
            params.addProperty("shouldPauseOnExit", shouldPauseOnExit);
        }
        this.request("setIsolatePauseMode", params, consumer);
    }

    public void setIsolatePauseMode(String isolateId, SetIsolatePauseModeConsumer consumer) {
        JsonObject params = new JsonObject();
        params.addProperty("isolateId", isolateId);
        this.request("setIsolatePauseMode", params, consumer);
    }

    public void setLibraryDebuggable(String isolateId, String libraryId, boolean isDebuggable, SetLibraryDebuggableConsumer consumer) {
        JsonObject params = new JsonObject();
        params.addProperty("isolateId", isolateId);
        params.addProperty("libraryId", libraryId);
        params.addProperty("isDebuggable", Boolean.valueOf(isDebuggable));
        this.request("setLibraryDebuggable", params, consumer);
    }

    public void setName(String isolateId, String name, SetNameConsumer consumer) {
        JsonObject params = new JsonObject();
        params.addProperty("isolateId", isolateId);
        params.addProperty("name", name);
        this.request("setName", params, consumer);
    }

    public void setTraceClassAllocation(String isolateId, String classId, boolean enable, SetTraceClassAllocationConsumer consumer) {
        JsonObject params = new JsonObject();
        params.addProperty("isolateId", isolateId);
        params.addProperty("classId", classId);
        params.addProperty("enable", Boolean.valueOf(enable));
        this.request("setTraceClassAllocation", params, consumer);
    }

    public void setVMName(String name, SuccessConsumer consumer) {
        JsonObject params = new JsonObject();
        params.addProperty("name", name);
        this.request("setVMName", params, consumer);
    }

    public void setVMTimelineFlags(List<String> recordedStreams, SuccessConsumer consumer) {
        JsonObject params = new JsonObject();
        params.add("recordedStreams", (JsonElement)this.convertIterableToJsonArray(recordedStreams));
        this.request("setVMTimelineFlags", params, consumer);
    }

    public void streamCancel(String streamId, SuccessConsumer consumer) {
        JsonObject params = new JsonObject();
        params.addProperty("streamId", streamId);
        this.request("streamCancel", params, consumer);
    }

    public void streamCpuSamplesWithUserTag(List<String> userTags, SuccessConsumer consumer) {
        JsonObject params = new JsonObject();
        params.add("userTags", (JsonElement)this.convertIterableToJsonArray(userTags));
        this.request("streamCpuSamplesWithUserTag", params, consumer);
    }

    public void streamListen(String streamId, SuccessConsumer consumer) {
        JsonObject params = new JsonObject();
        params.addProperty("streamId", streamId);
        this.request("streamListen", params, consumer);
    }

    private JsonArray convertIterableToJsonArray(Iterable list) {
        JsonArray arr = new JsonArray();
        for (Object element : list) {
            arr.add((JsonElement)new JsonPrimitive(element.toString()));
        }
        return arr;
    }

    private JsonObject convertMapToJsonObject(Map<String, String> map) {
        JsonObject obj = new JsonObject();
        for (String key : map.keySet()) {
            obj.addProperty(key, map.get(key));
        }
        return obj;
    }

    @Override
    void forwardResponse(Consumer consumer, String responseType, JsonObject json) {
        if (consumer instanceof AddBreakpointAtEntryConsumer) {
            if (responseType.equals("Breakpoint")) {
                ((AddBreakpointAtEntryConsumer)consumer).received(new Breakpoint(json));
                return;
            }
            if (responseType.equals("Sentinel")) {
                ((AddBreakpointAtEntryConsumer)consumer).received(new Sentinel(json));
                return;
            }
        }
        if (consumer instanceof AddBreakpointConsumer) {
            if (responseType.equals("Breakpoint")) {
                ((AddBreakpointConsumer)consumer).received(new Breakpoint(json));
                return;
            }
            if (responseType.equals("Sentinel")) {
                ((AddBreakpointConsumer)consumer).received(new Sentinel(json));
                return;
            }
        }
        if (consumer instanceof AddBreakpointWithScriptUriConsumer) {
            if (responseType.equals("Breakpoint")) {
                ((AddBreakpointWithScriptUriConsumer)consumer).received(new Breakpoint(json));
                return;
            }
            if (responseType.equals("Sentinel")) {
                ((AddBreakpointWithScriptUriConsumer)consumer).received(new Sentinel(json));
                return;
            }
        }
        if (consumer instanceof BreakpointConsumer && responseType.equals("Breakpoint")) {
            ((BreakpointConsumer)consumer).received(new Breakpoint(json));
            return;
        }
        if (consumer instanceof ClearCpuSamplesConsumer) {
            if (responseType.equals("Sentinel")) {
                ((ClearCpuSamplesConsumer)consumer).received(new Sentinel(json));
                return;
            }
            if (responseType.equals("Success")) {
                ((ClearCpuSamplesConsumer)consumer).received(new Success(json));
                return;
            }
        }
        if (consumer instanceof CpuSamplesConsumer && responseType.equals("CpuSamples")) {
            ((CpuSamplesConsumer)consumer).received(new CpuSamples(json));
            return;
        }
        if (consumer instanceof EvaluateConsumer) {
            if (responseType.equals("@Error")) {
                ((EvaluateConsumer)consumer).received(new ErrorRef(json));
                return;
            }
            if (responseType.equals("@Instance")) {
                ((EvaluateConsumer)consumer).received(new InstanceRef(json));
                return;
            }
            if (responseType.equals("@Null")) {
                ((EvaluateConsumer)consumer).received(new NullRef(json));
                return;
            }
            if (responseType.equals("Sentinel")) {
                ((EvaluateConsumer)consumer).received(new Sentinel(json));
                return;
            }
        }
        if (consumer instanceof EvaluateInFrameConsumer) {
            if (responseType.equals("@Error")) {
                ((EvaluateInFrameConsumer)consumer).received(new ErrorRef(json));
                return;
            }
            if (responseType.equals("@Instance")) {
                ((EvaluateInFrameConsumer)consumer).received(new InstanceRef(json));
                return;
            }
            if (responseType.equals("@Null")) {
                ((EvaluateInFrameConsumer)consumer).received(new NullRef(json));
                return;
            }
            if (responseType.equals("Sentinel")) {
                ((EvaluateInFrameConsumer)consumer).received(new Sentinel(json));
                return;
            }
        }
        if (consumer instanceof FlagListConsumer && responseType.equals("FlagList")) {
            ((FlagListConsumer)consumer).received(new FlagList(json));
            return;
        }
        if (consumer instanceof GetAllocationProfileConsumer) {
            if (responseType.equals("AllocationProfile")) {
                ((GetAllocationProfileConsumer)consumer).received(new AllocationProfile(json));
                return;
            }
            if (responseType.equals("Sentinel")) {
                ((GetAllocationProfileConsumer)consumer).received(new Sentinel(json));
                return;
            }
        }
        if (consumer instanceof GetClassListConsumer) {
            if (responseType.equals("ClassList")) {
                ((GetClassListConsumer)consumer).received(new ClassList(json));
                return;
            }
            if (responseType.equals("Sentinel")) {
                ((GetClassListConsumer)consumer).received(new Sentinel(json));
                return;
            }
        }
        if (consumer instanceof GetCpuSamplesConsumer) {
            if (responseType.equals("CpuSamples")) {
                ((GetCpuSamplesConsumer)consumer).received(new CpuSamples(json));
                return;
            }
            if (responseType.equals("Sentinel")) {
                ((GetCpuSamplesConsumer)consumer).received(new Sentinel(json));
                return;
            }
        }
        if (consumer instanceof GetInboundReferencesConsumer) {
            if (responseType.equals("InboundReferences")) {
                ((GetInboundReferencesConsumer)consumer).received(new InboundReferences(json));
                return;
            }
            if (responseType.equals("Sentinel")) {
                ((GetInboundReferencesConsumer)consumer).received(new Sentinel(json));
                return;
            }
        }
        if (consumer instanceof GetInstancesAsListConsumer) {
            if (responseType.equals("@Instance")) {
                ((GetInstancesAsListConsumer)consumer).received(new InstanceRef(json));
                return;
            }
            if (responseType.equals("@Null")) {
                ((GetInstancesAsListConsumer)consumer).received(new NullRef(json));
                return;
            }
            if (responseType.equals("Sentinel")) {
                ((GetInstancesAsListConsumer)consumer).received(new Sentinel(json));
                return;
            }
        }
        if (consumer instanceof GetInstancesConsumer) {
            if (responseType.equals("InstanceSet")) {
                ((GetInstancesConsumer)consumer).received(new InstanceSet(json));
                return;
            }
            if (responseType.equals("Sentinel")) {
                ((GetInstancesConsumer)consumer).received(new Sentinel(json));
                return;
            }
        }
        if (consumer instanceof GetIsolateConsumer) {
            if (responseType.equals(ISOLATE_STREAM_ID)) {
                ((GetIsolateConsumer)consumer).received(new Isolate(json));
                return;
            }
            if (responseType.equals("Sentinel")) {
                ((GetIsolateConsumer)consumer).received(new Sentinel(json));
                return;
            }
        }
        if (consumer instanceof GetIsolateGroupConsumer) {
            if (responseType.equals("IsolateGroup")) {
                ((GetIsolateGroupConsumer)consumer).received(new IsolateGroup(json));
                return;
            }
            if (responseType.equals("Sentinel")) {
                ((GetIsolateGroupConsumer)consumer).received(new Sentinel(json));
                return;
            }
        }
        if (consumer instanceof GetIsolateGroupMemoryUsageConsumer) {
            if (responseType.equals("MemoryUsage")) {
                ((GetIsolateGroupMemoryUsageConsumer)consumer).received(new MemoryUsage(json));
                return;
            }
            if (responseType.equals("Sentinel")) {
                ((GetIsolateGroupMemoryUsageConsumer)consumer).received(new Sentinel(json));
                return;
            }
        }
        if (consumer instanceof GetMemoryUsageConsumer) {
            if (responseType.equals("MemoryUsage")) {
                ((GetMemoryUsageConsumer)consumer).received(new MemoryUsage(json));
                return;
            }
            if (responseType.equals("Sentinel")) {
                ((GetMemoryUsageConsumer)consumer).received(new Sentinel(json));
                return;
            }
        }
        if (consumer instanceof GetObjectConsumer) {
            if (responseType.equals("Breakpoint")) {
                ((GetObjectConsumer)consumer).received(new Breakpoint(json));
                return;
            }
            if (responseType.equals("Class")) {
                ((GetObjectConsumer)consumer).received(new ClassObj(json));
                return;
            }
            if (responseType.equals("Code")) {
                ((GetObjectConsumer)consumer).received(new Code(json));
                return;
            }
            if (responseType.equals("Context")) {
                ((GetObjectConsumer)consumer).received(new Context(json));
                return;
            }
            if (responseType.equals("Error")) {
                ((GetObjectConsumer)consumer).received(new ErrorObj(json));
                return;
            }
            if (responseType.equals("Field")) {
                ((GetObjectConsumer)consumer).received(new Field(json));
                return;
            }
            if (responseType.equals("Function")) {
                ((GetObjectConsumer)consumer).received(new Func(json));
                return;
            }
            if (responseType.equals("Instance")) {
                ((GetObjectConsumer)consumer).received(new Instance(json));
                return;
            }
            if (responseType.equals("Library")) {
                ((GetObjectConsumer)consumer).received(new Library(json));
                return;
            }
            if (responseType.equals("Null")) {
                ((GetObjectConsumer)consumer).received(new Null(json));
                return;
            }
            if (responseType.equals("Object")) {
                ((GetObjectConsumer)consumer).received(new Obj(json));
                return;
            }
            if (responseType.equals("Script")) {
                ((GetObjectConsumer)consumer).received(new Script(json));
                return;
            }
            if (responseType.equals("Sentinel")) {
                ((GetObjectConsumer)consumer).received(new Sentinel(json));
                return;
            }
            if (responseType.equals("TypeArguments")) {
                ((GetObjectConsumer)consumer).received(new TypeArguments(json));
                return;
            }
        }
        if (consumer instanceof GetRetainingPathConsumer) {
            if (responseType.equals("RetainingPath")) {
                ((GetRetainingPathConsumer)consumer).received(new RetainingPath(json));
                return;
            }
            if (responseType.equals("Sentinel")) {
                ((GetRetainingPathConsumer)consumer).received(new Sentinel(json));
                return;
            }
        }
        if (consumer instanceof GetScriptsConsumer) {
            if (responseType.equals("ScriptList")) {
                ((GetScriptsConsumer)consumer).received(new ScriptList(json));
                return;
            }
            if (responseType.equals("Sentinel")) {
                ((GetScriptsConsumer)consumer).received(new Sentinel(json));
                return;
            }
        }
        if (consumer instanceof GetSourceReportConsumer) {
            if (responseType.equals("Sentinel")) {
                ((GetSourceReportConsumer)consumer).received(new Sentinel(json));
                return;
            }
            if (responseType.equals("SourceReport")) {
                ((GetSourceReportConsumer)consumer).received(new SourceReport(json));
                return;
            }
        }
        if (consumer instanceof GetStackConsumer) {
            if (responseType.equals("Sentinel")) {
                ((GetStackConsumer)consumer).received(new Sentinel(json));
                return;
            }
            if (responseType.equals("Stack")) {
                ((GetStackConsumer)consumer).received(new Stack(json));
                return;
            }
        }
        if (consumer instanceof InvokeConsumer) {
            if (responseType.equals("@Error")) {
                ((InvokeConsumer)consumer).received(new ErrorRef(json));
                return;
            }
            if (responseType.equals("@Instance")) {
                ((InvokeConsumer)consumer).received(new InstanceRef(json));
                return;
            }
            if (responseType.equals("@Null")) {
                ((InvokeConsumer)consumer).received(new NullRef(json));
                return;
            }
            if (responseType.equals("Sentinel")) {
                ((InvokeConsumer)consumer).received(new Sentinel(json));
                return;
            }
        }
        if (consumer instanceof KillConsumer) {
            if (responseType.equals("Sentinel")) {
                ((KillConsumer)consumer).received(new Sentinel(json));
                return;
            }
            if (responseType.equals("Success")) {
                ((KillConsumer)consumer).received(new Success(json));
                return;
            }
        }
        if (consumer instanceof PauseConsumer) {
            if (responseType.equals("Sentinel")) {
                ((PauseConsumer)consumer).received(new Sentinel(json));
                return;
            }
            if (responseType.equals("Success")) {
                ((PauseConsumer)consumer).received(new Success(json));
                return;
            }
        }
        if (consumer instanceof PortListConsumer && responseType.equals("PortList")) {
            ((PortListConsumer)consumer).received(new PortList(json));
            return;
        }
        if (consumer instanceof ProcessMemoryUsageConsumer && responseType.equals("ProcessMemoryUsage")) {
            ((ProcessMemoryUsageConsumer)consumer).received(new ProcessMemoryUsage(json));
            return;
        }
        if (consumer instanceof ProtocolListConsumer && responseType.equals("ProtocolList")) {
            ((ProtocolListConsumer)consumer).received(new ProtocolList(json));
            return;
        }
        if (consumer instanceof ReloadSourcesConsumer) {
            if (responseType.equals("ReloadReport")) {
                ((ReloadSourcesConsumer)consumer).received(new ReloadReport(json));
                return;
            }
            if (responseType.equals("Sentinel")) {
                ((ReloadSourcesConsumer)consumer).received(new Sentinel(json));
                return;
            }
        }
        if (consumer instanceof RemoveBreakpointConsumer) {
            if (responseType.equals("Sentinel")) {
                ((RemoveBreakpointConsumer)consumer).received(new Sentinel(json));
                return;
            }
            if (responseType.equals("Success")) {
                ((RemoveBreakpointConsumer)consumer).received(new Success(json));
                return;
            }
        }
        if (consumer instanceof RequestHeapSnapshotConsumer) {
            if (responseType.equals("Sentinel")) {
                ((RequestHeapSnapshotConsumer)consumer).received(new Sentinel(json));
                return;
            }
            if (responseType.equals("Success")) {
                ((RequestHeapSnapshotConsumer)consumer).received(new Success(json));
                return;
            }
        }
        if (consumer instanceof ResumeConsumer) {
            if (responseType.equals("Sentinel")) {
                ((ResumeConsumer)consumer).received(new Sentinel(json));
                return;
            }
            if (responseType.equals("Success")) {
                ((ResumeConsumer)consumer).received(new Success(json));
                return;
            }
        }
        if (consumer instanceof SetExceptionPauseModeConsumer) {
            if (responseType.equals("Sentinel")) {
                ((SetExceptionPauseModeConsumer)consumer).received(new Sentinel(json));
                return;
            }
            if (responseType.equals("Success")) {
                ((SetExceptionPauseModeConsumer)consumer).received(new Success(json));
                return;
            }
        }
        if (consumer instanceof SetFlagConsumer) {
            if (responseType.equals("Error")) {
                ((SetFlagConsumer)consumer).received(new ErrorObj(json));
                return;
            }
            if (responseType.equals("Success")) {
                ((SetFlagConsumer)consumer).received(new Success(json));
                return;
            }
        }
        if (consumer instanceof SetIsolatePauseModeConsumer) {
            if (responseType.equals("Sentinel")) {
                ((SetIsolatePauseModeConsumer)consumer).received(new Sentinel(json));
                return;
            }
            if (responseType.equals("Success")) {
                ((SetIsolatePauseModeConsumer)consumer).received(new Success(json));
                return;
            }
        }
        if (consumer instanceof SetLibraryDebuggableConsumer) {
            if (responseType.equals("Sentinel")) {
                ((SetLibraryDebuggableConsumer)consumer).received(new Sentinel(json));
                return;
            }
            if (responseType.equals("Success")) {
                ((SetLibraryDebuggableConsumer)consumer).received(new Success(json));
                return;
            }
        }
        if (consumer instanceof SetNameConsumer) {
            if (responseType.equals("Sentinel")) {
                ((SetNameConsumer)consumer).received(new Sentinel(json));
                return;
            }
            if (responseType.equals("Success")) {
                ((SetNameConsumer)consumer).received(new Success(json));
                return;
            }
        }
        if (consumer instanceof SetTraceClassAllocationConsumer) {
            if (responseType.equals("Sentinel")) {
                ((SetTraceClassAllocationConsumer)consumer).received(new Sentinel(json));
                return;
            }
            if (responseType.equals("Success")) {
                ((SetTraceClassAllocationConsumer)consumer).received(new Success(json));
                return;
            }
        }
        if (consumer instanceof SuccessConsumer && responseType.equals("Success")) {
            ((SuccessConsumer)consumer).received(new Success(json));
            return;
        }
        if (consumer instanceof TimelineConsumer && responseType.equals(TIMELINE_STREAM_ID)) {
            ((TimelineConsumer)consumer).received(new Timeline(json));
            return;
        }
        if (consumer instanceof TimelineFlagsConsumer && responseType.equals("TimelineFlags")) {
            ((TimelineFlagsConsumer)consumer).received(new TimelineFlags(json));
            return;
        }
        if (consumer instanceof TimestampConsumer && responseType.equals("Timestamp")) {
            ((TimestampConsumer)consumer).received(new Timestamp(json));
            return;
        }
        if (consumer instanceof UriListConsumer && responseType.equals("UriList")) {
            ((UriListConsumer)consumer).received(new UriList(json));
            return;
        }
        if (consumer instanceof VMConsumer && responseType.equals(VM_STREAM_ID)) {
            ((VMConsumer)consumer).received(new VM(json));
            return;
        }
        if (consumer instanceof VersionConsumer && responseType.equals("Version")) {
            ((VersionConsumer)consumer).received(new Version(json));
            return;
        }
        if (consumer instanceof ServiceExtensionConsumer) {
            ((ServiceExtensionConsumer)consumer).received(json);
            return;
        }
        this.logUnknownResponse(consumer, json);
    }
}

