/*
 * Decompiled with CFR 0.152.
 */
package org.dartlang.vm.service.element;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import org.dartlang.vm.service.element.ClassRef;
import org.dartlang.vm.service.element.ElementList;
import org.dartlang.vm.service.element.ErrorRef;
import org.dartlang.vm.service.element.FieldRef;
import org.dartlang.vm.service.element.FuncRef;
import org.dartlang.vm.service.element.InstanceRef;
import org.dartlang.vm.service.element.LibraryRef;
import org.dartlang.vm.service.element.Obj;
import org.dartlang.vm.service.element.SourceLocation;

public class ClassObj
extends Obj {
    public ClassObj(JsonObject json) {
        super(json);
    }

    public ErrorRef getError() {
        String kind;
        JsonObject obj = (JsonObject)this.json.get("error");
        if (obj == null) {
            return null;
        }
        String type = this.json.get("type").getAsString();
        if (("Instance".equals(type) || "@Instance".equals(type)) && "Null".equals(kind = this.json.get("kind").getAsString())) {
            return null;
        }
        return new ErrorRef(obj);
    }

    public ElementList<FieldRef> getFields() {
        return new ElementList<FieldRef>(this.json.get("fields").getAsJsonArray()){

            @Override
            protected FieldRef basicGet(JsonArray array, int index) {
                return new FieldRef(array.get(index).getAsJsonObject());
            }
        };
    }

    public ElementList<FuncRef> getFunctions() {
        return new ElementList<FuncRef>(this.json.get("functions").getAsJsonArray()){

            @Override
            protected FuncRef basicGet(JsonArray array, int index) {
                return new FuncRef(array.get(index).getAsJsonObject());
            }
        };
    }

    public ElementList<InstanceRef> getInterfaces() {
        return new ElementList<InstanceRef>(this.json.get("interfaces").getAsJsonArray()){

            @Override
            protected InstanceRef basicGet(JsonArray array, int index) {
                return new InstanceRef(array.get(index).getAsJsonObject());
            }
        };
    }

    public boolean getIsBaseClass() {
        return this.getAsBoolean("isBaseClass");
    }

    public boolean getIsFinal() {
        return this.getAsBoolean("isFinal");
    }

    public boolean getIsInterfaceClass() {
        return this.getAsBoolean("isInterfaceClass");
    }

    public boolean getIsMixinClass() {
        return this.getAsBoolean("isMixinClass");
    }

    public boolean getIsSealed() {
        return this.getAsBoolean("isSealed");
    }

    public LibraryRef getLibrary() {
        return new LibraryRef((JsonObject)this.json.get("library"));
    }

    public SourceLocation getLocation() {
        String kind;
        JsonObject obj = (JsonObject)this.json.get("location");
        if (obj == null) {
            return null;
        }
        String type = this.json.get("type").getAsString();
        if (("Instance".equals(type) || "@Instance".equals(type)) && "Null".equals(kind = this.json.get("kind").getAsString())) {
            return null;
        }
        return new SourceLocation(obj);
    }

    public InstanceRef getMixin() {
        JsonObject obj = (JsonObject)this.json.get("mixin");
        if (obj == null) {
            return null;
        }
        return new InstanceRef(obj);
    }

    public String getName() {
        return this.getAsString("name");
    }

    public ElementList<ClassRef> getSubclasses() {
        return new ElementList<ClassRef>(this.json.get("subclasses").getAsJsonArray()){

            @Override
            protected ClassRef basicGet(JsonArray array, int index) {
                return new ClassRef(array.get(index).getAsJsonObject());
            }
        };
    }

    public ClassRef getSuperClass() {
        String kind;
        JsonObject obj = (JsonObject)this.json.get("super");
        if (obj == null) {
            return null;
        }
        String type = this.json.get("type").getAsString();
        if (("Instance".equals(type) || "@Instance".equals(type)) && "Null".equals(kind = this.json.get("kind").getAsString())) {
            return null;
        }
        return new ClassRef(obj);
    }

    public InstanceRef getSuperType() {
        JsonObject obj = (JsonObject)this.json.get("superType");
        if (obj == null) {
            return null;
        }
        return new InstanceRef(obj);
    }

    public boolean getTraceAllocations() {
        return this.getAsBoolean("traceAllocations");
    }

    public ElementList<InstanceRef> getTypeParameters() {
        if (this.json.get("typeParameters") == null) {
            return null;
        }
        return new ElementList<InstanceRef>(this.json.get("typeParameters").getAsJsonArray()){

            @Override
            protected InstanceRef basicGet(JsonArray array, int index) {
                return new InstanceRef(array.get(index).getAsJsonObject());
            }
        };
    }

    public boolean isAbstract() {
        return this.getAsBoolean("abstract");
    }

    public boolean isConst() {
        return this.getAsBoolean("const");
    }
}

