/*
 * Decompiled with CFR 0.152.
 */
package org.dartlang.vm.service.element;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import org.dartlang.vm.service.element.CpuSample;
import org.dartlang.vm.service.element.Element;
import org.dartlang.vm.service.element.ElementList;
import org.dartlang.vm.service.element.NativeFunction;
import org.dartlang.vm.service.element.ObjRef;

public class CpuSamplesEvent
extends Element {
    public CpuSamplesEvent(JsonObject json) {
        super(json);
    }

    public Object getFunctions() {
        JsonElement elem = this.json.get("functions");
        if (elem == null) {
            return null;
        }
        if (elem.isJsonObject()) {
            JsonObject o = (JsonObject)elem;
            if (o.get("type").getAsString().equals("@Obj")) {
                return new ObjRef(o);
            }
            if (o.get("type").getAsString().equals("NativeFunction")) {
                return new NativeFunction(o);
            }
        }
        return null;
    }

    public int getMaxStackDepth() {
        return this.getAsInt("maxStackDepth");
    }

    public int getPid() {
        return this.getAsInt("pid");
    }

    public int getSampleCount() {
        return this.getAsInt("sampleCount");
    }

    public int getSamplePeriod() {
        return this.getAsInt("samplePeriod");
    }

    public ElementList<CpuSample> getSamples() {
        return new ElementList<CpuSample>(this.json.get("samples").getAsJsonArray()){

            @Override
            protected CpuSample basicGet(JsonArray array, int index) {
                return new CpuSample(array.get(index).getAsJsonObject());
            }
        };
    }

    public int getTimeExtentMicros() {
        return this.getAsInt("timeExtentMicros");
    }

    public int getTimeOriginMicros() {
        return this.getAsInt("timeOriginMicros");
    }
}

