/*
 * Decompiled with CFR 0.152.
 */
package org.dartlang.vm.service.element;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import org.dartlang.vm.service.element.ErrorKind;
import org.dartlang.vm.service.element.InstanceRef;
import org.dartlang.vm.service.element.Obj;

public class ErrorObj
extends Obj {
    public ErrorObj(JsonObject json) {
        super(json);
    }

    public InstanceRef getException() {
        JsonObject obj = (JsonObject)this.json.get("exception");
        if (obj == null) {
            return null;
        }
        return new InstanceRef(obj);
    }

    public ErrorKind getKind() {
        JsonElement value = this.json.get("kind");
        try {
            return value == null ? ErrorKind.Unknown : ErrorKind.valueOf(value.getAsString());
        }
        catch (IllegalArgumentException e) {
            return ErrorKind.Unknown;
        }
    }

    public String getMessage() {
        return this.getAsString("message");
    }

    public InstanceRef getStacktrace() {
        JsonObject obj = (JsonObject)this.json.get("stacktrace");
        if (obj == null) {
            return null;
        }
        return new InstanceRef(obj);
    }
}

