/*
 * Decompiled with CFR 0.152.
 */
package org.dartlang.vm.service.element;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import org.dartlang.vm.service.element.Breakpoint;
import org.dartlang.vm.service.element.CpuSamplesEvent;
import org.dartlang.vm.service.element.ElementList;
import org.dartlang.vm.service.element.EventKind;
import org.dartlang.vm.service.element.ExtensionData;
import org.dartlang.vm.service.element.Frame;
import org.dartlang.vm.service.element.InstanceRef;
import org.dartlang.vm.service.element.IsolateRef;
import org.dartlang.vm.service.element.LogRecord;
import org.dartlang.vm.service.element.Response;
import org.dartlang.vm.service.element.TimelineEvent;
import org.dartlang.vm.service.element.VMRef;

public class Event
extends Response {
    public Event(JsonObject json) {
        super(json);
    }

    public String getAlias() {
        return this.getAsString("alias");
    }

    public boolean getAtAsyncSuspension() {
        return this.getAsBoolean("atAsyncSuspension");
    }

    public Breakpoint getBreakpoint() {
        String kind;
        JsonObject obj = (JsonObject)this.json.get("breakpoint");
        if (obj == null) {
            return null;
        }
        String type = this.json.get("type").getAsString();
        if (("Instance".equals(type) || "@Instance".equals(type)) && "Null".equals(kind = this.json.get("kind").getAsString())) {
            return null;
        }
        return new Breakpoint(obj);
    }

    public String getBytes() {
        return this.getAsString("bytes");
    }

    public CpuSamplesEvent getCpuSamples() {
        String kind;
        JsonObject obj = (JsonObject)this.json.get("cpuSamples");
        if (obj == null) {
            return null;
        }
        String type = this.json.get("type").getAsString();
        if (("Instance".equals(type) || "@Instance".equals(type)) && "Null".equals(kind = this.json.get("kind").getAsString())) {
            return null;
        }
        return new CpuSamplesEvent(obj);
    }

    public InstanceRef getException() {
        JsonObject obj = (JsonObject)this.json.get("exception");
        if (obj == null) {
            return null;
        }
        return new InstanceRef(obj);
    }

    public ExtensionData getExtensionData() {
        String kind;
        JsonObject obj = (JsonObject)this.json.get("extensionData");
        if (obj == null) {
            return null;
        }
        String type = this.json.get("type").getAsString();
        if (("Instance".equals(type) || "@Instance".equals(type)) && "Null".equals(kind = this.json.get("kind").getAsString())) {
            return null;
        }
        return new ExtensionData(obj);
    }

    public String getExtensionKind() {
        return this.getAsString("extensionKind");
    }

    public String getExtensionRPC() {
        return this.getAsString("extensionRPC");
    }

    public String getFlag() {
        return this.getAsString("flag");
    }

    public String getGcType() {
        return this.getAsString("gcType");
    }

    public InstanceRef getInspectee() {
        JsonObject obj = (JsonObject)this.json.get("inspectee");
        if (obj == null) {
            return null;
        }
        return new InstanceRef(obj);
    }

    public IsolateRef getIsolate() {
        String kind;
        JsonObject obj = (JsonObject)this.json.get("isolate");
        if (obj == null) {
            return null;
        }
        String type = this.json.get("type").getAsString();
        if (("Instance".equals(type) || "@Instance".equals(type)) && "Null".equals(kind = this.json.get("kind").getAsString())) {
            return null;
        }
        return new IsolateRef(obj);
    }

    public EventKind getKind() {
        JsonElement value = this.json.get("kind");
        try {
            return value == null ? EventKind.Unknown : EventKind.valueOf(value.getAsString());
        }
        catch (IllegalArgumentException e) {
            return EventKind.Unknown;
        }
    }

    public boolean getLast() {
        return this.getAsBoolean("last");
    }

    public LogRecord getLogRecord() {
        String kind;
        JsonObject obj = (JsonObject)this.json.get("logRecord");
        if (obj == null) {
            return null;
        }
        String type = this.json.get("type").getAsString();
        if (("Instance".equals(type) || "@Instance".equals(type)) && "Null".equals(kind = this.json.get("kind").getAsString())) {
            return null;
        }
        return new LogRecord(obj);
    }

    public String getMethod() {
        return this.getAsString("method");
    }

    public String getNewValue() {
        return this.getAsString("newValue");
    }

    public ElementList<Breakpoint> getPauseBreakpoints() {
        if (this.json.get("pauseBreakpoints") == null) {
            return null;
        }
        return new ElementList<Breakpoint>(this.json.get("pauseBreakpoints").getAsJsonArray()){

            @Override
            protected Breakpoint basicGet(JsonArray array, int index) {
                return new Breakpoint(array.get(index).getAsJsonObject());
            }
        };
    }

    public String getPreviousTag() {
        return this.getAsString("previousTag");
    }

    public String getService() {
        return this.getAsString("service");
    }

    public String getStatus() {
        return this.getAsString("status");
    }

    public ElementList<TimelineEvent> getTimelineEvents() {
        if (this.json.get("timelineEvents") == null) {
            return null;
        }
        return new ElementList<TimelineEvent>(this.json.get("timelineEvents").getAsJsonArray()){

            @Override
            protected TimelineEvent basicGet(JsonArray array, int index) {
                return new TimelineEvent(array.get(index).getAsJsonObject());
            }
        };
    }

    public long getTimestamp() {
        return this.json.get("timestamp") == null ? -1L : this.json.get("timestamp").getAsLong();
    }

    public Frame getTopFrame() {
        String kind;
        JsonObject obj = (JsonObject)this.json.get("topFrame");
        if (obj == null) {
            return null;
        }
        String type = this.json.get("type").getAsString();
        if (("Instance".equals(type) || "@Instance".equals(type)) && "Null".equals(kind = this.json.get("kind").getAsString())) {
            return null;
        }
        return new Frame(obj);
    }

    public List<String> getUpdatedStreams() {
        return this.json.get("updatedStreams") == null ? null : this.getListString("updatedStreams");
    }

    public String getUpdatedTag() {
        return this.getAsString("updatedTag");
    }

    public VMRef getVm() {
        String kind;
        JsonObject obj = (JsonObject)this.json.get("vm");
        if (obj == null) {
            return null;
        }
        String type = this.json.get("type").getAsString();
        if (("Instance".equals(type) || "@Instance".equals(type)) && "Null".equals(kind = this.json.get("kind").getAsString())) {
            return null;
        }
        return new VMRef(obj);
    }
}

