/*
 * Decompiled with CFR 0.152.
 */
package org.dartlang.vm.service.element;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import org.dartlang.vm.service.element.InstanceRef;
import org.dartlang.vm.service.element.Obj;
import org.dartlang.vm.service.element.ObjRef;
import org.dartlang.vm.service.element.SourceLocation;

public class Field
extends Obj {
    public Field(JsonObject json) {
        super(json);
    }

    public InstanceRef getDeclaredType() {
        return new InstanceRef((JsonObject)this.json.get("declaredType"));
    }

    public SourceLocation getLocation() {
        String kind;
        JsonObject obj = (JsonObject)this.json.get("location");
        if (obj == null) {
            return null;
        }
        String type = this.json.get("type").getAsString();
        if (("Instance".equals(type) || "@Instance".equals(type)) && "Null".equals(kind = this.json.get("kind").getAsString())) {
            return null;
        }
        return new SourceLocation(obj);
    }

    public String getName() {
        return this.getAsString("name");
    }

    public ObjRef getOwner() {
        return new ObjRef((JsonObject)this.json.get("owner"));
    }

    public InstanceRef getStaticValue() {
        JsonElement elem = this.json.get("staticValue");
        if (!elem.isJsonObject()) {
            return null;
        }
        JsonObject child = elem.getAsJsonObject();
        String type = child.get("type").getAsString();
        if ("Sentinel".equals(type)) {
            return null;
        }
        return new InstanceRef(child);
    }

    public boolean isConst() {
        return this.getAsBoolean("const");
    }

    public boolean isFinal() {
        return this.getAsBoolean("final");
    }

    public boolean isStatic() {
        return this.getAsBoolean("static");
    }
}

