/*
 * Decompiled with CFR 0.152.
 */
package org.dartlang.vm.service.element;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import org.dartlang.vm.service.element.BoundVariable;
import org.dartlang.vm.service.element.CodeRef;
import org.dartlang.vm.service.element.ElementList;
import org.dartlang.vm.service.element.FrameKind;
import org.dartlang.vm.service.element.FuncRef;
import org.dartlang.vm.service.element.Response;
import org.dartlang.vm.service.element.SourceLocation;

public class Frame
extends Response {
    public Frame(JsonObject json) {
        super(json);
    }

    public CodeRef getCode() {
        String kind;
        JsonObject obj = (JsonObject)this.json.get("code");
        if (obj == null) {
            return null;
        }
        String type = this.json.get("type").getAsString();
        if (("Instance".equals(type) || "@Instance".equals(type)) && "Null".equals(kind = this.json.get("kind").getAsString())) {
            return null;
        }
        return new CodeRef(obj);
    }

    public FuncRef getFunction() {
        String kind;
        JsonObject obj = (JsonObject)this.json.get("function");
        if (obj == null) {
            return null;
        }
        String type = this.json.get("type").getAsString();
        if (("Instance".equals(type) || "@Instance".equals(type)) && "Null".equals(kind = this.json.get("kind").getAsString())) {
            return null;
        }
        return new FuncRef(obj);
    }

    public int getIndex() {
        return this.getAsInt("index");
    }

    public FrameKind getKind() {
        if (this.json.get("kind") == null) {
            return null;
        }
        JsonElement value = this.json.get("kind");
        try {
            return value == null ? FrameKind.Unknown : FrameKind.valueOf(value.getAsString());
        }
        catch (IllegalArgumentException e) {
            return FrameKind.Unknown;
        }
    }

    public SourceLocation getLocation() {
        String kind;
        JsonObject obj = (JsonObject)this.json.get("location");
        if (obj == null) {
            return null;
        }
        String type = this.json.get("type").getAsString();
        if (("Instance".equals(type) || "@Instance".equals(type)) && "Null".equals(kind = this.json.get("kind").getAsString())) {
            return null;
        }
        return new SourceLocation(obj);
    }

    public ElementList<BoundVariable> getVars() {
        if (this.json.get("vars") == null) {
            return null;
        }
        return new ElementList<BoundVariable>(this.json.get("vars").getAsJsonArray()){

            @Override
            protected BoundVariable basicGet(JsonArray array, int index) {
                return new BoundVariable(array.get(index).getAsJsonObject());
            }
        };
    }
}

