/*
 * Decompiled with CFR 0.152.
 */
package org.dartlang.vm.service.element;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import org.dartlang.vm.service.element.ClassRef;
import org.dartlang.vm.service.element.CodeRef;
import org.dartlang.vm.service.element.FuncRef;
import org.dartlang.vm.service.element.InstanceRef;
import org.dartlang.vm.service.element.LibraryRef;
import org.dartlang.vm.service.element.Obj;
import org.dartlang.vm.service.element.SourceLocation;

public class Func
extends Obj {
    public Func(JsonObject json) {
        super(json);
    }

    public CodeRef getCode() {
        String kind;
        JsonObject obj = (JsonObject)this.json.get("code");
        if (obj == null) {
            return null;
        }
        String type = this.json.get("type").getAsString();
        if (("Instance".equals(type) || "@Instance".equals(type)) && "Null".equals(kind = this.json.get("kind").getAsString())) {
            return null;
        }
        return new CodeRef(obj);
    }

    public boolean getImplicit() {
        return this.getAsBoolean("implicit");
    }

    public SourceLocation getLocation() {
        String kind;
        JsonObject obj = (JsonObject)this.json.get("location");
        if (obj == null) {
            return null;
        }
        String type = this.json.get("type").getAsString();
        if (("Instance".equals(type) || "@Instance".equals(type)) && "Null".equals(kind = this.json.get("kind").getAsString())) {
            return null;
        }
        return new SourceLocation(obj);
    }

    public String getName() {
        return this.getAsString("name");
    }

    public Object getOwner() {
        JsonElement elem = this.json.get("owner");
        if (elem == null) {
            return null;
        }
        if (elem.isJsonObject()) {
            JsonObject o = (JsonObject)elem;
            if (o.get("type").getAsString().equals("@Library")) {
                return new LibraryRef(o);
            }
            if (o.get("type").getAsString().equals("@Class")) {
                return new ClassRef(o);
            }
            if (o.get("type").getAsString().equals("@Func")) {
                return new FuncRef(o);
            }
        }
        return null;
    }

    public InstanceRef getSignature() {
        return new InstanceRef((JsonObject)this.json.get("signature"));
    }

    public boolean isAbstract() {
        return this.getAsBoolean("abstract");
    }

    public boolean isConst() {
        return this.getAsBoolean("const");
    }

    public boolean isStatic() {
        return this.getAsBoolean("static");
    }
}

