/*
 * Decompiled with CFR 0.152.
 */
package org.dartlang.vm.service.element;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import org.dartlang.vm.service.element.BoundField;
import org.dartlang.vm.service.element.ClassRef;
import org.dartlang.vm.service.element.ContextRef;
import org.dartlang.vm.service.element.ElementList;
import org.dartlang.vm.service.element.FuncRef;
import org.dartlang.vm.service.element.InstanceKind;
import org.dartlang.vm.service.element.InstanceRef;
import org.dartlang.vm.service.element.MapAssociation;
import org.dartlang.vm.service.element.Obj;
import org.dartlang.vm.service.element.ObjRef;
import org.dartlang.vm.service.element.Parameter;
import org.dartlang.vm.service.element.TypeArgumentsRef;

public class Instance
extends Obj {
    public Instance(JsonObject json) {
        super(json);
    }

    public InstanceRef getAllocationLocation() {
        JsonObject obj = (JsonObject)this.json.get("allocationLocation");
        if (obj == null) {
            return null;
        }
        return new InstanceRef(obj);
    }

    public ElementList<MapAssociation> getAssociations() {
        if (this.json.get("associations") == null) {
            return null;
        }
        return new ElementList<MapAssociation>(this.json.get("associations").getAsJsonArray()){

            @Override
            protected MapAssociation basicGet(JsonArray array, int index) {
                return new MapAssociation(array.get(index).getAsJsonObject());
            }
        };
    }

    public InstanceRef getBound() {
        JsonObject obj = (JsonObject)this.json.get("bound");
        if (obj == null) {
            return null;
        }
        return new InstanceRef(obj);
    }

    public String getBytes() {
        return this.getAsString("bytes");
    }

    @Override
    public ClassRef getClassRef() {
        return new ClassRef((JsonObject)this.json.get("class"));
    }

    public ContextRef getClosureContext() {
        String kind;
        JsonObject obj = (JsonObject)this.json.get("closureContext");
        if (obj == null) {
            return null;
        }
        String type = this.json.get("type").getAsString();
        if (("Instance".equals(type) || "@Instance".equals(type)) && "Null".equals(kind = this.json.get("kind").getAsString())) {
            return null;
        }
        return new ContextRef(obj);
    }

    public FuncRef getClosureFunction() {
        String kind;
        JsonObject obj = (JsonObject)this.json.get("closureFunction");
        if (obj == null) {
            return null;
        }
        String type = this.json.get("type").getAsString();
        if (("Instance".equals(type) || "@Instance".equals(type)) && "Null".equals(kind = this.json.get("kind").getAsString())) {
            return null;
        }
        return new FuncRef(obj);
    }

    public int getCount() {
        return this.getAsInt("count");
    }

    public String getDebugName() {
        return this.getAsString("debugName");
    }

    public ElementList<InstanceRef> getElements() {
        if (this.json.get("elements") == null) {
            return null;
        }
        return new ElementList<InstanceRef>(this.json.get("elements").getAsJsonArray()){

            @Override
            protected InstanceRef basicGet(JsonArray array, int index) {
                return new InstanceRef(array.get(index).getAsJsonObject());
            }
        };
    }

    public ElementList<BoundField> getFields() {
        if (this.json.get("fields") == null) {
            return null;
        }
        return new ElementList<BoundField>(this.json.get("fields").getAsJsonArray()){

            @Override
            protected BoundField basicGet(JsonArray array, int index) {
                return new BoundField(array.get(index).getAsJsonObject());
            }
        };
    }

    public int getIdentityHashCode() {
        return this.getAsInt("identityHashCode");
    }

    public boolean getIsCaseSensitive() {
        return this.getAsBoolean("isCaseSensitive");
    }

    public boolean getIsMultiLine() {
        return this.getAsBoolean("isMultiLine");
    }

    public InstanceKind getKind() {
        JsonElement value = this.json.get("kind");
        try {
            return value == null ? InstanceKind.Unknown : InstanceKind.valueOf(value.getAsString());
        }
        catch (IllegalArgumentException e) {
            return InstanceKind.Unknown;
        }
    }

    public int getLength() {
        return this.getAsInt("length");
    }

    public ObjRef getMirrorReferent() {
        String kind;
        JsonObject obj = (JsonObject)this.json.get("mirrorReferent");
        if (obj == null) {
            return null;
        }
        String type = this.json.get("type").getAsString();
        if (("Instance".equals(type) || "@Instance".equals(type)) && "Null".equals(kind = this.json.get("kind").getAsString())) {
            return null;
        }
        return new ObjRef(obj);
    }

    public String getName() {
        return this.getAsString("name");
    }

    public int getOffset() {
        return this.getAsInt("offset");
    }

    public int getParameterIndex() {
        return this.getAsInt("parameterIndex");
    }

    public ClassRef getParameterizedClass() {
        String kind;
        JsonObject obj = (JsonObject)this.json.get("parameterizedClass");
        if (obj == null) {
            return null;
        }
        String type = this.json.get("type").getAsString();
        if (("Instance".equals(type) || "@Instance".equals(type)) && "Null".equals(kind = this.json.get("kind").getAsString())) {
            return null;
        }
        return new ClassRef(obj);
    }

    public ElementList<Parameter> getParameters() {
        if (this.json.get("parameters") == null) {
            return null;
        }
        return new ElementList<Parameter>(this.json.get("parameters").getAsJsonArray()){

            @Override
            protected Parameter basicGet(JsonArray array, int index) {
                return new Parameter(array.get(index).getAsJsonObject());
            }
        };
    }

    public InstanceRef getPattern() {
        JsonObject obj = (JsonObject)this.json.get("pattern");
        if (obj == null) {
            return null;
        }
        return new InstanceRef(obj);
    }

    public int getPortId() {
        return this.getAsInt("portId");
    }

    public ObjRef getPropertyKey() {
        String kind;
        JsonObject obj = (JsonObject)this.json.get("propertyKey");
        if (obj == null) {
            return null;
        }
        String type = this.json.get("type").getAsString();
        if (("Instance".equals(type) || "@Instance".equals(type)) && "Null".equals(kind = this.json.get("kind").getAsString())) {
            return null;
        }
        return new ObjRef(obj);
    }

    public ObjRef getPropertyValue() {
        String kind;
        JsonObject obj = (JsonObject)this.json.get("propertyValue");
        if (obj == null) {
            return null;
        }
        String type = this.json.get("type").getAsString();
        if (("Instance".equals(type) || "@Instance".equals(type)) && "Null".equals(kind = this.json.get("kind").getAsString())) {
            return null;
        }
        return new ObjRef(obj);
    }

    public InstanceRef getReturnType() {
        JsonObject obj = (JsonObject)this.json.get("returnType");
        if (obj == null) {
            return null;
        }
        return new InstanceRef(obj);
    }

    public ObjRef getTarget() {
        String kind;
        JsonObject obj = (JsonObject)this.json.get("target");
        if (obj == null) {
            return null;
        }
        String type = this.json.get("type").getAsString();
        if (("Instance".equals(type) || "@Instance".equals(type)) && "Null".equals(kind = this.json.get("kind").getAsString())) {
            return null;
        }
        return new ObjRef(obj);
    }

    public InstanceRef getTargetType() {
        JsonObject obj = (JsonObject)this.json.get("targetType");
        if (obj == null) {
            return null;
        }
        return new InstanceRef(obj);
    }

    public TypeArgumentsRef getTypeArguments() {
        String kind;
        JsonObject obj = (JsonObject)this.json.get("typeArguments");
        if (obj == null) {
            return null;
        }
        String type = this.json.get("type").getAsString();
        if (("Instance".equals(type) || "@Instance".equals(type)) && "Null".equals(kind = this.json.get("kind").getAsString())) {
            return null;
        }
        return new TypeArgumentsRef(obj);
    }

    public ClassRef getTypeClass() {
        String kind;
        JsonObject obj = (JsonObject)this.json.get("typeClass");
        if (obj == null) {
            return null;
        }
        String type = this.json.get("type").getAsString();
        if (("Instance".equals(type) || "@Instance".equals(type)) && "Null".equals(kind = this.json.get("kind").getAsString())) {
            return null;
        }
        return new ClassRef(obj);
    }

    public ElementList<InstanceRef> getTypeParameters() {
        if (this.json.get("typeParameters") == null) {
            return null;
        }
        return new ElementList<InstanceRef>(this.json.get("typeParameters").getAsJsonArray()){

            @Override
            protected InstanceRef basicGet(JsonArray array, int index) {
                return new InstanceRef(array.get(index).getAsJsonObject());
            }
        };
    }

    public String getValueAsString() {
        return this.getAsString("valueAsString");
    }

    public boolean getValueAsStringIsTruncated() {
        JsonElement elem = this.json.get("valueAsStringIsTruncated");
        return elem != null ? elem.getAsBoolean() : false;
    }

    public boolean isNull() {
        return this.getKind() == InstanceKind.Null;
    }
}

