/*
 * Decompiled with CFR 0.152.
 */
package org.dartlang.vm.service.element;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import org.dartlang.vm.service.element.ClassRef;
import org.dartlang.vm.service.element.ContextRef;
import org.dartlang.vm.service.element.ElementList;
import org.dartlang.vm.service.element.FuncRef;
import org.dartlang.vm.service.element.InstanceKind;
import org.dartlang.vm.service.element.ObjRef;
import org.dartlang.vm.service.element.Parameter;

public class InstanceRef
extends ObjRef {
    public InstanceRef(JsonObject json) {
        super(json);
    }

    public InstanceRef getAllocationLocation() {
        JsonObject obj = (JsonObject)this.json.get("allocationLocation");
        if (obj == null) {
            return null;
        }
        return new InstanceRef(obj);
    }

    public ClassRef getClassRef() {
        return new ClassRef((JsonObject)this.json.get("class"));
    }

    public ContextRef getClosureContext() {
        String kind;
        JsonObject obj = (JsonObject)this.json.get("closureContext");
        if (obj == null) {
            return null;
        }
        String type = this.json.get("type").getAsString();
        if (("Instance".equals(type) || "@Instance".equals(type)) && "Null".equals(kind = this.json.get("kind").getAsString())) {
            return null;
        }
        return new ContextRef(obj);
    }

    public FuncRef getClosureFunction() {
        String kind;
        JsonObject obj = (JsonObject)this.json.get("closureFunction");
        if (obj == null) {
            return null;
        }
        String type = this.json.get("type").getAsString();
        if (("Instance".equals(type) || "@Instance".equals(type)) && "Null".equals(kind = this.json.get("kind").getAsString())) {
            return null;
        }
        return new FuncRef(obj);
    }

    public String getDebugName() {
        return this.getAsString("debugName");
    }

    public int getIdentityHashCode() {
        return this.getAsInt("identityHashCode");
    }

    public InstanceKind getKind() {
        JsonElement value = this.json.get("kind");
        try {
            return value == null ? InstanceKind.Unknown : InstanceKind.valueOf(value.getAsString());
        }
        catch (IllegalArgumentException e) {
            return InstanceKind.Unknown;
        }
    }

    public int getLength() {
        return this.getAsInt("length");
    }

    public String getName() {
        return this.getAsString("name");
    }

    public ClassRef getParameterizedClass() {
        String kind;
        JsonObject obj = (JsonObject)this.json.get("parameterizedClass");
        if (obj == null) {
            return null;
        }
        String type = this.json.get("type").getAsString();
        if (("Instance".equals(type) || "@Instance".equals(type)) && "Null".equals(kind = this.json.get("kind").getAsString())) {
            return null;
        }
        return new ClassRef(obj);
    }

    public ElementList<Parameter> getParameters() {
        if (this.json.get("parameters") == null) {
            return null;
        }
        return new ElementList<Parameter>(this.json.get("parameters").getAsJsonArray()){

            @Override
            protected Parameter basicGet(JsonArray array, int index) {
                return new Parameter(array.get(index).getAsJsonObject());
            }
        };
    }

    public InstanceRef getPattern() {
        JsonObject obj = (JsonObject)this.json.get("pattern");
        if (obj == null) {
            return null;
        }
        return new InstanceRef(obj);
    }

    public int getPortId() {
        return this.getAsInt("portId");
    }

    public InstanceRef getReturnType() {
        JsonObject obj = (JsonObject)this.json.get("returnType");
        if (obj == null) {
            return null;
        }
        return new InstanceRef(obj);
    }

    public ClassRef getTypeClass() {
        String kind;
        JsonObject obj = (JsonObject)this.json.get("typeClass");
        if (obj == null) {
            return null;
        }
        String type = this.json.get("type").getAsString();
        if (("Instance".equals(type) || "@Instance".equals(type)) && "Null".equals(kind = this.json.get("kind").getAsString())) {
            return null;
        }
        return new ClassRef(obj);
    }

    public ElementList<InstanceRef> getTypeParameters() {
        if (this.json.get("typeParameters") == null) {
            return null;
        }
        return new ElementList<InstanceRef>(this.json.get("typeParameters").getAsJsonArray()){

            @Override
            protected InstanceRef basicGet(JsonArray array, int index) {
                return new InstanceRef(array.get(index).getAsJsonObject());
            }
        };
    }

    public String getValueAsString() {
        return this.getAsString("valueAsString");
    }

    public boolean getValueAsStringIsTruncated() {
        JsonElement elem = this.json.get("valueAsStringIsTruncated");
        return elem != null ? elem.getAsBoolean() : false;
    }

    public boolean isNull() {
        return this.getKind() == InstanceKind.Null;
    }
}

