/*
 * Decompiled with CFR 0.152.
 */
package org.dartlang.vm.service.element;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import org.dartlang.vm.service.element.Breakpoint;
import org.dartlang.vm.service.element.ElementList;
import org.dartlang.vm.service.element.ErrorObj;
import org.dartlang.vm.service.element.Event;
import org.dartlang.vm.service.element.ExceptionPauseMode;
import org.dartlang.vm.service.element.IsolateFlag;
import org.dartlang.vm.service.element.LibraryRef;
import org.dartlang.vm.service.element.Response;

public class Isolate
extends Response {
    public Isolate(JsonObject json) {
        super(json);
    }

    public ElementList<Breakpoint> getBreakpoints() {
        return new ElementList<Breakpoint>(this.json.get("breakpoints").getAsJsonArray()){

            @Override
            protected Breakpoint basicGet(JsonArray array, int index) {
                return new Breakpoint(array.get(index).getAsJsonObject());
            }
        };
    }

    public ErrorObj getError() {
        String kind;
        JsonObject obj = (JsonObject)this.json.get("error");
        if (obj == null) {
            return null;
        }
        String type = this.json.get("type").getAsString();
        if (("Instance".equals(type) || "@Instance".equals(type)) && "Null".equals(kind = this.json.get("kind").getAsString())) {
            return null;
        }
        return new ErrorObj(obj);
    }

    public ExceptionPauseMode getExceptionPauseMode() {
        JsonElement value = this.json.get("exceptionPauseMode");
        try {
            return value == null ? ExceptionPauseMode.Unknown : ExceptionPauseMode.valueOf(value.getAsString());
        }
        catch (IllegalArgumentException e) {
            return ExceptionPauseMode.Unknown;
        }
    }

    public List<String> getExtensionRPCs() {
        return this.json.get("extensionRPCs") == null ? null : this.getListString("extensionRPCs");
    }

    public String getId() {
        return this.getAsString("id");
    }

    public boolean getIsSystemIsolate() {
        return this.getAsBoolean("isSystemIsolate");
    }

    public ElementList<IsolateFlag> getIsolateFlags() {
        return new ElementList<IsolateFlag>(this.json.get("isolateFlags").getAsJsonArray()){

            @Override
            protected IsolateFlag basicGet(JsonArray array, int index) {
                return new IsolateFlag(array.get(index).getAsJsonObject());
            }
        };
    }

    public String getIsolateGroupId() {
        return this.getAsString("isolateGroupId");
    }

    public ElementList<LibraryRef> getLibraries() {
        return new ElementList<LibraryRef>(this.json.get("libraries").getAsJsonArray()){

            @Override
            protected LibraryRef basicGet(JsonArray array, int index) {
                return new LibraryRef(array.get(index).getAsJsonObject());
            }
        };
    }

    public int getLivePorts() {
        return this.getAsInt("livePorts");
    }

    public String getName() {
        return this.getAsString("name");
    }

    public String getNumber() {
        return this.getAsString("number");
    }

    public Event getPauseEvent() {
        return new Event((JsonObject)this.json.get("pauseEvent"));
    }

    public boolean getPauseOnExit() {
        return this.getAsBoolean("pauseOnExit");
    }

    public LibraryRef getRootLib() {
        String kind;
        JsonObject obj = (JsonObject)this.json.get("rootLib");
        if (obj == null) {
            return null;
        }
        String type = this.json.get("type").getAsString();
        if (("Instance".equals(type) || "@Instance".equals(type)) && "Null".equals(kind = this.json.get("kind").getAsString())) {
            return null;
        }
        return new LibraryRef(obj);
    }

    public boolean getRunnable() {
        return this.getAsBoolean("runnable");
    }

    public int getStartTime() {
        return this.getAsInt("startTime");
    }
}

