/*
 * Decompiled with CFR 0.152.
 */
package org.dartlang.vm.service.element;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import org.dartlang.vm.service.element.ClassRef;
import org.dartlang.vm.service.element.ElementList;
import org.dartlang.vm.service.element.FieldRef;
import org.dartlang.vm.service.element.FuncRef;
import org.dartlang.vm.service.element.LibraryDependency;
import org.dartlang.vm.service.element.Obj;
import org.dartlang.vm.service.element.ScriptRef;

public class Library
extends Obj {
    public Library(JsonObject json) {
        super(json);
    }

    public ElementList<ClassRef> getClasses() {
        return new ElementList<ClassRef>(this.json.get("classes").getAsJsonArray()){

            @Override
            protected ClassRef basicGet(JsonArray array, int index) {
                return new ClassRef(array.get(index).getAsJsonObject());
            }
        };
    }

    public boolean getDebuggable() {
        return this.getAsBoolean("debuggable");
    }

    public ElementList<LibraryDependency> getDependencies() {
        return new ElementList<LibraryDependency>(this.json.get("dependencies").getAsJsonArray()){

            @Override
            protected LibraryDependency basicGet(JsonArray array, int index) {
                return new LibraryDependency(array.get(index).getAsJsonObject());
            }
        };
    }

    public ElementList<FuncRef> getFunctions() {
        return new ElementList<FuncRef>(this.json.get("functions").getAsJsonArray()){

            @Override
            protected FuncRef basicGet(JsonArray array, int index) {
                return new FuncRef(array.get(index).getAsJsonObject());
            }
        };
    }

    public String getName() {
        return this.getAsString("name");
    }

    public ElementList<ScriptRef> getScripts() {
        return new ElementList<ScriptRef>(this.json.get("scripts").getAsJsonArray()){

            @Override
            protected ScriptRef basicGet(JsonArray array, int index) {
                return new ScriptRef(array.get(index).getAsJsonObject());
            }
        };
    }

    public String getUri() {
        return this.getAsString("uri");
    }

    public ElementList<FieldRef> getVariables() {
        return new ElementList<FieldRef>(this.json.get("variables").getAsJsonArray()){

            @Override
            protected FieldRef basicGet(JsonArray array, int index) {
                return new FieldRef(array.get(index).getAsJsonObject());
            }
        };
    }
}

