/*
 * Decompiled with CFR 0.152.
 */
package org.dartlang.vm.service.internal;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import org.dartlang.vm.service.internal.RequestSink;
import org.dartlang.vm.service.internal.ResponseSink;
import org.dartlang.vm.service.internal.VmServiceConst;
import org.dartlang.vm.service.logging.Logging;

public class ErrorRequestSink
implements RequestSink,
VmServiceConst {
    private final ResponseSink responseSink;
    private final String code;
    private final String message;

    public ErrorRequestSink(ResponseSink responseSink, String code, String message) {
        if (responseSink == null || code == null || message == null) {
            throw new IllegalArgumentException("Unexpected null argument: " + String.valueOf(responseSink) + " " + code + " " + message);
        }
        this.responseSink = responseSink;
        this.code = code;
        this.message = message;
    }

    @Override
    public void add(JsonObject request) {
        String id = request.getAsJsonPrimitive("id").getAsString();
        try {
            JsonObject error = new JsonObject();
            error.addProperty("code", this.code);
            error.addProperty("message", this.message);
            JsonObject response = new JsonObject();
            response.addProperty("id", id);
            response.add("error", (JsonElement)error);
            this.responseSink.add(response);
        }
        catch (Throwable e) {
            Logging.getLogger().logError(e.getMessage(), e);
        }
    }

    @Override
    public void close() {
    }
}

