/*
 * Decompiled with CFR 0.152.
 */
package org.dartlang.vm.service.internal;

import com.google.gson.JsonObject;
import de.roderick.weberknecht.WebSocket;
import de.roderick.weberknecht.WebSocketException;
import org.dartlang.vm.service.internal.RequestSink;
import org.dartlang.vm.service.logging.Logging;

public class WebSocketRequestSink
implements RequestSink {
    private WebSocket webSocket;

    public WebSocketRequestSink(WebSocket webSocket) {
        this.webSocket = webSocket;
    }

    @Override
    public void add(JsonObject json) {
        String request = json.toString();
        if (this.webSocket == null) {
            Logging.getLogger().logInformation("Dropped: " + request);
            return;
        }
        Logging.getLogger().logInformation("Sent: " + request);
        try {
            this.webSocket.send(request);
        }
        catch (WebSocketException e) {
            Logging.getLogger().logError("Failed to send request: " + request, e);
        }
    }

    @Override
    public void close() {
        if (this.webSocket != null) {
            try {
                this.webSocket.close();
            }
            catch (WebSocketException e) {
                Logging.getLogger().logError("Failed to close websocket", e);
            }
            this.webSocket = null;
        }
    }
}

