/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.facet;

import com.android.tools.idea.gradle.project.GradleProjectInfo;
import com.intellij.facet.FacetType;
import com.intellij.framework.detection.DetectedFrameworkDescription;
import com.intellij.framework.detection.FacetBasedFrameworkDetector;
import com.intellij.framework.detection.FileContentPattern;
import com.intellij.framework.detection.FrameworkDetectionContext;
import com.intellij.ide.highlighter.XmlFileType;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.patterns.ElementPattern;
import com.intellij.util.indexing.FileContent;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.android.facet.AndroidFacetType;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;

public class AndroidFrameworkDetector
extends FacetBasedFrameworkDetector<AndroidFacet, AndroidFacetConfiguration> {
    public AndroidFrameworkDetector() {
        super("android");
    }

    public List<? extends DetectedFrameworkDescription> detect(@NotNull Collection<? extends VirtualFile> newFiles, @NotNull FrameworkDetectionContext context) {
        GradleProjectInfo gradleProjectInfo;
        Project project;
        if (newFiles == null) {
            AndroidFrameworkDetector.$$$reportNull$$$0(0);
        }
        if (context == null) {
            AndroidFrameworkDetector.$$$reportNull$$$0(1);
        }
        if ((project = context.getProject()) != null && ((gradleProjectInfo = GradleProjectInfo.getInstance((Project)project)).isBuildWithGradle() || gradleProjectInfo.hasTopLevelGradleFile())) {
            return Collections.emptyList();
        }
        return super.detect(newFiles, context);
    }

    private static boolean getFirstAsBoolean(@NotNull Pair<String, VirtualFile> pair) {
        if (pair == null) {
            AndroidFrameworkDetector.$$$reportNull$$$0(2);
        }
        return Boolean.parseBoolean((String)pair.getFirst());
    }

    @NotNull
    public static Notification showDexOptionNotification(@NotNull Module module, @NotNull String propertyName) {
        if (module == null) {
            AndroidFrameworkDetector.$$$reportNull$$$0(3);
        }
        if (propertyName == null) {
            AndroidFrameworkDetector.$$$reportNull$$$0(4);
        }
        final Project project = module.getProject();
        Notification notification = NotificationGroupManager.getInstance().getNotificationGroup("Android Module Importing").createNotification(AndroidBundle.message((String)"android.facet.importing.title", (Object[])new Object[]{module.getName()}), "'" + propertyName + "' property is detected in project.properties file.<br>You may enable related option in <a href='configure'>Settings | Compiler | Android DX</a>", NotificationType.INFORMATION).setListener((NotificationListener)new NotificationListener.Adapter(){

            protected void hyperlinkActivated(@NotNull Notification notification, @NotNull HyperlinkEvent event) {
                if (notification == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (event == null) {
                    1.$$$reportNull$$$0(1);
                }
                notification.expire();
                ShowSettingsUtil.getInstance().showSettingsDialog(project, AndroidBundle.message((String)"android.dex.compiler.configurable.display.name", (Object[])new Object[0]));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "notification";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "event";
                        break;
                    }
                }
                objectArray[1] = "org/jetbrains/android/facet/AndroidFrameworkDetector$1";
                objectArray[2] = "hyperlinkActivated";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        notification.notify(project);
        Notification notification2 = notification;
        if (notification2 == null) {
            AndroidFrameworkDetector.$$$reportNull$$$0(5);
        }
        return notification2;
    }

    @NotNull
    public FacetType<AndroidFacet, AndroidFacetConfiguration> getFacetType() {
        AndroidFacetType androidFacetType = AndroidFacet.getFacetType();
        if (androidFacetType == null) {
            AndroidFrameworkDetector.$$$reportNull$$$0(6);
        }
        return androidFacetType;
    }

    @NotNull
    public FileType getFileType() {
        XmlFileType xmlFileType = XmlFileType.INSTANCE;
        if (xmlFileType == null) {
            AndroidFrameworkDetector.$$$reportNull$$$0(7);
        }
        return xmlFileType;
    }

    @NotNull
    public ElementPattern<FileContent> createSuitableFilePattern() {
        FileContentPattern fileContentPattern = FileContentPattern.fileContent().withName("AndroidManifest.xml");
        if (fileContentPattern == null) {
            AndroidFrameworkDetector.$$$reportNull$$$0(8);
        }
        return fileContentPattern;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 6, 7, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newFiles";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pair";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyName";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/android/facet/AndroidFrameworkDetector";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/android/facet/AndroidFrameworkDetector";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "showDexOptionNotification";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getFacetType";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileType";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createSuitableFilePattern";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "detect";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getFirstAsBoolean";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "showDexOptionNotification";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 6, 7, 8 -> new IllegalStateException(string);
        };
    }
}

