package tnj;

import java.util.List;

import graphql.annotations.GraphQLAnnotations;
import graphql.annotations.GraphQLConnection;
import graphql.annotations.GraphQLField;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLSchema;

public class Schema {
    private GraphQLSchema schema;

    public class User {
        @GraphQLField
        @GraphQLConnection
        public List<Task> tasks;
    }

    public class Task {
        @GraphQLField
        @GraphQLConnection
        public List<User> users;
    }

    public interface Query {

        @GraphQLField
        public Task getTask();

        @GraphQLField
        public User getUser();


    }

    public static class Context implements Query {

        @Override
        public User getUser() {
            return null;
        }

        @Override
        public Task getTask() {
            return null;
        }
    }

    public GraphQLSchema getSchema() {
        GraphQLObjectType queryType;

        try {
            queryType = GraphQLAnnotations.object(Query.class);

//            Relay relay = new Relay();
//
//            TypeResolverProxy typeResolverProxy = new TypeResolverProxy();
//
//            GraphQLInterfaceType nodeInterface = relay.nodeInterface(typeResolverProxy);
//
//            GraphQLObjectType userEdge = relay.edgeType("User", new GraphQLTypeReference("User"), nodeInterface, Collections.<GraphQLFieldDefinition>emptyList());
//            GraphQLObjectType usersConnection = relay.connectionType("User", userEdge, Arrays.asList());
//
//            GraphQLObjectType taskType = newObject()
//                    .name("Task")
//                    .field(newFieldDefinition()
//                        .name("name")
//                        .type(Scalars.GraphQLString)
//                        .build()
//                    )
//                    .field(newFieldDefinition()
//                            .name("users")
//                            .type(usersConnection)
//                            .build()
//                    )
//                    .build();
//
//
//            GraphQLObjectType taskEdge = relay.edgeType("Task", new GraphQLTypeReference("Task"), nodeInterface, Collections.<GraphQLFieldDefinition>emptyList());
//            GraphQLObjectType tasksConnection = relay.connectionType("Task", taskEdge, Arrays.asList());
//
//            GraphQLObjectType userType = newObject()
//                    .name("User")
//                    .field(newFieldDefinition()
//                            .name("name")
//                            .type(Scalars.GraphQLString)
//                            .build()
//                    )
//                    .field(newFieldDefinition()
//                            .name("tasks")
//                            .type(tasksConnection)
//                            .build()
//                    )
//                    .build();
//
//            queryType = newObject()
//                    .name("Query")
//                    .field(newFieldDefinition()
//                        .name("task")
//                        .type(taskType)
//                        .build()
//                    )
//                    .field(newFieldDefinition()
//                            .name("user")
//                            .type(userType)
//                            .build()
//                    )
//                    .build();

            schema = GraphQLSchema.newSchema().query(queryType).build();
        } catch (IllegalAccessException e) {
            e.printStackTrace();
        } catch (InstantiationException e) {
            e.printStackTrace();
        } catch (NoSuchMethodException e) {
            e.printStackTrace();
        }

        return schema;
    }
}
