package tnj;

import graphql.annotations.GraphQLAnnotations;
import graphql.annotations.GraphQLObjectTypeWrapper;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLList;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLSchema;
import org.junit.Test;

import static org.junit.Assert.assertFalse;

public class MutuallyRecursiveConnectionTest {

    @Test
    public void test() {
        Schema schema = new Schema();
        GraphQLSchema graphQLSchema = schema.getSchema();
        GraphQLFieldDefinition taskDef = graphQLSchema.getQueryType().getFieldDefinition("task");
        GraphQLAnnotations.GraphQLFieldDefinitionWrapper taskDefWrap = (GraphQLAnnotations.GraphQLFieldDefinitionWrapper)taskDef;
        GraphQLObjectTypeWrapper taskTypeWrap = (GraphQLObjectTypeWrapper)taskDefWrap.getType();
        GraphQLAnnotations.GraphQLFieldDefinitionWrapper usersDefWrapper = (GraphQLAnnotations.GraphQLFieldDefinitionWrapper) taskTypeWrap.getFieldDefinition("users");
        GraphQLOutputType usersType = usersDefWrapper.getType();
        assertFalse(usersType instanceof GraphQLList);

        GraphQLFieldDefinition userDef = graphQLSchema.getQueryType().getFieldDefinition("user");
        GraphQLAnnotations.GraphQLFieldDefinitionWrapper userDefWrap = (GraphQLAnnotations.GraphQLFieldDefinitionWrapper)userDef;
        GraphQLObjectTypeWrapper userTypeWrap = (GraphQLObjectTypeWrapper)userDefWrap.getType();
        GraphQLAnnotations.GraphQLFieldDefinitionWrapper tasksDefWrapper = (GraphQLAnnotations.GraphQLFieldDefinitionWrapper) userTypeWrap.getFieldDefinition("tasks");
        GraphQLOutputType tasksType = tasksDefWrapper.getType();
        assertFalse(tasksType instanceof GraphQLList);
    }
}