# Kaazing JavaScript WebSocket Echo Tutorial

This tutorial shows how JavaScript application can communicate over the web with an `echo` service running within Kaazing WebSocket Gateway using Kaazing JavaScript WebSocket Client library. The application sends text messages to the `echo` service over WebSocket using Kaazing JavaScript WebSocket Client library.
The `echo` service, running inside the Kaazing WebSocket Gateway, reflects back the message that is received by the JavaScript application. 

## Minimum Requirements for Running or Building Kaazing JavaScript WebSocket Echo Tutorial

* Node.js version 4.4 and higher
* NPM v 3.9.5 and higher

    To update NPM to the latest version:
    `
        sudo npm install npm -g
    `

## Steps for building and running the project

* In a terminal, navigate to the folder for a tutorial, such as `javascript.client.tutorials/ws`.
* Enter `npm install` to build the tutorial.
* Enter `node server.js` to run the included Node.js server component (server.js).
* In a browser, open the URL `http://localhost:3000/`.

__Note:__ To test basic authentication for WebSocket connection in demo app use URL -  wss://sandbox.kaazing.net/echo-auth for location. 


## Interact with Kaazing JavaScript WebSocket Client API

Checklist how to create Kaazing JavaScript WebSocket from scratch, to be able to send and receive messages
over WebSocket can be found [here] (http://kaazing.com/doc/5.0/websocket_client_docs/dev-js/o_dev_js.html)

## API Documentation

API Documentation for Kaazing JavaScript WebSocket Client library is available:

* [missing](missing)

