This is a prototype of a Spring Boot 3 app running on Java 17. 

It has a single endpoint that demonstrates how a JAXB-annotated class can be used with both Spring Boot 3 - which 
requires Java 17 and Jakarta EE 10 (the jakarta.xml packages) - and with the MarkLogic Java Client, which requires 
the older javax.xml packages. The one requirement is that the class must have both kinds of JAXB annotations on it. 

The app uses a very naive connection to MarkLogic that assumes that a username of "admin" and a password of "admin" will
work. It runs against localhost:8000. This can be altered in the `ProductController` class if necessary.

To try this project out, run the Spring Boot app:

    ./gradlew bootRun

This will expose a single endpoint at http://localhost:8080/products that receives POST and GET requests. 

The following Python code below shows a simple way to create a product via a POST and then retrieve it via a GET. 
The POST will use Spring Boot to deserialize the XML string into a Product entity using the jakarta.xml library. The 
GET will use the MarkLogic Java to deserialize an XML document from MarkLogic into a Product entity via the javax.xml
library, and it then uses Spring Boot to serialize the Product entity into an XML string via jakarta.xml (note that 
the endpoint could just return the XML document as a string from MarkLogic without using JAXB at all).

```
import requests
r = requests.post("http://localhost:8080/products", data="<product><id>1</id><name>my name</name></product>", headers={"Content-type": "application/xml"})
r.headers

r = requests.get("http://localhost:8080/products/1")
r.text
```