package org.example.springboot;

import com.marklogic.client.DatabaseClient;
import com.marklogic.client.DatabaseClientFactory;
import com.marklogic.client.io.JAXBHandle;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

import javax.xml.bind.JAXBContext;
import java.net.URI;

@RestController
public class ProductController {

    private static DatabaseClient client;

    static {
        client = DatabaseClientFactory.newClient("localhost", 8000, new DatabaseClientFactory.DigestAuthContext("admin", "admin"));
    }

    @PostMapping("/products")
    public ResponseEntity create(@RequestBody Product product) throws Exception {
        System.out.println("Received product: " + product.getName());
        JAXBHandle content = new JAXBHandle(JAXBContext.newInstance(Product.class));
        content.set(product);
        URI uri = new URI(String.format("/product/%d.xml", product.getId()));
        client.newXMLDocumentManager().write(uri.toString(), content);
        return ResponseEntity.created(uri).build();
    }

    @GetMapping("/products2/{id}")
    public ResponseEntity<Product> get(@PathVariable int id) throws javax.xml.bind.JAXBException {
        JAXBHandle<Product> handle = new JAXBHandle(JAXBContext.newInstance(Product.class));
        client.newXMLDocumentManager().read(String.format("/product/%d.xml", id), handle);
        return ResponseEntity.ok(handle.get());
    }
}
